/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.internal.SigUtils;
import com.android.tools.apk.analyzer.internal.rewriters.FieldReferenceWithNameRewriter;
import com.android.tools.apk.analyzer.internal.rewriters.MethodReferenceWithNameRewriter;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.smali.baksmali.Adaptors.ClassDefinition;
import com.android.tools.smali.baksmali.Adaptors.MethodDefinition;
import com.android.tools.smali.baksmali.BaksmaliOptions;
import com.android.tools.smali.baksmali.formatter.BaksmaliWriter;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.DexFile;
import com.android.tools.smali.dexlib2.iface.Method;
import com.android.tools.smali.dexlib2.iface.MethodImplementation;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.rewriter.DexRewriter;
import com.android.tools.smali.dexlib2.rewriter.Rewriter;
import com.android.tools.smali.dexlib2.rewriter.RewriterModule;
import com.android.tools.smali.dexlib2.rewriter.Rewriters;
import com.android.tools.smali.dexlib2.rewriter.TypeRewriter;
import com.android.tools.smali.dexlib2.util.ReferenceUtil;
import com.android.tools.smali.util.IndentingWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexDisassembler {
    @NotNull
    private final DexFile dexFile;
    @Nullable
    private final ProguardMap proguardMap;

    public DexDisassembler(@NotNull DexBackedDexFile dexFile, @Nullable ProguardMap proguardMap) {
        this.dexFile = proguardMap == null ? dexFile : DexDisassembler.rewriteDexFile((DexFile)dexFile, proguardMap);
        this.proguardMap = proguardMap;
    }

    @NotNull
    public String disassembleMethod(@NotNull String fqcn, @NotNull String methodDescriptor) throws IOException {
        Optional<? extends ClassDef> classDef = this.getClassDef(fqcn = PackageTreeCreator.decodeClassName(SigUtils.typeToSignature(fqcn), this.proguardMap));
        if (!classDef.isPresent()) {
            throw new IllegalStateException("Unable to locate class definition for " + fqcn);
        }
        Optional<Method> method = StreamSupport.stream(classDef.get().getMethods().spliterator(), false).filter(m -> methodDescriptor.equals(ReferenceUtil.getMethodDescriptor((MethodReference)m))).findFirst();
        if (!method.isPresent()) {
            throw new IllegalStateException("Unable to locate method definition in class for method " + methodDescriptor);
        }
        return DexDisassembler.getMethodDexCode(classDef.get(), method.get());
    }

    @NotNull
    public String disassembleMethod(@NotNull String fqcn, @NotNull MethodReference methodRef) throws IOException {
        Optional<? extends ClassDef> classDef = this.getClassDef(fqcn = PackageTreeCreator.decodeClassName(SigUtils.typeToSignature(fqcn), this.proguardMap));
        if (!classDef.isPresent()) {
            throw new IllegalStateException("Unable to locate class definition for " + fqcn);
        }
        MethodReference finalMethodRef = this.proguardMap != null ? (MethodReference)DexDisassembler.getRewriter(this.proguardMap).getMethodReferenceRewriter().rewrite((Object)methodRef) : methodRef;
        Optional<Method> method = StreamSupport.stream(classDef.get().getMethods().spliterator(), false).filter(arg_0 -> ((MethodReference)finalMethodRef).equals(arg_0)).findFirst();
        if (!method.isPresent()) {
            throw new IllegalStateException("Unable to locate method definition in class for method " + methodRef);
        }
        return DexDisassembler.getMethodDexCode(classDef.get(), method.get());
    }

    @NotNull
    private static String getMethodDexCode(ClassDef classDef, Method method) throws IOException {
        BaksmaliOptions options = new BaksmaliOptions();
        ClassDefinition classDefinition = new ClassDefinition(options, classDef);
        StringWriter writer = new StringWriter(1024);
        try (BaksmaliWriter iw = new BaksmaliWriter((Writer)new IndentingWriter((Writer)writer));){
            MethodImplementation methodImpl = method.getImplementation();
            if (methodImpl == null) {
                MethodDefinition.writeEmptyMethodTo((BaksmaliWriter)iw, (Method)method, (ClassDefinition)classDefinition);
            } else {
                MethodDefinition methodDefinition = new MethodDefinition(classDefinition, method, methodImpl);
                methodDefinition.writeTo(iw);
            }
        }
        return writer.toString().replace("\r", "");
    }

    @NotNull
    public String disassembleClass(@NotNull String fqcn) throws IOException {
        Optional<? extends ClassDef> classDef = this.getClassDef(fqcn = PackageTreeCreator.decodeClassName(SigUtils.typeToSignature(fqcn), this.proguardMap));
        if (!classDef.isPresent()) {
            throw new IllegalStateException("Unable to locate class definition for " + fqcn);
        }
        BaksmaliOptions options = new BaksmaliOptions();
        ClassDefinition classDefinition = new ClassDefinition(options, classDef.get());
        StringWriter writer = new StringWriter(1024);
        try (BaksmaliWriter iw = new BaksmaliWriter((Writer)new IndentingWriter((Writer)writer));){
            classDefinition.writeTo(iw);
        }
        return writer.toString().replace("\r", "");
    }

    private static DexFile rewriteDexFile(@NotNull DexFile dexFile, @NotNull ProguardMap map2) {
        DexRewriter rewriter = DexDisassembler.getRewriter(map2);
        return (DexFile)rewriter.getDexFileRewriter().rewrite((Object)dexFile);
    }

    @NotNull
    private static DexRewriter getRewriter(final @NotNull ProguardMap map2) {
        return new DexRewriter(new RewriterModule(){

            @NotNull
            public Rewriter<String> getTypeRewriter(@NotNull Rewriters rewriters) {
                return new TypeRewriter(){

                    @NotNull
                    public String rewrite(@NotNull String typeName) {
                        return SigUtils.typeToSignature(PackageTreeCreator.decodeClassName(typeName, map2));
                    }
                };
            }

            @NotNull
            public Rewriter<FieldReference> getFieldReferenceRewriter(@NotNull Rewriters rewriters) {
                return new FieldReferenceWithNameRewriter(rewriters){

                    @Override
                    public String rewriteName(FieldReference fieldReference) {
                        return PackageTreeCreator.decodeFieldName(fieldReference, map2);
                    }
                };
            }

            @NotNull
            public Rewriter<MethodReference> getMethodReferenceRewriter(@NotNull Rewriters rewriters) {
                return new MethodReferenceWithNameRewriter(rewriters){

                    @Override
                    public String rewriteName(MethodReference methodReference2) {
                        return PackageTreeCreator.decodeMethodName(methodReference2, map2);
                    }
                };
            }
        });
    }

    @NotNull
    private Optional<? extends ClassDef> getClassDef(@NotNull String fqcn) {
        return this.dexFile.getClasses().stream().filter(c -> fqcn.equals(SigUtils.signatureToName(c.getType()))).findFirst();
    }
}

