/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ZipEntryInfo;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public abstract class ArchiveEntry {
    @NotNull
    private final Archive archive;
    @NotNull
    private final Path path;
    @NotNull
    private final String pathPrefix;

    public ArchiveEntry(@NotNull Archive archive, @NotNull Path path, @NotNull String pathPrefix) {
        assert (archive.getContentRoot().getFileSystem() == path.getFileSystem());
        this.archive = archive;
        this.path = path;
        this.pathPrefix = pathPrefix;
    }

    public void setRawFileSize(long rawFileSize) {
    }

    public long getRawFileSize() {
        return 0L;
    }

    public void setFileAlignment(ZipEntryInfo.Alignment alignment) {
    }

    public ZipEntryInfo.Alignment getFileAlignment() {
        return ZipEntryInfo.Alignment.ALIGNMENT_NONE;
    }

    public void setElfMinimumLoadSectionAlignment(long loadAlignment) {
    }

    public long getElfMinimumLoadSectionAlignment() {
        return -1L;
    }

    public boolean getSelfOrChild16kbIncompatible() {
        return false;
    }

    public void setSelfOrChild16kbIncompatible(Boolean value) {
    }

    public void setIsElf(boolean isElf) {
    }

    public boolean getIsElf() {
        return false;
    }

    public void setIsFileCompressed(boolean isCompressed) {
    }

    public boolean isFileCompressed() {
        return false;
    }

    public void setDownloadFileSize(long downloadFileSize) {
    }

    public long getDownloadFileSize() {
        return 0L;
    }

    @NotNull
    public Path getPath() {
        return this.path;
    }

    @NotNull
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    @NotNull
    public Archive getArchive() {
        return this.archive;
    }

    @NotNull
    public abstract String getNodeDisplayString();

    @NotNull
    public abstract String getSummaryDisplayString();

    public String toString() {
        return String.format("%s: pathPrefix=\"%s\", path=\"%s\"", this.getClass().getSimpleName(), this.pathPrefix, this.path);
    }
}

