/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.deviceprovisioner;

import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.sdklib.deviceprovisioner.ActivationAction;
import com.android.sdklib.deviceprovisioner.BootSnapshotAction;
import com.android.sdklib.deviceprovisioner.ColdBootAction;
import com.android.sdklib.deviceprovisioner.ConnectionType;
import com.android.sdklib.deviceprovisioner.DeactivationAction;
import com.android.sdklib.deviceprovisioner.DeleteAction;
import com.android.sdklib.deviceprovisioner.DeviceError;
import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.sdklib.deviceprovisioner.DeviceId;
import com.android.sdklib.deviceprovisioner.DeviceProperties;
import com.android.sdklib.deviceprovisioner.DeviceState;
import com.android.sdklib.deviceprovisioner.DeviceTemplate;
import com.android.sdklib.deviceprovisioner.DuplicateAction;
import com.android.sdklib.deviceprovisioner.EditAction;
import com.android.sdklib.deviceprovisioner.Extension;
import com.android.sdklib.deviceprovisioner.PairDeviceAction;
import com.android.sdklib.deviceprovisioner.RepairDeviceAction;
import com.android.sdklib.deviceprovisioner.Reservation;
import com.android.sdklib.deviceprovisioner.ReservationAction;
import com.android.sdklib.deviceprovisioner.ShowAction;
import com.android.sdklib.deviceprovisioner.WipeDataAction;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0012J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010 \u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/sdklib/deviceprovisioner/PhysicalDeviceHandle;", "Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "serialNumber", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "initialState", "Lcom/android/sdklib/deviceprovisioner/DeviceState$Connected;", "<init>", "(Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;Lcom/android/sdklib/deviceprovisioner/DeviceState$Connected;)V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "id", "Lcom/android/sdklib/deviceprovisioner/DeviceId;", "getId", "()Lcom/android/sdklib/deviceprovisioner/DeviceId;", "stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/android/sdklib/deviceprovisioner/DeviceState;", "getStateFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "usbConnectionFlow", "wifiConnectionFlow", "updateState", "", "flowForDevice", "device", "Lcom/android/adblib/ConnectedDevice;", "awaitRelease", "(Lcom/android/adblib/ConnectedDevice;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "newState", "deviceDisconnected", "toString", "android.sdktools.device-provisioner"})
@SourceDebugExtension(value={"SMAP\nPhysicalDeviceProvisionerPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicalDeviceProvisionerPlugin.kt\ncom/android/sdklib/deviceprovisioner/PhysicalDeviceHandle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,190:1\n1#2:191\n226#3,5:192\n*S KotlinDebug\n*F\n+ 1 PhysicalDeviceProvisionerPlugin.kt\ncom/android/sdklib/deviceprovisioner/PhysicalDeviceHandle\n*L\n182#1:192,5\n*E\n"})
final class PhysicalDeviceHandle
implements DeviceHandle {
    @NotNull
    private final String serialNumber;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final DeviceId id;
    @NotNull
    private final MutableStateFlow<DeviceState> stateFlow;
    @NotNull
    private final MutableStateFlow<DeviceState> usbConnectionFlow;
    @NotNull
    private final MutableStateFlow<DeviceState> wifiConnectionFlow;

    public PhysicalDeviceHandle(@NotNull String serialNumber, @NotNull CoroutineScope scope, @NotNull DeviceState.Connected initialState) {
        DeviceState.Connected it;
        DeviceState.Connected connected;
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)initialState, (String)"initialState");
        this.serialNumber = serialNumber;
        this.scope = scope;
        this.id = new DeviceId("PhysicalDevice", false, "serial=" + this.serialNumber);
        this.stateFlow = StateFlowKt.MutableStateFlow((Object)initialState);
        DeviceState.Connected connected2 = connected = initialState;
        PhysicalDeviceHandle physicalDeviceHandle = this;
        boolean bl = false;
        boolean bl2 = it.getProperties().getConnectionType() == ConnectionType.USB;
        physicalDeviceHandle.usbConnectionFlow = StateFlowKt.MutableStateFlow((Object)(bl2 ? connected : null));
        it = connected = initialState;
        physicalDeviceHandle = this;
        boolean bl3 = false;
        bl2 = it.getProperties().getConnectionType() != ConnectionType.USB;
        physicalDeviceHandle.wifiConnectionFlow = StateFlowKt.MutableStateFlow((Object)(bl2 ? connected : null));
    }

    @Override
    @NotNull
    public CoroutineScope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public DeviceId getId() {
        return this.id;
    }

    @NotNull
    public MutableStateFlow<DeviceState> getStateFlow() {
        return this.stateFlow;
    }

    private final void updateState() {
        DeviceState deviceState;
        MutableStateFlow<DeviceState> mutableStateFlow = this.getStateFlow();
        Object object = this.usbConnectionFlow.getValue();
        DeviceState.Connected connected = object instanceof DeviceState.Connected ? (DeviceState.Connected)object : null;
        if (connected != null) {
            deviceState = connected;
        } else {
            Object object2 = this.wifiConnectionFlow.getValue();
            DeviceState.Connected connected2 = object2 instanceof DeviceState.Connected ? (DeviceState.Connected)object2 : null;
            if (connected2 != null) {
                deviceState = connected2;
            } else {
                deviceState = (DeviceState)this.usbConnectionFlow.getValue();
                if (deviceState == null) {
                    Object object3 = this.wifiConnectionFlow.getValue();
                    Intrinsics.checkNotNull((Object)object3);
                    deviceState = (DeviceState)object3;
                }
            }
        }
        mutableStateFlow.setValue((Object)deviceState);
    }

    private final MutableStateFlow<DeviceState> flowForDevice(ConnectedDevice device2) {
        return Intrinsics.areEqual((Object)ConnectedDeviceKt.getSerialNumber(device2), (Object)this.serialNumber) ? this.usbConnectionFlow : this.wifiConnectionFlow;
    }

    @Override
    @Nullable
    public Object awaitRelease(@NotNull ConnectedDevice device2, @NotNull Continuation<? super Unit> $completion) {
        Object object = FlowKt.collect((Flow)FlowKt.takeWhile((Flow)((Flow)this.flowForDevice(device2)), (Function2)((Function2)new Function2<DeviceState, Continuation<? super Boolean>, Object>(device2, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ConnectedDevice $device;
            {
                this.$device = $device;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        DeviceState it;
                        ResultKt.throwOnFailure((Object)object);
                        DeviceState deviceState = it = (DeviceState)this.L$0;
                        return Boxing.boxBoolean((boolean)Intrinsics.areEqual((Object)(deviceState != null ? deviceState.getConnectedDevice() : null), (Object)this.$device));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(DeviceState p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void updateState(@NotNull ConnectedDevice device2, @NotNull DeviceState newState) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.flowForDevice(device2).setValue((Object)newState);
        this.updateState();
    }

    public final void deviceDisconnected(@NotNull ConnectedDevice device2) {
        DefaultConstructorMarker defaultConstructorMarker;
        int n;
        DeviceError deviceError;
        Reservation reservation;
        String string2;
        boolean bl;
        DeviceProperties.Builder builder;
        DeviceProperties deviceProperties;
        DeviceState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        MutableStateFlow<DeviceState> $this$update$iv = this.flowForDevice(device2);
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            DeviceState it = (DeviceState)prevValue$iv;
            boolean bl2 = false;
            DeviceState deviceState = it;
            Intrinsics.checkNotNull((Object)deviceState);
            DeviceProperties.Builder $this$deviceDisconnected_u24lambda_u243_u24lambda_u242 = builder = deviceState.getProperties().toBuilder();
            boolean bl3 = false;
            $this$deviceDisconnected_u24lambda_u243_u24lambda_u242.setConnectionType(null);
            defaultConstructorMarker = null;
            n = 30;
            deviceError = null;
            reservation = null;
            string2 = null;
            bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (DeviceState)new DeviceState.Disconnected(deviceProperties = builder.build(), bl, string2, reservation, deviceError, n, defaultConstructorMarker))));
        this.updateState();
    }

    @NotNull
    public String toString() {
        return "PhysicalDeviceHandle for " + this.getId();
    }

    @Override
    @NotNull
    public DeviceState getState() {
        return DeviceHandle.super.getState();
    }

    @Override
    @Nullable
    public DeviceTemplate getSourceTemplate() {
        return DeviceHandle.super.getSourceTemplate();
    }

    @Override
    @Nullable
    public ActivationAction getActivationAction() {
        return DeviceHandle.super.getActivationAction();
    }

    @Override
    @Nullable
    public ColdBootAction getColdBootAction() {
        return DeviceHandle.super.getColdBootAction();
    }

    @Override
    @Nullable
    public BootSnapshotAction getBootSnapshotAction() {
        return DeviceHandle.super.getBootSnapshotAction();
    }

    @Override
    @Nullable
    public DeactivationAction getDeactivationAction() {
        return DeviceHandle.super.getDeactivationAction();
    }

    @Override
    @Nullable
    public EditAction getEditAction() {
        return DeviceHandle.super.getEditAction();
    }

    @Override
    @Nullable
    public ReservationAction getReservationAction() {
        return DeviceHandle.super.getReservationAction();
    }

    @Override
    @Nullable
    public DuplicateAction getDuplicateAction() {
        return DeviceHandle.super.getDuplicateAction();
    }

    @Override
    @Nullable
    public WipeDataAction getWipeDataAction() {
        return DeviceHandle.super.getWipeDataAction();
    }

    @Override
    @Nullable
    public ShowAction getShowAction() {
        return DeviceHandle.super.getShowAction();
    }

    @Override
    @Nullable
    public DeleteAction getDeleteAction() {
        return DeviceHandle.super.getDeleteAction();
    }

    @Override
    @Nullable
    public RepairDeviceAction getRepairDeviceAction() {
        return DeviceHandle.super.getRepairDeviceAction();
    }

    @Override
    @Nullable
    public PairDeviceAction getWifiPairDeviceAction() {
        return DeviceHandle.super.getWifiPairDeviceAction();
    }

    @Override
    @Nullable
    public <T extends Extension> T extension(@NotNull Class<T> extensionClass) {
        return DeviceHandle.super.extension(extensionClass);
    }
}

