/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.deviceprovisioner;

import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionUtil;
import com.android.sdklib.deviceprovisioner.BaseDeviceProperties;
import com.android.sdklib.deviceprovisioner.ConnectionType;
import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.sdklib.deviceprovisioner.Resolution;
import com.android.sdklib.deviceprovisioner.SerialNumberAndMdnsConnectionType;
import com.android.sdklib.devices.Abi;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 @2\u00020\u0001:\u0002@AJ\b\u0010>\u001a\u00020?H&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005R\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001eR\u0014\u0010 \u001a\u0004\u0018\u00010\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u0004\u0018\u00010\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001eR\u0012\u0010\"\u001a\u00020#X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u0004\u0018\u00010'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\u0004\u0018\u00010'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0014\u0010,\u001a\u0004\u0018\u00010-X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0005R\u0014\u00102\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0005R\u0014\u00104\u001a\u0004\u0018\u000105X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0005R\u0012\u0010:\u001a\u00020;X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006B\u00c0\u0006\u0003"}, d2={"Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "", "model", "", "getModel", "()Ljava/lang/String;", "manufacturer", "getManufacturer", "primaryAbi", "Lcom/android/sdklib/devices/Abi;", "getPrimaryAbi", "()Lcom/android/sdklib/devices/Abi;", "preferredAbi", "getPreferredAbi", "abiList", "", "getAbiList", "()Ljava/util/List;", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "getAndroidVersion", "()Lcom/android/sdklib/AndroidVersion;", "androidRelease", "getAndroidRelease", "deviceType", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getDeviceType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "isVirtual", "", "()Ljava/lang/Boolean;", "isRemote", "isDebuggable", "isResizable", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "resolution", "Lcom/android/sdklib/deviceprovisioner/Resolution;", "getResolution", "()Lcom/android/sdklib/deviceprovisioner/Resolution;", "resolutionDp", "getResolutionDp", "density", "", "getDensity", "()Ljava/lang/Integer;", "disambiguator", "getDisambiguator", "wearPairingId", "getWearPairingId", "connectionType", "Lcom/android/sdklib/deviceprovisioner/ConnectionType;", "getConnectionType", "()Lcom/android/sdklib/deviceprovisioner/ConnectionType;", "title", "getTitle", "deviceInfoProto", "Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "getDeviceInfoProto", "()Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "toBuilder", "Lcom/android/sdklib/deviceprovisioner/DeviceProperties$Builder;", "Companion", "Builder", "android.sdktools.device-provisioner"})
public interface DeviceProperties {
    @NotNull
    public static final Companion Companion = com.android.sdklib.deviceprovisioner.DeviceProperties$Companion.$$INSTANCE;

    @Nullable
    public String getModel();

    @Nullable
    public String getManufacturer();

    @Nullable
    default public Abi getPrimaryAbi() {
        return (Abi)CollectionsKt.firstOrNull(this.getAbiList());
    }

    @Nullable
    public String getPreferredAbi();

    @NotNull
    public List<Abi> getAbiList();

    @Nullable
    public AndroidVersion getAndroidVersion();

    @Nullable
    public String getAndroidRelease();

    @Nullable
    public DeviceType getDeviceType();

    @Nullable
    public Boolean isVirtual();

    @Nullable
    public Boolean isRemote();

    @Nullable
    public Boolean isDebuggable();

    @Nullable
    public Boolean isResizable();

    @NotNull
    public Icon getIcon();

    @Nullable
    public Resolution getResolution();

    @Nullable
    default public Resolution getResolutionDp() {
        Resolution resolution = this.getResolution();
        if (resolution == null) {
            return null;
        }
        Resolution resolution2 = resolution;
        Integer n = this.getDensity();
        if (n == null) {
            return null;
        }
        int density = n;
        return new Resolution((int)Math.ceil((double)Density.DEFAULT_DENSITY * (double)resolution2.getWidth() / (double)density), (int)Math.ceil((double)Density.DEFAULT_DENSITY * (double)resolution2.getHeight() / (double)density));
    }

    @Nullable
    public Integer getDensity();

    @Nullable
    public String getDisambiguator();

    @Nullable
    public String getWearPairingId();

    @Nullable
    public ConnectionType getConnectionType();

    @NotNull
    default public String getTitle() {
        Object object;
        CharSequence charSequence = this.getManufacturer();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            object = this.getModel();
            if (object == null) {
                object = "Unknown";
            }
        } else {
            charSequence = this.getModel();
            object = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.getManufacturer() + " Device" : this.getManufacturer() + " " + this.getModel();
        }
        return object;
    }

    @NotNull
    public DeviceInfo getDeviceInfoProto();

    @NotNull
    public Builder toBuilder();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZJ\u000e\u0010[\u001a\u00020X2\u0006\u0010\\\u001a\u00020\u0005J\u001a\u0010]\u001a\u00020X2\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050^J4\u0010_\u001a\u00020X2\u0006\u0010`\u001a\u00020\u00052\b\u0010a\u001a\u0004\u0018\u00010\u00052\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050^2\u0006\u0010b\u001a\u00020\u0005J\u0010\u0010c\u001a\u00020\u00052\b\b\u0002\u0010d\u001a\u00020?J\b\u0010e\u001a\u00020ZH\u0016J\b\u0010f\u001a\u00020ZH\u0007J\b\u0010g\u001a\u00020ZH\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0007\"\u0004\b\u0016\u0010\tR\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0007\"\u0004\b\u001f\u0010\tR\u001c\u0010 \u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0007\"\u0004\b\"\u0010\tR\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001e\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010.\u001a\u0004\b)\u0010+\"\u0004\b,\u0010-R\u001e\u0010/\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010.\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u001e\u00101\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010.\u001a\u0004\b1\u0010+\"\u0004\b2\u0010-R\u001e\u00103\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010.\u001a\u0004\b3\u0010+\"\u0004\b4\u0010-R\u001c\u00105\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0007\"\u0004\b7\u0010\tR\u001c\u00108\u001a\u0004\u0018\u000109X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001e\u0010>\u001a\u0004\u0018\u00010?X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010D\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001c\u0010E\u001a\u0004\u0018\u00010FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u001c\u0010K\u001a\u0004\u0018\u00010LX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010Q\u001a\u00020RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010V\u00a8\u0006h"}, d2={"Lcom/android/sdklib/deviceprovisioner/DeviceProperties$Builder;", "", "<init>", "()V", "manufacturer", "", "getManufacturer", "()Ljava/lang/String;", "setManufacturer", "(Ljava/lang/String;)V", "model", "getModel", "setModel", "abiList", "", "Lcom/android/sdklib/devices/Abi;", "getAbiList", "()Ljava/util/List;", "setAbiList", "(Ljava/util/List;)V", "preferredAbi", "getPreferredAbi", "setPreferredAbi", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "getAndroidVersion", "()Lcom/android/sdklib/AndroidVersion;", "setAndroidVersion", "(Lcom/android/sdklib/AndroidVersion;)V", "androidRelease", "getAndroidRelease", "setAndroidRelease", "disambiguator", "getDisambiguator", "setDisambiguator", "deviceType", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getDeviceType", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "setDeviceType", "(Lcom/android/sdklib/deviceprovisioner/DeviceType;)V", "isVirtual", "", "()Ljava/lang/Boolean;", "setVirtual", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "isRemote", "setRemote", "isDebuggable", "setDebuggable", "isResizable", "setResizable", "wearPairingId", "getWearPairingId", "setWearPairingId", "resolution", "Lcom/android/sdklib/deviceprovisioner/Resolution;", "getResolution", "()Lcom/android/sdklib/deviceprovisioner/Resolution;", "setResolution", "(Lcom/android/sdklib/deviceprovisioner/Resolution;)V", "density", "", "getDensity", "()Ljava/lang/Integer;", "setDensity", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "setIcon", "(Ljavax/swing/Icon;)V", "connectionType", "Lcom/android/sdklib/deviceprovisioner/ConnectionType;", "getConnectionType", "()Lcom/android/sdklib/deviceprovisioner/ConnectionType;", "setConnectionType", "(Lcom/android/sdklib/deviceprovisioner/ConnectionType;)V", "deviceInfoProto", "Lcom/google/wireless/android/sdk/stats/DeviceInfo$Builder;", "getDeviceInfoProto", "()Lcom/google/wireless/android/sdk/stats/DeviceInfo$Builder;", "setDeviceInfoProto", "(Lcom/google/wireless/android/sdk/stats/DeviceInfo$Builder;)V", "copyFrom", "", "properties", "Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "readAdbSerialNumber", "adbSerialNumber", "readCommonProperties", "", "populateDeviceInfoProto", "pluginId", "serialNumber", "connectionId", "randomConnectionId", "length", "build", "buildBaseForTest", "buildBaseWithoutChecks", "android.sdktools.device-provisioner"})
    @SourceDebugExtension(value={"SMAP\nDeviceProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceProperties.kt\ncom/android/sdklib/deviceprovisioner/DeviceProperties$Builder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,471:1\n1611#2,9:472\n1863#2:481\n1864#2:483\n1620#2:484\n1#3:482\n1#3:485\n*S KotlinDebug\n*F\n+ 1 DeviceProperties.kt\ncom/android/sdklib/deviceprovisioner/DeviceProperties$Builder\n*L\n235#1:472,9\n235#1:481\n235#1:483\n235#1:484\n235#1:482\n*E\n"})
    public static class Builder {
        @Nullable
        private String manufacturer;
        @Nullable
        private String model;
        @NotNull
        private List<? extends Abi> abiList = CollectionsKt.emptyList();
        @Nullable
        private String preferredAbi;
        @Nullable
        private AndroidVersion androidVersion;
        @Nullable
        private String androidRelease;
        @Nullable
        private String disambiguator;
        @Nullable
        private DeviceType deviceType;
        @Nullable
        private Boolean isVirtual;
        @Nullable
        private Boolean isRemote;
        @Nullable
        private Boolean isDebuggable;
        @Nullable
        private Boolean isResizable;
        @Nullable
        private String wearPairingId;
        @Nullable
        private Resolution resolution;
        @Nullable
        private Integer density;
        @Nullable
        private Icon icon;
        @Nullable
        private ConnectionType connectionType;
        @NotNull
        private DeviceInfo.Builder deviceInfoProto;

        public Builder() {
            DeviceInfo.Builder builder = DeviceInfo.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
            this.deviceInfoProto = builder;
        }

        @Nullable
        public final String getManufacturer() {
            return this.manufacturer;
        }

        public final void setManufacturer(@Nullable String string2) {
            this.manufacturer = string2;
        }

        @Nullable
        public final String getModel() {
            return this.model;
        }

        public final void setModel(@Nullable String string2) {
            this.model = string2;
        }

        @NotNull
        public final List<Abi> getAbiList() {
            return this.abiList;
        }

        public final void setAbiList(@NotNull List<? extends Abi> list2) {
            Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
            this.abiList = list2;
        }

        @Nullable
        public final String getPreferredAbi() {
            return this.preferredAbi;
        }

        public final void setPreferredAbi(@Nullable String string2) {
            this.preferredAbi = string2;
        }

        @Nullable
        public final AndroidVersion getAndroidVersion() {
            return this.androidVersion;
        }

        public final void setAndroidVersion(@Nullable AndroidVersion androidVersion) {
            this.androidVersion = androidVersion;
        }

        @Nullable
        public final String getAndroidRelease() {
            return this.androidRelease;
        }

        public final void setAndroidRelease(@Nullable String string2) {
            this.androidRelease = string2;
        }

        @Nullable
        public final String getDisambiguator() {
            return this.disambiguator;
        }

        public final void setDisambiguator(@Nullable String string2) {
            this.disambiguator = string2;
        }

        @Nullable
        public final DeviceType getDeviceType() {
            return this.deviceType;
        }

        public final void setDeviceType(@Nullable DeviceType deviceType) {
            this.deviceType = deviceType;
        }

        @Nullable
        public final Boolean isVirtual() {
            return this.isVirtual;
        }

        public final void setVirtual(@Nullable Boolean bl) {
            this.isVirtual = bl;
        }

        @Nullable
        public final Boolean isRemote() {
            return this.isRemote;
        }

        public final void setRemote(@Nullable Boolean bl) {
            this.isRemote = bl;
        }

        @Nullable
        public final Boolean isDebuggable() {
            return this.isDebuggable;
        }

        public final void setDebuggable(@Nullable Boolean bl) {
            this.isDebuggable = bl;
        }

        @Nullable
        public final Boolean isResizable() {
            return this.isResizable;
        }

        public final void setResizable(@Nullable Boolean bl) {
            this.isResizable = bl;
        }

        @Nullable
        public final String getWearPairingId() {
            return this.wearPairingId;
        }

        public final void setWearPairingId(@Nullable String string2) {
            this.wearPairingId = string2;
        }

        @Nullable
        public final Resolution getResolution() {
            return this.resolution;
        }

        public final void setResolution(@Nullable Resolution resolution) {
            this.resolution = resolution;
        }

        @Nullable
        public final Integer getDensity() {
            return this.density;
        }

        public final void setDensity(@Nullable Integer n) {
            this.density = n;
        }

        @Nullable
        public final Icon getIcon() {
            return this.icon;
        }

        public final void setIcon(@Nullable Icon icon) {
            this.icon = icon;
        }

        @Nullable
        public final ConnectionType getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(@Nullable ConnectionType connectionType) {
            this.connectionType = connectionType;
        }

        @NotNull
        public final DeviceInfo.Builder getDeviceInfoProto() {
            return this.deviceInfoProto;
        }

        public final void setDeviceInfoProto(@NotNull DeviceInfo.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"<set-?>");
            this.deviceInfoProto = builder;
        }

        public final void copyFrom(@NotNull DeviceProperties properties) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            this.manufacturer = properties.getManufacturer();
            this.model = properties.getModel();
            this.androidVersion = properties.getAndroidVersion();
            this.abiList = properties.getAbiList();
            this.preferredAbi = properties.getPreferredAbi();
            this.androidRelease = properties.getAndroidRelease();
            this.disambiguator = properties.getDisambiguator();
            this.deviceType = properties.getDeviceType();
            this.isVirtual = properties.isVirtual();
            this.isRemote = properties.isRemote();
            this.isDebuggable = properties.isDebuggable();
            this.isResizable = properties.isResizable();
            this.wearPairingId = properties.getWearPairingId();
            this.resolution = properties.getResolution();
            this.density = properties.getDensity();
            this.icon = properties.getIcon();
            this.connectionType = properties.getConnectionType();
            DeviceInfo.Builder builder = properties.getDeviceInfoProto().toBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"toBuilder(...)");
            this.deviceInfoProto = builder;
        }

        public final void readAdbSerialNumber(@NotNull String adbSerialNumber) {
            Intrinsics.checkNotNullParameter((Object)adbSerialNumber, (String)"adbSerialNumber");
            SerialNumberAndMdnsConnectionType it = SerialNumberAndMdnsConnectionType.Companion.fromAdbSerialNumber(adbSerialNumber);
            boolean bl = false;
            this.wearPairingId = it.getSerialNumber();
            this.deviceInfoProto.setMdnsConnectionType(it.getMdnsConnectionType());
            switch (WhenMappings.$EnumSwitchMapping$0[it.getMdnsConnectionType().ordinal()]) {
                case 1: 
                case 2: {
                    this.connectionType = ConnectionType.WIFI;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void readCommonProperties(@NotNull Map<String, String> properties) {
            DeviceType deviceType;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object[] objectArray;
            String string2;
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            String string3 = properties.get("ro.product.manufacturer");
            if (string3 == null) {
                string3 = this.manufacturer = properties.get("ro.manufacturer");
            }
            if ((string2 = properties.get("ro.product.model")) == null) {
                string2 = properties.get("ro.model");
            }
            this.model = string2;
            this.androidVersion = AndroidVersionUtil.androidVersionFromDeviceProperties(properties);
            Object object = properties.get("ro.product.cpu.abilist");
            if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(objectArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
                objectArray = new String[]{properties.get("ro.product.cpu.abi"), properties.get("ro.product.cpu.abi2")};
                object = CollectionsKt.listOfNotNull((Object[])objectArray);
            }
            Object abiStrings = object;
            Iterable iterable = (Iterable)abiStrings;
            Builder builder = this;
            boolean $i$f$mapNotNull = false;
            objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Abi it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (Abi.getEnum((String)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            builder.abiList = (List)destination$iv$iv;
            this.androidRelease = properties.get("ro.build.version.release");
            String string4 = properties.get("ro.build.characteristics");
            if (string4 == null) {
                string4 = "";
            }
            Object[] objectArray2 = new String[]{","};
            List characteristics = StringsKt.split$default((CharSequence)string4, (String[])objectArray2, (boolean)false, (int)0, (int)6, null);
            if (characteristics.contains("watch")) {
                deviceType = DeviceType.WEAR;
            } else if (characteristics.contains("tv")) {
                deviceType = DeviceType.TV;
            } else if (characteristics.contains("automotive")) {
                deviceType = DeviceType.AUTOMOTIVE;
            } else if (characteristics.contains("xr")) {
                deviceType = DeviceType.XR_HEADSET;
            } else {
                String string5 = properties.get("ro.build.product");
                deviceType = (string5 != null ? StringsKt.startsWith$default((String)string5, (String)"xr", (boolean)false, (int)2, null) : false) ? DeviceType.XR_HEADSET : DeviceType.HANDHELD;
            }
            this.deviceType = deviceType;
            this.isVirtual = Intrinsics.areEqual((Object)properties.get("ro.kernel.qemu"), (Object)"1");
            objectArray2 = new String[]{"userdebug", "eng"};
            this.isDebuggable = CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray2), (Object)properties.get("ro.build.type"));
            String string6 = properties.get("ro.sf.lcd_density");
            this.density = string6 != null ? StringsKt.toIntOrNull((String)string6) : null;
        }

        public final void populateDeviceInfoProto(@NotNull String pluginId, @Nullable String serialNumber, @NotNull Map<String, String> properties, @NotNull String connectionId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
            String string2 = Anonymizer.anonymize((String)serialNumber);
            if (string2 == null) {
                string2 = "";
            }
            this.deviceInfoProto.setAnonymizedSerialNumber(string2);
            String string3 = properties.get("ro.build.tags");
            if (string3 == null) {
                string3 = "";
            }
            this.deviceInfoProto.setBuildTags(string3);
            String string4 = properties.get("ro.build.type");
            if (string4 == null) {
                string4 = "";
            }
            this.deviceInfoProto.setBuildType(string4);
            String string5 = this.androidRelease;
            if (string5 == null) {
                string5 = "";
            }
            this.deviceInfoProto.setBuildVersionRelease(string5);
            Abi abi = (Abi)CollectionsKt.firstOrNull(this.abiList);
            this.deviceInfoProto.setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)(abi != null ? abi.toString() : null)));
            String string6 = this.manufacturer;
            if (string6 == null) {
                string6 = "";
            }
            this.deviceInfoProto.setManufacturer(string6);
            String string7 = this.model;
            if (string7 == null) {
                string7 = "";
            }
            this.deviceInfoProto.setModel(string7);
            this.deviceInfoProto.setDeviceType(Intrinsics.areEqual((Object)this.isRemote, (Object)true) && Intrinsics.areEqual((Object)this.isVirtual, (Object)true) ? DeviceInfo.DeviceType.CLOUD_EMULATOR : (Intrinsics.areEqual((Object)this.isRemote, (Object)true) ? DeviceInfo.DeviceType.CLOUD_PHYSICAL : (Intrinsics.areEqual((Object)this.isVirtual, (Object)true) ? DeviceInfo.DeviceType.LOCAL_EMULATOR : (Intrinsics.areEqual((Object)this.isVirtual, (Object)false) ? DeviceInfo.DeviceType.LOCAL_PHYSICAL : DeviceInfo.DeviceType.UNKNOWN_DEVICE_TYPE))));
            Object object = this.androidVersion;
            if (object == null || (object = object.getApiStringWithExtension()) == null) {
                object = "";
            }
            this.deviceInfoProto.setBuildApiLevelFull((String)object);
            String string8 = properties.get("ro.build.characteristics");
            if (string8 != null) {
                String it = string8;
                boolean bl = false;
                String[] stringArray = new String[]{","};
                this.deviceInfoProto.addAllCharacteristics((Iterable)StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }
            this.deviceInfoProto.setDeviceProvisionerId(pluginId);
            this.deviceInfoProto.setConnectionId(connectionId);
        }

        @NotNull
        public final String randomConnectionId(int length) {
            StringBuilder stringBuilder;
            StringBuilder $this$randomConnectionId_u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl = false;
            IntRange intRange = RangesKt.until((int)0, (int)16);
            int n = 0;
            while (n < length) {
                int it = n++;
                boolean bl2 = false;
                String string2 = Integer.toString(RangesKt.random((IntRange)intRange, (Random)((Random)Random.Default)), CharsKt.checkRadix((int)36));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                $this$randomConnectionId_u24lambda_u244.append(string2);
            }
            return stringBuilder.toString();
        }

        public static /* synthetic */ String randomConnectionId$default(Builder builder, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: randomConnectionId");
            }
            if ((n2 & 1) != 0) {
                n = 8;
            }
            return builder.randomConnectionId(n);
        }

        @NotNull
        public DeviceProperties build() {
            String string2 = this.deviceInfoProto.getDeviceProvisionerId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDeviceProvisionerId(...)");
            if (!(((CharSequence)string2).length() > 0)) {
                boolean bl = false;
                String string3 = "populateDeviceInfoProto was not invoked";
                throw new IllegalStateException(string3.toString());
            }
            return this.buildBaseWithoutChecks();
        }

        @VisibleForTesting
        @NotNull
        public final DeviceProperties buildBaseForTest() {
            return this.buildBaseWithoutChecks();
        }

        private final DeviceProperties buildBaseWithoutChecks() {
            Icon icon = this.icon;
            if (icon == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            DeviceInfo deviceInfo = this.deviceInfoProto.build();
            Intrinsics.checkNotNullExpressionValue((Object)deviceInfo, (String)"build(...)");
            return new BaseDeviceProperties(this.manufacturer, this.model, this.androidVersion, this.abiList, this.preferredAbi, this.androidRelease, this.disambiguator, this.deviceType, this.isVirtual, this.isRemote, this.isDebuggable, this.isResizable, this.wearPairingId, this.resolution, this.density, icon, this.connectionType, deviceInfo);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DeviceInfo.MdnsConnectionType.values().length];
                try {
                    nArray[DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_UNENCRYPTED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_TLS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0086\b\u00f8\u0001\u0000J%\u0010\u000b\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nH\u0087\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\f"}, d2={"Lcom/android/sdklib/deviceprovisioner/DeviceProperties$Companion;", "", "<init>", "()V", "build", "Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "block", "Lkotlin/Function1;", "Lcom/android/sdklib/deviceprovisioner/DeviceProperties$Builder;", "", "Lkotlin/ExtensionFunctionType;", "buildForTest", "android.sdktools.device-provisioner"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final DeviceProperties build(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$build = false;
            Builder builder = new Builder();
            block.invoke((Object)builder);
            return builder.build();
        }

        @VisibleForTesting
        @NotNull
        public final DeviceProperties buildForTest(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$buildForTest = false;
            Builder builder = new Builder();
            block.invoke((Object)builder);
            return builder.buildBaseForTest();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @Nullable
        public static Abi getPrimaryAbi(@NotNull DeviceProperties $this) {
            return $this.getPrimaryAbi();
        }

        @Deprecated
        @Nullable
        public static Resolution getResolutionDp(@NotNull DeviceProperties $this) {
            return $this.getResolutionDp();
        }

        @Deprecated
        @NotNull
        public static String getTitle(@NotNull DeviceProperties $this) {
            return $this.getTitle();
        }
    }
}

