/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ProgressManagerAdapter;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValueImpl;
import com.android.ide.common.resources.AndroidAaptIgnore;
import com.android.ide.common.resources.PatternBasedFileFilter;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.io.CancellableFileIo;
import com.android.resources.Arity;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicArrayResourceItem;
import com.android.resources.base.BasicAttrResourceItem;
import com.android.resources.base.BasicDensityBasedFileResourceItem;
import com.android.resources.base.BasicFileResourceItem;
import com.android.resources.base.BasicForeignAttrResourceItem;
import com.android.resources.base.BasicPluralsResourceItem;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.BasicStyleResourceItem;
import com.android.resources.base.BasicStyleableResourceItem;
import com.android.resources.base.BasicTextValueResourceItem;
import com.android.resources.base.BasicValueResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.CommentTrackingXmlPullParser;
import com.android.resources.base.FileFilter;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.resources.base.ResourceSourceFileImpl;
import com.android.resources.base.ResourceUrlParser;
import com.android.resources.base.ValueResourceXmlParser;
import com.android.tools.environment.Logger;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class RepositoryLoader<T extends LoadableResourceRepository>
implements FileFilter {
    private static final Logger LOG = Logger.getInstance(RepositoryLoader.class);
    private final Set<AttributeFormat> DEFAULT_ATTR_FORMATS = Sets.immutableEnumSet((Enum)AttributeFormat.BOOLEAN, (Enum[])new AttributeFormat[]{AttributeFormat.COLOR, AttributeFormat.DIMENSION, AttributeFormat.FLOAT, AttributeFormat.FRACTION, AttributeFormat.INTEGER, AttributeFormat.REFERENCE, AttributeFormat.STRING});
    private final PatternBasedFileFilter myFileFilter = new PatternBasedFileFilter(new AndroidAaptIgnore(System.getenv("ANDROID_AAPT_IGNORE")));
    private final Map<ResourceType, Set<String>> myPublicResources = new EnumMap<ResourceType, Set<String>>(ResourceType.class);
    private final ListMultimap<String, BasicAttrResourceItem> myAttrs = ArrayListMultimap.create();
    private final ListMultimap<String, BasicAttrResourceItem> myAttrCandidates = ArrayListMultimap.create();
    private final ListMultimap<String, BasicStyleableResourceItem> myStyleables = ArrayListMultimap.create();
    protected ResourceVisibility myDefaultVisibility = ResourceVisibility.PRIVATE;
    protected final Map<String, FolderConfiguration> myFolderConfigCache = new HashMap<String, FolderConfiguration>();
    private final Map<FolderConfiguration, RepositoryConfiguration> myConfigCache = new HashMap<FolderConfiguration, RepositoryConfiguration>();
    private final ValueResourceXmlParser myParser = new ValueResourceXmlParser();
    private final XmlTextExtractor myTextExtractor = new XmlTextExtractor();
    private final ResourceUrlParser myUrlParser = new ResourceUrlParser();
    private final Table<ResourceType, String, BasicValueResourceItemBase> myValueFileResources = Tables.newCustomTable(new EnumMap(ResourceType.class), LinkedHashMap::new);
    protected final Path myResourceDirectoryOrFile;
    private final PathString myResourceDirectoryOrFilePath;
    private final boolean myLoadingFromZipArchive;
    private final ResourceNamespace myNamespace;
    private final Collection<PathString> myResourceFilesAndFolders;
    protected ZipFile myZipFile;

    public RepositoryLoader(Path resourceDirectoryOrFile, Collection<PathString> resourceFilesAndFolders, ResourceNamespace namespace) {
        this.myResourceDirectoryOrFile = resourceDirectoryOrFile;
        this.myResourceDirectoryOrFilePath = new PathString(this.myResourceDirectoryOrFile);
        this.myLoadingFromZipArchive = RepositoryLoader.isZipArchive(resourceDirectoryOrFile);
        this.myNamespace = namespace;
        this.myResourceFilesAndFolders = resourceFilesAndFolders;
    }

    public final Path getResourceDirectoryOrFile() {
        return this.myResourceDirectoryOrFile;
    }

    public final boolean isLoadingFromZipArchive() {
        return this.myLoadingFromZipArchive;
    }

    public final ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    public void loadRepositoryContents(T repository2) {
        if (this.myLoadingFromZipArchive) {
            this.loadFromZip(repository2);
        } else {
            this.loadFromResFolder(repository2);
        }
    }

    public List<String> getPublicXmlFileNames() {
        return ImmutableList.of((Object)"public.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromZip(T repository2) {
        try (ZipFile zipFile = new ZipFile(this.myResourceDirectoryOrFile.toFile());){
            this.myZipFile = zipFile;
            this.loadPublicResourceNames();
            boolean shouldParseResourceIds = !this.loadIdsFromRTxt();
            zipFile.stream().forEach(zipEntry -> {
                if (!zipEntry.isDirectory()) {
                    PathString path = new PathString(zipEntry.getName());
                    this.loadResourceFile(path, repository2, shouldParseResourceIds);
                }
            });
        }
        catch (Exception e) {
            ProgressManagerAdapter.throwIfCancellation((Throwable)e);
            LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
        }
        finally {
            this.myZipFile = null;
        }
        this.finishLoading(repository2);
    }

    protected void loadFromResFolder(T repository2) {
        try {
            if (CancellableFileIo.notExists((Path)this.myResourceDirectoryOrFile, (LinkOption[])new LinkOption[0])) {
                return;
            }
            this.loadPublicResourceNames();
            boolean shouldParseResourceIds = !this.loadIdsFromRTxt();
            ImmutableList sourceFilesAndFolders = this.myResourceFilesAndFolders == null ? ImmutableList.of((Object)this.myResourceDirectoryOrFile) : this.myResourceFilesAndFolders.stream().map(PathString::toPath).collect(Collectors.toList());
            List<PathString> resourceFiles = this.findResourceFiles((List<Path>)sourceFilesAndFolders);
            for (PathString file : resourceFiles) {
                this.loadResourceFile(file, repository2, shouldParseResourceIds);
            }
        }
        catch (Exception e) {
            ProgressManagerAdapter.throwIfCancellation((Throwable)e);
            LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
        }
        this.finishLoading(repository2);
    }

    protected final void loadResourceFile(PathString file, T repository2, boolean shouldParseResourceIds) {
        FolderInfo folderInfo;
        String folderName = file.getParentFileName();
        if (folderName != null && (folderInfo = FolderInfo.create(folderName, this.myFolderConfigCache)) != null) {
            RepositoryConfiguration configuration = this.getConfiguration(repository2, folderInfo.configuration);
            this.loadResourceFile(file, folderInfo, configuration, shouldParseResourceIds);
        }
    }

    protected void finishLoading(T repository2) {
        this.processAttrsAndStyleables();
    }

    public final String getSourceFileProtocol() {
        if (this.myLoadingFromZipArchive) {
            return "jar";
        }
        return "file";
    }

    public String getResourcePathPrefix() {
        if (this.myLoadingFromZipArchive) {
            return RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "!/res/";
        }
        return RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "/";
    }

    public String getResourceUrlPrefix() {
        if (this.myLoadingFromZipArchive) {
            return "jar://" + RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "!/res/";
        }
        return RepositoryLoader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "/";
    }

    protected boolean loadIdsFromRTxt() {
        return false;
    }

    @Override
    public boolean isIgnored(Path fileOrDirectory, BasicFileAttributes attrs) {
        if (fileOrDirectory.equals(this.myResourceDirectoryOrFile)) {
            return false;
        }
        return this.myFileFilter.isIgnored(fileOrDirectory.toString(), attrs.isDirectory());
    }

    protected void loadPublicResourceNames() {
        Path valuesFolder = this.myResourceDirectoryOrFile.resolve("values");
        List<String> fileNames = this.getPublicXmlFileNames();
        for (String fileName : fileNames) {
            Path publicXmlFile = valuesFolder.resolve(fileName);
            try (BufferedInputStream stream2 = new BufferedInputStream(CancellableFileIo.newInputStream((Path)publicXmlFile, (OpenOption[])new OpenOption[0]));){
                CommentTrackingXmlPullParser parser2 = new CommentTrackingXmlPullParser();
                parser2.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                parser2.setInput(stream2, StandardCharsets.UTF_8.name());
                String groupTag = null;
                ResourceType groupType = null;
                ResourceType lastType = null;
                String lastTypeName = "";
                while (true) {
                    int event;
                    if ((event = parser2.nextToken()) == 2) {
                        if (parser2.getName().equals("public")) {
                            ResourceType type;
                            String name = null;
                            String typeName = groupType == null ? null : groupType.getName();
                            int n = parser2.getAttributeCount();
                            for (int i = 0; i < n; ++i) {
                                String attribute = parser2.getAttributeName(i);
                                if (attribute.equals("name")) {
                                    name = parser2.getAttributeValue(i);
                                    if (typeName == null) continue;
                                    break;
                                }
                                if (!attribute.equals("type")) continue;
                                typeName = parser2.getAttributeValue(i);
                            }
                            if (name == null || name.startsWith("__removed") || typeName == null && groupType == null || parser2.getLastComment() != null && RepositoryLoader.containsWord(parser2.getLastComment(), "@hide")) continue;
                            if (groupType != null) {
                                type = groupType;
                            } else if (typeName.equals(lastTypeName)) {
                                type = lastType;
                            } else {
                                lastType = type = ResourceType.fromXmlValue((String)typeName);
                                lastTypeName = typeName;
                            }
                            if (type != null) {
                                this.addPublicResourceName(type, name);
                                continue;
                            }
                            LOG.error("Public resource declaration \"" + name + "\" of type " + typeName + " points to unknown resource type.");
                            continue;
                        }
                        if (!this.isPublicGroupTag(parser2.getName())) continue;
                        groupTag = parser2.getName();
                        String typeName = parser2.getAttributeValue(null, "type");
                        groupType = typeName == null ? null : ResourceType.fromXmlValue((String)typeName);
                        continue;
                    }
                    if (event == 3) {
                        if (groupTag == null || !groupTag.equals(parser2.getName())) continue;
                        groupTag = null;
                        groupType = null;
                        continue;
                    }
                    if (event == 1) break;
                }
            }
            catch (NoSuchFileException stream2) {
            }
            catch (Exception e) {
                ProgressManagerAdapter.throwIfCancellation((Throwable)e);
                LOG.error("Can't read and parse " + publicXmlFile, (Throwable)e);
            }
        }
    }

    private boolean isPublicGroupTag(String tag) {
        return tag.equals("public-group") || tag.equals("staging-public-group") || tag.equals("staging-public-group-final");
    }

    protected final void addPublicResourceName(ResourceType type, String name) {
        Set names = this.myPublicResources.computeIfAbsent(type, t -> new HashSet());
        names.add(name);
    }

    private static boolean containsWord(String text, String word) {
        int start2;
        int end2 = 0;
        do {
            if ((start2 = text.indexOf(word, end2)) < 0) {
                return false;
            }
            end2 = start2 + word.length();
        } while (start2 != 0 && !Character.isWhitespace(text.charAt(start2)) || end2 != text.length() && !Character.isWhitespace(text.charAt(end2)));
        return true;
    }

    private List<PathString> findResourceFiles(List<Path> filesOrFolders) {
        ResourceFileCollector fileCollector = new ResourceFileCollector(this);
        for (Path file : filesOrFolders) {
            try {
                CancellableFileIo.walkFileTree((Path)file, (FileVisitor)fileCollector);
            }
            catch (IOException iOException) {}
        }
        for (IOException e : fileCollector.ioErrors) {
            LOG.error("Error loading resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
        }
        Collections.sort(fileCollector.resourceFiles);
        return fileCollector.resourceFiles;
    }

    protected final RepositoryConfiguration getConfiguration(T repository2, FolderConfiguration folderConfiguration) {
        RepositoryConfiguration repositoryConfiguration = this.myConfigCache.get(folderConfiguration);
        if (repositoryConfiguration != null) {
            return repositoryConfiguration;
        }
        repositoryConfiguration = new RepositoryConfiguration((LoadableResourceRepository)repository2, folderConfiguration);
        this.myConfigCache.put(folderConfiguration, repositoryConfiguration);
        return repositoryConfiguration;
    }

    private void loadResourceFile(PathString file, FolderInfo folderInfo, RepositoryConfiguration configuration, boolean shouldParseResourceIds) {
        if (folderInfo.resourceType == null) {
            if (RepositoryLoader.isXmlFile(file)) {
                this.parseValueResourceFile(file, configuration);
            }
        } else {
            if (shouldParseResourceIds && folderInfo.isIdGenerating && RepositoryLoader.isXmlFile(file)) {
                this.parseIdGeneratingResourceFile(file, configuration);
            }
            BasicFileResourceItem item = this.createFileResourceItem(file, folderInfo.resourceType, configuration);
            this.addResourceItem(item);
        }
    }

    protected static boolean isXmlFile(PathString file) {
        return RepositoryLoader.isXmlFile(file.getFileName());
    }

    protected static boolean isXmlFile(String filename) {
        return SdkUtils.endsWithIgnoreCase((String)filename, (String)".xml");
    }

    private void addResourceItem(BasicResourceItemBase item) {
        this.addResourceItem(item, item.getRepository());
    }

    protected abstract void addResourceItem(BasicResourceItem var1, T var2);

    protected final void parseValueResourceFile(PathString file, RepositoryConfiguration configuration) {
        try (InputStream stream = this.getInputStream(file);){
            int event;
            ResourceSourceFile sourceFile = this.createResourceSourceFile(file, configuration);
            this.myParser.setInput(stream, null);
            do {
                event = this.myParser.nextToken();
                int depth = this.myParser.getDepth();
                if (event != 2 || this.myParser.getPrefix() != null) continue;
                String tagName = this.myParser.getName();
                assert (depth <= 2);
                if (depth == 1) {
                    if (tagName.equals("resources")) continue;
                    break;
                }
                if (depth <= 1) continue;
                ResourceType resourceType = this.getResourceType(tagName, file);
                if (resourceType != null && resourceType != ResourceType.PUBLIC) {
                    String resourceName = this.myParser.getAttributeValue(null, "name");
                    if (resourceName != null) {
                        this.validateResourceName(resourceName, resourceType, file);
                        BasicValueResourceItemBase item = this.createResourceItem(resourceType, resourceName, sourceFile);
                        this.addValueResourceItem(item);
                        continue;
                    }
                    this.skipSubTags();
                    continue;
                }
                this.skipSubTags();
            } while (event != 1);
        }
        catch (XmlSyntaxException | IOException | RuntimeException | XmlPullParserException e) {
            ProgressManagerAdapter.throwIfCancellation((Throwable)e);
            this.handleParsingError(file, (Exception)e);
        }
        this.addValueFileResources();
    }

    protected ResourceSourceFile createResourceSourceFile(PathString file, RepositoryConfiguration configuration) {
        return new ResourceSourceFileImpl(this.getResRelativePath(file), configuration);
    }

    private void addValueResourceItem(BasicValueResourceItemBase item) {
        ResourceType resourceType = item.getType();
        if (resourceType == ResourceType.ATTR) {
            RepositoryLoader.addAttr((BasicAttrResourceItem)item, this.myAttrs);
        } else if (resourceType == ResourceType.STYLEABLE) {
            this.myStyleables.put((Object)item.getName(), (Object)((BasicStyleableResourceItem)item));
        } else {
            this.myValueFileResources.put((Object)resourceType, (Object)item.getName(), (Object)item);
        }
    }

    protected final void addValueFileResources() {
        for (BasicValueResourceItemBase item : this.myValueFileResources.values()) {
            this.addResourceItem(item);
        }
        this.myValueFileResources.clear();
    }

    protected final void parseIdGeneratingResourceFile(PathString file, RepositoryConfiguration configuration) {
        try (InputStream stream = this.getInputStream(file);){
            int event;
            ResourceSourceFile sourceFile = this.createResourceSourceFile(file, configuration);
            KXmlParser parser2 = new KXmlParser();
            parser2.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser2.setInput(stream, null);
            do {
                if ((event = parser2.nextToken()) != 2) continue;
                int numAttributes = parser2.getAttributeCount();
                for (int i = 0; i < numAttributes; ++i) {
                    String idValue = parser2.getAttributeValue(i);
                    if (!idValue.startsWith("@+id/") || idValue.length() <= "@+id/".length()) continue;
                    String resourceName = idValue.substring("@+id/".length());
                    this.addIdResourceItem(resourceName, sourceFile);
                }
            } while (event != 1);
        }
        catch (IOException | RuntimeException | XmlPullParserException e) {
            ProgressManagerAdapter.throwIfCancellation((Throwable)e);
            this.handleParsingError(file, (Exception)e);
        }
        this.addValueFileResources();
    }

    protected void handleParsingError(PathString file, Exception e) {
        LOG.warn("Failed to parse " + file.toString(), (Throwable)e);
    }

    protected InputStream getInputStream(PathString file) throws IOException {
        if (this.myZipFile == null) {
            Path path = file.toPath();
            Preconditions.checkArgument((path != null ? 1 : 0) != 0);
            return new BufferedInputStream(CancellableFileIo.newInputStream((Path)path, (OpenOption[])new OpenOption[0]));
        }
        ProgressManagerAdapter.checkCanceled();
        ZipEntry entry = this.myZipFile.getEntry(file.getPortablePath());
        if (entry == null) {
            throw new NoSuchFileException(file.getPortablePath());
        }
        return new BufferedInputStream(this.myZipFile.getInputStream(entry));
    }

    protected final void addIdResourceItem(String resourceName, ResourceSourceFile sourceFile) {
        ResourceVisibility visibility = this.getVisibility(ResourceType.ID, resourceName);
        BasicValueResourceItem item = new BasicValueResourceItem(ResourceType.ID, resourceName, sourceFile, visibility, null);
        if (!RepositoryLoader.resourceAlreadyDefined(item)) {
            this.addValueResourceItem(item);
        }
    }

    private BasicFileResourceItem createFileResourceItem(PathString file, ResourceType resourceType, RepositoryConfiguration configuration) {
        DensityQualifier densityQualifier;
        String resourceName = SdkUtils.fileNameToResourceName((String)file.getFileName());
        ResourceVisibility visibility = this.getVisibility(resourceType, resourceName);
        Density density = null;
        if (DensityBasedResourceValue.isDensityBasedResourceType((ResourceType)resourceType) && (densityQualifier = configuration.getFolderConfiguration().getDensityQualifier()) != null) {
            density = densityQualifier.getValue();
        }
        return this.createFileResourceItem(file, resourceType, resourceName, configuration, visibility, density);
    }

    protected final BasicFileResourceItem createFileResourceItem(PathString file, ResourceType type, String name, RepositoryConfiguration configuration, ResourceVisibility visibility, Density density) {
        String relativePath = this.getResRelativePath(file);
        return density == null ? new BasicFileResourceItem(type, name, configuration, visibility, relativePath) : new BasicDensityBasedFileResourceItem(type, name, configuration, visibility, relativePath, density);
    }

    private BasicValueResourceItemBase createResourceItem(ResourceType type, String name, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        switch (type) {
            case ARRAY: {
                return this.createArrayItem(name, sourceFile);
            }
            case ATTR: {
                return this.createAttrItem(name, sourceFile);
            }
            case PLURALS: {
                return this.createPluralsItem(name, sourceFile);
            }
            case STRING: {
                return this.createStringItem(type, name, sourceFile, true);
            }
            case STYLE: {
                return this.createStyleItem(name, sourceFile);
            }
            case STYLEABLE: {
                return this.createStyleableItem(name, sourceFile);
            }
            case ANIMATOR: 
            case DRAWABLE: 
            case INTERPOLATOR: 
            case LAYOUT: 
            case MENU: 
            case MIPMAP: 
            case TRANSITION: {
                return this.createFileReferenceItem(type, name, sourceFile);
            }
        }
        return this.createStringItem(type, name, sourceFile, false);
    }

    private BasicArrayResourceItem createArrayItem(String name, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        String indexValue = this.myParser.getAttributeValue("http://schemas.android.com/tools", "index");
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        ArrayList<String> values = new ArrayList<String>();
        this.forSubTags("item", () -> {
            String text = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false);
            values.add(text);
        });
        int index2 = 0;
        if (indexValue != null) {
            try {
                index2 = Integer.parseUnsignedInt(indexValue);
            }
            catch (NumberFormatException e) {
                throw new XmlSyntaxException("The value of the " + namespaceResolver.prefixToUri("http://schemas.android.com/tools") + ":index attribute is not a valid number.", (XmlPullParser)this.myParser, this.getDisplayName(sourceFile));
            }
            if (index2 >= values.size()) {
                throw new XmlSyntaxException("The value of the " + namespaceResolver.prefixToUri("http://schemas.android.com/tools") + ":index attribute is out of bounds.", (XmlPullParser)this.myParser, this.getDisplayName(sourceFile));
            }
        }
        ResourceVisibility visibility = this.getVisibility(ResourceType.ARRAY, name);
        BasicArrayResourceItem item = new BasicArrayResourceItem(name, sourceFile, visibility, values, index2);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private BasicAttrResourceItem createAttrItem(String name, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        BasicAttrResourceItem item;
        ResourceNamespace attrNamespace;
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        this.myUrlParser.parseResourceUrl(name);
        if (this.myUrlParser.hasNamespacePrefix("android")) {
            attrNamespace = ResourceNamespace.ANDROID;
        } else {
            String prefix = this.myUrlParser.getNamespacePrefix();
            attrNamespace = ResourceNamespace.fromNamespacePrefix((String)prefix, (ResourceNamespace)this.myNamespace, (ResourceNamespace.Resolver)this.myParser.getNamespaceResolver());
            if (attrNamespace == null) {
                throw new XmlSyntaxException("Undefined prefix of attr resource name \"" + name + "\"", (XmlPullParser)this.myParser, this.getDisplayName(sourceFile));
            }
        }
        name = this.myUrlParser.getName();
        String description = this.myParser.getLastComment();
        String groupName = this.myParser.getAttrGroupComment();
        String formatString = this.myParser.getAttributeValue(null, "format");
        Set<Object> formats = Strings.isNullOrEmpty((String)formatString) ? EnumSet.noneOf(AttributeFormat.class) : AttributeFormat.parse((String)formatString);
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap descriptionMap = Maps.newHashMapWithExpectedSize((int)8);
        this.forSubTags(null, () -> {
            if (this.myParser.getPrefix() == null) {
                AttributeFormat format;
                String tagName = this.myParser.getName();
                Object object = tagName.equals("enum") ? AttributeFormat.ENUM : (format = tagName.equals("flag") ? AttributeFormat.FLAGS : null);
                if (format != null) {
                    formats.add(format);
                    String valueName = this.myParser.getAttributeValue(null, "name");
                    if (valueName != null) {
                        String valueDescription = this.myParser.getLastComment();
                        if (valueDescription != null) {
                            descriptionMap.put(valueName, valueDescription);
                        }
                        String value = this.myParser.getAttributeValue(null, "value");
                        Integer numericValue = null;
                        if (value != null) {
                            try {
                                numericValue = Long.decode(value).intValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        valueMap.put(valueName, numericValue);
                    }
                }
            }
        });
        if (attrNamespace.equals((Object)this.myNamespace)) {
            ResourceVisibility visibility = this.getVisibility(ResourceType.ATTR, name);
            item = new BasicAttrResourceItem(name, sourceFile, visibility, description, groupName, formats, valueMap, descriptionMap);
        } else {
            item = new BasicForeignAttrResourceItem(attrNamespace, name, sourceFile, description, groupName, formats, (Map<String, Integer>)valueMap, (Map<String, String>)descriptionMap);
        }
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private BasicPluralsResourceItem createPluralsItem(String name, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException, XmlSyntaxException {
        String defaultQuantity = this.myParser.getAttributeValue("http://schemas.android.com/tools", "quantity");
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        EnumMap<Arity, String> values = new EnumMap<Arity, String>(Arity.class);
        this.forSubTags("item", () -> {
            Arity quantity;
            String quantityValue = this.myParser.getAttributeValue(null, "quantity");
            if (quantityValue != null && (quantity = Arity.getEnum((String)quantityValue)) != null) {
                String text = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false);
                values.put(quantity, text);
            }
        });
        Arity defaultArity = null;
        if (!(defaultQuantity == null || (defaultArity = Arity.getEnum((String)defaultQuantity)) != null && values.containsKey(defaultArity))) {
            throw new XmlSyntaxException("Invalid value of the " + namespaceResolver.prefixToUri("http://schemas.android.com/tools") + ":quantity attribute.", (XmlPullParser)this.myParser, this.getDisplayName(sourceFile));
        }
        ResourceVisibility visibility = this.getVisibility(ResourceType.PLURALS, name);
        BasicPluralsResourceItem item = new BasicPluralsResourceItem(name, sourceFile, visibility, values, defaultArity);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private BasicValueResourceItem createStringItem(ResourceType type, String name, ResourceSourceFile sourceFile, boolean withRowXml) throws IOException, XmlPullParserException {
        String rawXml;
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        String text = type == ResourceType.ID ? null : this.myTextExtractor.extractText((XmlPullParser)this.myParser, withRowXml);
        String string2 = rawXml = type == ResourceType.ID ? null : this.myTextExtractor.getRawXml();
        assert (withRowXml || rawXml == null);
        ResourceVisibility visibility = this.getVisibility(type, name);
        BasicValueResourceItem item = rawXml == null ? new BasicValueResourceItem(type, name, sourceFile, visibility, text) : new BasicTextValueResourceItem(type, name, sourceFile, visibility, text, rawXml);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private BasicStyleResourceItem createStyleItem(String name, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException {
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        String parentStyle = this.myParser.getAttributeValue(null, "parent");
        if (parentStyle != null && !parentStyle.isEmpty()) {
            this.myUrlParser.parseResourceUrl(parentStyle);
            parentStyle = this.myUrlParser.getQualifiedName();
        }
        ArrayList<StyleItemResourceValue> styleItems = new ArrayList<StyleItemResourceValue>();
        this.forSubTags("item", () -> {
            ResourceNamespace.Resolver itemNamespaceResolver = this.myParser.getNamespaceResolver();
            String itemName = this.myParser.getAttributeValue(null, "name");
            if (itemName != null) {
                String text = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false);
                StyleItemResourceValueImpl styleItem = new StyleItemResourceValueImpl(this.myNamespace, itemName, text, sourceFile.getRepository().getLibraryName());
                styleItem.setNamespaceResolver(itemNamespaceResolver);
                styleItems.add((StyleItemResourceValue)styleItem);
            }
        });
        ResourceVisibility visibility = this.getVisibility(ResourceType.STYLE, name);
        BasicStyleResourceItem item = new BasicStyleResourceItem(name, sourceFile, visibility, parentStyle, styleItems);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private BasicStyleableResourceItem createStyleableItem(String name, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException {
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        ArrayList<AttrResourceValue> attrs = new ArrayList<AttrResourceValue>();
        this.forSubTags("attr", () -> {
            String attrName = this.myParser.getAttributeValue(null, "name");
            if (attrName != null) {
                try {
                    BasicAttrResourceItem attr = this.createAttrItem(attrName, sourceFile);
                    attrs.add((AttrResourceValue)(attr.getFormats().isEmpty() ? attr : attr.createReference()));
                    if (attr.getNamespace().equals((Object)this.myNamespace) && (this.myNamespace != ResourceNamespace.RES_AUTO || !attr.getFormats().isEmpty())) {
                        RepositoryLoader.addAttr(attr, this.myAttrCandidates);
                    }
                }
                catch (XmlSyntaxException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        BasicStyleableResourceItem item = new BasicStyleableResourceItem(name, sourceFile, ResourceVisibility.PUBLIC, attrs);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private static void addAttr(BasicAttrResourceItem attr, ListMultimap<String, BasicAttrResourceItem> map2) {
        List attrs = map2.get((Object)attr.getName());
        int i = RepositoryLoader.findResourceWithSameNameAndConfiguration((ResourceItem)attr, attrs);
        if (i >= 0) {
            BasicAttrResourceItem existing = (BasicAttrResourceItem)attrs.get(i);
            if (!attr.getFormats().isEmpty()) {
                if (existing.getFormats().isEmpty()) {
                    attrs.set(i, attr);
                } else if (!attr.getFormats().equals(existing.getFormats())) {
                    if (attr.getFormats().containsAll(existing.getFormats())) {
                        existing.setFormats(attr.getFormats());
                    } else if (existing.getFormats().containsAll(attr.getFormats())) {
                        attr.setFormats(existing.getFormats());
                    } else {
                        ImmutableSet formats = EnumSet.copyOf(attr.getFormats());
                        formats.addAll(existing.getFormats());
                        formats = ImmutableSet.copyOf(formats);
                        attr.setFormats((Set<AttributeFormat>)formats);
                        existing.setFormats((Set<AttributeFormat>)formats);
                    }
                }
            }
            if (existing.getFormats().isEmpty() && !attr.getFormats().isEmpty()) {
                attrs.set(i, attr);
            }
        } else {
            attrs.add(attr);
        }
    }

    private void processAttrsAndStyleables() {
        for (BasicAttrResourceItem attr : this.myAttrs.values()) {
            this.addAttrWithAdjustedFormats(attr);
        }
        for (BasicAttrResourceItem attr : this.myAttrCandidates.values()) {
            List attrs;
            int i = RepositoryLoader.findResourceWithSameNameAndConfiguration((ResourceItem)attr, attrs = this.myAttrs.get((Object)attr.getName()));
            if (i >= 0) continue;
            this.addAttrWithAdjustedFormats(attr);
        }
        for (BasicStyleableResourceItem styleable : this.myStyleables.values()) {
            this.addResourceItem(RepositoryLoader.resolveAttrReferences(styleable));
        }
    }

    public static BasicStyleableResourceItem resolveAttrReferences(BasicStyleableResourceItem styleable) {
        LoadableResourceRepository repository2 = styleable.getRepository();
        List<AttrResourceValue> attributes = styleable.getAllAttributes();
        ArrayList<AttrResourceValue> resolvedAttributes = null;
        for (int i = 0; i < attributes.size(); ++i) {
            AttrResourceValue attr = attributes.get(i);
            AttrResourceValue canonicalAttr = BasicStyleableResourceItem.getCanonicalAttr(attr, (ResourceRepository)repository2);
            if (canonicalAttr != attr) {
                if (resolvedAttributes == null) {
                    resolvedAttributes = new ArrayList<AttrResourceValue>(attributes.size());
                    for (int j = 0; j < i; ++j) {
                        resolvedAttributes.add(attributes.get(j));
                    }
                }
                resolvedAttributes.add(canonicalAttr);
                continue;
            }
            if (resolvedAttributes == null) continue;
            resolvedAttributes.add(attr);
        }
        if (resolvedAttributes != null) {
            ResourceNamespace.Resolver namespaceResolver = styleable.getNamespaceResolver();
            styleable = new BasicStyleableResourceItem(styleable.getName(), styleable.getSourceFile(), styleable.getVisibility(), resolvedAttributes);
            styleable.setNamespaceResolver(namespaceResolver);
        }
        return styleable;
    }

    private void addAttrWithAdjustedFormats(BasicAttrResourceItem attr) {
        if (attr.getFormats().isEmpty()) {
            attr = new BasicAttrResourceItem(attr.getName(), attr.getSourceFile(), attr.getVisibility(), attr.getDescription(), attr.getGroupName(), this.DEFAULT_ATTR_FORMATS, Collections.emptyMap(), Collections.emptyMap());
        }
        this.addResourceItem(attr);
    }

    private static boolean resourceAlreadyDefined(BasicResourceItemBase resource) {
        LoadableResourceRepository repository2 = resource.getRepository();
        List items = repository2.getResources(resource.getNamespace(), resource.getType(), resource.getName());
        return RepositoryLoader.findResourceWithSameNameAndConfiguration((ResourceItem)resource, items) >= 0;
    }

    private static int findResourceWithSameNameAndConfiguration(ResourceItem resource, List<? extends ResourceItem> items) {
        for (int i = 0; i < items.size(); ++i) {
            ResourceItem item = items.get(i);
            if (!item.getConfiguration().equals((Object)resource.getConfiguration())) continue;
            return i;
        }
        return -1;
    }

    private BasicValueResourceItem createFileReferenceItem(ResourceType type, String name, ResourceSourceFile sourceFile) throws IOException, XmlPullParserException {
        ResourceNamespace.Resolver namespaceResolver = this.myParser.getNamespaceResolver();
        String text = this.myTextExtractor.extractText((XmlPullParser)this.myParser, false).trim();
        if (!(text.isEmpty() || text.startsWith("@") || text.startsWith("?"))) {
            text = text.replace('/', File.separatorChar);
        }
        ResourceVisibility visibility = this.getVisibility(type, name);
        BasicValueResourceItem item = new BasicValueResourceItem(type, name, sourceFile, visibility, text);
        item.setNamespaceResolver(namespaceResolver);
        return item;
    }

    private ResourceType getResourceType(String tagName, PathString file) throws XmlSyntaxException {
        ResourceType type = ResourceType.fromXmlTagName((String)tagName);
        if (type == null) {
            if ("eat-comment".equals(tagName) || "skip".equals(tagName)) {
                return null;
            }
            if ("java-symbol".equals(tagName)) {
                return null;
            }
            if (tagName.equals("item")) {
                String typeAttr = this.myParser.getAttributeValue(null, "type");
                if (typeAttr != null) {
                    type = ResourceType.fromClassName((String)typeAttr);
                    if (type != null) {
                        return type;
                    }
                    LOG.warn("Unrecognized type attribute \"" + typeAttr + "\" at " + this.getDisplayName(file) + " line " + this.myParser.getLineNumber());
                }
            } else {
                LOG.warn("Unrecognized tag name \"" + tagName + "\" at " + this.getDisplayName(file) + " line " + this.myParser.getLineNumber());
            }
        }
        return type;
    }

    private void forSubTags(String tagName, XmlTagVisitor subtagVisitor) throws IOException, XmlPullParserException {
        int event;
        int elementDepth = this.myParser.getDepth();
        do {
            if ((event = this.myParser.nextToken()) != 2 || tagName != null && (!tagName.equals(this.myParser.getName()) || this.myParser.getPrefix() != null)) continue;
            subtagVisitor.visitTag();
        } while (event != 1 && (event != 3 || this.myParser.getDepth() > elementDepth));
    }

    private void skipSubTags() throws IOException, XmlPullParserException {
        int event;
        int elementDepth = this.myParser.getDepth();
        while ((event = this.myParser.nextToken()) != 1 && (event != 3 || this.myParser.getDepth() > elementDepth)) {
        }
    }

    private void validateResourceName(String resourceName, ResourceType resourceType, PathString file) throws XmlSyntaxException {
        String error = ValueResourceNameValidator.getErrorText((String)resourceName, (ResourceType)resourceType);
        if (error != null) {
            throw new XmlSyntaxException(error, (XmlPullParser)this.myParser, this.getDisplayName(file));
        }
    }

    private String getDisplayName(PathString file) {
        return file.isAbsolute() ? file.getNativePath() : file.getPortablePath() + " in " + this.myResourceDirectoryOrFile.toString();
    }

    private String getDisplayName(ResourceSourceFile sourceFile) {
        String relativePath = sourceFile.getRelativePath();
        Preconditions.checkArgument((relativePath != null ? 1 : 0) != 0);
        return this.getDisplayName(new PathString(relativePath));
    }

    protected final ResourceVisibility getVisibility(ResourceType resourceType, String resourceName) {
        Set<String> names = this.myPublicResources.get(resourceType);
        return names != null && names.contains(this.getKeyForVisibilityLookup(resourceName)) ? ResourceVisibility.PUBLIC : this.myDefaultVisibility;
    }

    protected String getKeyForVisibilityLookup(String resourceName) {
        return ResourcesUtil.resourceNameToFieldName((String)resourceName);
    }

    protected final String getResRelativePath(PathString file) {
        if (file.isAbsolute()) {
            return this.myResourceDirectoryOrFilePath.relativize(file).getPortablePath();
        }
        assert (file.getNameCount() != 0);
        assert (file.segment(0).equals("res"));
        return file.subpath(1, file.getNameCount()).getPortablePath();
    }

    private static boolean isZipArchive(Path resourceDirectoryOrFile) {
        String filename = resourceDirectoryOrFile.getFileName().toString();
        return SdkUtils.endsWithIgnoreCase((String)filename, (String)".aar") || SdkUtils.endsWithIgnoreCase((String)filename, (String)".jar") || SdkUtils.endsWithIgnoreCase((String)filename, (String)".zip");
    }

    public static String portableFileName(String fileName) {
        return fileName.replace(File.separatorChar, '/');
    }

    private static class XmlTextExtractor {
        private final StringBuilder text = new StringBuilder();
        private final StringBuilder rawXml = new StringBuilder();
        private final Deque<Boolean> textInclusionState = new ArrayDeque<Boolean>();
        private boolean nontrivialRawXml;

        private XmlTextExtractor() {
        }

        /*
         * Enabled aggressive block sorting
         */
        String extractText(XmlPullParser parser2, boolean withRawXml) throws IOException, XmlPullParserException {
            int event;
            this.text.setLength(0);
            this.rawXml.setLength(0);
            this.textInclusionState.clear();
            this.nontrivialRawXml = false;
            int elementDepth = parser2.getDepth();
            do {
                event = parser2.nextToken();
                switch (event) {
                    case 2: {
                        String tagName = parser2.getName();
                        if ("g".equals(tagName) && XmlTextExtractor.isXliffNamespace(parser2.getNamespace())) {
                            boolean includeNestedText = this.getTextInclusionState();
                            String example = parser2.getAttributeValue(null, "example");
                            if (example != null) {
                                this.text.append('(').append(example).append(')');
                                includeNestedText = false;
                            } else {
                                String id = parser2.getAttributeValue(null, "id");
                                if (id != null && !id.equals("id")) {
                                    this.text.append('$').append('{').append(id).append('}');
                                    includeNestedText = false;
                                }
                            }
                            this.textInclusionState.addLast(includeNestedText);
                        }
                        if (!withRawXml) break;
                        this.nontrivialRawXml = true;
                        this.rawXml.append('<');
                        String prefix = parser2.getPrefix();
                        if (prefix != null) {
                            this.rawXml.append(prefix).append(':');
                        }
                        this.rawXml.append(tagName);
                        int numAttr = parser2.getAttributeCount();
                        for (int i = 0; i < numAttr; ++i) {
                            this.rawXml.append(' ');
                            String attributePrefix = parser2.getAttributePrefix(i);
                            if (attributePrefix != null) {
                                this.rawXml.append(attributePrefix).append(':');
                            }
                            this.rawXml.append(parser2.getAttributeName(i)).append('=').append('\"');
                            XmlUtils.appendXmlAttributeValue((StringBuilder)this.rawXml, (String)parser2.getAttributeValue(i));
                            this.rawXml.append('\"');
                        }
                        this.rawXml.append('>');
                        break;
                    }
                    case 3: {
                        if (parser2.getDepth() <= elementDepth) {
                            return ValueXmlHelper.unescapeResourceString((String)this.text.toString(), (boolean)false, (boolean)true);
                        }
                        String tagName = parser2.getName();
                        if (withRawXml) {
                            this.rawXml.append('<').append('/');
                            String prefix = parser2.getPrefix();
                            if (prefix != null) {
                                this.rawXml.append(prefix).append(':');
                            }
                            this.rawXml.append(tagName).append('>');
                        }
                        if (!"g".equals(tagName) || !XmlTextExtractor.isXliffNamespace(parser2.getNamespace())) break;
                        this.textInclusionState.removeLast();
                        break;
                    }
                    case 4: 
                    case 6: {
                        String textPiece = parser2.getText();
                        if (this.getTextInclusionState()) {
                            this.text.append(textPiece);
                        }
                        if (!withRawXml) break;
                        this.rawXml.append(textPiece);
                        break;
                    }
                    case 5: {
                        String textPiece = parser2.getText();
                        if (this.getTextInclusionState()) {
                            this.text.append(textPiece);
                        }
                        if (!withRawXml) break;
                        this.nontrivialRawXml = true;
                        this.rawXml.append("<![CDATA[").append(textPiece).append("]]>");
                    }
                }
            } while (event != 1);
            return ValueXmlHelper.unescapeResourceString((String)this.text.toString(), (boolean)false, (boolean)true);
        }

        private boolean getTextInclusionState() {
            return this.textInclusionState.isEmpty() || this.textInclusionState.getLast() != false;
        }

        String getRawXml() {
            return this.nontrivialRawXml ? this.rawXml.toString() : null;
        }

        private static boolean isXliffNamespace(String namespaceUri) {
            return namespaceUri != null && namespaceUri.startsWith("urn:oasis:names:tc:xliff:document:");
        }
    }

    protected static class FolderInfo {
        public final ResourceFolderType folderType;
        public final FolderConfiguration configuration;
        public final ResourceType resourceType;
        public final boolean isIdGenerating;

        private FolderInfo(ResourceFolderType folderType, FolderConfiguration configuration, ResourceType resourceType, boolean isIdGenerating) {
            this.configuration = configuration;
            this.resourceType = resourceType;
            this.folderType = folderType;
            this.isIdGenerating = isIdGenerating;
        }

        public static FolderInfo create(String folderName, Map<String, FolderConfiguration> folderConfigCache) {
            boolean isIdGenerating;
            ResourceType resourceType;
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
            if (folderType == null) {
                return null;
            }
            String qualifier = FolderConfiguration.getQualifier((String)folderName);
            FolderConfiguration config = folderConfigCache.computeIfAbsent(qualifier, FolderConfiguration::getConfigForQualifierString);
            if (config == null) {
                return null;
            }
            config.normalizeByRemovingRedundantVersionQualifier();
            if (folderType == ResourceFolderType.VALUES) {
                resourceType = null;
                isIdGenerating = false;
            } else {
                resourceType = FolderTypeRelationship.getNonIdRelatedResourceType((ResourceFolderType)folderType);
                isIdGenerating = FolderTypeRelationship.isIdGeneratingFolderType((ResourceFolderType)folderType);
            }
            return new FolderInfo(folderType, config, resourceType, isIdGenerating);
        }
    }

    private static class ResourceFileCollector
    implements FileVisitor<Path> {
        final List<PathString> resourceFiles = new ArrayList<PathString>();
        final List<IOException> ioErrors = new ArrayList<IOException>();
        final FileFilter fileFilter;

        private ResourceFileCollector(FileFilter filter2) {
            this.fileFilter = filter2;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.fileFilter.isIgnored(dir, attrs)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (this.fileFilter.isIgnored(file, attrs)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            this.resourceFiles.add(new PathString(file));
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            this.ioErrors.add(exc);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }

    private static class XmlSyntaxException
    extends Exception {
        XmlSyntaxException(String error, XmlPullParser parser2, String filename) {
            super(error + " at " + filename + " line " + parser2.getLineNumber());
        }
    }

    private static interface XmlTagVisitor {
        public void visitTag() throws IOException, XmlPullParserException;
    }
}

