/*
 * Decompiled with CFR 0.152.
 */
package com.android.processmonitor.monitor.ddmlib;

import com.android.adblib.AdbLogger;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.processmonitor.common.DeviceEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/processmonitor/monitor/ddmlib/DevicesMonitorListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "producerScope", "Lkotlinx/coroutines/channels/ProducerScope;", "Lcom/android/processmonitor/common/DeviceEvent;", "Lcom/android/ddmlib/IDevice;", "logger", "Lcom/android/adblib/AdbLogger;", "<init>", "(Lkotlinx/coroutines/channels/ProducerScope;Lcom/android/adblib/AdbLogger;)V", "deviceConnected", "", "device", "deviceDisconnected", "deviceChanged", "changeMask", "", "send", "event", "android.sdktools.process-monitor"})
@SourceDebugExtension(value={"SMAP\nDevicesMonitorListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevicesMonitorListener.kt\ncom/android/processmonitor/monitor/ddmlib/DevicesMonitorListener\n+ 2 Channel.kt\nkotlinx/coroutines/channels/ChannelKt\n*L\n1#1,64:1\n539#2,5:65\n*S KotlinDebug\n*F\n+ 1 DevicesMonitorListener.kt\ncom/android/processmonitor/monitor/ddmlib/DevicesMonitorListener\n*L\n59#1:65,5\n*E\n"})
public final class DevicesMonitorListener
implements AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final ProducerScope<DeviceEvent<IDevice>> producerScope;
    @NotNull
    private final AdbLogger logger;

    public DevicesMonitorListener(@NotNull ProducerScope<? super DeviceEvent<IDevice>> producerScope, @NotNull AdbLogger logger) {
        Intrinsics.checkNotNullParameter(producerScope, (String)"producerScope");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.producerScope = producerScope;
        this.logger = logger;
    }

    @Override
    public void deviceConnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        if (device2.getState() == IDevice.DeviceState.ONLINE) {
            this.send((DeviceEvent<IDevice>)new DeviceEvent.DeviceOnline<IDevice>(device2));
        }
    }

    @Override
    public void deviceDisconnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        String string2 = device2.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSerialNumber(...)");
        this.send(new DeviceEvent.DeviceDisconnected(string2));
    }

    @Override
    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        if ((changeMask & 1) != 0 && device2.getState() == IDevice.DeviceState.ONLINE) {
            this.send((DeviceEvent<IDevice>)new DeviceEvent.DeviceOnline<IDevice>(device2));
        }
    }

    private final void send(DeviceEvent<IDevice> event) {
        Object $this$onFailure_u2dWpGqRn0$iv = ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this.producerScope), event);
        boolean bl = false;
        if ($this$onFailure_u2dWpGqRn0$iv instanceof ChannelResult.Failed) {
            Throwable it = ChannelResult.exceptionOrNull-impl((Object)$this$onFailure_u2dWpGqRn0$iv);
            boolean bl2 = false;
            this.logger.warn(it, "Failed to send DeviceMonitorEvent");
        }
    }
}

