/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.IDSizes;
import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.PacketHeader;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.CmdSets;
import com.android.jdwptracer.Command;
import com.android.jdwptracer.DdmJDWPTiming;
import com.android.jdwptracer.Direction;
import com.android.jdwptracer.Event;
import com.android.jdwptracer.Log;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.NamedEvent;
import com.android.jdwptracer.Packet;
import com.android.jdwptracer.Reply;
import com.android.jdwptracer.Transmission;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class Session {
    private IDSizes idSizes = new IDSizes();
    private final List<Event> events = new ArrayList<Event>();
    private final HashMap<Integer, Transmission> upStreamTransmissions = new HashMap();
    private Map<Integer, DdmJDWPTiming> timings = new HashMap<Integer, DdmJDWPTiming>();
    private String name = "unknown";
    private final Log log;

    Session(Log log) {
        this.log = log;
    }

    void addPacket(ByteBuffer packet, Direction direction) {
        long now_ns = System.nanoTime();
        MessageReader messageReader = new MessageReader(this.idSizes, packet);
        PacketHeader header = new PacketHeader(messageReader);
        if (header.isReply()) {
            this.processReplyPacket(now_ns, header, messageReader);
        } else {
            this.processCmdPacket(now_ns, header, messageReader, direction);
        }
    }

    private void processCmdPacket(long time_ns, PacketHeader header, MessageReader messageReader, Direction direction) {
        CmdSet cmdSet = CmdSets.get(header.getCmdSet());
        Message message = cmdSet.getCmd(header.getCmd()).getCmdParser().parse(messageReader, this);
        Command command = new Command(header, time_ns, message);
        Transmission t = new Transmission(command, header.getId(), this.events.size());
        if (direction == Direction.UPSTREAM) {
            this.upStreamTransmissions.put(header.getId(), t);
        }
        this.events.add(t);
    }

    private void processReplyPacket(long time_ns, PacketHeader header, MessageReader messageReader) {
        if (!this.upStreamTransmissions.containsKey(header.getId())) {
            String msg = String.format(Locale.US, "Found reply id=%s packet without a cmd", Integer.toHexString(header.getId()));
            this.log.warn(msg);
            return;
        }
        Transmission t = this.upStreamTransmissions.get(header.getId());
        this.upStreamTransmissions.remove(header.getId());
        int cmdSetID = t.cmd().cmdSetID();
        int cmdID = t.cmd().cmdID();
        if (header.getError() != 0) {
            Message message = new Message(messageReader);
            Reply reply = new Reply(header, time_ns, message);
            t.addReply(reply);
            t.cmd().message().prefixName("ERROR:");
            return;
        }
        CmdSet cmdSet = CmdSets.get(cmdSetID);
        Message message = cmdSet.getCmd(cmdID).getReplyParser().parse(messageReader, this);
        Reply reply = new Reply(header, time_ns, message);
        t.addReply(reply);
    }

    void addEvent(String name) {
        long now = System.nanoTime();
        this.events.add(new NamedEvent(name, now, this.events.size()));
    }

    List<Event> events() {
        return this.events;
    }

    Map<Integer, DdmJDWPTiming> timings() {
        return this.timings;
    }

    void addTimings(Map<Integer, DdmJDWPTiming> timings) {
        this.timings.putAll(timings);
    }

    void setName(String name) {
        this.name = name;
    }

    String name() {
        return this.name;
    }

    String details(ByteBuffer buffer) {
        String details = "";
        if (buffer.remaining() < 4) {
            details = details + "Empty";
            return details;
        }
        details = details + "Length=" + buffer.getInt();
        if (buffer.remaining() < 4) {
            details = details + ", no ID";
            return details;
        }
        details = details + ", ID=" + buffer.getInt();
        if (buffer.remaining() < 1) {
            details = details + ", no FLAGS";
            return details;
        }
        byte flag = buffer.get();
        details = details + ", flags=0x" + Integer.toHexString(flag);
        details = Packet.isReply(flag) ? details + this.detailsReply(buffer) : details + this.detailsCmd(buffer);
        return details;
    }

    private String detailsCmd(ByteBuffer buffer) {
        String details = "";
        if (buffer.remaining() < 1) {
            details = details + ", no cmdset";
            return details;
        }
        details = details + ", cmdset=" + buffer.get();
        if (buffer.remaining() < 1) {
            details = details + ", no cmd";
            return details;
        }
        details = details + ", cmd=" + buffer.get();
        return details;
    }

    private String detailsReply(ByteBuffer buffer) {
        String details = "";
        if (buffer.remaining() < 2) {
            details = details + ", no errorCode";
            return details;
        }
        details = details + ", errorCode=" + buffer.getShort();
        return details;
    }

    void setIDSizes(IDSizes idSizes) {
        this.idSizes = idSizes;
    }
}

