/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.IDSizes;
import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.vm.AllClassesWithGenericsReply;
import com.android.jdwppacket.vm.ClassesBySignatureReply;
import com.android.jdwppacket.vm.IDSizesReply;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.PacketParser;
import com.android.jdwptracer.Session;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

class CmdSetVM
extends CmdSet {
    static final int ID = 1;

    CmdSetVM() {
        super(1, "VM");
        this.add(Cmd.VERSION);
        this.add(Cmd.CLASSES_BY_SIGNATURE, CmdSetVM::parseClassesBySignatureCmd, CmdSetVM::parseClassesBySignatureReply);
        this.add(Cmd.ALL_CLASSES);
        this.add(Cmd.ALL_THREADS);
        this.add(Cmd.TOP_LEVEL_GROUP_THREADS);
        this.add(Cmd.DISPOSE);
        this.add(Cmd.ID_SIZES, CmdSetVM::parseCmdIdSizes, CmdSetVM::parseReplyIdSizes);
        this.add(Cmd.SUSPEND);
        this.add(Cmd.RESUME);
        this.add(Cmd.EXIT);
        this.add(Cmd.CREATE_STRING);
        this.add(Cmd.CAPABILITIES);
        this.add(Cmd.CLASSPATH);
        this.add(Cmd.DISPOSE_OBJECTS);
        this.add(Cmd.HOLD_EVENTS);
        this.add(Cmd.RELEASE_EVENTS);
        this.add(Cmd.CAPACITIES_NEW);
        this.add(Cmd.REDEFINE_CLASSES);
        this.add(Cmd.SET_DEFAULT_STRATUM);
        this.add(Cmd.ALL_CLASSES_WITH_GENERIC, CmdSetVM::parseAllClassesWithGenericsCmd, CmdSetVM::parseAllClassesWithGenericsReply);
        this.add(Cmd.INSTANCE_COUNTS);
    }

    private void add(Cmd cmd) {
        this.add(cmd.ID, cmd.NAME);
    }

    private void add(Cmd cmd, PacketParser onCmd, PacketParser onReply) {
        this.add(cmd.ID, cmd.NAME, onCmd, onReply);
    }

    private static Message parseReplyIdSizes(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        IDSizesReply reply = IDSizesReply.parse(reader);
        session2.setIDSizes(new IDSizes(reply));
        message.addArg("FieldIDSize", Integer.toString(reply.getFieldIDSize()));
        message.addArg("methodIDSize", Integer.toString(reply.getMethodIDSize()));
        message.addArg("objectIDSize", Integer.toString(reply.getObjectIDSize()));
        message.addArg("referenceTypeID", Integer.toString(reply.getReferenceTypeIDSize()));
        message.addArg("frameIDSize", Integer.toString(reply.getFrameIDSize()));
        return message;
    }

    private static Message parseCmdIdSizes(MessageReader reader, Session session2) {
        return Message.defaultMessageParser(reader, session2);
    }

    private static Message parseClassesBySignatureCmd(MessageReader reader, Session session2) {
        Message message = Message.defaultMessageParser(reader, session2);
        message.addArg("signature", reader.getString());
        return message;
    }

    private static Message parseClassesBySignatureReply(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        ClassesBySignatureReply reply = ClassesBySignatureReply.parse(reader);
        message.addArg("classes", reply.getClasses().size());
        JsonArray classList = new JsonArray();
        for (ClassesBySignatureReply.Class clazz : reply.getClasses()) {
            JsonObject classEntry = new JsonObject();
            classEntry.addProperty("refTypeTag", (Number)clazz.getRefTypeTag());
            classEntry.addProperty("typeID", (Number)clazz.getRefTypeTag());
            classEntry.addProperty("status", (Number)clazz.getStatus());
            classList.add((JsonElement)classEntry);
        }
        message.addArg("classList", (JsonElement)classList);
        return message;
    }

    private static Message parseAllClassesWithGenericsCmd(MessageReader reader, Session session2) {
        return Message.defaultMessageParser(reader, session2);
    }

    private static Message parseAllClassesWithGenericsReply(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        AllClassesWithGenericsReply reply = AllClassesWithGenericsReply.parse(reader);
        message.addArg("classes", reply.getClasses().size());
        JsonArray classList = new JsonArray();
        for (AllClassesWithGenericsReply.Class clazz : reply.getClasses()) {
            JsonObject classEntry = new JsonObject();
            classEntry.addProperty("refTypeTag", (Number)clazz.getRefTypeTag());
            classEntry.addProperty("typeID", (Number)clazz.getReferenceTypeID());
            classEntry.addProperty("signature", clazz.getSignature());
            classEntry.addProperty("genericSignature", clazz.getGenericSignature());
            classEntry.addProperty("status", (Number)clazz.getStatus());
            classList.add((JsonElement)classEntry);
        }
        message.addArg("classList", (JsonElement)classList);
        return message;
    }

    static enum Cmd {
        VERSION(1, "Version"),
        CLASSES_BY_SIGNATURE(2, "ClassesBySignature"),
        ALL_CLASSES(3, "AllClasses"),
        ALL_THREADS(4, "AllThreads"),
        TOP_LEVEL_GROUP_THREADS(5, "TopLevelGroupThreads"),
        DISPOSE(6, "Dispose"),
        ID_SIZES(7, "IdSizes"),
        SUSPEND(8, "Suspend"),
        RESUME(9, "Resume"),
        EXIT(10, "Exit"),
        CREATE_STRING(11, "CreateString"),
        CAPABILITIES(12, "Capabilities"),
        CLASSPATH(13, "ClassPaths"),
        DISPOSE_OBJECTS(14, "DisposeObjects"),
        HOLD_EVENTS(15, "HoldEvents"),
        RELEASE_EVENTS(16, "ReleaseEvents"),
        CAPACITIES_NEW(17, "CapabilitiesNew"),
        REDEFINE_CLASSES(18, "RedefineClasses"),
        SET_DEFAULT_STRATUM(19, "SetDefaultStratum"),
        ALL_CLASSES_WITH_GENERIC(20, "AllClassesWithGeneric"),
        INSTANCE_COUNTS(21, "InstanceCounts");

        public final int ID;
        public final String NAME;

        private Cmd(int id, String name) {
            this.ID = id;
            this.NAME = name;
        }
    }
}

