/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwpscache;

import com.android.jdwppacket.ClassType;
import com.android.jdwppacket.Cmd;
import com.android.jdwppacket.CmdSet;
import com.android.jdwppacket.IDSizes;
import com.android.jdwppacket.IsObsoleteCmd;
import com.android.jdwppacket.Keyable;
import com.android.jdwppacket.LineTableCmd;
import com.android.jdwppacket.Location;
import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.Method;
import com.android.jdwppacket.PacketHeader;
import com.android.jdwppacket.ReferenceType;
import com.android.jdwppacket.SourceFileCmd;
import com.android.jdwppacket.SuperClassCmd;
import com.android.jdwppacket.ThreadReference;
import com.android.jdwppacket.VariableTableWithGenericCmd;
import com.android.jdwppacket.VirtualMachine;
import com.android.jdwppacket.event.CompositeCmd;
import com.android.jdwppacket.referencetype.InterfacesCmd;
import com.android.jdwppacket.referencetype.MethodsWithGenericsCmd;
import com.android.jdwppacket.referencetype.SourceDebugExtensionCmd;
import com.android.jdwppacket.threadreference.FramesReply;
import com.android.jdwppacket.vm.AllClassesReply;
import com.android.jdwppacket.vm.AllClassesWithGenericsReply;
import com.android.jdwpscache.ClassesRepo;
import com.android.jdwpscache.Handler;
import com.android.jdwpscache.IDGenerator;
import com.android.jdwpscache.SCacheLogger;
import com.android.jdwpscache.SCacheResponse;
import com.android.jdwpscache.TriggerManager;
import com.android.jdwpscache.UtilsKt;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u001d\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b*J\"\u0010+\u001a\u0004\u0018\u00010\u00192\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0015H\u0002J\u0015\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b2J\u001d\u00103\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u00104\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b5J\u001f\u00106\u001a\u0004\u0018\u00010\u00122\u0006\u00100\u001a\u0002012\u0006\u0010)\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b7J\u0006\u00108\u001a\u00020 J\u000e\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020;J\u0010\u0010<\u001a\u00020 2\u0006\u0010=\u001a\u00020\u000fH\u0002J\u0018\u0010>\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010?\u001a\u00020&H\u0002J\u0018\u0010@\u001a\u00020 2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010?\u001a\u00020&H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u000fj\u0002`\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\u0013\u001a-\u0012\u0004\u0012\u00020\u000e\u0012#\u0012!\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0014j\u0002`\u001a0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/jdwpscache/Speculator;", "", "triggerManager", "Lcom/android/jdwpscache/TriggerManager;", "logger", "Lcom/android/jdwpscache/SCacheLogger;", "<init>", "(Lcom/android/jdwpscache/TriggerManager;Lcom/android/jdwpscache/SCacheLogger;)V", "getLogger", "()Lcom/android/jdwpscache/SCacheLogger;", "idGenerator", "Lcom/android/jdwpscache/IDGenerator;", "syntheticCmds", "", "", "", "Lcom/android/jdwpscache/CmdKey;", "cache", "Ljava/nio/ByteBuffer;", "keyableParsers", "Lkotlin/Function1;", "Lcom/android/jdwppacket/MessageReader;", "Lkotlin/ParameterName;", "name", "messageReader", "Lcom/android/jdwppacket/Keyable;", "Lcom/android/jdwpscache/Parser;", "speculationCounter", "cacheHit", "classesRepo", "Lcom/android/jdwpscache/ClassesRepo;", "speculateClassInfo", "", "classID", "", "command", "Lcom/android/jdwppacket/Cmd;", "response", "Lcom/android/jdwpscache/SCacheResponse;", "speculate", "onFramesReply", "reader", "onFramesReply$android_sdktools_jdwpscache", "parseKeyableCmd", "cmdSet", "cmd", "isSyntheticReply", "", "header", "Lcom/android/jdwppacket/PacketHeader;", "isSyntheticReply$android_sdktools_jdwpscache", "handleSyntheticReply", "packet", "handleSyntheticReply$android_sdktools_jdwpscache", "getCachedReply", "getCachedReply$android_sdktools_jdwpscache", "invalidateCache", "onEvent", "event", "Lcom/android/jdwppacket/event/CompositeCmd;", "invalidateCacheForClass", "signature", "onAllClassesWithGenericReply", "unused", "onAllClassesReply", "android.sdktools.jdwpscache"})
@SourceDebugExtension(value={"SMAP\nSpeculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Speculator.kt\ncom/android/jdwpscache/Speculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1863#2,2:239\n1863#2,2:241\n1863#2,2:243\n*S KotlinDebug\n*F\n+ 1 Speculator.kt\ncom/android/jdwpscache/Speculator\n*L\n154#1:239,2\n211#1:241,2\n227#1:243,2\n*E\n"})
public final class Speculator {
    @NotNull
    private final SCacheLogger logger;
    @NotNull
    private final IDGenerator idGenerator;
    @NotNull
    private final Map<Integer, String> syntheticCmds;
    @NotNull
    private final Map<String, ByteBuffer> cache;
    @NotNull
    private Map<Integer, Function1<MessageReader, Keyable>> keyableParsers;
    private int speculationCounter;
    private int cacheHit;
    @NotNull
    private final ClassesRepo classesRepo;

    public Speculator(@NotNull TriggerManager triggerManager, @NotNull SCacheLogger logger) {
        Intrinsics.checkNotNullParameter((Object)triggerManager, (String)"triggerManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.idGenerator = new IDGenerator();
        this.syntheticCmds = new LinkedHashMap();
        this.cache = new LinkedHashMap();
        this.keyableParsers = new HashMap();
        this.classesRepo = new ClassesRepo();
        triggerManager.registerReplyTrigger$android_sdktools_jdwpscache(CmdSet.ThreadReference.getId(), ThreadReference.Frames.getId(), new Handler(){

            @Override
            public void handle(MessageReader reader, SCacheResponse response) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.onFramesReply$android_sdktools_jdwpscache(reader, response);
            }
        });
        triggerManager.registerReplyTrigger$android_sdktools_jdwpscache(CmdSet.Vm.getId(), VirtualMachine.AllClasses.getId(), new Handler(){

            @Override
            public void handle(MessageReader reader, SCacheResponse response) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.onAllClassesReply(reader, response);
            }
        });
        triggerManager.registerReplyTrigger$android_sdktools_jdwpscache(CmdSet.Vm.getId(), VirtualMachine.AllClassesWithGeneric.getId(), new Handler(){

            @Override
            public void handle(MessageReader reader, SCacheResponse response) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.onAllClassesWithGenericReply(reader, response);
            }
        });
        this.keyableParsers.put(UtilsKt.packCmd(CmdSet.ClassType.getId(), ClassType.Superclass.getId()), (Function1<MessageReader, Keyable>)new Function1<MessageReader, SuperClassCmd>((Object)SuperClassCmd.Companion){

            public final SuperClassCmd invoke(MessageReader p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SuperClassCmd.Companion)this.receiver).parse(p0);
            }
        });
        this.keyableParsers.put(UtilsKt.packCmd(CmdSet.Method.getId(), Method.LineTable.getId()), (Function1<MessageReader, Keyable>)new Function1<MessageReader, LineTableCmd>((Object)LineTableCmd.Companion){

            public final LineTableCmd invoke(MessageReader p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LineTableCmd.Companion)this.receiver).parse(p0);
            }
        });
        this.keyableParsers.put(UtilsKt.packCmd(CmdSet.ReferenceType.getId(), ReferenceType.SourceFile.getId()), (Function1<MessageReader, Keyable>)new Function1<MessageReader, SourceFileCmd>((Object)SourceFileCmd.Companion){

            public final SourceFileCmd invoke(MessageReader p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SourceFileCmd.Companion)this.receiver).parse(p0);
            }
        });
        this.keyableParsers.put(UtilsKt.packCmd(CmdSet.ReferenceType.getId(), ReferenceType.Interfaces.getId()), (Function1<MessageReader, Keyable>)new Function1<MessageReader, InterfacesCmd>((Object)InterfacesCmd.Companion){

            public final InterfacesCmd invoke(MessageReader p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((InterfacesCmd.Companion)this.receiver).parse(p0);
            }
        });
        this.keyableParsers.put(UtilsKt.packCmd(CmdSet.ReferenceType.getId(), ReferenceType.MethodsWithGeneric.getId()), (Function1<MessageReader, Keyable>)new Function1<MessageReader, MethodsWithGenericsCmd>((Object)MethodsWithGenericsCmd.Companion){

            public final MethodsWithGenericsCmd invoke(MessageReader p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((MethodsWithGenericsCmd.Companion)this.receiver).parse(p0);
            }
        });
        this.keyableParsers.put(UtilsKt.packCmd(CmdSet.ReferenceType.getId(), ReferenceType.SourceDebugExtension.getId()), (Function1<MessageReader, Keyable>)new Function1<MessageReader, SourceDebugExtensionCmd>((Object)SourceDebugExtensionCmd.Companion){

            public final SourceDebugExtensionCmd invoke(MessageReader p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SourceDebugExtensionCmd.Companion)this.receiver).parse(p0);
            }
        });
        this.keyableParsers.put(UtilsKt.packCmd(CmdSet.Method.getId(), Method.IsObsolete.getId()), (Function1<MessageReader, Keyable>)new Function1<MessageReader, IsObsoleteCmd>((Object)IsObsoleteCmd.Companion){

            public final IsObsoleteCmd invoke(MessageReader p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((IsObsoleteCmd.Companion)this.receiver).parse(p0);
            }
        });
        this.keyableParsers.put(UtilsKt.packCmd(CmdSet.Method.getId(), Method.VariableTableWithGeneric.getId()), (Function1<MessageReader, Keyable>)new Function1<MessageReader, VariableTableWithGenericCmd>((Object)VariableTableWithGenericCmd.Companion){

            public final VariableTableWithGenericCmd invoke(MessageReader p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((VariableTableWithGenericCmd.Companion)this.receiver).parse(p0);
            }
        });
    }

    @NotNull
    public final SCacheLogger getLogger() {
        return this.logger;
    }

    private final void speculateClassInfo(long classID, Cmd command, SCacheResponse response) {
        this.classesRepo.declareSpeculation(classID, command.getKey());
        this.speculate(command, response);
    }

    private final void speculate(Cmd command, SCacheResponse response) {
        if (this.syntheticCmds.containsValue(command.getKey())) {
            return;
        }
        if (this.cache.containsKey(command.getKey())) {
            return;
        }
        int n = this.speculationCounter;
        this.speculationCounter = n + 1;
        int packetID = this.idGenerator.get$android_sdktools_jdwpscache();
        response.addToUpstream(command.toPacket(packetID, new IDSizes(0, 0, 0, 0, 0, 31, null)));
        this.syntheticCmds.put(packetID, command.getKey());
    }

    public final void onFramesReply$android_sdktools_jdwpscache(@NotNull MessageReader reader, @NotNull SCacheResponse response) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        FramesReply reply = FramesReply.Companion.parse(reader);
        int count = 0;
        Iterable $this$forEach$iv = reply.getFrames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FramesReply.Frame it = (FramesReply.Frame)element$iv;
            boolean bl = false;
            if (count > 40) continue;
            Location loc = it.getLocation();
            this.speculateClassInfo(loc.getClassID(), new SuperClassCmd(loc.getClassID()), response);
            this.speculateClassInfo(loc.getClassID(), new LineTableCmd(loc.getClassID(), loc.getMethodID()), response);
            this.speculateClassInfo(loc.getClassID(), new SourceFileCmd(loc.getClassID()), response);
            this.speculateClassInfo(loc.getClassID(), new IsObsoleteCmd(loc.getClassID(), loc.getMethodID()), response);
            this.speculateClassInfo(loc.getClassID(), new SourceDebugExtensionCmd(loc.getClassID()), response);
            this.speculateClassInfo(loc.getClassID(), new InterfacesCmd(loc.getClassID()), response);
            this.speculateClassInfo(loc.getClassID(), new VariableTableWithGenericCmd(loc.getClassID(), loc.getMethodID()), response);
            this.speculateClassInfo(loc.getClassID(), new MethodsWithGenericsCmd(loc.getClassID()), response);
            ++count;
        }
    }

    private final Keyable parseKeyableCmd(int cmdSet, int cmd, MessageReader reader) {
        int packedCmd = UtilsKt.packCmd(cmdSet, cmd);
        if (!this.keyableParsers.containsKey(packedCmd)) {
            return null;
        }
        Function1<MessageReader, Keyable> function1 = this.keyableParsers.get(packedCmd);
        Intrinsics.checkNotNull(function1);
        return (Keyable)function1.invoke((Object)reader);
    }

    public final boolean isSyntheticReply$android_sdktools_jdwpscache(@NotNull PacketHeader header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        return this.syntheticCmds.containsKey(header.getId());
    }

    public final void handleSyntheticReply$android_sdktools_jdwpscache(@NotNull PacketHeader header, @NotNull ByteBuffer packet) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        String string2 = this.syntheticCmds.get(header.getId());
        Intrinsics.checkNotNull((Object)string2);
        String cmdKey = string2;
        this.cache.put(cmdKey, UtilsKt.deepCopy(packet));
        this.syntheticCmds.remove(header.getId());
    }

    @Nullable
    public final ByteBuffer getCachedReply$android_sdktools_jdwpscache(@NotNull PacketHeader header, @NotNull MessageReader reader) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Keyable cmd = this.parseKeyableCmd(header.getCmdSet(), header.getCmd(), reader.duplicate());
        if (cmd != null && this.cache.get(cmd.getKey()) != null) {
            int n = this.cacheHit;
            this.cacheHit = n + 1;
            ByteBuffer byteBuffer = this.cache.get(cmd.getKey());
            Intrinsics.checkNotNull((Object)byteBuffer);
            return UtilsKt.deepCopy(byteBuffer);
        }
        return null;
    }

    public final void invalidateCache() {
        this.cache.clear();
    }

    public final void onEvent(@NotNull CompositeCmd event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = event.getEvents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompositeCmd.Event it = (CompositeCmd.Event)element$iv;
            boolean bl = false;
            CompositeCmd.Event event2 = it;
            if (event2 instanceof CompositeCmd.EventClassUnload) {
                this.invalidateCacheForClass(((CompositeCmd.EventClassUnload)it).getSignature());
                this.classesRepo.onClassUnload((CompositeCmd.EventClassUnload)it);
                continue;
            }
            if (!(event2 instanceof CompositeCmd.EventClassPrepare)) continue;
            this.classesRepo.onClassPrepare((CompositeCmd.EventClassPrepare)it);
        }
    }

    private final void invalidateCacheForClass(String signature) {
        List<String> keys = this.classesRepo.getSpeculatedFor(signature);
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.cache.remove(it);
        }
    }

    private final void onAllClassesWithGenericReply(MessageReader reader, SCacheResponse unused) {
        this.classesRepo.onAllClassesWithGenericReply(AllClassesWithGenericsReply.Companion.parse(reader));
    }

    private final void onAllClassesReply(MessageReader reader, SCacheResponse unused) {
        this.classesRepo.onAllClassesReply(AllClassesReply.Companion.parse(reader));
    }
}

