/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.ImageTransferHandler;
import com.android.draw9patch.ui.ImageViewer;
import com.android.draw9patch.ui.MainFrame;
import com.android.draw9patch.ui.PngFileFilter;
import com.android.draw9patch.ui.StretchesViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ImageEditorPanel
extends JPanel {
    private static final String EXTENSION_9PATCH = ".9.png";
    private static final Color HELP_COLOR = new Color(0xFFFFE1);
    private static final Color HELP_BORDER_COLOR = new Color(0xC0C0C0);
    private final Supplier<Color> helpPanelBackground;
    private final Supplier<Color> helpPanelBorderColor;
    private String name;
    private BufferedImage image;
    private boolean is9Patch;
    private ImageViewer viewer;
    private StretchesViewer stretchesViewer;
    private JLabel xLabel;
    private JLabel yLabel;
    private TexturePaint texture;
    private JSlider zoomSlider;
    private JSlider scaleSlider;
    private JCheckBox showLockCheckbox;
    private JCheckBox showPatchesCheckbox;
    private JCheckBox showContentCheckbox;
    private JCheckBox showBadPatchesCheckbox;
    private final AtomicBoolean isUpdating = new AtomicBoolean(false);

    public ImageEditorPanel(MainFrame mainFrame, BufferedImage image, String name) {
        this(mainFrame, image, name, () -> HELP_COLOR, () -> HELP_BORDER_COLOR);
    }

    public ImageEditorPanel(MainFrame mainFrame, BufferedImage image, String name, Supplier<Color> helpPanelBackgroundColor, Supplier<Color> helpPanelBorderColor) {
        this.helpPanelBackground = helpPanelBackgroundColor;
        this.helpPanelBorderColor = helpPanelBorderColor;
        this.image = image;
        this.name = name;
        if (mainFrame != null) {
            this.setTransferHandler(new ImageTransferHandler(mainFrame));
        }
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.is9Patch = name.endsWith(EXTENSION_9PATCH);
        if (!this.is9Patch) {
            this.image = ImageEditorPanel.convertTo9Patch(image);
            this.name = name.substring(0, name.lastIndexOf(46)) + EXTENSION_9PATCH;
        } else {
            ImageEditorPanel.ensure9Patch(image);
        }
        this.loadSupport();
        this.buildImageViewer();
        this.buildStatusPanel();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                ImageEditorPanel.this.removeAncestorListener(this);
                ImageEditorPanel.this.synchronizeImageViewerZoomLevel();
            }
        });
    }

    private void synchronizeImageViewerZoomLevel() {
        this.zoomSlider.setValue(this.viewer.getZoom());
    }

    public ImageViewer getViewer() {
        return this.viewer;
    }

    private void loadSupport() {
        try {
            URL resource = this.getClass().getResource("/images/checker.png");
            BufferedImage checker = GraphicsUtilities.loadCompatibleImage(resource);
            this.texture = new TexturePaint(checker, new Rectangle2D.Double(0.0, 0.0, checker.getWidth(), checker.getHeight()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildImageViewer() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.createHelpPanel(), "North");
        this.viewer = new ImageViewer(this, this.texture, this.image, (x, y) -> {
            this.xLabel.setText(x + " px");
            this.yLabel.setText(y + " px");
        });
        JSplitPane splitter = new JSplitPane();
        splitter.setContinuousLayout(true);
        splitter.setResizeWeight(0.8);
        splitter.setBorder(null);
        JScrollPane scroller = new JScrollPane(this.viewer);
        scroller.setOpaque(false);
        scroller.setBorder(null);
        scroller.getViewport().setBorder(null);
        scroller.getViewport().setOpaque(false);
        splitter.setLeftComponent(scroller);
        splitter.setRightComponent(this.buildStretchesViewer());
        panel.add((Component)splitter, "Center");
        this.add(panel);
    }

    @Override
    public void updateUI() {
        if (this.isUpdating == null || this.isUpdating.compareAndSet(false, true)) {
            super.updateUI();
            if (this.image != null) {
                boolean showLock = this.showLockCheckbox.isSelected();
                boolean showPatches = this.showPatchesCheckbox.isSelected();
                boolean showContent = this.showContentCheckbox.isSelected();
                boolean showBadPatches = this.showBadPatchesCheckbox.isSelected();
                float zoom = this.zoomSlider.getValue();
                float scale = this.scaleSlider.getValue();
                this.removeAll();
                this.buildImageViewer();
                this.buildStatusPanel();
                SwingUtilities.invokeLater(() -> {
                    if (showLock) {
                        this.showLockCheckbox.doClick();
                    }
                    if (showPatches) {
                        this.showPatchesCheckbox.doClick();
                    }
                    if (showContent) {
                        this.showContentCheckbox.doClick();
                    }
                    if (showBadPatches) {
                        this.showBadPatchesCheckbox.doClick();
                    }
                    this.zoomSlider.setValue((int)zoom);
                    this.scaleSlider.setValue((int)scale);
                    this.isUpdating.set(false);
                });
            }
        }
    }

    private Component createHelpPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        CompoundBorder border = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.helpPanelBorderColor.get()), BorderFactory.createEmptyBorder(3, 6, 3, 6));
        panel.setBorder(border);
        panel.setBackground(this.helpPanelBackground.get());
        JLabel label = new JLabel("Press Control/Shift while dragging on the border to modify layout bounds.");
        panel.add((Component)label, "West");
        return panel;
    }

    private JComponent buildStretchesViewer() {
        this.stretchesViewer = new StretchesViewer(this, this.viewer, this.texture);
        JScrollPane scroller = new JScrollPane(this.stretchesViewer);
        scroller.setBorder(null);
        scroller.getViewport().setBorder(null);
        scroller.setHorizontalScrollBarPolicy(32);
        scroller.setVerticalScrollBarPolicy(22);
        return scroller;
    }

    private void buildStatusPanel() {
        JPanel status2 = new JPanel(new GridBagLayout());
        JLabel label = new JLabel();
        label.setText("Zoom: ");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status2.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel("30%");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status2.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.zoomSlider = new JSlider(30, 800, 100);
        this.zoomSlider.putClientProperty("JComponent.sizeVariant", "small");
        this.zoomSlider.addChangeListener(evt -> this.viewer.setZoom(((JSlider)evt.getSource()).getValue()));
        status2.add((Component)this.zoomSlider, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel maxZoomLabel = new JLabel("800%");
        maxZoomLabel.putClientProperty("JComponent.sizeVariant", "small");
        status2.add((Component)maxZoomLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel();
        label.setText("Patch scale: ");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status2.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 6, 0, 0), 0, 0));
        label = new JLabel();
        label.setText("2x");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status2.add((Component)label, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scaleSlider = new JSlider(200, 600, 200);
        this.scaleSlider.putClientProperty("JComponent.sizeVariant", "small");
        this.scaleSlider.addChangeListener(evt -> this.stretchesViewer.setScale((float)((JSlider)evt.getSource()).getValue() / 100.0f));
        status2.add((Component)this.scaleSlider, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        maxZoomLabel = new JLabel();
        maxZoomLabel.putClientProperty("JComponent.sizeVariant", "small");
        maxZoomLabel.setText("6x");
        status2.add((Component)maxZoomLabel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.showLockCheckbox = new JCheckBox("Show lock");
        this.showLockCheckbox.setOpaque(false);
        this.showLockCheckbox.setSelected(false);
        this.showLockCheckbox.putClientProperty("JComponent.sizeVariant", "small");
        this.showLockCheckbox.addActionListener(event -> this.viewer.setLockVisible(((JCheckBox)event.getSource()).isSelected()));
        status2.add((Component)this.showLockCheckbox, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.showPatchesCheckbox = new JCheckBox("Show patches");
        this.showPatchesCheckbox.setOpaque(false);
        this.showPatchesCheckbox.putClientProperty("JComponent.sizeVariant", "small");
        this.showPatchesCheckbox.addActionListener(event -> this.viewer.setPatchesVisible(((JCheckBox)event.getSource()).isSelected()));
        status2.add((Component)this.showPatchesCheckbox, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.showContentCheckbox = new JCheckBox("Show content");
        this.showContentCheckbox.setOpaque(false);
        this.showContentCheckbox.putClientProperty("JComponent.sizeVariant", "small");
        this.showContentCheckbox.addActionListener(event -> this.stretchesViewer.setPaddingVisible(((JCheckBox)event.getSource()).isSelected()));
        status2.add((Component)this.showContentCheckbox, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.showBadPatchesCheckbox = new JCheckBox("Show bad patches");
        this.showBadPatchesCheckbox.setOpaque(false);
        this.showBadPatchesCheckbox.putClientProperty("JComponent.sizeVariant", "small");
        this.showBadPatchesCheckbox.addActionListener(event -> this.viewer.setShowBadPatches(((JCheckBox)event.getSource()).isSelected()));
        status2.add((Component)this.showBadPatchesCheckbox, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        status2.add(Box.createHorizontalGlue(), new GridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("X: ");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status2.add((Component)label, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.xLabel = new JLabel("0px");
        this.xLabel.putClientProperty("JComponent.sizeVariant", "small");
        status2.add((Component)this.xLabel, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 6), 0, 0));
        label = new JLabel("Y: ");
        label.putClientProperty("JComponent.sizeVariant", "small");
        status2.add((Component)label, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.yLabel = new JLabel("0px");
        this.yLabel.putClientProperty("JComponent.sizeVariant", "small");
        status2.add((Component)this.yLabel, new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 6), 0, 0));
        String helpUrl = "http://developer.android.com/r/studio-ui/ninepatch.html";
        String helpText = "Learn More...";
        final JLabel helpButton = new JLabel("<html><a href=\"\">Learn More</a></html>");
        helpButton.setCursor(Cursor.getPredefinedCursor(12));
        helpButton.setToolTipText("Show help for 9-Patch files");
        helpButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://developer.android.com/r/studio-ui/ninepatch.html"));
                }
                catch (IOException | UnsupportedOperationException | URISyntaxException ex) {
                    JOptionPane.showMessageDialog(null, "Failed to open help link. Please visit http://developer.android.com/r/studio-ui/ninepatch.html directly.", "Cannot open URL", 2);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.updateText(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.updateText(false);
            }

            public void updateText(boolean ul) {
                String link = ul ? "<u>Learn More...</u>" : "Learn More...";
                helpButton.setText("<html><span style=\"color: #000099;\">" + link + "</span></html>");
            }
        });
        status2.add((Component)helpButton, new GridBagConstraints(9, 0, 1, 2, 0.0, 0.0, 21, 0, new Insets(0, 6, 0, 6), 0, 0));
        this.add((Component)status2, "South");
    }

    private static void ensure9Patch(BufferedImage image) {
        int pixel;
        int i;
        int width = image.getWidth();
        int height = image.getHeight();
        for (i = 0; i < width; ++i) {
            pixel = image.getRGB(i, 0);
            if (pixel != 0 && pixel != -16777216 && pixel != -65536) {
                image.setRGB(i, 0, 0);
            }
            if ((pixel = image.getRGB(i, height - 1)) == 0 || pixel == -16777216 || pixel == -65536) continue;
            image.setRGB(i, height - 1, 0);
        }
        for (i = 0; i < height; ++i) {
            pixel = image.getRGB(0, i);
            if (pixel != 0 && pixel != -16777216 && pixel != -65536) {
                image.setRGB(0, i, 0);
            }
            if ((pixel = image.getRGB(width - 1, i)) == 0 || pixel == -16777216 || pixel == -65536) continue;
            image.setRGB(width - 1, i, 0);
        }
    }

    private static BufferedImage convertTo9Patch(BufferedImage image) {
        BufferedImage buffer = GraphicsUtilities.createTranslucentCompatibleImage(image.getWidth() + 2, image.getHeight() + 2);
        Graphics2D g2 = buffer.createGraphics();
        g2.drawImage((Image)image, 1, 1, null);
        g2.dispose();
        return buffer;
    }

    File chooseSaveFile() {
        if (this.is9Patch) {
            return new File(this.name);
        }
        JFileChooser chooser = new JFileChooser(this.name.substring(0, this.name.lastIndexOf(File.separatorChar)));
        chooser.setFileFilter(new PngFileFilter());
        int choice = chooser.showSaveDialog(this);
        if (choice == 0) {
            File file = chooser.getSelectedFile();
            if (!file.getAbsolutePath().endsWith(EXTENSION_9PATCH)) {
                Object path = file.getAbsolutePath();
                path = ((String)path).endsWith(".png") ? ((String)path).substring(0, ((String)path).lastIndexOf(".png")) + EXTENSION_9PATCH : (String)path + EXTENSION_9PATCH;
                this.name = path;
                this.is9Patch = true;
                return new File((String)path);
            }
            this.is9Patch = true;
            return file;
        }
        return null;
    }

    RenderedImage getImage() {
        return this.image;
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.dispose();
        }
    }
}

