/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.AvdData;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.ClientTracker;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IDeviceSharedImpl;
import com.android.ddmlib.IDeviceUsageTracker;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.IUserDataMap;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.InstallMetrics;
import com.android.ddmlib.InstallReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ProfileableClient;
import com.android.ddmlib.PropertyFetcher;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.RemoteSplitApkInstaller;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.ddmlib.ServiceInfo;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SimpleConnectedSocket;
import com.android.ddmlib.SocketChannelWithTimeouts;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.clientmanager.DeviceClientManager;
import com.android.ddmlib.internal.BatteryFetcher;
import com.android.ddmlib.internal.ClientImpl;
import com.android.ddmlib.internal.ProfileableClientImpl;
import com.android.ddmlib.internal.UserDataMapImpl;
import com.android.ddmlib.log.LogReceiver;
import com.android.sdklib.AndroidVersion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

public final class DeviceImpl
implements IDevice {
    private final String mSerialNumber;
    private final SettableFuture<AvdData> mAvdData = SettableFuture.create();
    private IDevice.DeviceState mState;
    private boolean mIsRoot;
    private final PropertyFetcher mPropFetcher = new PropertyFetcher(this);
    private final Map<String, String> mMountPoints = new HashMap<String, String>();
    private final BatteryFetcher mBatteryFetcher = new BatteryFetcher(this);
    private final List<ClientImpl> mClients = new ArrayList<ClientImpl>();
    private final Map<Integer, String> mClientInfo = new ConcurrentHashMap<Integer, String>();
    private final List<ProfileableClientImpl> mProfileableClients = new ArrayList<ProfileableClientImpl>();
    private final ClientTracker mClientTracer;
    private final Function<IDevice, DeviceClientManager> mDeviceClientManagerProvider;
    private final IDeviceUsageTracker mIDeviceUsageTracker;
    private final UserDataMapImpl mUserDataMap = new UserDataMapImpl();
    private final IDeviceSharedImpl iDeviceSharedImpl = new IDeviceSharedImpl(this);
    private static final String LOG_TAG = "Device";
    private static final long GET_PROP_TIMEOUT_MS = 1000L;
    private static final long INITIAL_GET_PROP_TIMEOUT_MS = 5000L;
    private static final int QUERY_IS_ROOT_TIMEOUT_MS = 1000;
    static final int WAIT_TIME = 5;
    private SocketChannel mSocketChannel;
    private static final long LS_TIMEOUT_SEC = 2L;
    private Set<String> mAdbFeatures;
    private Object mAdbFeaturesLock = new Object();
    private DeviceClientManager mDeviceClientManager;

    @Override
    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    @Override
    public String getAvdName() {
        return this.logCall(IDeviceUsageTracker.Method.GET_AVD_NAME, () -> {
            AvdData avdData = this.getCurrentAvdData();
            return avdData != null ? avdData.getName() : null;
        });
    }

    @Override
    public String getAvdPath() {
        return this.logCall(IDeviceUsageTracker.Method.GET_AVD_PATH, () -> {
            AvdData avdData = this.getCurrentAvdData();
            return avdData != null ? avdData.getPath() : null;
        });
    }

    private AvdData getCurrentAvdData() {
        try {
            return this.mAvdData.isDone() ? (AvdData)this.mAvdData.get() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @Override
    public ListenableFuture<AvdData> getAvdData() {
        return (ListenableFuture)this.logCall(IDeviceUsageTracker.Method.GET_AVD_DATA, () -> this.mAvdData);
    }

    void setAvdData(AvdData data) {
        this.mAvdData.set((Object)data);
    }

    @Override
    public String getName() {
        return this.iDeviceSharedImpl.getName();
    }

    @Override
    public IDevice.DeviceState getState() {
        return this.mState;
    }

    void setState(IDevice.DeviceState state) {
        this.mState = state;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.logCall(IDeviceUsageTracker.Method.GET_PROPERTIES, () -> Collections.unmodifiableMap(this.mPropFetcher.getProperties()));
    }

    @Override
    public int getPropertyCount() {
        return this.logCall(IDeviceUsageTracker.Method.GET_PROPERTY_COUNT, () -> this.mPropFetcher.getProperties().size());
    }

    @Override
    public String getProperty(String name) {
        return this.logCall(IDeviceUsageTracker.Method.GET_PROPERTY, () -> {
            Map<String, String> properties = this.mPropFetcher.getProperties();
            long timeout = properties.isEmpty() ? 5000L : 1000L;
            ListenableFuture<String> future = this.mPropFetcher.getProperty(name);
            try {
                return (String)future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | java.util.concurrent.TimeoutException exception) {
                return null;
            }
        });
    }

    @Override
    public boolean arePropertiesSet() {
        return this.logCall(IDeviceUsageTracker.Method.ARE_PROPERTIES_SET, () -> this.mPropFetcher.arePropertiesSet());
    }

    @Override
    public String getPropertyCacheOrSync(String name) {
        ListenableFuture<String> future = this.mPropFetcher.getProperty(name);
        try {
            return (String)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return null;
        }
    }

    @Override
    public String getPropertySync(String name) {
        ListenableFuture<String> future = this.mPropFetcher.getProperty(name);
        try {
            return (String)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return null;
        }
    }

    @Override
    public ListenableFuture<String> getSystemProperty(String name) {
        return this.mPropFetcher.getProperty(name);
    }

    @Override
    public boolean supportsFeature(IDevice.Feature feature) {
        return this.iDeviceSharedImpl.supportsFeature(feature, this.getAdbFeatures());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getAdbFeatures() {
        Object object = this.mAdbFeaturesLock;
        synchronized (object) {
            if (this.mAdbFeatures != null) {
                return this.mAdbFeatures;
            }
            try {
                String response = AdbHelper.getFeatures(this);
                this.mAdbFeatures = new HashSet<String>(Arrays.asList(response.split(",")));
                response = AdbHelper.getHostFeatures();
                this.mAdbFeatures.retainAll(Arrays.asList(response.split(",")));
            }
            catch (AdbCommandRejectedException | TimeoutException | IOException e) {
                Log.e(LOG_TAG, new RuntimeException("Error obtaining features: ", e));
                return new HashSet<String>();
            }
            return this.mAdbFeatures;
        }
    }

    @Override
    public Map<String, ServiceInfo> services() {
        return this.logCall(IDeviceUsageTracker.Method.SERVICES, () -> this.iDeviceSharedImpl.services());
    }

    @Override
    public boolean supportsFeature(IDevice.HardwareFeature feature) {
        return this.logCall(IDeviceUsageTracker.Method.SUPPORTS_FEATURE_1, () -> this.iDeviceSharedImpl.supportsFeature(feature));
    }

    @Override
    public AndroidVersion getVersion() {
        return this.iDeviceSharedImpl.getVersion();
    }

    @Override
    public String getMountPoint(String name) {
        String mount = this.mMountPoints.get(name);
        if (mount == null) {
            try {
                mount = this.queryMountPoint(name);
                this.mMountPoints.put(name, mount);
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException exception) {
                // empty catch block
            }
        }
        return mount;
    }

    private String queryMountPoint(String name) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        final AtomicReference ref = Atomics.newReference();
        this.executeShellCommand("echo $" + name, new MultiLineReceiver(){

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public void processNewLines(String[] lines) {
                for (String line : lines) {
                    if (line.isEmpty()) continue;
                    ref.set(line);
                }
            }
        });
        return (String)ref.get();
    }

    public String toString() {
        return this.mSerialNumber;
    }

    @Override
    public boolean isOnline() {
        return this.logCall(IDeviceUsageTracker.Method.IS_ONLINE, () -> this.mState == IDevice.DeviceState.ONLINE);
    }

    @Override
    public boolean isEmulator() {
        return this.mSerialNumber.matches("emulator-(\\d+)");
    }

    @Override
    public boolean isOffline() {
        return this.mState == IDevice.DeviceState.OFFLINE;
    }

    @Override
    public boolean isBootLoader() {
        return this.mState == IDevice.DeviceState.BOOTLOADER;
    }

    @Override
    public SyncService getSyncService() throws TimeoutException, AdbCommandRejectedException, IOException {
        SyncService syncService = new SyncService(AndroidDebugBridge.getSocketAddress(), this);
        if (syncService.openSync()) {
            return syncService;
        }
        return null;
    }

    @Override
    public FileListingService getFileListingService() {
        return new FileListingService(this);
    }

    @Override
    public RawImage getScreenshot() throws TimeoutException, AdbCommandRejectedException, IOException {
        return this.getScreenshot(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public RawImage getScreenshot(long timeout, TimeUnit unit) throws TimeoutException, AdbCommandRejectedException, IOException {
        return AdbHelper.getFrameBuffer(AndroidDebugBridge.getSocketAddress(), this, timeout, unit);
    }

    @Override
    public void startScreenRecorder(String remoteFilePath, ScreenRecorderOptions options, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        this.executeShellCommand(DeviceImpl.getScreenRecorderCommand(remoteFilePath, options), receiver, 0L, null);
    }

    @VisibleForTesting
    public static String getScreenRecorderCommand(String remoteFilePath, ScreenRecorderOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append("screenrecord");
        sb.append(' ');
        if (options.width > 0 && options.height > 0) {
            sb.append("--size ");
            sb.append(options.width);
            sb.append('x');
            sb.append(options.height);
            sb.append(' ');
        }
        if (options.bitrateMbps > 0) {
            sb.append("--bit-rate ");
            sb.append(options.bitrateMbps * 1000000);
            sb.append(' ');
        }
        if (options.timeLimit > 0L) {
            sb.append("--time-limit ");
            long seconds = TimeUnit.SECONDS.convert(options.timeLimit, options.timeLimitUnits);
            if (seconds > 180L) {
                seconds = 180L;
            }
            sb.append(seconds);
            sb.append(' ');
        }
        sb.append(remoteFilePath);
        return sb.toString();
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.logRun1(IDeviceUsageTracker.Method.EXECUTE_SHELL_COMMAND_1, () -> this.executeRemoteCommand(command, receiver, DdmPreferences.getTimeOut(), TimeUnit.MILLISECONDS));
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, InputStream is) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.logRun1(IDeviceUsageTracker.Method.EXECUTE_SHELL_COMMAND_4, () -> this.executeRemoteCommand(AdbHelper.AdbService.EXEC, command, receiver, 0L, maxTimeToOutputResponse, maxTimeUnits, is));
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, int maxTimeToOutputResponse) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.logRun1(IDeviceUsageTracker.Method.EXECUTE_SHELL_COMMAND_2, () -> this.executeRemoteCommand(command, receiver, maxTimeToOutputResponse, TimeUnit.MILLISECONDS));
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.logRun1(IDeviceUsageTracker.Method.EXECUTE_SHELL_COMMAND_3, () -> this.executeRemoteCommand(command, receiver, 0L, maxTimeToOutputResponse, maxTimeUnits));
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeout, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.logRun1(IDeviceUsageTracker.Method.EXECUTE_SHELL_COMMAND_5, () -> this.executeRemoteCommand(command, receiver, maxTimeout, maxTimeToOutputResponse, maxTimeUnits));
    }

    @Override
    public void executeRemoteCommand(String command, IShellOutputReceiver rcvr, long maxTimeout, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.logRun1(IDeviceUsageTracker.Method.EXECUTE_REMOTE_COMMAND_2, () -> this.executeRemoteCommand(AdbHelper.AdbService.SHELL, command, rcvr, maxTimeout, maxTimeToOutputResponse, maxTimeUnits, null));
    }

    @Override
    public void executeRemoteCommand(String command, IShellOutputReceiver rcvr, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.logRun1(IDeviceUsageTracker.Method.EXECUTE_REMOTE_COMMAND_1, () -> this.executeRemoteCommand(AdbHelper.AdbService.SHELL, command, rcvr, maxTimeToOutputResponse, maxTimeUnits, null));
    }

    @Override
    public void executeRemoteCommand(AdbHelper.AdbService adbService, String command, IShellOutputReceiver rcvr, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, InputStream is) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.logRun1(IDeviceUsageTracker.Method.EXECUTE_REMOTE_COMMAND_3, () -> this.executeRemoteCommand(adbService, command, rcvr, 0L, maxTimeToOutputResponse, maxTimeUnits, is));
    }

    @Override
    @Slow
    public void executeRemoteCommand(AdbHelper.AdbService adbService, String command, IShellOutputReceiver rcvr, long maxTimeout, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, InputStream is) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.logRun1(IDeviceUsageTracker.Method.EXECUTE_REMOTE_COMMAND_4, () -> {
            block25: {
                long maxTimeToOutputMs = 0L;
                if (maxTimeToOutputResponse > 0L) {
                    if (maxTimeUnits == null) {
                        throw new NullPointerException("Time unit must not be null for non-zero max.");
                    }
                    maxTimeToOutputMs = maxTimeUnits.toMillis(maxTimeToOutputResponse);
                }
                long maxTimeoutMs = 0L;
                if (maxTimeout > 0L) {
                    if (maxTimeUnits == null) {
                        throw new NullPointerException("Time unit must not be null for non-zero max.");
                    }
                    maxTimeoutMs = maxTimeUnits.toMillis(maxTimeout);
                }
                Log.v("ddms", "execute: running " + command);
                SocketChannel adbChan = null;
                try {
                    long startTime = System.currentTimeMillis();
                    adbChan = SocketChannel.open(AndroidDebugBridge.getSocketAddress());
                    adbChan.configureBlocking(false);
                    AdbHelper.setDevice(adbChan, this);
                    byte[] request2 = AdbHelper.formAdbRequest(adbService, command);
                    AdbHelper.write(adbChan, request2);
                    long timeOutForResp = maxTimeToOutputMs > 0L ? maxTimeToOutputMs : (long)DdmPreferences.getTimeOut();
                    AdbHelper.AdbResponse resp = AdbHelper.readAdbResponse(adbChan, false, timeOutForResp);
                    if (!resp.okay) {
                        Log.e("ddms", "ADB rejected shell command (" + command + "): " + resp.message);
                        throw new AdbCommandRejectedException(resp.message);
                    }
                    byte[] data = new byte[16384];
                    if (is != null) {
                        int read2;
                        while ((read2 = is.read(data)) != -1) {
                            ByteBuffer buf = ByteBuffer.wrap(data, 0, read2);
                            int writtenTotal = 0;
                            long lastResponsive = System.currentTimeMillis();
                            while (buf.hasRemaining()) {
                                int written = adbChan.write(buf);
                                if (written == 0) {
                                    if (maxTimeToOutputMs > 0L && System.currentTimeMillis() - lastResponsive > maxTimeToOutputMs) {
                                        throw new TimeoutException(String.format("executeRemoteCommand write timed out after %sms", maxTimeToOutputMs));
                                    }
                                } else {
                                    lastResponsive = System.currentTimeMillis();
                                }
                                if (maxTimeoutMs > 0L && System.currentTimeMillis() - startTime > maxTimeoutMs) {
                                    throw new TimeoutException(String.format("executeRemoteCommand timed out after %sms", maxTimeoutMs));
                                }
                                writtenTotal += written;
                            }
                            if (writtenTotal == read2) continue;
                            Log.e("ddms", "ADB write inconsistency, wrote " + writtenTotal + "expected " + read2);
                            throw new AdbCommandRejectedException("write failed");
                        }
                    }
                    ByteBuffer buf = ByteBuffer.wrap(data);
                    buf.clear();
                    long timeToResponseCount = 0L;
                    do {
                        if (rcvr != null && rcvr.isCancelled()) {
                            Log.v("ddms", "execute: cancelled");
                            break block25;
                        }
                        int count = adbChan.read(buf);
                        if (count < 0) {
                            rcvr.flush();
                            Log.v("ddms", "execute '" + command + "' on '" + this + "' : EOF hit. Read: " + count);
                            break block25;
                        }
                        if (count == 0) {
                            try {
                                int wait = 25;
                                if (maxTimeToOutputMs > 0L && (timeToResponseCount += (long)wait) > maxTimeToOutputMs) {
                                    throw new ShellCommandUnresponsiveException();
                                }
                                Thread.sleep(wait);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new TimeoutException("executeRemoteCommand interrupted with immediate timeout via interruption.");
                            }
                        } else {
                            timeToResponseCount = 0L;
                            if (rcvr != null) {
                                rcvr.addOutput(buf.array(), buf.arrayOffset(), buf.position());
                            }
                            buf.rewind();
                        }
                    } while (maxTimeoutMs <= 0L || System.currentTimeMillis() - startTime <= maxTimeoutMs);
                    throw new TimeoutException(String.format("executeRemoteCommand timed out after %sms", maxTimeoutMs));
                }
                finally {
                    if (adbChan != null) {
                        adbChan.close();
                    }
                    Log.v("ddms", "execute: returning");
                }
            }
        });
    }

    @Override
    public SocketChannel rawExec(String executable, String[] parameters) throws AdbCommandRejectedException, TimeoutException, IOException {
        return AdbHelper.rawExec(AndroidDebugBridge.getSocketAddress(), this, executable, parameters);
    }

    @Override
    public SimpleConnectedSocket rawExec2(String executable, String[] parameters) throws AdbCommandRejectedException, TimeoutException, IOException {
        return this.logCall4(IDeviceUsageTracker.Method.RAW_EXEC2, () -> SocketChannelWithTimeouts.wrap(this.rawExec(executable, parameters)));
    }

    @Override
    public SocketChannel rawBinder(String service, String[] parameters) throws AdbCommandRejectedException, TimeoutException, IOException {
        CharSequence[] command = new String[parameters.length + 1];
        command[0] = service;
        System.arraycopy(parameters, 0, command, 1, parameters.length);
        if (this.supportsFeature(IDevice.Feature.ABB_EXEC)) {
            return AdbHelper.rawAdbService(AndroidDebugBridge.getSocketAddress(), this, String.join((CharSequence)"\u0000", command), AdbHelper.AdbService.ABB_EXEC);
        }
        return AdbHelper.rawExec(AndroidDebugBridge.getSocketAddress(), this, "cmd", (String[])command);
    }

    @Override
    public void runEventLogService(LogReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.runEventLogService(AndroidDebugBridge.getSocketAddress(), this, receiver);
    }

    @Override
    public void runLogService(String logname, LogReceiver receiver) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.runLogService(AndroidDebugBridge.getSocketAddress(), this, logname, receiver);
    }

    @Override
    public void createForward(int localPort, int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
        this.logRun2(IDeviceUsageTracker.Method.CREATE_FORWARD_1, () -> AdbHelper.createForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", localPort), String.format("tcp:%d", remotePort)));
    }

    @Override
    public void createForward(int localPort, String remoteSocketName, IDevice.DeviceUnixSocketNamespace namespace) throws TimeoutException, AdbCommandRejectedException, IOException {
        this.logRun2(IDeviceUsageTracker.Method.CREATE_FORWARD_2, () -> AdbHelper.createForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", localPort), String.format("%s:%s", namespace.getType(), remoteSocketName)));
    }

    @Override
    public void removeForward(int localPort) throws TimeoutException, AdbCommandRejectedException, IOException {
        this.logRun2(IDeviceUsageTracker.Method.REMOVE_FORWARD, () -> AdbHelper.removeForward(AndroidDebugBridge.getSocketAddress(), this, String.format("tcp:%d", localPort)));
    }

    @Override
    public void createReverse(int remotePort, int localPort) throws TimeoutException, AdbCommandRejectedException, IOException {
        this.logRun2(IDeviceUsageTracker.Method.CREATE_REVERSE, () -> AdbHelper.createReverse(AndroidDebugBridge.getSocketAddress(), this, String.format(Locale.US, "tcp:%d", localPort), String.format(Locale.US, "tcp:%d", remotePort)));
    }

    @Override
    public void removeReverse(int remotePort) throws TimeoutException, AdbCommandRejectedException, IOException {
        this.logRun2(IDeviceUsageTracker.Method.REMOVE_REVERSE, () -> AdbHelper.removeReverse(AndroidDebugBridge.getSocketAddress(), this, String.format(Locale.US, "tcp:%d", remotePort)));
    }

    public DeviceImpl(ClientTracker clientTracer, String serialNumber, IDevice.DeviceState deviceState) {
        this(clientTracer, null, serialNumber, deviceState, null);
    }

    public DeviceImpl(ClientTracker clientTracer, Function<IDevice, DeviceClientManager> deviceClientManagerProvider, String serialNumber, IDevice.DeviceState deviceState, IDeviceUsageTracker iDeviceUsageTracker) {
        this.mClientTracer = clientTracer;
        this.mDeviceClientManagerProvider = deviceClientManagerProvider;
        this.mSerialNumber = serialNumber;
        this.mState = deviceState;
        this.mIDeviceUsageTracker = iDeviceUsageTracker;
    }

    public ClientTracker getClientTracker() {
        return this.mClientTracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasClients() {
        if (this.mDeviceClientManagerProvider != null) {
            return !this.getClientManager().getClients().isEmpty();
        }
        List<ClientImpl> list2 = this.mClients;
        synchronized (list2) {
            return !this.mClients.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client[] getClients() {
        if (this.mDeviceClientManagerProvider != null) {
            return this.getClientManager().getClients().toArray(new Client[0]);
        }
        List<ClientImpl> list2 = this.mClients;
        synchronized (list2) {
            return this.mClients.toArray(new Client[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getClient(String processName) {
        if (this.mDeviceClientManagerProvider != null) {
            Client[] clients;
            for (Client c : clients = this.getClients()) {
                if (!processName.equals(c.getClientData().getProcessName())) continue;
                return c;
            }
            return null;
        }
        List<ClientImpl> list2 = this.mClients;
        synchronized (list2) {
            for (Client client : this.mClients) {
                if (!processName.equals(client.getClientData().getProcessName())) continue;
                return client;
            }
        }
        return null;
    }

    @Override
    public ProfileableClient[] getProfileableClients() {
        if (this.mDeviceClientManagerProvider != null) {
            return this.getClientManager().getProfileableClients().toArray(new ProfileableClient[0]);
        }
        return this.getProfileableClientImpls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProfileableClientImpl[] getProfileableClientImpls() {
        List<ProfileableClientImpl> list2 = this.mProfileableClients;
        synchronized (list2) {
            return this.mProfileableClients.toArray(new ProfileableClientImpl[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceClientManager getClientManager() {
        if (this.mDeviceClientManagerProvider == null) {
            return IDevice.super.getClientManager();
        }
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            if (this.mDeviceClientManager == null) {
                this.mDeviceClientManager = this.mDeviceClientManagerProvider.apply(this);
            }
            return this.mDeviceClientManager;
        }
    }

    @Override
    public void forceStop(String applicationName) {
        this.logRun(IDeviceUsageTracker.Method.FORCE_STOP, () -> this.iDeviceSharedImpl.forceStop(applicationName));
    }

    @Override
    public void kill(String applicationName) {
        this.logRun(IDeviceUsageTracker.Method.KILL, () -> this.iDeviceSharedImpl.kill(applicationName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClient(ClientImpl client) {
        List<ClientImpl> list2 = this.mClients;
        synchronized (list2) {
            this.mClients.add(client);
        }
        this.addClientInfo(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ClientImpl> getClientList() {
        List<ClientImpl> list2 = this.mClients;
        synchronized (list2) {
            return this.mClients;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearClientList() {
        List<ClientImpl> list2 = this.mClients;
        synchronized (list2) {
            this.mClients.clear();
        }
        this.clearClientInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClient(ClientImpl client, boolean notify) {
        this.mClientTracer.trackDisconnectedClient(client);
        List<ClientImpl> list2 = this.mClients;
        synchronized (list2) {
            this.mClients.remove(client);
        }
        if (notify) {
            AndroidDebugBridge.deviceChanged(this, 2);
        }
        this.removeClientInfo(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProfileableClientList(List<ProfileableClientImpl> newClientList) {
        List<ProfileableClientImpl> list2 = this.mProfileableClients;
        synchronized (list2) {
            this.mProfileableClients.clear();
            this.mProfileableClients.addAll(newClientList);
            Collections.sort(this.mProfileableClients, Comparator.comparingInt(c -> c.getProfileableClientData().getPid()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProfileableClientName(int pid, String name) {
        List<ProfileableClientImpl> list2 = this.mProfileableClients;
        synchronized (list2) {
            for (ProfileableClientImpl client : this.mProfileableClients) {
                if (client.getProfileableClientData().getPid() != pid) continue;
                client.getProfileableClientData().setProcessName(name);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearProfileableClientList() {
        List<ProfileableClientImpl> list2 = this.mProfileableClients;
        synchronized (list2) {
            this.mProfileableClients.clear();
        }
    }

    void setClientMonitoringSocket(SocketChannel socketChannel) {
        this.mSocketChannel = socketChannel;
    }

    SocketChannel getClientMonitoringSocket() {
        return this.mSocketChannel;
    }

    void update(int changeMask) {
        AndroidDebugBridge.deviceChanged(this, changeMask);
    }

    void update(ClientImpl client, int changeMask) {
        AndroidDebugBridge.clientChanged(client, changeMask);
        this.updateClientInfo(client, changeMask);
    }

    void setMountingPoint(String name, String value) {
        this.mMountPoints.put(name, value);
    }

    private void addClientInfo(ClientImpl client) {
        ClientData cd = client.getClientData();
        this.setClientInfo(cd.getPid(), cd.getPackageName());
    }

    private void updateClientInfo(ClientImpl client, int changeMask) {
        if ((changeMask & 1) == 1) {
            this.addClientInfo(client);
        }
    }

    private void removeClientInfo(ClientImpl client) {
        int pid = client.getClientData().getPid();
        this.mClientInfo.remove(pid);
    }

    private void clearClientInfo() {
        this.mClientInfo.clear();
    }

    private void setClientInfo(int pid, String pkgName) {
        if (pkgName == null) {
            pkgName = "";
        }
        this.mClientInfo.put(pid, pkgName);
    }

    @Override
    public String getClientName(int pid) {
        if (this.mDeviceClientManagerProvider != null) {
            Client[] clients;
            String name = null;
            for (Client c : clients = this.getClients()) {
                if (pid != c.getClientData().getPid()) continue;
                name = c.getClientData().getPackageName();
                break;
            }
            return name == null ? "" : name;
        }
        return this.mClientInfo.getOrDefault(pid, "");
    }

    @Override
    public void push(String[] local, String remote) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        Log.d(String.join((CharSequence)", ", local), String.format("Uploading %1$s onto device '%2$s'", remote, this.getSerialNumber()));
        try (SyncService sync = this.getSyncService();){
            if (sync == null) {
                throw new IOException("Unable to open sync connection");
            }
            String message = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
            Log.d(LOG_TAG, message);
            sync.push(local, remote, SyncService.getNullProgressMonitor());
        }
        catch (TimeoutException e) {
            Log.e(LOG_TAG, "Error during Sync: timeout.");
            throw e;
        }
        catch (SyncException | IOException e) {
            Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
            throw e;
        }
    }

    @Override
    public void pushFile(String local, String remote) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        this.logRun4(IDeviceUsageTracker.Method.PUSH_FILE, () -> {
            String targetFileName = DeviceImpl.getFileName(local);
            Log.d(targetFileName, String.format("Uploading %1$s onto device '%2$s'", targetFileName, this.getSerialNumber()));
            try (SyncService sync = this.getSyncService();){
                if (sync == null) {
                    throw new IOException("Unable to open sync connection");
                }
                String message = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
                Log.d(LOG_TAG, message);
                sync.pushFile(local, remote, SyncService.getNullProgressMonitor());
            }
            catch (TimeoutException e) {
                Log.e(LOG_TAG, "Error during Sync: timeout.");
                throw e;
            }
            catch (SyncException | IOException e) {
                Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
                throw e;
            }
        });
    }

    @Override
    public void pullFile(String remote, String local) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        this.logRun4(IDeviceUsageTracker.Method.PULL_FILE, () -> {
            block8: {
                try (SyncService sync = null;){
                    String targetFileName = DeviceImpl.getFileName(remote);
                    Log.d(targetFileName, String.format("Downloading %1$s from device '%2$s'", targetFileName, this.getSerialNumber()));
                    sync = this.getSyncService();
                    if (sync != null) {
                        String message = String.format("Downloading file from device '%1$s'", this.getSerialNumber());
                        Log.d(LOG_TAG, message);
                        sync.pullFile(remote, local, SyncService.getNullProgressMonitor());
                        break block8;
                    }
                    throw new IOException("Unable to open sync connection!");
                }
            }
        });
    }

    @Override
    public SyncService.FileStat statFile(String remote) throws IOException, AdbCommandRejectedException, TimeoutException {
        return this.logCall4(IDeviceUsageTracker.Method.STAT_FILE, () -> {
            try (SyncService sync = null;){
                String targetFileName = DeviceImpl.getFileName(remote);
                Log.d(LOG_TAG, String.format("Stat %1$s from device '%2$s'", targetFileName, this.getSerialNumber()));
                sync = this.getSyncService();
                if (sync != null) {
                    SyncService.FileStat fileStat = sync.statFile(remote);
                    return fileStat;
                }
                try {
                    throw new IOException("Unable to open sync connection!");
                }
                catch (TimeoutException e) {
                    Log.e(LOG_TAG, "Error during Sync: timeout.");
                    throw e;
                }
                catch (IOException e) {
                    Log.e(LOG_TAG, String.format("Error during Sync: %1$s", e.getMessage()));
                    throw e;
                }
            }
        });
    }

    @Override
    public void installPackage(String packageFilePath, boolean reinstall, String ... extraArgs) throws InstallException {
        this.logRun3(IDeviceUsageTracker.Method.INSTALL_PACKAGE_1, () -> this.installPackage(packageFilePath, reinstall, new InstallReceiver(), extraArgs));
    }

    @Override
    public void installPackage(String packageFilePath, boolean reinstall, InstallReceiver receiver, String ... extraArgs) throws InstallException {
        this.logRun3(IDeviceUsageTracker.Method.INSTALL_PACKAGE_2, () -> this.installPackage(packageFilePath, reinstall, receiver, 0L, IDeviceSharedImpl.INSTALL_TIMEOUT_MINUTES, TimeUnit.MINUTES, extraArgs));
    }

    @Override
    public void installPackage(String packageFilePath, boolean reinstall, InstallReceiver receiver, long maxTimeout, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, String ... extraArgs) throws InstallException {
        this.logRun3(IDeviceUsageTracker.Method.INSTALL_PACKAGE_3, () -> this.iDeviceSharedImpl.installPackage(packageFilePath, reinstall, receiver, maxTimeout, maxTimeToOutputResponse, maxTimeUnits, extraArgs));
    }

    @Override
    public void installPackages(List<File> apks, boolean reinstall, List<String> installOptions, long timeout, TimeUnit timeoutUnit) throws InstallException {
        this.logRun3(IDeviceUsageTracker.Method.INSTALL_PACKAGES_2, () -> this.iDeviceSharedImpl.installPackages(apks, reinstall, installOptions, timeout, timeoutUnit));
    }

    @Override
    public void installPackages(List<File> apks, boolean reinstall, List<String> installOptions) throws InstallException {
        this.logRun3(IDeviceUsageTracker.Method.INSTALL_PACKAGES_1, () -> this.installPackages(apks, reinstall, installOptions, IDeviceSharedImpl.INSTALL_TIMEOUT_MINUTES, TimeUnit.MINUTES));
    }

    @Override
    public InstallMetrics getLastInstallMetrics() {
        return this.iDeviceSharedImpl.getLastInstallMetrics();
    }

    @Override
    public void installRemotePackages(List<String> remoteApks, boolean reinstall, List<String> installOptions) throws InstallException {
        this.installRemotePackages(remoteApks, reinstall, installOptions, IDeviceSharedImpl.INSTALL_TIMEOUT_MINUTES, TimeUnit.MINUTES);
    }

    @Override
    public void installRemotePackages(List<String> remoteApks, boolean reinstall, List<String> installOptions, long timeout, TimeUnit timeoutUnit) throws InstallException {
        try {
            RemoteSplitApkInstaller.create(this, remoteApks, reinstall, installOptions).install(timeout, timeoutUnit);
        }
        catch (InstallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstallException(e);
        }
    }

    @Override
    public String syncPackageToDevice(String localFilePath) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        return this.logCall3(IDeviceUsageTracker.Method.SYNC_PACKAGE_TO_DEVICE, () -> {
            try (SyncService sync = null;){
                String packageFileName = DeviceImpl.getFileName(localFilePath);
                String remoteFilePath = String.format("/data/local/tmp/%1$s", packageFileName);
                Log.d(packageFileName, String.format("Uploading %1$s onto device '%2$s'", packageFileName, this.getSerialNumber()));
                sync = this.getSyncService();
                if (sync == null) {
                    throw new IOException("Unable to open sync connection!");
                }
                String message = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
                Log.d(LOG_TAG, message);
                sync.pushFile(localFilePath, remoteFilePath, SyncService.getNullProgressMonitor());
                String string2 = remoteFilePath;
                return string2;
            }
        });
    }

    private static String getFileName(String filePath) {
        return new File(filePath).getName();
    }

    @Override
    public void installRemotePackage(String remoteFilePath, boolean reinstall, String ... extraArgs) throws InstallException {
        this.installRemotePackage(remoteFilePath, reinstall, new InstallReceiver(), extraArgs);
    }

    @Override
    public void installRemotePackage(String remoteFilePath, boolean reinstall, InstallReceiver receiver, String ... extraArgs) throws InstallException {
        this.installRemotePackage(remoteFilePath, reinstall, receiver, 0L, IDeviceSharedImpl.INSTALL_TIMEOUT_MINUTES, TimeUnit.MINUTES, extraArgs);
    }

    @Override
    public void installRemotePackage(String remoteFilePath, boolean reinstall, InstallReceiver receiver, long maxTimeout, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, String ... extraArgs) throws InstallException {
        this.logRun3(IDeviceUsageTracker.Method.INSTALL_REMOTE_PACKAGE, () -> this.iDeviceSharedImpl.installRemotePackage(remoteFilePath, reinstall, receiver, maxTimeout, maxTimeToOutputResponse, maxTimeUnits, extraArgs));
    }

    @Override
    public void removeRemotePackage(String remoteFilePath) throws InstallException {
        this.logRun3(IDeviceUsageTracker.Method.REMOVE_REMOTE_PACKAGE, () -> this.iDeviceSharedImpl.removeRemotePackage(remoteFilePath));
    }

    @Override
    public String uninstallPackage(String packageName) throws InstallException {
        return this.logCall2(IDeviceUsageTracker.Method.UNINSTALL_PACKAGE, () -> this.uninstallApp(packageName, new String[0]));
    }

    @Override
    public String uninstallApp(String applicationID, String ... extraArgs) throws InstallException {
        return this.logCall2(IDeviceUsageTracker.Method.UNINSTALL_APP, () -> this.iDeviceSharedImpl.uninstallApp(applicationID, extraArgs));
    }

    @Override
    public void reboot(String into) throws TimeoutException, AdbCommandRejectedException, IOException {
        AdbHelper.reboot(into, AndroidDebugBridge.getSocketAddress(), this);
    }

    @Override
    public boolean root() throws TimeoutException, AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException {
        return this.logCall1(IDeviceUsageTracker.Method.ROOT, () -> {
            if (!this.mIsRoot) {
                AdbHelper.root(AndroidDebugBridge.getSocketAddress(), this);
            }
            return this.isRoot();
        });
    }

    @Override
    public boolean isRoot() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        return this.logCall1(IDeviceUsageTracker.Method.IS_ROOT, () -> {
            if (this.mIsRoot) {
                return true;
            }
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            this.executeShellCommand("echo $USER_ID", receiver, 1000L, TimeUnit.MILLISECONDS);
            String userID = receiver.getOutput().trim();
            this.mIsRoot = userID.equals("0");
            return this.mIsRoot;
        });
    }

    @Override
    public Integer getBatteryLevel() {
        return this.getBatteryLevel(300000L);
    }

    @Override
    public Integer getBatteryLevel(long freshnessMs) {
        Future<Integer> futureBattery = this.getBattery(freshnessMs, TimeUnit.MILLISECONDS);
        try {
            return futureBattery.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @Override
    public Future<Integer> getBattery() {
        return this.getBattery(5L, TimeUnit.MINUTES);
    }

    @Override
    public Future<Integer> getBattery(long freshnessTime, TimeUnit timeUnit) {
        return this.mBatteryFetcher.getBattery(freshnessTime, timeUnit);
    }

    @Override
    public List<String> getAbis() {
        return this.logCall(IDeviceUsageTracker.Method.GET_ABIS, () -> this.iDeviceSharedImpl.getAbis());
    }

    @Override
    public int getDensity() {
        return this.logCall(IDeviceUsageTracker.Method.GET_DENSITY, () -> this.iDeviceSharedImpl.getDensity());
    }

    @Override
    public String getLanguage() {
        return this.getProperties().get("persist.sys.language");
    }

    @Override
    public String getRegion() {
        return this.getProperty("persist.sys.country");
    }

    @Override
    public <T> T computeUserDataIfAbsent(IUserDataMap.Key<T> key, Function<IUserDataMap.Key<T>, T> mappingFunction) {
        return this.mUserDataMap.computeUserDataIfAbsent(key, mappingFunction);
    }

    @Override
    public <T> T getUserDataOrNull(IUserDataMap.Key<T> key) {
        return this.mUserDataMap.getUserDataOrNull(key);
    }

    @Override
    public <T> T removeUserData(IUserDataMap.Key<T> key) {
        return this.mUserDataMap.removeUserData(key);
    }

    private void logRun(IDeviceUsageTracker.Method method, Runnable block) {
        try {
            block.run();
            this.maybeLogUsage(method, false);
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private void logRun1(IDeviceUsageTracker.Method method, ThrowingRunnable1 block) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        try {
            block.run();
            this.maybeLogUsage(method, false);
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private void logRun2(IDeviceUsageTracker.Method method, ThrowingRunnable2 block) throws TimeoutException, AdbCommandRejectedException, IOException {
        try {
            block.run();
            this.maybeLogUsage(method, false);
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private void logRun3(IDeviceUsageTracker.Method method, ThrowingRunnable3 block) throws InstallException {
        try {
            block.run();
            this.maybeLogUsage(method, false);
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private void logRun4(IDeviceUsageTracker.Method method, ThrowingRunnable4 block) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        try {
            block.run();
            this.maybeLogUsage(method, false);
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private <R> R logCall(IDeviceUsageTracker.Method method, Supplier<R> block) {
        try {
            R result2 = block.get();
            this.maybeLogUsage(method, false);
            return result2;
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private <R> R logCall1(IDeviceUsageTracker.Method method, ThrowingSupplier1<R> block) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        try {
            R result2 = block.get();
            this.maybeLogUsage(method, false);
            return result2;
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private <R> R logCall2(IDeviceUsageTracker.Method method, ThrowingSupplier2<R> block) throws InstallException {
        try {
            R result2 = block.get();
            this.maybeLogUsage(method, false);
            return result2;
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private <R> R logCall3(IDeviceUsageTracker.Method method, ThrowingSupplier3<R> block) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException {
        try {
            R result2 = block.get();
            this.maybeLogUsage(method, false);
            return result2;
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private <R> R logCall4(IDeviceUsageTracker.Method method, ThrowingSupplier4<R> block) throws IOException, AdbCommandRejectedException, TimeoutException {
        try {
            R result2 = block.get();
            this.maybeLogUsage(method, false);
            return result2;
        }
        catch (Throwable t) {
            this.maybeLogUsage(method, true);
            throw t;
        }
    }

    private void maybeLogUsage(IDeviceUsageTracker.Method method, boolean isException) {
        if (this.mIDeviceUsageTracker != null) {
            this.mIDeviceUsageTracker.logUsage(method, isException);
        }
    }

    @FunctionalInterface
    private static interface ThrowingRunnable1 {
        public void run() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException;
    }

    @FunctionalInterface
    private static interface ThrowingSupplier4<T> {
        public T get() throws IOException, AdbCommandRejectedException, TimeoutException;
    }

    @FunctionalInterface
    private static interface ThrowingRunnable2 {
        public void run() throws TimeoutException, AdbCommandRejectedException, IOException;
    }

    @FunctionalInterface
    private static interface ThrowingRunnable4 {
        public void run() throws IOException, AdbCommandRejectedException, TimeoutException, SyncException;
    }

    @FunctionalInterface
    private static interface ThrowingRunnable3 {
        public void run() throws InstallException;
    }

    @FunctionalInterface
    private static interface ThrowingSupplier3<T> {
        public T get() throws IOException, AdbCommandRejectedException, TimeoutException, SyncException;
    }

    @FunctionalInterface
    private static interface ThrowingSupplier2<T> {
        public T get() throws InstallException;
    }

    @FunctionalInterface
    private static interface ThrowingSupplier1<T> {
        public T get() throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException;
    }
}

