/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.CommandFailedException;
import com.android.ddmlib.EmulatorConsoleImpl;
import com.android.ddmlib.IDevice;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public abstract class EmulatorConsole {
    private static final Map<String, EmulatorConsole> sTestConsoles = new HashMap<String, EmulatorConsole>();

    public abstract void close();

    public abstract void kill();

    public abstract String getAvdName();

    public Path getAvdNioPath() throws CommandFailedException {
        return Paths.get(this.getAvdPath(), new String[0]);
    }

    @Deprecated
    public abstract String getAvdPath() throws CommandFailedException;

    public abstract String startEmulatorScreenRecording(String var1);

    public abstract String stopScreenRecording();

    @VisibleForTesting
    public static void registerConsoleForTest(String deviceSerial, EmulatorConsole console) {
        sTestConsoles.put(deviceSerial, console);
    }

    @VisibleForTesting
    public static void clearConsolesForTest() {
        sTestConsoles.clear();
    }

    public static EmulatorConsole getConsole(IDevice d) {
        EmulatorConsole result2 = sTestConsoles.get(d.getSerialNumber());
        if (result2 == null) {
            result2 = EmulatorConsoleImpl.createConsole(d);
        }
        return result2;
    }

    public static Integer getEmulatorPort(String serialNumber) {
        return EmulatorConsoleImpl.getEmulatorPortFromSerialNumber(serialNumber);
    }
}

