/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.utils;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/adblib/utils/WarningsTracker;", "", "staleThreshold", "Ljava/time/Duration;", "repeatLogPeriod", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Clock;)V", "lock", "lastWarningStates", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/adblib/utils/WarningsTracker$WarningState;", "operationCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getLogAction", "Lcom/android/adblib/utils/WarningsTracker$LogAction;", "key", "failureReason", "didRecover", "Lcom/android/adblib/utils/WarningsTracker$RecoveryAction;", "runCleanupIfNeeded", "", "cleanupStaleEntries", "LogAction", "RecoveryAction", "WarningState", "Companion", "android.sdktools.adblib"})
public final class WarningsTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration staleThreshold;
    @Nullable
    private final Duration repeatLogPeriod;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Object lock;
    @NotNull
    private final ConcurrentHashMap<String, WarningState> lastWarningStates;
    @NotNull
    private final AtomicInteger operationCounter;
    public static final int CLEANUP_INTERVAL = 1000;

    public WarningsTracker(@NotNull Duration staleThreshold, @Nullable Duration repeatLogPeriod, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)staleThreshold, (String)"staleThreshold");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.staleThreshold = staleThreshold;
        this.repeatLogPeriod = repeatLogPeriod;
        this.clock = clock;
        this.lock = new Object();
        if (!(this.staleThreshold.compareTo(Duration.ZERO) > 0)) {
            boolean bl = false;
            String string2 = "staleThreshold must be positive.";
            throw new IllegalArgumentException(string2.toString());
        }
        Duration duration = this.repeatLogPeriod;
        if (duration != null) {
            Duration it = duration;
            boolean bl = false;
            if (!(this.repeatLogPeriod.compareTo(this.staleThreshold) <= 0)) {
                boolean bl2 = false;
                String string3 = "repeatLogPeriod (" + this.repeatLogPeriod + ") cannot be greater than staleThreshold (" + this.staleThreshold + ").";
                throw new IllegalArgumentException(string3.toString());
            }
        }
        this.lastWarningStates = new ConcurrentHashMap();
        this.operationCounter = new AtomicInteger(0);
    }

    public /* synthetic */ WarningsTracker(Duration duration, Duration duration2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            duration2 = null;
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(duration, duration2, clock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final LogAction getLogAction(@NotNull String key, @NotNull String failureReason) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)failureReason, (String)"failureReason");
        Object object = this.lock;
        synchronized (object) {
            WarningState previousState;
            Instant now;
            block6: {
                boolean shouldRepeat;
                block5: {
                    boolean bl = false;
                    this.runCleanupIfNeeded();
                    now = this.clock.instant();
                    WarningState warningState = previousState = this.lastWarningStates.get(key);
                    if (Intrinsics.areEqual((Object)(warningState != null ? warningState.getFailureReason() : null), (Object)failureReason)) break block5;
                    int skippedCount = previousState != null ? previousState.getConsecutiveSeenCount() - 1 : 0;
                    Intrinsics.checkNotNull((Object)now);
                    WarningState newState = new WarningState(failureReason, now, now, 1);
                    ((Map)this.lastWarningStates).put(key, newState);
                    LogAction logAction = new LogAction.LogAsNew(skippedCount);
                    return logAction;
                }
                boolean bl = shouldRepeat = this.repeatLogPeriod != null && Duration.between(previousState.getLastLoggedTime(), now).compareTo(this.repeatLogPeriod) > 0;
                if (!shouldRepeat) break block6;
                int skippedCount = previousState.getConsecutiveSeenCount() - 1;
                Intrinsics.checkNotNull((Object)now);
                WarningState newState = WarningState.copy$default(previousState, null, now, now, 1, 1, null);
                ((Map)this.lastWarningStates).put(key, newState);
                LogAction logAction = new LogAction.LogAsRepeat(skippedCount);
                return logAction;
            }
            Intrinsics.checkNotNull((Object)now);
            WarningState newState = WarningState.copy$default(previousState, null, now, null, previousState.getConsecutiveSeenCount() + 1, 5, null);
            ((Map)this.lastWarningStates).put(key, newState);
            LogAction logAction = LogAction.Skip.INSTANCE;
            return logAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RecoveryAction didRecover(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.runCleanupIfNeeded();
            WarningState previousState = this.lastWarningStates.remove(key);
            RecoveryAction recoveryAction = previousState != null ? (RecoveryAction)new RecoveryAction.Recovered(previousState.getConsecutiveSeenCount() - 1) : (RecoveryAction)RecoveryAction.NoRecovery.INSTANCE;
            return recoveryAction;
        }
    }

    private final void runCleanupIfNeeded() {
        if (this.operationCounter.incrementAndGet() % 1000 == 0) {
            this.cleanupStaleEntries();
        }
    }

    private final void cleanupStaleEntries() {
        Instant now = this.clock.instant();
        this.lastWarningStates.entrySet().removeIf(arg_0 -> WarningsTracker.cleanupStaleEntries$lambda$6(arg_0 -> WarningsTracker.cleanupStaleEntries$lambda$5(now, this, arg_0), arg_0));
    }

    private static final boolean cleanupStaleEntries$lambda$5(Instant $now, WarningsTracker this$0, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return Duration.between(((WarningState)entry.getValue()).getLastSeenTime(), $now).compareTo(this$0.staleThreshold) > 0;
    }

    private static final boolean cleanupStaleEntries$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/adblib/utils/WarningsTracker$Companion;", "", "<init>", "()V", "CLEANUP_INTERVAL", "", "android.sdktools.adblib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/android/adblib/utils/WarningsTracker$LogAction;", "", "<init>", "()V", "Skip", "LogAsNew", "LogAsRepeat", "Lcom/android/adblib/utils/WarningsTracker$LogAction$LogAsNew;", "Lcom/android/adblib/utils/WarningsTracker$LogAction$LogAsRepeat;", "Lcom/android/adblib/utils/WarningsTracker$LogAction$Skip;", "android.sdktools.adblib"})
    public static abstract class LogAction {
        private LogAction() {
        }

        public /* synthetic */ LogAction(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/adblib/utils/WarningsTracker$LogAction$LogAsNew;", "Lcom/android/adblib/utils/WarningsTracker$LogAction;", "skippedCount", "", "<init>", "(I)V", "getSkippedCount", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "android.sdktools.adblib"})
        public static final class LogAsNew
        extends LogAction {
            private final int skippedCount;

            public LogAsNew(int skippedCount) {
                super(null);
                this.skippedCount = skippedCount;
            }

            public final int getSkippedCount() {
                return this.skippedCount;
            }

            public final int component1() {
                return this.skippedCount;
            }

            @NotNull
            public final LogAsNew copy(int skippedCount) {
                return new LogAsNew(skippedCount);
            }

            public static /* synthetic */ LogAsNew copy$default(LogAsNew logAsNew, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = logAsNew.skippedCount;
                }
                return logAsNew.copy(n);
            }

            @NotNull
            public String toString() {
                return "LogAsNew(skippedCount=" + this.skippedCount + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.skippedCount);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LogAsNew)) {
                    return false;
                }
                LogAsNew logAsNew = (LogAsNew)other;
                return this.skippedCount == logAsNew.skippedCount;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/adblib/utils/WarningsTracker$LogAction$LogAsRepeat;", "Lcom/android/adblib/utils/WarningsTracker$LogAction;", "skippedCount", "", "<init>", "(I)V", "getSkippedCount", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "android.sdktools.adblib"})
        public static final class LogAsRepeat
        extends LogAction {
            private final int skippedCount;

            public LogAsRepeat(int skippedCount) {
                super(null);
                this.skippedCount = skippedCount;
            }

            public final int getSkippedCount() {
                return this.skippedCount;
            }

            public final int component1() {
                return this.skippedCount;
            }

            @NotNull
            public final LogAsRepeat copy(int skippedCount) {
                return new LogAsRepeat(skippedCount);
            }

            public static /* synthetic */ LogAsRepeat copy$default(LogAsRepeat logAsRepeat, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = logAsRepeat.skippedCount;
                }
                return logAsRepeat.copy(n);
            }

            @NotNull
            public String toString() {
                return "LogAsRepeat(skippedCount=" + this.skippedCount + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.skippedCount);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LogAsRepeat)) {
                    return false;
                }
                LogAsRepeat logAsRepeat = (LogAsRepeat)other;
                return this.skippedCount == logAsRepeat.skippedCount;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/adblib/utils/WarningsTracker$LogAction$Skip;", "Lcom/android/adblib/utils/WarningsTracker$LogAction;", "<init>", "()V", "android.sdktools.adblib"})
        public static final class Skip
        extends LogAction {
            @NotNull
            public static final Skip INSTANCE = new Skip();

            private Skip() {
                super(null);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/android/adblib/utils/WarningsTracker$RecoveryAction;", "", "<init>", "()V", "NoRecovery", "Recovered", "Lcom/android/adblib/utils/WarningsTracker$RecoveryAction$NoRecovery;", "Lcom/android/adblib/utils/WarningsTracker$RecoveryAction$Recovered;", "android.sdktools.adblib"})
    public static abstract class RecoveryAction {
        private RecoveryAction() {
        }

        public /* synthetic */ RecoveryAction(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/adblib/utils/WarningsTracker$RecoveryAction$NoRecovery;", "Lcom/android/adblib/utils/WarningsTracker$RecoveryAction;", "<init>", "()V", "android.sdktools.adblib"})
        public static final class NoRecovery
        extends RecoveryAction {
            @NotNull
            public static final NoRecovery INSTANCE = new NoRecovery();

            private NoRecovery() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/adblib/utils/WarningsTracker$RecoveryAction$Recovered;", "Lcom/android/adblib/utils/WarningsTracker$RecoveryAction;", "skippedCount", "", "<init>", "(I)V", "getSkippedCount", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "android.sdktools.adblib"})
        public static final class Recovered
        extends RecoveryAction {
            private final int skippedCount;

            public Recovered(int skippedCount) {
                super(null);
                this.skippedCount = skippedCount;
            }

            public final int getSkippedCount() {
                return this.skippedCount;
            }

            public final int component1() {
                return this.skippedCount;
            }

            @NotNull
            public final Recovered copy(int skippedCount) {
                return new Recovered(skippedCount);
            }

            public static /* synthetic */ Recovered copy$default(Recovered recovered, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = recovered.skippedCount;
                }
                return recovered.copy(n);
            }

            @NotNull
            public String toString() {
                return "Recovered(skippedCount=" + this.skippedCount + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.skippedCount);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Recovered)) {
                    return false;
                }
                Recovered recovered = (Recovered)other;
                return this.skippedCount == recovered.skippedCount;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/android/adblib/utils/WarningsTracker$WarningState;", "", "failureReason", "", "lastSeenTime", "Ljava/time/Instant;", "lastLoggedTime", "consecutiveSeenCount", "", "<init>", "(Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;I)V", "getFailureReason", "()Ljava/lang/String;", "getLastSeenTime", "()Ljava/time/Instant;", "getLastLoggedTime", "getConsecutiveSeenCount", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "android.sdktools.adblib"})
    private static final class WarningState {
        @NotNull
        private final String failureReason;
        @NotNull
        private final Instant lastSeenTime;
        @NotNull
        private final Instant lastLoggedTime;
        private final int consecutiveSeenCount;

        public WarningState(@NotNull String failureReason, @NotNull Instant lastSeenTime, @NotNull Instant lastLoggedTime, int consecutiveSeenCount) {
            Intrinsics.checkNotNullParameter((Object)failureReason, (String)"failureReason");
            Intrinsics.checkNotNullParameter((Object)lastSeenTime, (String)"lastSeenTime");
            Intrinsics.checkNotNullParameter((Object)lastLoggedTime, (String)"lastLoggedTime");
            this.failureReason = failureReason;
            this.lastSeenTime = lastSeenTime;
            this.lastLoggedTime = lastLoggedTime;
            this.consecutiveSeenCount = consecutiveSeenCount;
        }

        @NotNull
        public final String getFailureReason() {
            return this.failureReason;
        }

        @NotNull
        public final Instant getLastSeenTime() {
            return this.lastSeenTime;
        }

        @NotNull
        public final Instant getLastLoggedTime() {
            return this.lastLoggedTime;
        }

        public final int getConsecutiveSeenCount() {
            return this.consecutiveSeenCount;
        }

        @NotNull
        public final String component1() {
            return this.failureReason;
        }

        @NotNull
        public final Instant component2() {
            return this.lastSeenTime;
        }

        @NotNull
        public final Instant component3() {
            return this.lastLoggedTime;
        }

        public final int component4() {
            return this.consecutiveSeenCount;
        }

        @NotNull
        public final WarningState copy(@NotNull String failureReason, @NotNull Instant lastSeenTime, @NotNull Instant lastLoggedTime, int consecutiveSeenCount) {
            Intrinsics.checkNotNullParameter((Object)failureReason, (String)"failureReason");
            Intrinsics.checkNotNullParameter((Object)lastSeenTime, (String)"lastSeenTime");
            Intrinsics.checkNotNullParameter((Object)lastLoggedTime, (String)"lastLoggedTime");
            return new WarningState(failureReason, lastSeenTime, lastLoggedTime, consecutiveSeenCount);
        }

        public static /* synthetic */ WarningState copy$default(WarningState warningState, String string2, Instant instant, Instant instant2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = warningState.failureReason;
            }
            if ((n2 & 2) != 0) {
                instant = warningState.lastSeenTime;
            }
            if ((n2 & 4) != 0) {
                instant2 = warningState.lastLoggedTime;
            }
            if ((n2 & 8) != 0) {
                n = warningState.consecutiveSeenCount;
            }
            return warningState.copy(string2, instant, instant2, n);
        }

        @NotNull
        public String toString() {
            return "WarningState(failureReason=" + this.failureReason + ", lastSeenTime=" + this.lastSeenTime + ", lastLoggedTime=" + this.lastLoggedTime + ", consecutiveSeenCount=" + this.consecutiveSeenCount + ")";
        }

        public int hashCode() {
            int result2 = this.failureReason.hashCode();
            result2 = result2 * 31 + this.lastSeenTime.hashCode();
            result2 = result2 * 31 + this.lastLoggedTime.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.consecutiveSeenCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WarningState)) {
                return false;
            }
            WarningState warningState = (WarningState)other;
            if (!Intrinsics.areEqual((Object)this.failureReason, (Object)warningState.failureReason)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastSeenTime, (Object)warningState.lastSeenTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastLoggedTime, (Object)warningState.lastLoggedTime)) {
                return false;
            }
            return this.consecutiveSeenCount == warningState.consecutiveSeenCount;
        }
    }
}

