/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.DeviceConnectionType;
import com.android.adblib.DeviceInfo;
import com.android.adblib.DeviceState;
import com.android.adblib.ListWithErrors;
import com.android.adblib.impl.DeviceListParser;
import com.android.server.adb.protos.DevicesProto;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/adblib/impl/DeviceListProtoParser;", "Lcom/android/adblib/impl/DeviceListParser;", "<init>", "()V", "protoState", "Lcom/android/adblib/DeviceState;", "state", "Lcom/android/server/adb/protos/DevicesProto$ConnectionState;", "parse", "Lcom/android/adblib/ListWithErrors;", "Lcom/android/adblib/DeviceInfo;", "Lcom/android/adblib/DeviceList;", "buffer", "Ljava/nio/ByteBuffer;", "android.sdktools.adblib"})
@SourceDebugExtension(value={"SMAP\nDeviceListParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceListParser.kt\ncom/android/adblib/impl/DeviceListProtoParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n1863#2,2:232\n*S KotlinDebug\n*F\n+ 1 DeviceListParser.kt\ncom/android/adblib/impl/DeviceListProtoParser\n*L\n70#1:232,2\n*E\n"})
public final class DeviceListProtoParser
extends DeviceListParser {
    @NotNull
    public final DeviceState protoState(@NotNull DevicesProto.ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1, 2 -> DeviceState.UNKNOWN;
            case 3 -> DeviceState.CONNECTING;
            case 4 -> DeviceState.AUTHORIZING;
            case 5 -> DeviceState.UNAUTHORIZED;
            case 6 -> DeviceState.NO_PERMISSIONS;
            case 7 -> DeviceState.DETACHED;
            case 8 -> DeviceState.OFFLINE;
            case 9 -> DeviceState.BOOTLOADER;
            case 10 -> DeviceState.ONLINE;
            case 11 -> DeviceState.HOST;
            case 12 -> DeviceState.RECOVERY;
            case 13 -> DeviceState.SIDELOAD;
            case 14 -> DeviceState.RESCUE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public ListWithErrors<DeviceInfo> parse(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ListWithErrors.Builder<DeviceInfo> result2 = new ListWithErrors.Builder<DeviceInfo>();
        DevicesProto.Devices devices2 = DevicesProto.Devices.parseFrom((ByteBuffer)buffer);
        List list2 = devices2.getDeviceList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDeviceList(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string2;
            DevicesProto.Device it = (DevicesProto.Device)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getSerial(), (String)"getSerial(...)");
            DevicesProto.ConnectionState connectionState = it.getState();
            Intrinsics.checkNotNullExpressionValue((Object)connectionState, (String)"getState(...)");
            DeviceState deviceState = this.protoState(connectionState);
            String string3 = it.getProduct();
            String string4 = it.getModel();
            String string5 = it.getDevice();
            String string6 = String.valueOf(it.getTransportId());
            long l = it.getMaxSpeed();
            long l2 = it.getNegotiatedSpeed();
            DevicesProto.ConnectionType connectionType = it.getConnectionType();
            DeviceConnectionType deviceConnectionType = switch (connectionType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[connectionType.ordinal()]) {
                case 1 -> DeviceConnectionType.USB;
                case -1, 2, 3, 4 -> DeviceConnectionType.SOCKET;
                default -> throw new NoWhenBranchMatchedException();
            };
            result2.addEntry(new DeviceInfo(string2, deviceState, string3, string4, string5, string6, deviceConnectionType, l2, l, null, 512, null));
        }
        return result2.build();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DevicesProto.ConnectionState.values().length];
            try {
                nArray[DevicesProto.ConnectionState.UNRECOGNIZED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.ANY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.CONNECTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.AUTHORIZING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.UNAUTHORIZED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.NOPERMISSION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.DETACHED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.OFFLINE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.BOOTLOADER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.DEVICE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.HOST.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.RECOVERY.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.SIDELOAD.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionState.RESCUE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DevicesProto.ConnectionType.values().length];
            try {
                nArray[DevicesProto.ConnectionType.USB.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionType.SOCKET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionType.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DevicesProto.ConnectionType.UNRECOGNIZED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

