/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.AndroidConfigurationExecutor;
import com.android.tools.idea.execution.common.UtilsKt;
import com.android.tools.idea.execution.common.stats.RunStats;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.google.gct.testrecorder.debugger.TestRecorderDebugProcessListener;
import com.google.gct.testrecorder.settings.TestRecorderSettings;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001Bf\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00123\u0010\u000b\u001a/\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00110\f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0016R;\u0010\u000b\u001a/\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lcom/google/gct/testrecorder/run/TestRecorderExecutor;", "Lcom/android/tools/idea/execution/common/AndroidConfigurationExecutor;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "baseExecutor", "specificActivityName", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "isRecordingTest", "", "getApplicationIdAndDevices", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Lkotlin/ParameterName;", "name", "indicator", "Lkotlin/Pair;", "", "Lcom/android/ddmlib/IDevice;", "<init>", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/android/tools/idea/execution/common/AndroidConfigurationExecutor;Ljava/lang/String;Lorg/jetbrains/android/facet/AndroidFacet;ZLkotlin/jvm/functions/Function1;)V", "()Z", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "debug", "Lcom/intellij/execution/ui/RunContentDescriptor;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getConfiguration", "()Lcom/intellij/execution/configurations/RunConfiguration;", "run", "applyChanges", "applyCodeChanges", "test-recorder"})
public final class TestRecorderExecutor
implements AndroidConfigurationExecutor {
    @NotNull
    private final ExecutionEnvironment env;
    @NotNull
    private final AndroidConfigurationExecutor baseExecutor;
    @Nullable
    private final String specificActivityName;
    @NotNull
    private final AndroidFacet facet;
    @VisibleForTesting
    private final boolean isRecordingTest;
    @NotNull
    private final Function1<ProgressIndicator, Pair<String, List<IDevice>>> getApplicationIdAndDevices;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final RunConfiguration configuration;

    public TestRecorderExecutor(@NotNull ExecutionEnvironment env, @NotNull AndroidConfigurationExecutor baseExecutor, @Nullable String specificActivityName, @NotNull AndroidFacet facet, boolean isRecordingTest, @NotNull Function1<? super ProgressIndicator, ? extends Pair<String, ? extends List<? extends IDevice>>> getApplicationIdAndDevices) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)baseExecutor, (String)"baseExecutor");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter(getApplicationIdAndDevices, (String)"getApplicationIdAndDevices");
        this.env = env;
        this.baseExecutor = baseExecutor;
        this.specificActivityName = specificActivityName;
        this.facet = facet;
        this.isRecordingTest = isRecordingTest;
        this.getApplicationIdAndDevices = getApplicationIdAndDevices;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        RunProfile runProfile = this.env.getRunProfile();
        RunConfiguration runConfiguration = runProfile instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
        if (runConfiguration == null) {
            throw new RuntimeException("Test recorder should only be run for RunConfiguration");
        }
        this.configuration = runConfiguration;
    }

    public final boolean isRecordingTest() {
        return this.isRecordingTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RunContentDescriptor debug(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.LOG.info("Start test recording session");
        Pair pair = (Pair)this.getApplicationIdAndDevices.invoke((Object)indicator);
        String packageName = (String)pair.component1();
        List devices = (List)pair.component2();
        if (devices.size() != 1) {
            throw new ExecutionException("Test recording can run only on one device");
        }
        IDevice device = (IDevice)CollectionsKt.single((List)devices);
        if (TestRecorderSettings.getInstance().CLEAN_BEFORE_START) {
            Project project = this.env.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RunStats runStats = RunStats.from((ExecutionEnvironment)this.env);
            Intrinsics.checkNotNullExpressionValue((Object)runStats, (String)"from(...)");
            UtilsKt.clearAppStorage((Project)project, (IDevice)device, (String)packageName, (RunStats)runStats);
        }
        RunProfile runProfile = this.env.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.android.tools.idea.run.AndroidRunConfiguration");
        String string = ((AndroidRunConfiguration)runProfile).getAndroidDebuggerContext().getDebuggerType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDebuggerType(...)");
        String startingDebuggerType = string;
        if (Intrinsics.areEqual((Object)startingDebuggerType, (Object)"Auto")) {
            RunProfile runProfile2 = this.env.getRunProfile();
            Intrinsics.checkNotNull((Object)runProfile2, (String)"null cannot be cast to non-null type com.android.tools.idea.run.AndroidRunConfiguration");
            ((AndroidRunConfiguration)runProfile2).getAndroidDebuggerContext().setDebuggerType("Java");
        }
        DebuggerManagerListener session2 = new DebuggerManagerListener(this, device, packageName){
            final /* synthetic */ TestRecorderExecutor this$0;
            final /* synthetic */ IDevice $device;
            final /* synthetic */ String $packageName;
            {
                this.this$0 = $receiver;
                this.$device = $device;
                this.$packageName = $packageName;
            }

            public void sessionCreated(DebuggerSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                session2.getProcess().addDebugProcessListener((DebugProcessListener)new TestRecorderDebugProcessListener(TestRecorderExecutor.access$getFacet$p(this.this$0), TestRecorderExecutor.access$getEnv$p(this.this$0), this.$device, this.$packageName, this.this$0.isRecordingTest(), TestRecorderExecutor.access$getSpecificActivityName$p(this.this$0), session2));
            }
        };
        MessageBusConnection busConnection = this.env.getProject().getMessageBus().connect();
        Topic topic = DebuggerManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        busConnection.subscribe(topic, (Object)session2);
        try {
            RunContentDescriptor runContentDescriptor = this.baseExecutor.debug(indicator);
            return runContentDescriptor;
        }
        finally {
            busConnection.disconnect();
            RunProfile runProfile3 = this.env.getRunProfile();
            Intrinsics.checkNotNull((Object)runProfile3, (String)"null cannot be cast to non-null type com.android.tools.idea.run.AndroidRunConfiguration");
            ((AndroidRunConfiguration)runProfile3).getAndroidDebuggerContext().setDebuggerType(startingDebuggerType);
        }
    }

    @NotNull
    public RunConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public RunContentDescriptor run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        throw new RuntimeException("TestRecorderAndroidRunConfigurationExecutor should always run in debug mode");
    }

    @NotNull
    public RunContentDescriptor applyChanges(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        throw new RuntimeException("TestRecorderAndroidRunConfigurationExecutor should always run in debug mode");
    }

    @NotNull
    public RunContentDescriptor applyCodeChanges(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        throw new RuntimeException("TestRecorderAndroidRunConfigurationExecutor should always run in debug mode");
    }

    public static final /* synthetic */ AndroidFacet access$getFacet$p(TestRecorderExecutor $this) {
        return $this.facet;
    }

    public static final /* synthetic */ ExecutionEnvironment access$getEnv$p(TestRecorderExecutor $this) {
        return $this.env;
    }

    public static final /* synthetic */ String access$getSpecificActivityName$p(TestRecorderExecutor $this) {
        return $this.specificActivityName;
    }
}

