/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.scheduling;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ThrowableComputable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001aF\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00012\u001a\u0010\u0007\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004\u0012\u0004\u0012\u00020\t0\bH\u0000\u001aJ\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00012\u001a\u0010\u0007\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004\u0012\u0004\u0012\u00020\t0\bH\u0080\b\u00f8\u0001\u0000\u001aD\u0010\n\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u0004\u0018\u00010\u000b\"\u0004\b\u0000\u0010\u00052\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a/\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\b\u0004\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"calculateWorkerQuota", "", "estimatedWorksetSize", "peekWorkset", "Lcom/google/common/collect/ImmutableList;", "I", "quota", "forkAsPending", "Lkotlin/Function1;", "", "splitWorkset", "Lkotlin/Pair;", "workset", "prioritize", "R", "shouldPrioritize", "", "block", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.c"})
public final class UtilKt {
    public static final int calculateWorkerQuota(int estimatedWorksetSize) {
        return Math.max(31, estimatedWorksetSize / ((Runtime.getRuntime().availableProcessors() + 1) * 16));
    }

    @NotNull
    public static final <I> ImmutableList<? extends I> peekWorkset(@NotNull ImmutableList<? extends I> $this$peekWorkset, int quota, @NotNull Function1<? super ImmutableList<? extends I>, Unit> forkAsPending) {
        Intrinsics.checkNotNullParameter($this$peekWorkset, (String)"<this>");
        Intrinsics.checkNotNullParameter(forkAsPending, (String)"forkAsPending");
        int size = $this$peekWorkset.size();
        if (size <= quota) {
            return $this$peekWorkset;
        }
        int split = size >= quota + 16 ? quota : size - 16;
        ImmutableList immutableList = $this$peekWorkset.subList(split, size);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"subList(...)");
        forkAsPending.invoke((Object)immutableList);
        ImmutableList immutableList2 = $this$peekWorkset.subList(0, split);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList2, (String)"subList(...)");
        return immutableList2;
    }

    @NotNull
    public static final <I> ImmutableList<? extends I> splitWorkset(@NotNull ImmutableList<? extends I> $this$splitWorkset, int quota, @NotNull Function1<? super ImmutableList<? extends I>, Unit> forkAsPending) {
        Intrinsics.checkNotNullParameter($this$splitWorkset, (String)"<this>");
        Intrinsics.checkNotNullParameter(forkAsPending, (String)"forkAsPending");
        boolean $i$f$splitWorkset = false;
        ImmutableList workset2 = $this$splitWorkset;
        while (UtilKt.splitWorkset(workset2, quota) != null) {
            Pair pair;
            ImmutableList left = (ImmutableList)pair.component1();
            ImmutableList right = (ImmutableList)pair.component2();
            forkAsPending.invoke((Object)right);
            workset2 = left;
        }
        return workset2;
    }

    private static final <I> Pair<ImmutableList<? extends I>, ImmutableList<? extends I>> splitWorkset(ImmutableList<? extends I> workset2, int quota) {
        int size = workset2.size();
        if (size <= quota) {
            return null;
        }
        int split = size > 31 ? size / 2 : 0;
        return TuplesKt.to((Object)workset2.subList(0, split), (Object)workset2.subList(split, size));
    }

    public static final <R> R prioritize(boolean shouldPrioritize, @NotNull Function0<? extends R> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$prioritize = false;
        return (R)(shouldPrioritize ? ProgressManager.getInstance().computePrioritized(new ThrowableComputable(block){
            final /* synthetic */ Function0<R> $block;
            {
                this.$block = $block;
            }

            public final R compute() {
                return (R)this.$block.invoke();
            }
        }) : block.invoke());
    }
}

