/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.logging;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.PathKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u0017J\u001c\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aJ\u001c\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010!\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0001\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/logging/OCBuildingLoggingService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "curPath", "Ljava/nio/file/Path;", "lock", "Lorg/jetbrains/annotations/NotNull;", "projectDirName", "", "getProjectDirName", "()Ljava/lang/String;", "projectDirName$delegate", "Lkotlin/Lazy;", "existingNames", "", "startNewBuilding", "", "write", "fileName", "block", "Lkotlin/Function1;", "Ljava/io/BufferedWriter;", "lines", "Lkotlin/sequences/Sequence;", "append", "lazyLine", "Lkotlin/Function0;", "isOff", "", "getTargetFile", "getPath", "Companion", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nOCBuildingLoggingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCBuildingLoggingService.kt\ncom/jetbrains/cidr/lang/symbols/symtable/logging/OCBuildingLoggingService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n381#2,7:102\n1#3:109\n*S KotlinDebug\n*F\n+ 1 OCBuildingLoggingService.kt\ncom/jetbrains/cidr/lang/symbols/symtable/logging/OCBuildingLoggingService\n*L\n78#1:102,7\n*E\n"})
public final class OCBuildingLoggingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Path curPath;
    @NotNull
    private final Object lock;
    @NotNull
    private final Lazy projectDirName$delegate;
    @NotNull
    private final Map<String, String> existingNames;
    private static final DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS");

    public OCBuildingLoggingService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Object object = ObjectUtils.sentinel((String)"OCBuildingLoggingService");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sentinel(...)");
        this.lock = object;
        this.projectDirName$delegate = LazyKt.lazy(() -> OCBuildingLoggingService.projectDirName_delegate$lambda$1(this));
        this.existingNames = new LinkedHashMap();
    }

    private final String getProjectDirName() {
        Lazy lazy = this.projectDirName$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startNewBuilding() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.curPath = null;
            this.existingNames.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull String fileName, @NotNull Function1<? super BufferedWriter, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.isOff()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Path file = this.getTargetFile(fileName);
            Object object2 = file;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object3 = Charsets.UTF_8;
            int n = 8192;
            object2 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object2, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object3), n);
            object3 = null;
            try {
                Object object4 = block.invoke(object2);
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void write(@NotNull String fileName, @NotNull Sequence<String> lines) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this.write(fileName, (Function1<? super BufferedWriter, Unit>)((Function1)arg_0 -> OCBuildingLoggingService.write$lambda$4(lines, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void append(@NotNull String fileName, @NotNull Function0<String> lazyLine) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(lazyLine, (String)"lazyLine");
        if (this.isOff()) {
            return;
        }
        String line = (String)lazyLine.invoke();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Path file = this.getTargetFile(fileName);
            Object object2 = file;
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Object object3 = Charsets.UTF_8;
            int n = 8192;
            object2 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object2, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object3), n);
            object3 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object2;
                boolean bl2 = false;
                writer.write(line);
                writer.newLine();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean isOff() {
        return !Registry.Companion.is("cidr.enable.extensive.building.symbols.logging");
    }

    private final Path getTargetFile(String fileName) {
        String string;
        Path curPath = this.getPath();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(curPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathKt.createDirectories((Path)curPath);
        }
        Map<String, String> $this$getOrPut$iv = this.existingNames;
        boolean $i$f$getOrPut = false;
        String value$iv = $this$getOrPut$iv.get(fileName);
        if (value$iv == null) {
            StringBuilder stringBuilder;
            boolean bl = false;
            StringBuilder $this$getTargetFile_u24lambda_u248_u24lambda_u247 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$getTargetFile_u24lambda_u248_u24lambda_u247.append(this.existingNames.size());
            $this$getTargetFile_u24lambda_u248_u24lambda_u247.append("_");
            $this$getTargetFile_u24lambda_u248_u24lambda_u247.append(fileName);
            if (!StringsKt.contains$default((CharSequence)fileName, (CharSequence)".", (boolean)false, (int)2, null)) {
                $this$getTargetFile_u24lambda_u248_u24lambda_u247.append(".txt");
            }
            String answer$iv = stringBuilder.toString();
            $this$getOrPut$iv.put(fileName, answer$iv);
            string = answer$iv;
        } else {
            string = value$iv;
        }
        String effectiveFileName = string;
        Path path = curPath.resolve(effectiveFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path getPath() {
        Path path = this.curPath;
        if (path == null) {
            Path path2;
            Path it = path2 = PathManager.getLogDir().resolve("cidrSymbolBuilding").resolve(this.getProjectDirName()).resolve("session_" + LocalDateTime.now().format(format));
            boolean bl = false;
            this.curPath = it;
            Path path3 = path2;
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"also(...)");
        }
        return path;
    }

    private static final String projectDirName_delegate$lambda$1$lambda$0(OCBuildingLoggingService this$0) {
        return this$0.project.getName() + "-" + this$0.project.getLocationHash();
    }

    private static final String projectDirName_delegate$lambda$1(OCBuildingLoggingService this$0) {
        return (String)ActionsKt.runReadAction(() -> OCBuildingLoggingService.projectDirName_delegate$lambda$1$lambda$0(this$0));
    }

    private static final Unit write$lambda$4(Sequence $lines, BufferedWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        int count = 0;
        for (String line : $lines) {
            writer.write(line);
            writer.newLine();
            ++count;
        }
        writer.write("lines count = " + count);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final OCBuildingLoggingService getService(@NotNull Project project) {
        return Companion.getService(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/logging/OCBuildingLoggingService$Companion;", "", "<init>", "()V", "getService", "Lcom/jetbrains/cidr/lang/symbols/symtable/logging/OCBuildingLoggingService;", "project", "Lcom/intellij/openapi/project/Project;", "format", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "Ljava/time/format/DateTimeFormatter;", "intellij.c"})
    @SourceDebugExtension(value={"SMAP\nOCBuildingLoggingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCBuildingLoggingService.kt\ncom/jetbrains/cidr/lang/symbols/symtable/logging/OCBuildingLoggingService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,101:1\n31#2,2:102\n*S KotlinDebug\n*F\n+ 1 OCBuildingLoggingService.kt\ncom/jetbrains/cidr/lang/symbols/symtable/logging/OCBuildingLoggingService$Companion\n*L\n97#1:102,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OCBuildingLoggingService getService(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<OCBuildingLoggingService> serviceClass$iv = OCBuildingLoggingService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (OCBuildingLoggingService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

