/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.modulemap.serialization.AppCodeModuleCacheBuildingSession;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCClearingSymbolsActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCFileCollectingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCHeaderMapLoadingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCIndexingStatisticsCollector;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapDeserializationActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCModuleMapSerializationActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolLoadingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolSavingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingMode;
import com.jetbrains.cidr.lang.symbols.symtable.building.SingleTaskExecutor;
import com.jetbrains.cidr.lang.symbols.symtable.logging.OCBuildingLoggingService;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import io.opentelemetry.api.trace.SpanBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class OCSymbolTablesBuildingActivity
implements Disposable.Default {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SingleTaskExecutor myExecutor;
    private volatile boolean myIsInitialized;

    public static OCSymbolTablesBuildingActivity getInstance(@NotNull Project project) {
        if (project == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(0);
        }
        return (OCSymbolTablesBuildingActivity)project.getService(OCSymbolTablesBuildingActivity.class);
    }

    public OCSymbolTablesBuildingActivity(@NotNull Project project) {
        if (project == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(1);
        }
        this.myIsInitialized = false;
        this.myProject = project;
        this.myExecutor = new SingleTaskExecutor(project);
    }

    public void setInitialized() {
        this.myIsInitialized = true;
    }

    public void rebuildSymbols() {
        this.rebuildSymbols(OCSymbolTablesBuildingMode.FAST);
    }

    public void rebuildSymbols(@NotNull OCSymbolTablesBuildingMode mode) {
        if (mode == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed() || AppCodeModuleCacheBuildingSession.INSTANCE.isModuleMapBuildingSession() || !this.myIsInitialized) {
            return;
        }
        this.myExecutor.schedule((Function1<? super OCBuildingActivityProgressIndicator, Unit>)((Function1)indicator -> {
            IJTracer tracer = TelemetryManager.getInstance().getTracer(new Scope("symbols", null, true));
            TraceKt.use((SpanBuilder)tracer.spanBuilder("OCBuildSymbols"), __ -> {
                this.buildSymbolsInternal((OCBuildingActivityProgressIndicator)((Object)indicator), mode);
                return null;
            });
            return Unit.INSTANCE;
        }));
    }

    private void buildSymbolsInternal(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCSymbolTablesBuildingMode mode) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(3);
        }
        if (mode == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(4);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            AllowedModules.Companion.setRebuildRequired(false);
            return;
        }
        OCBuildingLoggingService.getService(this.myProject).startNewBuilding();
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            OCLog.LOG.error("Symbols building must not be initiated from write action, otherwise deadlock will occur");
            return;
        }
        long startTime = System.nanoTime();
        OCInitialBuildingInfo userInfo = new OCInitialBuildingInfo(this.myProject, mode);
        userInfo.setLocationHash(this.myProject.getLocationHash());
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "processAdditionalActivitiesBeforeClearingSymbols", (Object)"");){
            OCInitialBuildingActivity.processAdditionalActivities(indicator, userInfo, OCInitialBuildingActivity.Order.BeforeClearing);
        }
        OCClearingSymbolsActivity.build(indicator, userInfo);
        OCHeaderMapLoadingActivity.build(indicator, userInfo);
        OCModuleMapDeserializationActivity.build(indicator, userInfo);
        OCFileCollectingActivity.build(indicator, userInfo);
        ignored = new CidrEventSpan("symbols", "processAdditionalActivitiesBeforeClearingSymbols", (Object)"");
        try {
            OCInitialBuildingActivity.processAdditionalActivities(indicator, userInfo, OCInitialBuildingActivity.Order.AfterFileCollecting);
        }
        finally {
            ignored.close();
        }
        OCSymbolLoadingActivity.build(indicator, userInfo);
        OCModuleMapBuildingActivity.build(indicator, userInfo);
        OCModuleMapSerializationActivity.build(indicator, userInfo);
        Collection<VirtualFile> allFiles = Objects.requireNonNull(userInfo.getAllFiles());
        @NonNls String allFilesDescription = allFiles.size() + " project files";
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "processAdditionalActivitiesBeforeSymbolBuilding", (Object)allFilesDescription);){
            OCInitialBuildingActivity.processAdditionalActivities(indicator, userInfo, OCInitialBuildingActivity.Order.BeforeSymbols);
        }
        OCSymbolBuildingActivity.build(indicator, userInfo);
        ignored = new CidrEventSpan("symbols", "processAdditionalActivitiesAfterSymbolBuilding", (Object)allFilesDescription);
        try {
            OCInitialBuildingActivity.processAdditionalActivities(indicator, userInfo, OCInitialBuildingActivity.Order.AfterSymbols);
        }
        finally {
            ignored.close();
        }
        Pair<Integer, Integer> fileStats = OCSymbolSavingActivity.build(indicator, userInfo);
        long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        OCIndexingStatisticsCollector.logSymbolBuilt(mode, durationMs, (Integer)fileStats.first, (Integer)fileStats.second);
    }

    public boolean isBuilding() {
        return this.myExecutor.isBuilding();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/building/OCSymbolTablesBuildingActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "rebuildSymbols";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildSymbolsInternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

