/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.MathUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCActivityLog;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService;", "", "<init>", "()V", "nameCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "executor", "Ljava/util/concurrent/ForkJoinPool;", "getExecutor", "()Ljava/util/concurrent/ForkJoinPool;", "getThreadCount", "", "userValue", "isBuildingThread", "", "assertParsingAndSymbolBuildingAllowed", "", "project", "Lcom/intellij/openapi/project/Project;", "OCBuildingThread", "Companion", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nOCBuildingActivityExecutionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCBuildingActivityExecutionService.kt\ncom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class OCBuildingActivityExecutionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicInteger nameCounter = new AtomicInteger();
    @NotNull
    private final ForkJoinPool executor = new ForkJoinPool(this.getThreadCount(), arg_0 -> OCBuildingActivityExecutionService.executor$lambda$0(this, arg_0), null, false);

    @NotNull
    public final ForkJoinPool getExecutor() {
        return this.executor;
    }

    public final int getThreadCount(int userValue) {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        Integer n = userValue;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        int userCpuCount = n2 != null ? n2 : userValue + cpuCount;
        return MathUtil.clamp((int)userCpuCount, (int)1, (int)cpuCount);
    }

    public final int getThreadCount() {
        RegistryValue registryValue = Registry.Companion.get("cidr.indexer.thread.count");
        int userValue = ApplicationManager.getApplication().isHeadlessEnvironment() && !registryValue.isChangedFromDefault() ? 0 : registryValue.asInteger();
        return this.getThreadCount(userValue);
    }

    public final boolean isBuildingThread() {
        return Thread.currentThread() instanceof OCBuildingThread;
    }

    public final void assertParsingAndSymbolBuildingAllowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProgressManager.checkCanceled();
        if (this.isBuildingThread()) {
            return;
        }
        if (FileSymbolTablesCache.getInstance(project).areSymbolsLoaded()) {
            return;
        }
        String string = OCActivityLog.getEntries(project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEntries(...)");
        String logEntries = string;
        Object message = StringsKt.trimIndent((String)("\n      Symbol building is not allowed: " + System.currentTimeMillis() + " . \n      Loaded: false\n      Dumb:   " + DumbService.Companion.isDumb(project) + "\n      Previous activities: \n      " + logEntries + "\n    "));
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal()) {
            message = (String)message + "\nThis error happens if building symbols is provoked outside of centralized symbol building activity before it has finished for the first time, or \nif this activity did not start at all (see OCSymbolTablesBuildingActivity#rebuildSymbols, FileSymbolTablesCache#shouldBuildTables).\n\nIn order to fix this exception, you need to make sure that the client code does check `FileSymbolTablesCache.areSymbolsLoaded()`.\nPreviously, this was not necessary because it was guaranteed that we finish symbol loading in smart mode.\nBut after replacing components with services, it is not guaranteed any more. ";
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            message = (String)message + "\n\nIf you want to use symbols in your test, make sure it has an implementation of `CidrTestCase#shouldBuildSymbolTables` and it returns at least `ONLY_USED`.";
        }
        OCLog.LOG.error((String)message);
        throw new ProcessCanceledException(new Throwable((String)message));
    }

    private static final ForkJoinWorkerThread executor$lambda$0(OCBuildingActivityExecutionService this$0, ForkJoinPool it) {
        Intrinsics.checkNotNull((Object)it);
        return new OCBuildingThread(it, this$0.nameCounter.getAndIncrement());
    }

    @NotNull
    public static final OCBuildingActivityExecutionService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService$Companion;", "", "<init>", "()V", "instance", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService;", "getInstance$annotations", "getInstance", "()Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService;", "executor", "Ljava/util/concurrent/ForkJoinPool;", "getExecutor", "()Ljava/util/concurrent/ForkJoinPool;", "intellij.c"})
    @SourceDebugExtension(value={"SMAP\nOCBuildingActivityExecutionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCBuildingActivityExecutionService.kt\ncom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,94:1\n40#2,3:95\n*S KotlinDebug\n*F\n+ 1 OCBuildingActivityExecutionService.kt\ncom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService$Companion\n*L\n91#1:95,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OCBuildingActivityExecutionService getInstance() {
            boolean $i$f$service = false;
            Class<OCBuildingActivityExecutionService> serviceClass$iv = OCBuildingActivityExecutionService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (OCBuildingActivityExecutionService)object;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final ForkJoinPool getExecutor() {
            return this.getInstance().getExecutor();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityExecutionService$OCBuildingThread;", "Ljava/util/concurrent/ForkJoinWorkerThread;", "pool", "Ljava/util/concurrent/ForkJoinPool;", "index", "", "<init>", "(Ljava/util/concurrent/ForkJoinPool;I)V", "intellij.c"})
    private static final class OCBuildingThread
    extends ForkJoinWorkerThread {
        public OCBuildingThread(@NotNull ForkJoinPool pool, int index) {
            Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
            super(pool);
            this.setName("Cidr Symbol Building Thread (" + index + ")");
        }
    }
}

