/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithParentAndSubstitution;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import icons.CidrLangIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructSymbol
extends OCNamespaceSymbol
implements OCTemplateSymbol,
OCSymbolWithParentAndSubstitution {
    private static final Key<CachedValue<Map<OCStructSymbol, Boolean>>> TRIVIAL_DTOR_CACHE = Key.create((String)"TRIVIAL_DTOR_CACHE_IN_FILE");
    private OCSymbolKind mySymbolKind;
    @NotNull
    private List<Pair<OCType, OCVisibility>> myBaseCppClasses;
    @NotNull
    private List<OCTypeParameterSymbol> myTemplateParameters;
    @Nullable
    private List<OCTypeArgument> myTemplateSpecialization;
    @NotNull
    private OCTypeSubstitution mySubstitution;
    @Nullable
    private ComplexTextRange myScope;
    @Nullable
    private List<OCType> myBefriendedTypes;
    private int myPropertiesAndAttributes;
    private boolean myHasClassKeyword;

    public OCStructSymbol() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCStructSymbol(@Nullable VirtualFile file, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @NotNull OCSymbolKind kind, @NotNull List<Pair<OCType, OCVisibility>> baseClasses, @NotNull List<OCTypeParameterSymbol> templateParameters, @Nullable List<OCTypeArgument> templateSpecialization, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> members, @Nullable ComplexTextRange scope, @Nullable OCVisibility visibility, int classProperties, int classAttributes, boolean bl) {
        void hasClassKeyword;
        if (name == null) {
            OCStructSymbol.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            OCStructSymbol.$$$reportNull$$$0(1);
        }
        if (kind == null) {
            OCStructSymbol.$$$reportNull$$$0(2);
        }
        if (baseClasses == null) {
            OCStructSymbol.$$$reportNull$$$0(3);
        }
        if (templateParameters == null) {
            OCStructSymbol.$$$reportNull$$$0(4);
        }
        super(file, offset, parent, name, attributes, membersList, members, null, false, visibility);
        this.mySubstitution = OCTypeSubstitution.ID;
        assert (kind == OCSymbolKind.STRUCT || kind == OCSymbolKind.UNION || kind == OCSymbolKind.ENUM);
        this.mySymbolKind = kind;
        this.myBaseCppClasses = baseClasses;
        this.myTemplateParameters = templateParameters;
        this.myTemplateSpecialization = templateSpecialization;
        this.myScope = scope;
        this.myPropertiesAndAttributes = classProperties | classAttributes;
        this.myHasClassKeyword = hasClassKeyword;
    }

    protected OCStructSymbol(@NotNull OCStructSymbol origin, @NotNull OCTypeSubstitution substitution, @Nullable OCSymbolWithQualifiedName parent) {
        if (origin == null) {
            OCStructSymbol.$$$reportNull$$$0(5);
        }
        if (substitution == null) {
            OCStructSymbol.$$$reportNull$$$0(6);
        }
        super(origin.myFile, origin.myComplexOffset, parent, origin.getQualifiedName(), origin.getAttributes(), origin.getMembersList(), origin.getMembers(), null, false, origin.myVisibility);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.mySymbolKind = origin.getKind();
        this.myBaseCppClasses = origin.myBaseCppClasses;
        this.myTemplateParameters = origin.myTemplateParameters;
        this.myTemplateSpecialization = origin.myTemplateSpecialization;
        this.mySubstitution = substitution;
        this.myScope = origin.getScope();
        this.myBefriendedTypes = origin.myBefriendedTypes;
        this.myPropertiesAndAttributes = origin.myPropertiesAndAttributes;
    }

    @Override
    @NotNull
    public OCStructSymbol cloneWithSubstitution(@NotNull OCTypeSubstitution substitution, @Nullable OCSymbolWithQualifiedName parent) {
        if (substitution == null) {
            OCStructSymbol.$$$reportNull$$$0(7);
        }
        return new OCStructSymbol(this, substitution, parent);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCStructSymbol.$$$reportNull$$$0(8);
        }
        if (first == null) {
            OCStructSymbol.$$$reportNull$$$0(9);
        }
        if (second == null) {
            OCStructSymbol.$$$reportNull$$$0(10);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCStructSymbol f = (OCStructSymbol)first;
        OCStructSymbol s = (OCStructSymbol)second;
        if (!c.equalLists(f.myBefriendedTypes, s.myBefriendedTypes)) {
            return false;
        }
        if (f.myPropertiesAndAttributes != s.myPropertiesAndAttributes) {
            return false;
        }
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!Comparing.equal((Object)((Object)f.mySymbolKind), (Object)((Object)s.mySymbolKind))) {
            return false;
        }
        if (!c.equalLists(f.myBaseCppClasses, s.myBaseCppClasses)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        if (!c.equalLists(f.myTemplateParameters, s.myTemplateParameters)) {
            return false;
        }
        return c.equalLists(f.myTemplateSpecialization, s.myTemplateSpecialization);
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            parameter.updateOffset(start, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        this.myBaseCppClasses = ContainerUtil.trimToSize(this.myBaseCppClasses);
        this.myTemplateParameters = ContainerUtil.trimToSize(this.myTemplateParameters);
        this.myTemplateSpecialization = ContainerUtil.trimToSize(this.myTemplateSpecialization);
        for (OCTypeParameterSymbol parameter : this.myTemplateParameters) {
            parameter.compact();
        }
        this.myBefriendedTypes = ContainerUtil.trimToSize(this.myBefriendedTypes);
    }

    @Override
    public boolean isFriend() {
        return this.hasAttribute(OCSymbolAttribute.FRIEND);
    }

    public boolean isFinal() {
        return this.hasAttribute(OCSymbolAttribute.FINAL);
    }

    public boolean isEnumClass() {
        return this.hasProperty(Property.IS_ENUM_CLASS);
    }

    public boolean isClass() {
        return this.getKind() == OCSymbolKind.STRUCT && this.myHasClassKeyword;
    }

    public boolean isStruct() {
        return this.getKind() == OCSymbolKind.STRUCT && !this.myHasClassKeyword;
    }

    @Override
    public boolean isQualifiedContainer() {
        return this.hasProperty(Property.IS_QUALIFIED_CONTAINER);
    }

    public boolean isEnum() {
        return this.getKind() == OCSymbolKind.ENUM;
    }

    @Override
    public boolean isTemplateSymbol() {
        return !this.myTemplateParameters.isEmpty() || this.myTemplateSpecialization != null;
    }

    public boolean isInnerClass() {
        for (OCSymbolWithQualifiedName parent = this.myParent; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof OCStructSymbol)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(@NotNull OCSymbolAttribute attr) {
        if (attr == null) {
            OCStructSymbol.$$$reportNull$$$0(11);
        }
        return (this.myPropertiesAndAttributes & attr.getMask()) != 0;
    }

    public boolean hasProperty(@NotNull Property prop) {
        if (prop == null) {
            OCStructSymbol.$$$reportNull$$$0(12);
        }
        return (this.myPropertiesAndAttributes & prop.getMask()) != 0;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        List<OCTypeParameterSymbol> list = this.myTemplateParameters;
        if (list == null) {
            OCStructSymbol.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return this.myTemplateSpecialization;
    }

    @Nullable
    public List<OCType> getBefriendedTypes() {
        return this.myBefriendedTypes;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCStructSymbol.$$$reportNull$$$0(14);
        }
        return oCTypeSubstitution;
    }

    @Override
    public boolean isVariadicTemplate() {
        return OCTemplateSymbolImpl.isVariadicTemplate(this);
    }

    @Override
    @Contract(pure=true)
    public boolean isSpecialization() {
        return this.getTemplateSpecialization() != null;
    }

    @Override
    public boolean isExplicitInstantiation() {
        return this.isTemplateSymbol() && this.getTemplateParameters().isEmpty();
    }

    @Override
    public int getRequiredTemplateArgumentsCnt() {
        return OCTemplateSymbolImpl.getRequiredTemplateArgumentsCnt(this);
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }

    @Override
    public boolean isPredeclaration() {
        return this.getMembers() == null;
    }

    @Override
    public boolean isDefinition() {
        return !this.isPredeclaration();
    }

    public void addBefriendedType(@NotNull OCType type) {
        if (type == null) {
            OCStructSymbol.$$$reportNull$$$0(15);
        }
        if (this.myBefriendedTypes == null) {
            this.myBefriendedTypes = new ArrayList<OCType>(1);
        }
        this.myBefriendedTypes.add(type);
    }

    public String getNiceAttributes() {
        ArrayList<String> words = new ArrayList<String>();
        for (OCSymbolAttribute oCSymbolAttribute : OCSymbolAttribute.values()) {
            if (!this.hasAttribute(oCSymbolAttribute)) continue;
            words.add(StringUtil.toLowerCase((String)oCSymbolAttribute.name()));
        }
        for (Enum enum_ : Property.values()) {
            if (!this.hasProperty((Property)enum_)) continue;
            words.add(enum_.name().substring(3));
        }
        return "\u300a" + StringUtil.join(words, (String)" ") + "\u300b";
    }

    @Override
    public String toString() {
        return this.getKind() + this.getNiceAttributes() + "[" + this.getName() + "]@" + this.getOffset();
    }

    @Override
    @NotNull
    public String getKindUppercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(16);
        }
        if (this.getKind() != OCSymbolKind.STRUCT || !context.isCpp()) {
            String string = super.getKindUppercase(context);
            if (string == null) {
                OCStructSymbol.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = this.myHasClassKeyword ? OCBundle.message("symbol.kind.name.uppercase.class", new Object[0]) : OCBundle.message("symbol.kind.name.uppercase.struct", new Object[0]);
        if (string == null) {
            OCStructSymbol.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    @NotNull
    public String getKindLowercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(19);
        }
        if (this.getKind() != OCSymbolKind.STRUCT || !context.isCpp()) {
            String string = super.getKindLowercase(context);
            if (string == null) {
                OCStructSymbol.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = this.myHasClassKeyword ? OCBundle.message("symbol.kind.name.lowercase.class", new Object[0]) : OCBundle.message("symbol.kind.name.lowercase.struct", new Object[0]);
        if (string == null) {
            OCStructSymbol.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    public boolean processMembers(@Nullable String memberName, @NotNull Processor<? super OCSymbol> processor2) {
        if (processor2 == null) {
            OCStructSymbol.$$$reportNull$$$0(22);
        }
        Processor inner = this.mySubstitution != OCTypeSubstitution.ID ? symbol -> processor2.process((Object)this.mySubstitution.substitute(symbol, this, false)) : processor2;
        return super.processMembers(memberName, (Processor<? super OCSymbol>)inner);
    }

    public boolean processFields(@NotNull Processor<? super OCDeclaratorSymbol> processor2) {
        if (processor2 == null) {
            OCStructSymbol.$$$reportNull$$$0(23);
        }
        return this.processMembers((String)null, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCDeclaratorSymbol.class));
    }

    public boolean processFunctions(@Nullable String name, @NotNull Processor<? super OCFunctionSymbol> processor2) {
        if (processor2 == null) {
            OCStructSymbol.$$$reportNull$$$0(24);
        }
        return this.processMembers(name, new OCCommonProcessors.TypeFilteredProcessor(processor2, OCFunctionSymbol.class));
    }

    @Nullable
    public OCDeclaratorSymbol findField(String name) {
        MostlySingularMultiMap<String, OCSymbol> members = this.getMembers();
        if (members == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(@NotNull OCSymbol symbol) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                return symbol.getDelegate() instanceof OCDeclaratorSymbol;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol$1", "accept"));
            }
        };
        members.processForKey((Object)name, (Processor)finder);
        OCDeclaratorSymbol result = (OCDeclaratorSymbol)finder.getFoundValue();
        return result != null ? (OCDeclaratorSymbol)result.getDelegate() : null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = this.mySymbolKind;
        if (oCSymbolKind == null) {
            OCStructSymbol.$$$reportNull$$$0(25);
        }
        return oCSymbolKind;
    }

    @Override
    @NotNull
    public OCStructType getType() {
        return new OCStructType(this);
    }

    @Override
    @Nullable
    public ComplexTextRange getScope() {
        return this.myScope;
    }

    @Override
    public void setScope(@NotNull ComplexTextRange scope) {
        if (scope == null) {
            OCStructSymbol.$$$reportNull$$$0(26);
        }
        this.myScope = scope;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getType().getName();
        if (string == null) {
            OCStructSymbol.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        Icon result;
        if (project == null) {
            OCStructSymbol.$$$reportNull$$$0(28);
        }
        if ((result = super.computeFullIconNow(symbolElement, project)) == null) {
            return null;
        }
        return OCTestFrameworks.isTestClassOrStruct(this, symbolElement, project) ? OCIcons.getTestIcon(result) : result;
    }

    private boolean processAllMembersWithName(String name, Processor<OCSymbol> processor2, @NotNull Project project) {
        if (project == null) {
            OCStructSymbol.$$$reportNull$$$0(29);
        }
        if (!this.isGlobal()) {
            return this.processMembers(name, (Processor<? super OCSymbol>)processor2);
        }
        OCSymbol definition = this.getDefinitionSymbol(project);
        Processor _processor = symbol -> {
            if (!symbol.getClass().equals(OCFunctionSymbol.class)) {
                return true;
            }
            OCSymbolWithQualifiedName resolvedQualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(OCResolveContext.forSymbol(symbol, project));
            if (resolvedQualifiedName == null || !resolvedQualifiedName.equals(definition)) {
                return true;
            }
            return processor2.process(symbol);
        };
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<? super OCSymbol>)_processor, name);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2) {
        return this.processConstructors(processor2, false, false, false, null);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(30);
        }
        return this.processConstructors(processor2, false, true, false, context);
    }

    public boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(31);
        }
        return this.processConstructors(processor2, includeOutOfClassDefinitions, false, false, context);
    }

    private boolean processConstructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, boolean includeUsingBaseConstructors, boolean includeImplicitCtors, @Nullable OCResolveContext context) {
        Processor memberProcessor = symbol -> {
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor()) {
                return processor2.process((Object)((OCFunctionSymbol)symbol));
            }
            return true;
        };
        if (includeUsingBaseConstructors && context != null && !this.processConstructorsFromUsings((Processor<? super OCSymbol>)memberProcessor, context)) {
            return false;
        }
        if (includeImplicitCtors && context != null && this.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor(), context) && !processor2.process((Object)new OCCompilerGeneratedConstructorSymbol(this, OCCompilerGeneratedConstructorSymbol.Kind.DefaultCtor, context.getProject()))) {
            return false;
        }
        if (includeOutOfClassDefinitions) {
            assert (context != null);
            return this.processAllMembersWithName(this.getName(), (Processor<OCSymbol>)memberProcessor, context.getProject());
        }
        return this.processMembers(this.getName(), (Processor<? super OCSymbol>)memberProcessor);
    }

    public boolean processConstructorsFromUsings(@NotNull Processor<? super OCSymbol> processor2, @NotNull OCResolveContext context) {
        if (processor2 == null) {
            OCStructSymbol.$$$reportNull$$$0(32);
        }
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(33);
        }
        return this.processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol -> {
            if (symbol instanceof OCUsingSymbol) {
                OCSymbolReference reference = ((OCUsingSymbol)symbol).getSymbolReference();
                OCQualifiedName name = reference.getQualifiedName();
                OCQualifiedName qualifier = name.getQualifier();
                Set set = OCTypeUtils.newTypeSet();
                this.processConstructors((Processor<? super OCFunctionSymbol>)((Processor)c -> set.add(new OCFunctionType(this.getType(), c.getType().getParameterTypes()))), false, false, false, context);
                Processor ctorProcessor = c -> {
                    OCFunctionSymbol ctor = this.mySubstitution.substitute(new OCCompilerGeneratedConstructorSymbol(this, c.getParameterSymbols()), context);
                    return set.contains(ctor.getType()) || processor2.process((Object)ctor);
                };
                if (qualifier != null && qualifier.getNameWithParent().equals(name.getName())) {
                    for (OCSymbol baseClass : reference.getSymbolReferenceToQualifier().resolveToSymbols(true, true, true, context.substitute(this.getSubstitution()))) {
                        if (!this.isSameSymbol(baseClass, context) && (!(baseClass instanceof OCStructSymbol) || ((OCStructSymbol)baseClass).processConstructors((Processor<? super OCFunctionSymbol>)ctorProcessor, false, true, true, context))) continue;
                        return false;
                    }
                }
                return reference.processPossibleSymbols((Processor<OCSymbol>)((Processor)s -> !(s instanceof OCFunctionSymbol) || !((OCFunctionSymbol)s).isCppConstructor() || ctorProcessor.process((Object)((OCFunctionSymbol)s))), context.substitute(((OCUsingSymbol)symbol).getSubstitution()));
            }
            return true;
        }));
    }

    public boolean processDestructors(Processor<? super OCFunctionSymbol> processor2, boolean includeOutOfClassDefinitions, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(34);
        }
        Processor memberProcessor = symbol -> {
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppDestructor()) {
                return processor2.process((Object)((OCFunctionSymbol)symbol));
            }
            return true;
        };
        if (includeOutOfClassDefinitions) {
            return this.processAllMembersWithName("~" + this.getName(), (Processor<OCSymbol>)memberProcessor, context.getProject());
        }
        return this.processMembers("~" + this.getName(), (Processor<? super OCSymbol>)memberProcessor);
    }

    public boolean processDeductionGuides(Processor<? super OCDeductionGuideSymbol> processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(35);
        }
        Processor _processor = symbol -> {
            OCDeductionGuideSymbol deductionGuideSymbol;
            OCStructSymbol templateId;
            if (symbol instanceof OCDeductionGuideSymbol && (templateId = (deductionGuideSymbol = (OCDeductionGuideSymbol)symbol).getResolvedTemplateId(OCResolveContext.forSymbol(symbol, context.getProject()))) != null && templateId.isSameSymbol(this, context)) {
                return processor2.process((Object)deductionGuideSymbol);
            }
            return true;
        };
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(context.getProject(), (Processor<? super OCSymbol>)_processor, this.getName());
    }

    public boolean hasDefaultConstructor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(36);
        }
        class MyProcessor
        implements Processor<OCFunctionSymbol> {
            boolean wasConstructor;
            boolean wasDefaultConstructor;

            MyProcessor() {
            }

            public boolean process(OCFunctionSymbol symbol) {
                this.wasConstructor = true;
                this.wasDefaultConstructor |= symbol.canBeCalledWithoutArguments();
                return true;
            }

            public boolean hasDefaultConstructor() {
                return !this.wasConstructor || this.wasDefaultConstructor;
            }
        }
        MyProcessor processor2 = new MyProcessor();
        this.processConstructors(processor2, context);
        return processor2.hasDefaultConstructor();
    }

    public boolean hasDeclaredConstructor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(37);
        }
        return !this.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor(), context);
    }

    public boolean hasDeclaredDestructor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(38);
        }
        return !this.processDestructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor(), false, context);
    }

    @Nullable
    public OCFunctionSymbol getDefaultConstructor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(39);
        }
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> finder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol symbol) {
                return symbol.canBeCalledWithoutArguments();
            }
        };
        this.processConstructors((Processor<? super OCFunctionSymbol>)finder, context);
        return (OCFunctionSymbol)finder.getFoundValue();
    }

    public boolean hasTrivialDestructor(@NotNull OCResolveContext context) {
        PsiFile file;
        Map<OCStructSymbol, Boolean> cache;
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(40);
        }
        if ((cache = OCStructSymbol.getTrivialDtorCache(file = context.getFile())) != null && cache.containsKey(this)) {
            return cache.get(this);
        }
        boolean hasTrivialDestructor = this.hasTrivialDestructor(new HashMap<OCStructSymbol, Optional<Boolean>>(), context);
        if (cache != null) {
            cache.put(this, hasTrivialDestructor);
        }
        return hasTrivialDestructor;
    }

    private static Map<OCStructSymbol, Boolean> getTrivialDtorCache(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file.getProject());
        ModificationTracker modificationTracker = FileSymbolTablesCache.getInstance(file.getProject()).getOutOfBlockModificationTracker();
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result(OCTypeUtils.newDeepEqualityMap(), new Object[]{modificationTracker});
        return (Map)manager.getCachedValue((UserDataHolder)file, TRIVIAL_DTOR_CACHE, provider2, false);
    }

    private boolean hasTrivialDestructor(@NotNull HashMap<OCStructSymbol, Optional<Boolean>> processingSymbols, @NotNull OCResolveContext context) {
        if (processingSymbols == null) {
            OCStructSymbol.$$$reportNull$$$0(41);
        }
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(42);
        }
        if (processingSymbols.containsKey(this)) {
            Optional<Boolean> hasTrivialDestructor = processingSymbols.get(this);
            return hasTrivialDestructor.orElse(false);
        }
        OCStructType myType = this.getType();
        OCSymbolKind kind = this.getKind();
        if (kind != OCSymbolKind.STRUCT && kind != OCSymbolKind.UNION) {
            return true;
        }
        Processor dtorProcessor = dtor -> !dtor.isVirtual() && dtor.isDefault();
        BaseClassProcessor baseClassProcessor = (symbol, visibility) -> {
            if (symbol instanceof OCStructSymbol) {
                return ((OCStructSymbol)symbol).hasTrivialDestructor(processingSymbols, context);
            }
            return false;
        };
        Processor fieldsProcessor = field -> {
            OCType type = field.getType().resolve(context);
            if (type instanceof OCStructType) {
                return ((OCStructType)type).getSymbol().hasTrivialDestructor(processingSymbols, context);
            }
            return !type.isUnknown();
        };
        processingSymbols.put(this, Optional.empty());
        boolean hasTrivialDestructor = !this.isPredeclaration() && !myType.isMagicInside(context) && this.processDestructors((Processor<? super OCFunctionSymbol>)dtorProcessor, false, context) && this.processBaseClasses(context, baseClassProcessor) && this.processFields((Processor<? super OCDeclaratorSymbol>)fieldsProcessor);
        processingSymbols.put(this, Optional.of(hasTrivialDestructor));
        return hasTrivialDestructor;
    }

    public boolean hasBaseClasses() {
        return !this.myBaseCppClasses.isEmpty();
    }

    public boolean isPOD(boolean checkInnerStructs, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(43);
        }
        if (this.mySymbolKind != OCSymbolKind.STRUCT && this.mySymbolKind != OCSymbolKind.ENUM) {
            return false;
        }
        if (this.hasBaseClasses()) {
            return false;
        }
        return OCStructSymbol.isPOD(this, new HashSet<OCSymbol>(), checkInnerStructs, context);
    }

    public boolean isPOD(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(44);
        }
        return this.isPOD(true, context);
    }

    private static boolean isPOD(OCStructSymbol symbol, Set<OCSymbol> processed, boolean checkInnerStructs, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(45);
        }
        boolean[] pod = new boolean[]{true};
        symbol.processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol12 -> {
            if (!processed.add((OCSymbol)symbol12)) {
                return true;
            }
            if (symbol12 instanceof OCStructSymbol) {
                if (checkInnerStructs && !OCStructSymbol.isPOD((OCStructSymbol)symbol12, processed, true, context)) {
                    pod[0] = false;
                    return false;
                }
            } else if (symbol12 instanceof OCDeclaratorSymbol) {
                OCVisibility vis = ((OCDeclaratorSymbol)symbol12).getVisibility();
                if (vis != null && vis != OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC && vis != OCVisibility.PUBLIC) {
                    pod[0] = false;
                    return false;
                }
                OCType type = symbol12.getType().resolve(context);
                if (checkInnerStructs && type instanceof OCStructType && symbol12.getKind() != OCSymbolKind.TYPEDEF && ContainerUtil.exists(((OCStructType)type).getStructs(), symbol1 -> !OCStructSymbol.isPOD(symbol1, processed, true, context))) {
                    pod[0] = false;
                    return false;
                }
            }
            return true;
        }));
        return pod[0];
    }

    public boolean hasMemberFunctions() {
        return !this.processFunctions(null, (Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor());
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(@NotNull PsiElement context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(46);
        }
        Collection<OCType> collection = this.getBaseCppClasses(OCResolveContext.forPsi(context));
        if (collection == null) {
            OCStructSymbol.$$$reportNull$$$0(47);
        }
        return collection;
    }

    @NotNull
    public Collection<OCType> getBaseCppClasses(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(48);
        }
        return new ArrayList<OCType>(ContainerUtil.map(this.myBaseCppClasses, pair -> this.mySubstitution.substitute((OCType)pair.first, context)));
    }

    @NotNull
    public Collection<Pair<OCType, OCVisibility>> getBaseCppClassesWithVisibility(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(49);
        }
        return new ArrayList<Pair<OCType, OCVisibility>>(ContainerUtil.map(this.myBaseCppClasses, pair -> {
            OCType type = this.mySubstitution.substitute((OCType)pair.first, context);
            return new Pair((Object)type, (Object)((OCVisibility)((Object)((Object)pair.second))));
        }));
    }

    public boolean processBaseClasses(@NotNull OCResolveContext context, BaseClassProcessor processor2) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(50);
        }
        for (Pair<OCType, OCVisibility> pair : this.myBaseCppClasses) {
            OCType type = this.mySubstitution.substitute((OCType)pair.first, context);
            OCType resolved = type.accept(new OCTypeResolveVisitor(context));
            if (OCStructSymbol.processBaseClass(resolved.isUnknown() ? type : resolved, (OCVisibility)((Object)pair.second), processor2, context)) continue;
            return false;
        }
        return true;
    }

    private static boolean processBaseClass(OCType type, OCVisibility visibility, BaseClassProcessor processor2, @NotNull OCResolveContext context) {
        block5: {
            block6: {
                block4: {
                    if (context == null) {
                        OCStructSymbol.$$$reportNull$$$0(51);
                    }
                    ProgressManager.checkCanceled();
                    if (!(type instanceof OCStructType)) break block4;
                    for (OCStructSymbol symbol : ((OCStructType)type).getStructs()) {
                        if (processor2.process(symbol, visibility)) continue;
                        return false;
                    }
                    break block5;
                }
                if (!(type instanceof OCReferenceType)) break block6;
                for (OCSymbol baseSymbol : context.resolveToSymbols(((OCReferenceType)type).getReference(context), true, true)) {
                    ProgressManager.checkCanceled();
                    if (processor2.process(baseSymbol, visibility)) continue;
                    return false;
                }
                break block5;
            }
            if (!(type instanceof OCExpansionPackType)) break block5;
            for (OCTypeArgument typeArgument : ((OCExpansionPackType)type).getExpansions()) {
                if (!(typeArgument instanceof OCType) || OCStructSymbol.processBaseClass((OCType)typeArgument, visibility, processor2, context)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processAllBaseClasses(BaseClassProcessor processor2, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(52);
        }
        return this.processAllBaseClasses(context, processor2, true);
    }

    public boolean processAllBaseClasses(@NotNull OCResolveContext context, @NotNull BaseClassProcessor processor2, boolean skipFirstVisibility) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(53);
        }
        if (processor2 == null) {
            OCStructSymbol.$$$reportNull$$$0(54);
        }
        return this.processAllBaseClasses(context, processor2, (Condition<OCStructSymbol>)Conditions.alwaysTrue(), skipFirstVisibility);
    }

    public boolean processAllBaseClasses(@NotNull OCResolveContext context, @NotNull BaseClassProcessor processor2, @NotNull Condition<OCStructSymbol> filter, boolean skipFirstVisibility) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(55);
        }
        if (processor2 == null) {
            OCStructSymbol.$$$reportNull$$$0(56);
        }
        if (filter == null) {
            OCStructSymbol.$$$reportNull$$$0(57);
        }
        Set processed = OCTypeUtils.newSymbolWithSubstitutionSet();
        Stack structsWorkset = new Stack();
        Stack visibilityWorkset = new Stack();
        structsWorkset.add((Object)this);
        visibilityWorkset.add(null);
        while (!structsWorkset.isEmpty()) {
            OCStructSymbol symbol = (OCStructSymbol)structsWorkset.pop();
            OCVisibility visibility = (OCVisibility)((Object)visibilityWorkset.pop());
            if (processed.contains(symbol)) continue;
            processed.add(symbol);
            if (symbol.processBaseClasses(context, (baseSymbol, baseVisibility) -> {
                baseVisibility = visibility == null ? (skipFirstVisibility ? OCVisibility.PUBLIC : baseVisibility) : OCVisibility.leastVisible(visibility, baseVisibility);
                if (!processor2.process(baseSymbol, baseVisibility)) {
                    return false;
                }
                if (baseSymbol instanceof OCStructSymbol && filter.value((Object)((OCStructSymbol)baseSymbol))) {
                    structsWorkset.push((Object)((OCStructSymbol)baseSymbol));
                    visibilityWorkset.push((Object)baseVisibility);
                }
                return true;
            })) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestor(OCStructSymbol struct, @NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(58);
        }
        return this.resolvedNamesEqual(struct, context) || !struct.processAllBaseClasses((symbol, visibility) -> !(symbol instanceof OCStructSymbol) || !this.resolvedNamesEqual((OCSymbolWithQualifiedName)symbol, context), context);
    }

    @NotNull
    public List<OCTypeArgument> getTemplateArguments(@NotNull OCResolveContext context) {
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(59);
        }
        ArrayList<OCTypeArgument> result = new ArrayList<OCTypeArgument>();
        List<OCTypeArgument> specialization = this.getTemplateSpecialization();
        if (specialization != null) {
            for (OCTypeArgument spec : specialization) {
                if (spec instanceof OCType) {
                    OCType substitution = ((OCType)spec).transformType(new OCTypeResolveVisitor(context.substituteFirst(this.getSubstitution()), false));
                    if (substitution instanceof OCStructType && ((OCStructType)substitution).getSymbol().equals(this)) continue;
                    result.add(substitution);
                    continue;
                }
                result.add(spec);
            }
        } else {
            for (OCTypeParameterSymbol param : this.getTemplateParameters()) {
                OCTypeArgument argument = this.getSubstitution().getSubstitutionFor(param);
                if (argument instanceof OCExpansionPackType) {
                    result.addAll(((OCExpansionPackType)argument).getExpansions());
                    continue;
                }
                if (argument != null) {
                    result.add(argument);
                    continue;
                }
                result.add(new OCTypeParameterType(param));
            }
        }
        ArrayList<OCTypeArgument> arrayList = result;
        if (arrayList == null) {
            OCStructSymbol.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    @NotNull
    public FindConstructorResult findConstructor(@NotNull OCArgumentsList<?> arguments, @NotNull OCResolveContext context, @Nullable PsiElement localContext, boolean allowImplicitConversions, final @Nullable Supplier<Boolean> isExplicitCall, boolean isListInitialization, @NotNull OCStructType type) {
        if (arguments == null) {
            OCStructSymbol.$$$reportNull$$$0(61);
        }
        if (context == null) {
            OCStructSymbol.$$$reportNull$$$0(62);
        }
        if (type == null) {
            OCStructSymbol.$$$reportNull$$$0(63);
        }
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCFunctionSymbol;
            }
        };
        this.processConstructors((Processor<? super OCFunctionSymbol>)collector, context);
        Collection symbols = collector.getResults();
        symbols.add(this);
        Collection filtered = isExplicitCall != null ? new ArrayList(ContainerUtil.filter((Collection)symbols, (Condition)new Condition<OCSymbol>(){
            Boolean myExplicitConstructorCall;

            public boolean value(OCSymbol symbol) {
                if (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isExplicit()) {
                    return true;
                }
                if (this.myExplicitConstructorCall == null) {
                    this.myExplicitConstructorCall = (Boolean)isExplicitCall.get();
                }
                return this.myExplicitConstructorCall;
            }
        })) : symbols;
        FindConstructorResult findConstructorResult = OCResolveOverloadsUtil.resolveConstructorOverloads(type, filtered, arguments, allowImplicitConversions, isListInitialization, false, context, localContext);
        if (findConstructorResult == null) {
            OCStructSymbol.$$$reportNull$$$0(64);
        }
        return findConstructorResult;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        if (this.myHasClassKeyword) {
            return this.isQualifiedContainer() ? CidrLangIcons.CodeAssistantClass : OCIcons.getVisibilityIcon(this.getVisibility(), CidrLangIcons.CodeAssistantClass);
        }
        return super.getBaseIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 17, 18, 20, 21, 25, 27, 47, 60, 64 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClasses";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateParameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 47: 
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol";
                break;
            }
            case 15: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 19: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 58: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingSymbols";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateParameters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindUppercase";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindLowercase";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseCppClasses";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateArguments";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "findConstructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithSubstitution";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasProperty";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 27: 
            case 47: 
            case 60: 
            case 64: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addBefriendedType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getKindUppercase";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getKindLowercase";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processFields";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processFunctions";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setScope";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processAllMembersWithName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processConstructors";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processConstructorsFromUsings";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processDestructors";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processDeductionGuides";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultConstructor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "hasDeclaredConstructor";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasDeclaredDestructor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructor";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasTrivialDestructor";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isPOD";
                break;
            }
            case 46: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getBaseCppClasses";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getBaseCppClassesWithVisibility";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processBaseClasses";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processBaseClass";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processAllBaseClasses";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateArguments";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findConstructor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 17, 18, 20, 21, 25, 27, 47, 60, 64 -> new IllegalStateException(string);
        };
    }

    public static final class Property
    extends Enum<Property> {
        public static final /* enum */ Property IS_ENUM_CLASS = new Property();
        public static final /* enum */ Property IS_QUALIFIED_CONTAINER = new Property();
        public static final int DEFAULT = 0;
        private static final /* synthetic */ Property[] $VALUES;

        public static Property[] values() {
            return (Property[])$VALUES.clone();
        }

        public static Property valueOf(String name) {
            return Enum.valueOf(Property.class, name);
        }

        public int getMask() {
            assert (this.ordinal() < 8);
            return 1 << 31 - this.ordinal();
        }

        private static /* synthetic */ Property[] $values() {
            return new Property[]{IS_ENUM_CLASS, IS_QUALIFIED_CONTAINER};
        }

        static {
            $VALUES = Property.$values();
        }
    }

    @FunctionalInterface
    public static interface BaseClassProcessor {
        public boolean process(OCSymbol var1, OCVisibility var2);
    }
}

