/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeepEqualImpl
implements DeepEqual.Resolver.Debug,
DeepEqual.Comparator {
    @NotNull
    private final Map<Entry, State> myVisited;
    @NotNull
    private final List<Entry> myComparisonStack;
    @NotNull
    private final Map<Entry, Set<Entry>> myDependencies;
    private HashMap<Class, Function<Object, DeepEqual.Equality>> myCustomMappings;

    DeepEqualImpl() {
        this(new HashMap<Entry, State>());
    }

    DeepEqualImpl(@NotNull Map<Entry, State> traversingState) {
        if (traversingState == null) {
            DeepEqualImpl.$$$reportNull$$$0(0);
        }
        this.myComparisonStack = new ArrayList<Entry>();
        this.myDependencies = new HashMap<Entry, Set<Entry>>();
        this.myVisited = traversingState;
    }

    @Override
    public void clearCaches() {
        this.myVisited.clear();
    }

    @Override
    public <T> void setEquality(@NotNull Class<T> klass, @Nullable Function<T, DeepEqual.Equality<T>> equality) {
        if (klass == null) {
            DeepEqualImpl.$$$reportNull$$$0(1);
        }
        if (this.myCustomMappings == null) {
            this.myCustomMappings = new HashMap();
        }
        if (equality == null) {
            this.myCustomMappings.remove(klass);
        } else {
            this.myCustomMappings.put(klass, equality);
        }
    }

    @Override
    public boolean equalLists(List list1, List list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        return this.containEqualElementsInSameOrder(list1, list2);
    }

    @Override
    public <T> boolean equalArrays(T @Nullable [] array1, T @Nullable [] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        return this.containEqualElementsInSameOrder(Arrays.asList(array1), Arrays.asList(array2));
    }

    protected boolean containEqualElementsInSameOrder(@NotNull Iterable it1, @NotNull Iterable it2) {
        if (it1 == null) {
            DeepEqualImpl.$$$reportNull$$$0(2);
        }
        if (it2 == null) {
            DeepEqualImpl.$$$reportNull$$$0(3);
        }
        if (it1 == it2) {
            return true;
        }
        Iterator i1 = it1.iterator();
        Iterator i2 = it2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object next1;
            Object next = i1.next();
            if (this.equalObjects(next, next1 = i2.next())) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    @Override
    public boolean equalObjects(Object o1, Object o2) {
        Function<Object, DeepEqual.Equality> mapper;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof List) {
            return o2 instanceof List && this.equalLists((List)o1, (List)o2);
        }
        if (o1 instanceof Map) {
            return o2 instanceof Map && this.equalMaps((Map)o1, (Map)o2);
        }
        Class<?> klass = o1.getClass();
        if (!this.equalClass(klass, o2)) {
            return false;
        }
        if (o1 instanceof Pair) {
            return this.equalObjects(((Pair)o1).first, ((Pair)o2).first) && this.equalObjects(((Pair)o1).second, ((Pair)o2).second);
        }
        if (o1 instanceof DeepEqual.Equality) {
            return this.equalObjects((DeepEqual.Equality)o1, o1, o2);
        }
        if (o1 instanceof MostlySingularMultiMap) {
            return this.equalMultiMaps((MostlySingularMultiMap)o1, (MostlySingularMultiMap)o2);
        }
        if (o1 instanceof String || o1 instanceof Number || o1 instanceof Boolean) {
            return o1.equals(o2);
        }
        if (o1.getClass().isEnum()) {
            return false;
        }
        if (this.myCustomMappings != null && (mapper = this.myCustomMappings.get(klass)) != null) {
            DeepEqual.Equality e = (DeepEqual.Equality)mapper.fun(o1);
            return this.equalObjects(e, o1, o2);
        }
        OCLog.LOG.error("trying to compare objects of class " + o1.getClass());
        return false;
    }

    protected boolean equalClass(@NotNull Class<?> klass, @NotNull Object o2) {
        if (klass == null) {
            DeepEqualImpl.$$$reportNull$$$0(4);
        }
        if (o2 == null) {
            DeepEqualImpl.$$$reportNull$$$0(5);
        }
        return klass == o2.getClass();
    }

    protected <T> void afterDeepEqualStep(T o1, T o2, boolean isEqual) {
    }

    public boolean equalObjects(DeepEqual.Equality c1, DeepEqual.Equality c2) {
        return this.equalObjects(c1, c1, c2);
    }

    protected <T> boolean equalObjects(DeepEqual.Equality<T> equality, T o1, T o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!this.equalClass(o1.getClass(), o2)) {
            return false;
        }
        boolean isRoot = this.myComparisonStack.isEmpty();
        try {
            State state;
            ProgressManager.checkCanceled();
            Entry p = new Entry(o1, o2);
            State state2 = state = isRoot ? null : this.myVisited.get(p);
            if (state == null) {
                if (!isRoot) {
                    this.myVisited.put(p, State.MAYBE);
                }
                this.pushDependent(p);
                boolean ok = equality.deepEqualStep(this, o1, o2);
                this.afterDeepEqualStep(o1, o2, ok);
                State pushedState = this.popDependent();
                if (isRoot) {
                    state = ok ? State.EQUALS : State.NOT_EQUALS;
                } else {
                    State state3 = state = ok ? pushedState : State.NOT_EQUALS;
                }
                if (!isRoot && state != State.MAYBE) {
                    this.myVisited.put(p, state);
                    this.myDependencies.remove(p);
                }
            }
            assert (state != null);
            if (state == State.MAYBE) {
                this.addDependencyToCurrent(p);
            }
            if (isRoot) {
                assert (this.myComparisonStack.isEmpty());
                while (!this.myDependencies.isEmpty()) {
                    Entry e = this.myDependencies.keySet().iterator().next();
                    this.unwindDependencies(e);
                }
            }
            return state != State.NOT_EQUALS;
        }
        catch (Throwable t) {
            if (isRoot) {
                this.myDependencies.clear();
                this.myComparisonStack.clear();
                this.myVisited.entrySet().removeIf(entry -> entry.getValue() == State.MAYBE);
            }
            throw t;
        }
    }

    private boolean unwindDependencies(Entry p) {
        Set<Entry> deps = this.myDependencies.remove(p);
        State state = this.myVisited.get(p);
        if (state != State.MAYBE) {
            return state == null || state == State.EQUALS;
        }
        boolean answer = true;
        if (deps != null) {
            for (Entry dep : deps) {
                answer &= this.unwindDependencies(dep);
            }
        }
        this.myVisited.put(p, answer ? State.EQUALS : State.NOT_EQUALS);
        return answer;
    }

    private void addDependencyToCurrent(Entry dependency) {
        Entry cd = this.currentDependent();
        if (cd == null) {
            return;
        }
        cd.myPushedState = State.MAYBE;
        this.myDependencies.computeIfAbsent(cd, k -> new HashSet()).add(dependency);
    }

    private State popDependent() {
        Entry entry = this.myComparisonStack.remove(this.myComparisonStack.size() - 1);
        return entry.myPushedState;
    }

    private void pushDependent(Entry p) {
        p.myPushedState = State.EQUALS;
        this.myComparisonStack.add(p);
    }

    private Entry currentDependent() {
        if (this.myComparisonStack.isEmpty()) {
            return null;
        }
        return this.myComparisonStack.get(this.myComparisonStack.size() - 1);
    }

    @Override
    @NotNull
    public String getComparisonStackTrace() {
        String string = Lists.reverse(this.myComparisonStack).stream().map(e -> String.format("  on %s vs. %s", e.t1, e.t2)).collect(Collectors.joining("\n"));
        if (string == null) {
            DeepEqualImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public <K, V> boolean equalMaps(@Nullable Map<K, V> map1, @Nullable Map<K, V> map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry1 : map1.entrySet()) {
            V value2;
            K key = entry1.getKey();
            V value1 = entry1.getValue();
            if (this.equalObjects(value1, value2 = key instanceof DeepEqual.Equality ? this.findValueWithEqualKey(map2, key) : map2.get(key))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private <K, V> V findValueWithEqualKey(@NotNull Map<K, V> map2, @NotNull K key) {
        if (map2 == null) {
            DeepEqualImpl.$$$reportNull$$$0(7);
        }
        if (key == null) {
            DeepEqualImpl.$$$reportNull$$$0(8);
        }
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            if (!this.equalObjects(key, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public <K, V> boolean equalMultiMaps(@Nullable MostlySingularMultiMap<K, V> map1, @Nullable MostlySingularMultiMap<K, V> map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Object key : map1.keySet()) {
            if (key instanceof DeepEqual.Equality) {
                OCLog.LOG.error("CustomObject " + key.getClass() + " passed to equalMap as key");
            }
            Iterable iterable1 = map1.get(key);
            Iterable iterable2 = map2.get(key);
            if (iterable1 instanceof Collection && iterable2 instanceof Collection && ((Collection)iterable1).size() != ((Collection)iterable2).size()) {
                return false;
            }
            if (this.containEqualElementsInSameOrder(iterable1, iterable2)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traversingState";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/DeepEqualImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/DeepEqualImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparisonStackTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEquality";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containEqualElementsInSameOrder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "equalClass";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findValueWithEqualKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static final class Entry {
        private final Object t1;
        private final Object t2;
        State myPushedState;
        private int myHash;

        private Entry(Object t1, Object t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public int hashCode() {
            if (this.myHash == 0) {
                this.myHash = System.identityHashCode(this.t1) + System.identityHashCode(this.t2);
            }
            return this.myHash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (other.t1 == this.t1 && other.t2 == this.t2) {
                return true;
            }
            return other.t2 == this.t1 && other.t1 == this.t2;
        }
    }

    private static enum State {
        MAYBE,
        EQUALS,
        NOT_EQUALS;

    }
}

