/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import org.jetbrains.annotations.NotNull;

public class ComplexTextRange {
    private final long myStartOffset;
    private final long myEndOffset;

    public ComplexTextRange(long startOffset, long endOffset) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    public long getStartOffset() {
        return this.myStartOffset;
    }

    public long getEndOffset() {
        return this.myEndOffset;
    }

    public boolean contains(@NotNull ComplexTextRange range) {
        if (range == null) {
            ComplexTextRange.$$$reportNull$$$0(0);
        }
        return this.myStartOffset <= range.getStartOffset() && range.getEndOffset() <= this.myEndOffset;
    }

    public boolean contains(long offset) {
        return this.myStartOffset <= offset && offset < this.myEndOffset;
    }

    public boolean containsOffset(long offset) {
        return this.myStartOffset <= offset && offset <= this.myEndOffset;
    }

    public boolean isEmpty() {
        return this.myStartOffset >= this.myEndOffset;
    }

    @NotNull
    public TextRange simple() {
        return new TextRange(OCSymbolOffsetUtil.getTextOffset(this.myStartOffset), OCSymbolOffsetUtil.getTextOffset(this.myEndOffset));
    }

    @NotNull
    public TextRange subst() {
        return new TextRange(OCSymbolOffsetUtil.getSubstOffset(this.myStartOffset), OCSymbolOffsetUtil.getSubstOffset(this.myEndOffset));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexTextRange range = (ComplexTextRange)o;
        if (this.myStartOffset != range.myStartOffset) {
            return false;
        }
        return this.myEndOffset == range.myEndOffset;
    }

    public int hashCode() {
        int result = Long.hashCode(this.myStartOffset);
        result = 31 * result + Long.hashCode(this.myEndOffset);
        return result;
    }

    public String toString() {
        return "text " + this.simple() + ", subst " + this.subst();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/cidr/lang/symbols/ComplexTextRange", "contains"));
    }
}

