/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangDiagnosticIntentionAction;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuppressClangForFile
extends OCSuppressClangDiagnosticIntentionAction {
    private SmartPsiFileRange myPsiRange;
    private final TextRange myTextRange;
    private final OCSuppressionGroup mySuppressionGroup;

    public OCSuppressClangForFile(@Nullable PsiFile file, @Nullable TextRange range, @Nullable OCSuppressionGroup suppressionGroup) {
        super((PsiElement)file, suppressionGroup, "file");
        if (file != null && range != null) {
            this.myPsiRange = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiFileRangePointer(file, range);
        }
        this.myTextRange = range;
        this.mySuppressionGroup = suppressionGroup;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            OCSuppressClangForFile.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCSuppressClangForFile.$$$reportNull$$$0(1);
        }
        return super.isAvailable(project, editor, element) && this.myPsiRange != null;
    }

    @Override
    @Nullable
    protected TextRange getSuppressionRange(OCFile file) {
        Segment range = this.myPsiRange.getRange();
        if (range == null || range.getEndOffset() > file.getTextLength()) {
            return null;
        }
        int beforeOffset = range.getStartOffset();
        for (PsiElement child : file.getChildren()) {
            TextRange childRange = child.getTextRange();
            if (child instanceof OCPragma) {
                OCPragmaSuppressionUtils.Scope scope = OCPragmaSuppressionUtils.findScope(file, child.getTextOffset());
                TextRange pragmaPush = scope.getPush();
                TextRange pragmaPop = scope.getPop();
                if (pragmaPush != null && pragmaPop != null && pragmaPush.getStartOffset() == child.getTextOffset()) {
                    return new TextRange(pragmaPush.getEndOffset(), pragmaPop.getStartOffset() - 1);
                }
            }
            if ((OCElementUtil.isWhitespace(child) || child instanceof OCIncludeDirective) && childRange.getEndOffset() < beforeOffset && !(child instanceof OCPragma)) continue;
            return new TextRange(childRange.getStartOffset(), file.getTextLength());
        }
        return file.getTextRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/quickfixes/OCSuppressClangForFile";
        objectArray[2] = "isAvailable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

