/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddTypeModifierIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private final OCElementType myModifier;
    private final String mySubject;
    private final boolean myProcessSameSymbols;

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, @NotNull Project project, @Nullable String subject, boolean processSameSymbols) {
        if (symbol == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(1);
        }
        super(project, symbol);
        this.myModifier = modifier;
        this.mySubject = subject;
        this.myProcessSameSymbols = processSameSymbols;
    }

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, Project project, boolean processSameSymbols) {
        if (symbol == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(2);
        }
        this(symbol, modifier, project, symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project)), processSameSymbols);
    }

    public OCAddTypeModifierIntentionAction(@NotNull OCSymbol symbol, OCElementType modifier, Project project) {
        if (symbol == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(3);
        }
        this(symbol, modifier, project, true);
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message((String)"intention.name.add.type.modifier", (Object[])new Object[]{this.mySubject, this.myModifier.getName()});
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.add.modifier", (Object[])new Object[]{this.myModifier.getName()});
        if (string == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        if (this.myModifier == OCLexerTokenTypes.CONST_KEYWORD && (((OCDeclaratorSymbol)this.mySymbol).isConst() || this.mySymbol.getKind() == OCSymbolKind.ENUM_CONST)) {
            return false;
        }
        if (this.myModifier == OCLexerTokenTypes.BLOCK_KEYWORD && (((OCDeclaratorSymbol)this.mySymbol).isBlockModifiable() || this.mySymbol.getKind() != OCSymbolKind.LOCAL_VARIABLE)) {
            return false;
        }
        if (this.myModifier == OCLexerTokenTypes.VIRTUAL_CPP_KEYWORD && ((OCFunctionSymbol)this.mySymbol).isVirtual()) {
            return false;
        }
        return !this.mySymbol.getKind().isFunction() || this.myModifier != OCLexerTokenTypes.STATIC_KEYWORD || !((OCFunctionSymbol)this.mySymbol).isVirtual();
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        if (project == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(5);
        }
        List<ASTNode> nodesToUpdate = this.getNodesToUpdate(this.myProcessSameSymbols, project);
        OCFile context = this.mySymbol.getContainingOCFile(project);
        if (nodesToUpdate.isEmpty() || context == null) {
            return;
        }
        for (ASTNode node : nodesToUpdate) {
            node.addChild(OCElementFactory.spaceFromText(context).getNode(), node.getFirstChildNode());
            OCChangeUtil.addChild(node, OCElementFactory.typeModifierFromText(this.myModifier.getName(), context), node.getFirstChildNode());
        }
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        List<ASTNode> nodesToUpdate;
        if (project == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(8);
        }
        if ((nodesToUpdate = this.getNodesToUpdate(false, project)).isEmpty()) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                OCAddTypeModifierIntentionAction.$$$reportNull$$$0(9);
            }
            return intentionPreviewInfo;
        }
        ASTNode node = nodesToUpdate.get(0);
        String builder = this.myModifier.getName() + " " + node.getText();
        return new IntentionPreviewInfo.CustomDiff(file.getFileType(), node.getText(), builder);
    }

    private List<ASTNode> getNodesToUpdate(boolean processSameSymbols, @NotNull Project project) {
        if (project == null) {
            OCAddTypeModifierIntentionAction.$$$reportNull$$$0(10);
        }
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project))) {
            return ContainerUtil.emptyList();
        }
        ArrayList<ASTNode> nodesToUpdate = new ArrayList<ASTNode>();
        Processor processor2 = symbol1 -> {
            PsiElement element = symbol1.locateDefinition(project);
            if (element == null || !(element.getParent() instanceof OCDeclaration)) {
                return true;
            }
            OCTypeElement typeElement = ((OCDeclaration)element.getParent()).getTypeElement();
            if (typeElement == null) {
                return true;
            }
            ASTNode typeNode = typeElement.getNode();
            if (typeNode != null && typeNode.getFirstChildNode() != null && typeNode.findChildByType((IElementType)this.myModifier) == null) {
                nodesToUpdate.add(typeNode);
            }
            return true;
        };
        if (processSameSymbols) {
            this.mySymbol.processSameSymbols((Processor<OCSymbol>)processor2, project);
        } else {
            processor2.process((Object)this.mySymbol);
        }
        return nodesToUpdate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCAddTypeModifierIntentionAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCAddTypeModifierIntentionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNodesToUpdate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9 -> new IllegalStateException(string);
        };
    }
}

