/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddInitializerIntentionAction
extends OCPsiElementQuickFix<OCDeclarator> {
    private final OCSymbol mySymbol;

    public OCAddInitializerIntentionAction(@NotNull OCDeclarator declarator, OCSymbol symbol) {
        if (declarator == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(0);
        }
        super(declarator);
        this.mySymbol = symbol;
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message((String)"intention.name.initialize", (Object[])new Object[]{this.mySymbol.getNameWithKindLowercase(OCCompilationContext.create(this.mySymbol, this.getProject()))});
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.add.initializer", (Object[])new Object[0]);
        if (string == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean isAvailable(@NotNull OCDeclarator declarator) {
        if (declarator == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(2);
        }
        if (this.mySymbol != null) {
            OCDeclaratorSymbol declaratorSymbol;
            OCResolveContext context = OCResolveContext.forPsi(declarator);
            OCType type = this.mySymbol.getResolvedType(context);
            OCSymbol oCSymbol = this.mySymbol;
            if (oCSymbol instanceof OCDeclaratorSymbol && (declaratorSymbol = (OCDeclaratorSymbol)oCSymbol).hasInitializer()) {
                return false;
            }
            return !(type instanceof OCStructType) || type.isCppStructType(context) || ((OCStructType)type).isEnum();
        }
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        OCDeclarator declarator;
        if (project == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(3);
        }
        if ((declarator = (OCDeclarator)this.myElementPtr.getElement()) != null) {
            this.invoke(file, declarator, editor);
        }
    }

    protected void invoke(PsiFile file, @NotNull OCDeclarator declarator, Editor editor) {
        if (declarator == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(4);
        }
        OCResolveContext context = OCResolveContext.forPsi(declarator);
        OCType type = this.mySymbol.getResolvedType(context);
        @NlsSafe String declarationText = "int " + declarator.getTextWithMacros() + "=" + type.getDefaultValue(context);
        OCDeclaration declaration = OCElementFactory.declarationFromText(declarationText, (PsiElement)file, true);
        OCExpression initializer = (declarator = (OCDeclarator)OCChangeUtil.replaceHandlingMacros(declarator, declaration.getDeclarators().get(0))).getInitializer();
        if (initializer != null) {
            OCAddInitializerIntentionAction.invokeSmartCompletion(initializer, type);
        }
    }

    public static void invokeSmartCompletion(final @NotNull OCExpression expression, @NotNull OCType type) {
        if (expression == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(5);
        }
        if (type == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(6);
        }
        OCFile file = expression.getContainingOCFile();
        final boolean deleteOnEsc = type.isPointerToObjectCompatible() && !OCCompilerFeaturesHelper.isArcDisabled(file);
        TextRange initializerRange = expression.getRangeWithMacros();
        final Editor editor = EditorHelper.openInEditor((PsiElement)expression);
        if (editor == null) {
            return;
        }
        editor.getCaretModel().moveToOffset(initializerRange.getEndOffset());
        editor.getSelectionModel().setSelection(initializerRange.getStartOffset(), initializerRange.getEndOffset());
        ApplicationManager.getApplication().invokeLater(() -> {
            if (file.getProject().isDisposed() || !file.isValid()) {
                return;
            }
            CodeCompletionHandlerBase base = new CodeCompletionHandlerBase(CompletionType.SMART, false, false, true);
            base.invokeCompletion(file.getProject(), editor, 1, true);
            LookupEx lookup = LookupManager.getActiveLookup((Editor)editor);
            if (lookup != null) {
                lookup.addLookupListener(new LookupListener(){

                    public void lookupCanceled(@NotNull LookupEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (deleteOnEsc && expression.isValid()) {
                            ApplicationManager.getApplication().runWriteAction(() -> {
                                Document document = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(expression.getContainingFile());
                                if (document != null) {
                                    PsiDocumentManager.getInstance((Project)expression.getProject()).commitDocument(document);
                                }
                                OCChangeUtil.delete(expression);
                            });
                        } else {
                            editor.getSelectionModel().removeSelection();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/quickfixes/OCAddInitializerIntentionAction$1", "lookupCanceled"));
                    }
                });
            }
        }, ModalityState.stateForComponent((Component)editor.getComponent()));
    }

    @Override
    protected boolean shouldCommitAllDocuments() {
        return false;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiElement copyPsiElement;
        if (target == null) {
            OCAddInitializerIntentionAction.$$$reportNull$$$0(7);
        }
        return (copyPsiElement = OCInspectionUtil.findSameElementInCopy((SmartPsiElementPointer)this.myElementPtr, (PsiFile)target)) instanceof OCDeclarator ? new OCAddInitializerIntentionAction((OCDeclarator)copyPsiElement, this.mySymbol) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCAddInitializerIntentionAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCAddInitializerIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeSmartCompletion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

