/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.PersistentByteStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0002\n\u000bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationStorage;", "", "outputStream", "Ljava/io/DataOutputStream;", "getOutputStream", "()Ljava/io/DataOutputStream;", "inputStream", "Ljava/io/DataInputStream;", "getInputStream", "()Ljava/io/DataInputStream;", "PersistentStorage", "None", "intellij.c"})
public interface ModuleMapSerializationStorage {
    @NotNull
    public DataOutputStream getOutputStream();

    @NotNull
    public DataInputStream getInputStream();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationStorage$None;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationStorage;", "<init>", "()V", "outputStream", "Ljava/io/DataOutputStream;", "getOutputStream", "()Ljava/io/DataOutputStream;", "inputStream", "Ljava/io/DataInputStream;", "getInputStream", "()Ljava/io/DataInputStream;", "intellij.c"})
    public static final class None
    implements ModuleMapSerializationStorage {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
        }

        @Override
        @NotNull
        public DataOutputStream getOutputStream() {
            ModuleMapLog.LOG.error("should not happen. serialize should have been filtered out all \"None\" storages");
            return new DataOutputStream(OutputStream.nullOutputStream());
        }

        @Override
        @NotNull
        public DataInputStream getInputStream() {
            ModuleMapLog.LOG.error("should not happen. deserialize should have been filtered out all \"None\" storages");
            return new DataInputStream(InputStream.nullInputStream());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationStorage$PersistentStorage;", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationStorage;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "outputStream", "Ljava/io/DataOutputStream;", "getOutputStream", "()Ljava/io/DataOutputStream;", "inputStream", "Ljava/io/DataInputStream;", "getInputStream", "()Ljava/io/DataInputStream;", "storage", "Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/PersistentByteStorage;", "getStorage", "()Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/PersistentByteStorage;", "key", "", "getKey", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.c"})
    public static final class PersistentStorage
    implements ModuleMapSerializationStorage {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile virtualFile;

        public PersistentStorage(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            this.project = project;
            this.virtualFile = virtualFile;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @Override
        @NotNull
        public DataOutputStream getOutputStream() {
            return this.getStorage().outputStream(this.virtualFile, this.getKey());
        }

        @Override
        @NotNull
        public DataInputStream getInputStream() {
            DataInputStream dataInputStream = this.getStorage().inputStream(this.virtualFile, this.getKey());
            if (dataInputStream == null) {
                dataInputStream = new DataInputStream(InputStream.nullInputStream());
            }
            return dataInputStream;
        }

        private final PersistentByteStorage getStorage() {
            return PersistentByteStorage.Companion.create(57);
        }

        private final String getKey() {
            return "clang_module_map_attribute:" + this.project.getLocationHash();
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.virtualFile;
        }

        @NotNull
        public final PersistentStorage copy(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            return new PersistentStorage(project, virtualFile);
        }

        public static /* synthetic */ PersistentStorage copy$default(PersistentStorage persistentStorage, Project project, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                project = persistentStorage.project;
            }
            if ((n & 2) != 0) {
                virtualFile = persistentStorage.virtualFile;
            }
            return persistentStorage.copy(project, virtualFile);
        }

        @NotNull
        public String toString() {
            return "PersistentStorage(project=" + this.project + ", virtualFile=" + this.virtualFile + ")";
        }

        public int hashCode() {
            int result = this.project.hashCode();
            result = result * 31 + this.virtualFile.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PersistentStorage)) {
                return false;
            }
            PersistentStorage persistentStorage = (PersistentStorage)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)persistentStorage.project)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.virtualFile, (Object)persistentStorage.virtualFile);
        }
    }
}

