/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCWrapStringIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCLiteralExpression literal;
        if (project == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(1);
        }
        return OCCodeInsightUtil.isValid(literal = OCWrapStringIntentionAction.getStringLiteral(editor, element.getContainingFile())) && OCElementUtil.getStringLiteral(literal) != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"intentions.wrap.with.stringFormat", (Object[])new Object[0]);
        if (string == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static OCLiteralExpression getStringLiteral(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(5);
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return OCElementUtil.getAdjacentParentOfType(element, OCLiteralExpression.class);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiFile file;
        OCLiteralExpression literal;
        if (project == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(6);
        }
        if (element == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(7);
        }
        if ((literal = OCWrapStringIntentionAction.getStringLiteral(editor, file = element.getContainingFile())) == null) {
            return;
        }
        OCSendMessageExpression call = (OCSendMessageExpression)OCElementFactory.expressionFromText("[NSString stringWithFormat: 0]", (PsiElement)file);
        call.getArguments().get(0).getArgumentExpression().replace(literal);
        call = (OCSendMessageExpression)literal.replace(call);
        editor.getCaretModel().moveToOffset(call.getTextRange().getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCWrapStringIntentionAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCWrapStringIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteral";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

