/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.oc;

import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotTypeStructureProvider;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.OCDirectInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCTypeStructureProvider
implements PolyglotTypeStructureProvider {
    @Override
    @Nullable
    public PsiElement getSuperClass(@NotNull PsiElement declaration) {
        if (declaration == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(0);
        }
        if (declaration instanceof OCProtocol) {
            return null;
        }
        OCObjectType type = ((OCClassDeclaration)declaration).getType();
        if (type == null) {
            return null;
        }
        OCObjectType superType = type.getSuperType();
        if (superType == null) {
            return null;
        }
        OCClassSymbol superSymbol = superType.getClassSymbol();
        if (superSymbol == null) {
            return null;
        }
        return superSymbol.locateDefinition(declaration.getProject());
    }

    @Override
    @NotNull
    public List<? extends PsiElement> getSuperTypes(@NotNull PsiElement declaration) {
        OCClassDeclaration aClass;
        OCObjectType type;
        if (declaration == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(1);
        }
        if ((type = (aClass = (OCClassDeclaration)declaration).getType()) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                OCTypeStructureProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        OCObjectType superType = type.getSuperType();
        ArrayList<PsiElement> answer = new ArrayList<PsiElement>();
        if (superType != null) {
            OCTypeStructureProvider.appendSymbol(answer, superType.getClassSymbol(), declaration.getProject());
        }
        Project project = declaration.getProject();
        if (aClass instanceof OCProtocol) {
            OCTypeStructureProvider.appendProtocols(answer, aClass.getSymbol(), project, aClass);
        } else {
            OCTypeStructureProvider.appendProtocols(answer, type.getClassSymbol(), project, aClass);
        }
        for (OCInterfaceSymbol category : type.getCategoryInterfaces()) {
            OCTypeStructureProvider.appendProtocols(answer, category, project, aClass);
        }
        ArrayList<PsiElement> arrayList = answer;
        if (arrayList == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void appendSymbol(@NotNull List<PsiElement> answer, @Nullable OCSymbol symbol, @NotNull Project project) {
        PsiElement def;
        if (answer == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(5);
        }
        if (symbol != null && (def = symbol.locateDefinition(project)) != null) {
            answer.add(def);
        }
    }

    private static void appendProtocols(@NotNull List<PsiElement> answer, @Nullable OCClassSymbol symbol, @NotNull Project project, @NotNull OCClassDeclaration aClass) {
        if (answer == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(7);
        }
        if (aClass == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(8);
        }
        if (symbol != null) {
            for (String protocolName : symbol.getProtocolNames()) {
                CommonProcessors.FindFirstProcessor resolver = new CommonProcessors.FindFirstProcessor();
                OCResolveUtil.processGlobalSymbols(protocolName, aClass, new OCCommonProcessors.TypeFilteredProcessor((Processor<OCProtocolSymbol>)resolver, OCProtocolSymbol.class));
                if (!resolver.isFound()) continue;
                OCTypeStructureProvider.appendSymbol(answer, (OCSymbol)resolver.getFoundValue(), project);
            }
        }
    }

    @Override
    @NotNull
    public List<? extends PsiElement> getInheritors(@NotNull PsiElement declaration) {
        if (declaration == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(9);
        }
        Project project = declaration.getProject();
        Collection symbols = OCDirectInheritorsSearch.search((OCClassDeclaration)declaration).findAll();
        List list = symbols.stream().map(symbol -> symbol.locateDefinition(project)).filter(Predicates.nonNull()).collect(Collectors.toList());
        if (list == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    @Nullable
    public PolyglotHierarchyNodeDescriptor createNodeDescriptor(@NotNull PsiElement declaration, @Nullable PolyglotHierarchyNodeDescriptor parent, boolean isBase) {
        if (declaration == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(11);
        }
        return new OCClassHierarchyNodeDescriptor<OCClassDeclaration>(declaration.getProject(), parent, (OCClassDeclaration)declaration, isBase);
    }

    @Override
    public boolean isTypeHierarchyAvailable(@NotNull PsiElement element) {
        if (element == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(12);
        }
        return element instanceof OCClassDeclaration;
    }

    @Override
    @Nullable
    public String getHierarchyType(@NotNull PsiElement base) {
        if (base == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(13);
        }
        if (base instanceof OCProtocol) {
            return TypeHierarchyBrowserBase.getSubtypesHierarchyType();
        }
        return TypeHierarchyBrowserBase.getTypeHierarchyType();
    }

    @Override
    @NotNull
    public String getQualifiedName(@NotNull PsiElement element) {
        if (element == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(14);
        }
        if (element instanceof OCClassDeclaration) {
            String string = ((OCClassDeclaration)element).getCanonicalName();
            if (string == null) {
                OCTypeStructureProvider.$$$reportNull$$$0(15);
            }
            return string;
        }
        return "";
    }

    @Override
    public boolean isInterface(@NotNull PsiElement element) {
        if (element == null) {
            OCTypeStructureProvider.$$$reportNull$$$0(16);
        }
        return element instanceof OCProtocol;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 10, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/hierarchy/oc/OCTypeStructureProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/hierarchy/oc/OCTypeStructureProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSuperTypes";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendSymbol";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendProtocols";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInheritors";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createNodeDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTypeHierarchyAvailable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInterface";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 10, 15 -> new IllegalStateException(string);
        };
    }
}

