/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateFromIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.intentions.OCMoveToPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.refactoring.OCConvertMemberRefactoringProcessor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGeneratePropertiesHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCInstanceVariableSymbol, OCGenerateFromIvarsActionContext> {
    private static final OCBooleanOption SHOW_SYNTHESIZED = new OCBooleanOption(OCGenerateBundle.message("generate.properties.handler.show.synthesized", new Object[0]));
    private static final OCBooleanOption CONVERT_USAGES = new OCBooleanOption(OCGenerateBundle.message("generate.properties.handler.convert.usages", new Object[0]));

    @Override
    @NlsContexts.DialogTitle
    protected String getMembersChooserTitle() {
        return OCGenerateBundle.message("generate.properties.handler.members.chooser.title", new Object[0]);
    }

    @Override
    @NotNull
    @NlsContexts.Command
    protected String getActionTitle() {
        String string = OCGenerateBundle.message("generate.properties.handler.action.title", new Object[0]);
        if (string == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NlsContexts.DialogMessage
    protected String getNoMembersMessage(@NotNull OCGenerateFromIvarsActionContext context) {
        if (context == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(1);
        }
        String parentName = context.getParentNameUppercase();
        return OCGenerateBundle.message("generate.properties.handler.no.instance.variables", parentName);
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateFromIvarsActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(2);
        }
        if (options == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(3);
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_SYNTHESIZED, (Object)true));
        if (OCCompilerFeaturesHelper.supportsAutosynthesis(file)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)CONVERT_USAGES, (Object)true));
        }
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    @NotNull
    protected OCGenerateFromIvarsActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(4);
        }
        return new OCGenerateFromIvarsActionContext(parent, parent.getResolvedType(OCResolveContext.forPsi(element), true), element);
    }

    @Override
    @NotNull
    protected Condition<OCInstanceVariableSymbol> getCandidatesFilter(@NotNull OCGenerateFromIvarsActionContext actionContext) {
        if (actionContext == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(5);
        }
        Condition condition = symbol -> symbol.getGeneratedFromProperty() == null;
        if (condition == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @Override
    protected void performAction(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCGenerateFromIvarsActionContext context, @NotNull List<OCInstanceVariableSymbol> ivars) {
        if (project == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(8);
        }
        if (context == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(9);
        }
        if (ivars == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(10);
        }
        this.performAction(file, context, ivars, null, null, false, this.convertUsages(context), false);
    }

    protected boolean convertUsages(OCGenerateFromIvarsActionContext context) {
        Boolean value = this.getOption(context, CONVERT_USAGES);
        return value != null ? value : true;
    }

    protected void performAction(PsiFile file, OCGenerateFromIvarsActionContext context, List<OCInstanceVariableSymbol> ivars, @Nullable String customName, @Nullable OCPropertySymbol.PropertySemantics customSemantics, boolean isReadonly, boolean convertUsages, final boolean putToPrivateCategory) {
        OCInterfaceSymbol interfaceSymbol = (OCInterfaceSymbol)context.getInterfaceSymbol();
        HashMap newNames = new HashMap();
        HashMap newDeclarations = new HashMap();
        HashMap existingDeclarations = new HashMap();
        ArrayList synthesizes = new ArrayList();
        boolean replaceAllIvars = this.replaceAllIvars();
        PsiFile psiContext = context.getContext().isValid() ? context.getContext() : file;
        ApplicationManager.getApplication().runWriteAction(() -> OCGeneratePropertiesHandler.lambda$performAction$1(ivars, context, customName, newNames, convertUsages, interfaceSymbol, (PsiElement)psiContext, customSemantics, file, isReadonly, newDeclarations, existingDeclarations, replaceAllIvars, synthesizes));
        OCConvertMemberRefactoringProcessor<OCInstanceVariableSymbol> processor2 = new OCConvertMemberRefactoringProcessor<OCInstanceVariableSymbol>((OCClassSymbol)interfaceSymbol, ivars, newNames, newDeclarations, existingDeclarations, replaceAllIvars ? null : synthesizes, (OCElementType)OCLexerTokenTypes.DOT, this.getActionTitle(), convertUsages, context.getProject()){

            protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
                if (conflicts == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    OCGeneratePropertiesHandler.this.passConflictsToTest(new ArrayList<String>(conflicts.values()));
                    this.prepareSuccessful();
                    return true;
                }
                return super.showConflicts(conflicts, usages);
            }

            @Override
            protected void performRefactoring(UsageInfo @NotNull [] usages) {
                OCMoveToPrivateCategoryIntentionAction action;
                PsiElement newDeclaration;
                if (usages == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.performRefactoring(usages);
                PsiElement psiElement = newDeclaration = this.myNewDeclarations.isEmpty() ? null : (PsiElement)this.myNewDeclarations.values().iterator().next();
                if (putToPrivateCategory && newDeclaration instanceof OCProperty && (action = new OCMoveToPrivateCategoryIntentionAction(){

                    @Override
                    protected OCMemberSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
                        if (project == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return (OCMemberSymbol)((OCProperty)newDeclaration).getDeclaration().getDeclarators().get(0).getSymbol();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/generate/handlers/OCGeneratePropertiesHandler$1$1", "locateCandidate"));
                    }
                }).isAvailable(this.myProject, null, newDeclaration.getContainingFile())) {
                    action.defaultInvoke(this.myProject, null, newDeclaration.getContainingFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "conflicts";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "usages";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGeneratePropertiesHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "showConflicts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performRefactoring";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor2.run();
    }

    protected void passConflictsToTest(List<String> conflicts) {
    }

    protected boolean replaceAllIvars() {
        return false;
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCInstanceVariableSymbol> candidates, OCGenerateFromIvarsActionContext actionContext, int moreNodesLevel) {
        if (OCGeneratePropertiesHandler.getOption(chooser.getOptionSelections(), SHOW_SYNTHESIZED).booleanValue()) {
            return super.getChooserNodes(chooser, candidates, actionContext, moreNodesLevel);
        }
        HashSet synthesizedIvars = new HashSet();
        actionContext.getType().processMembers(OCSynthesizeSymbol.class, symbol -> {
            if (symbol.isSynthesize()) {
                synthesizedIvars.add(symbol.getIvarName());
            }
            return true;
        });
        if (OCCompilerFeaturesHelper.supportsAutosynthesis(actionContext.getContext().getContainingFile())) {
            actionContext.getInterfaceSymbol().processMembersInAllCategories(null, OCPropertySymbol.class, propertySymbol -> {
                OCInstanceVariableSymbol ivar = propertySymbol.getAssociatedIvar(actionContext.getProject());
                if (ivar != null) {
                    synthesizedIvars.add(ivar.getName());
                }
                return true;
            }, false, actionContext.getProject());
        }
        return super.getChooserNodes(chooser, ContainerUtil.filter(candidates, ivar -> !synthesizedIvars.contains(ivar.getName())), actionContext, moreNodesLevel);
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCInstanceVariableSymbol> candidates, OCOption option, OCGenerateFromIvarsActionContext actionContext) {
        if (SHOW_SYNTHESIZED.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    private static /* synthetic */ void lambda$performAction$1(List ivars, OCGenerateFromIvarsActionContext context, String customName, Map newNames, boolean convertUsages, OCInterfaceSymbol interfaceSymbol, PsiElement psiContext, OCPropertySymbol.PropertySemantics customSemantics, PsiFile file, boolean isReadonly, Map newDeclarations, Map existingDeclarations, boolean replaceAllIvars, List synthesizes) {
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol associatedProperty = ivar.getAssociatedProperty(context.getProject());
            String propName = customName != null ? customName : (associatedProperty != null ? associatedProperty.getName() : OCNameSuggester.getNonCollidingName(ivar, true, context.getProject()));
            newNames.put(ivar, convertUsages ? propName : OCNameSuggester.getClang4ImplicitIvarName(propName));
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            if (interfaceSymbol != null) {
                interfaceSymbol.processMembers(propName, OCPropertySymbol.class, finder);
            }
            OCResolveContext resolveContext = OCResolveContext.forPsi(psiContext);
            if (!finder.isFound()) {
                OCPropertySymbol.PropertySemantics semantics = null;
                OCType type = ivar.getResolvedType(resolveContext);
                if (customSemantics != null) {
                    semantics = customSemantics;
                } else if (OCCompilerFeaturesHelper.isArcEnabled(file) && type.isPointerToObjectCompatible()) {
                    semantics = ivar.getARCAttribute(psiContext, context.getProject()).getPropertyCompatibleSemantics(type, psiContext);
                }
                OCProperty property = OCElementFactory.propertyDeclaration(propName, type, psiContext, semantics, isReadonly);
                newDeclarations.put(ivar, property);
            } else {
                existingDeclarations.put(ivar, (OCMemberSymbol)finder.getFoundValue());
            }
            if (!(replaceAllIvars || OCCompilerFeaturesHelper.supportsAutosynthesis(file) && OCNameSuggester.getClang4ImplicitIvarName(propName).equals(ivar.getName()))) {
                OCSynthesizePropertiesList synthesize = OCElementFactory.synthesizeList("@synthesize", propName, propName.equals(ivar.getName()) ? null : ivar.getName(), psiContext);
                synthesizes.add(synthesize);
            }
            OCType oCType = ivar.getResolvedType(resolveContext);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGeneratePropertiesHandler";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ivars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGeneratePropertiesHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNoMembersMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatesFilter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

