/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.generate.FunctionQualifiedNameInfo;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppGeneratedQualifiedFunctionKt;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCNewCppFunctionsLocator;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCExplicitSpecifier;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCRequiresClause;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCNewImportLocation;
import com.jetbrains.cidr.lang.symbols.OCAttributes;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCCppDefinitionsUtil {
    private static final Comparator<OCGenerateUtil.Replacement> REPLACEMENT_COMPARATOR = (o1, o2) -> {
        if (!o1.position.file.equals(o2.position.file)) {
            return System.identityHashCode(o2.position.file) - System.identityHashCode(o1.position.file);
        }
        return o2.position.range.getStartOffset() - o1.position.range.getStartOffset();
    };

    @NotNull
    public static String functionSignature(@NotNull OCFunctionSymbol function, @NotNull OCFunctionSymbol baseFunction, boolean isOutOfClassDefinition, @NotNull PsiElement context) {
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(0);
        }
        if (baseFunction == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(2);
        }
        Project project = context.getProject();
        OCFunctionDeclaration baseDecl = baseFunction.locateFunctionDefinition(project);
        return OCCppDefinitionsUtil.functionSignature(function, baseDecl, isOutOfClassDefinition, context);
    }

    @NotNull
    public static String functionSignature(@NotNull OCFunctionSymbol function, boolean isOutOfClassDefinition, @NotNull PsiElement context) {
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(3);
        }
        if (context == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(4);
        }
        return OCCppDefinitionsUtil.functionSignature(function, function, isOutOfClassDefinition, context);
    }

    @NotNull
    private static String functionSignature(@NotNull OCFunctionSymbol function, @Nullable OCFunctionDeclaration funDefinition, boolean isOutOfClassDefinition, @NotNull PsiElement context) {
        OCTypeElement trailingType;
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(6);
        }
        @NlsSafe StringBuilder answer = new StringBuilder();
        FunctionQualifiedNameInfo qualInfo = isOutOfClassDefinition ? OCCppGeneratedQualifiedFunctionKt.getQualifiedNameAndTemplateHeader(function, context) : new FunctionQualifiedNameInfo(function.getName(), "");
        OCRequiresClause requiresClause = null;
        if (funDefinition != null) {
            requiresClause = funDefinition.getRequiresClause();
        }
        answer.append(qualInfo.getTemplateHeader());
        if (requiresClause != null && !requiresClause.isTrailing()) {
            answer.append(requiresClause.getTextWithMacros()).append("\n");
        }
        answer.append(OCCppDefinitionsUtil.getCudaAttributes(function.getAttributes()));
        if (function.isConstexpr()) {
            answer.append("constexpr ");
        }
        if (function.isConsteval()) {
            answer.append("consteval ");
        }
        if (!isOutOfClassDefinition) {
            if (function.isVirtual()) {
                answer.append("virtual ");
            }
            if (function.isFriend()) {
                answer.append("friend ");
            }
            if (function.isStatic()) {
                answer.append("static ");
            }
            if (function.isExplicit()) {
                OCCondition explicitCond;
                OCExplicitSpecifier explicitSpecifier;
                answer.append("explicit");
                if (funDefinition != null && (explicitSpecifier = funDefinition.getExplicitSpecifier()) != null && (explicitCond = explicitSpecifier.getCondition()) != null) {
                    answer.append("(").append(explicitCond.getTextWithMacros()).append(")");
                }
                answer.append(" ");
            }
        }
        Project project = context.getProject();
        if (!(function.isCppConstructor() || function.isCppDestructor() || function.isCppConversionOperator())) {
            if (funDefinition != null && funDefinition.getTrailingReturnTypeElement() != null) {
                answer.append("auto");
            } else {
                OCResolveContext resolveContext = OCResolveContext.forPsi(context);
                answer.append(function.getEffectiveResolvedType(resolveContext).getBestNameInContext(resolveContext, OCElementUtil.getReturnTypeTextWithModifiers(function, project)));
            }
            answer.append(' ');
        }
        answer.append(qualInfo.getQualifiedName());
        String paramStr = StringUtil.join(function.getParameterSymbols(), it -> {
            OCParameterDeclaration paramDecl = OCElementFactory.paramDeclarationByNameAndType(it.getName(), it.getType(), null, context);
            return paramDecl.getTextWithMacros();
        }, (String)", ");
        answer.append('(').append(paramStr).append(')');
        function.getType().getCVQualifiers().appendCVQualifiers(answer);
        if (function.getType().isLValueRef()) {
            answer.append(" &");
        } else if (function.getType().isRValueRef()) {
            answer.append(" &&");
        }
        OCCppDefinitionsUtil.addNoexceptSpecifier(function, funDefinition, answer, context);
        if (funDefinition != null && (trailingType = funDefinition.getTrailingReturnTypeElement()) != null) {
            answer.append(" -> ").append(trailingType.getType().resolve(context).getBestNameInContext(context, trailingType.getTextWithMacros()));
        }
        if (requiresClause != null && requiresClause.isTrailing()) {
            answer.append(" ").append(requiresClause.getTextWithMacros());
        }
        if (!isOutOfClassDefinition && function.isOverride()) {
            answer.append(" override");
        }
        if (!isOutOfClassDefinition && function.isFinal()) {
            answer.append(" final");
        }
        if (!isOutOfClassDefinition && function.isPureVirtual()) {
            answer.append(" = 0");
        }
        if (!isOutOfClassDefinition && function.isDefault()) {
            answer.append(" = default");
        }
        if (!isOutOfClassDefinition && function.isDelete()) {
            answer.append(" = delete");
        }
        String string = answer.toString();
        if (string == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static String getCudaAttributes(@NotNull List<String> attributes) {
        if (attributes == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(8);
        }
        return attributes.stream().map(it -> it.replace("_", "")).filter(it -> OCAttributes.CUDA_ATTRIBUTES.contains(it)).map(it -> String.format("__%s__ ", it)).collect(Collectors.joining());
    }

    private static boolean isOverrideSpecifier(@NlsSafe @NotNull String text) {
        if (text == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(9);
        }
        return text.equals("override") || text.equals("final");
    }

    private static boolean isNoexceptSpecifier(@NlsSafe @NotNull String text) {
        if (text == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(10);
        }
        return text.startsWith("noexcept") || text.startsWith("throw");
    }

    private static boolean addTrailingMacroCalls(@NotNull OCFunctionDeclaration funDefinition, @NotNull StringBuilder answer) {
        if (funDefinition == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(11);
        }
        if (answer == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(12);
        }
        boolean hasMacroNoexcept = false;
        OCMacroCall[] macroCalls = (OCMacroCall[])PsiTreeUtil.getChildrenOfType((PsiElement)funDefinition.getDeclarator(), OCMacroCall.class);
        if (macroCalls != null) {
            for (OCMacroCall macro : macroCalls) {
                String replacementText = macro.getReplacementText();
                if (OCCppDefinitionsUtil.isOverrideSpecifier(replacementText)) continue;
                String macroText = macro.getText();
                if (macroText != null && !macroText.isEmpty()) {
                    answer.append(" ");
                    answer.append(macroText);
                }
                hasMacroNoexcept = OCCppDefinitionsUtil.isNoexceptSpecifier(replacementText);
            }
        }
        return hasMacroNoexcept;
    }

    public static String getExceptionSpecification(@NotNull OCFunctionSymbol function, @Nullable OCFunctionDeclaration funDefinition) {
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(13);
        }
        StringBuilder sb = new StringBuilder();
        OCCppDefinitionsUtil.addNoexceptSpecifier(function, funDefinition, sb, funDefinition);
        return sb.toString();
    }

    private static void addNoexceptSpecifier(@NotNull OCFunctionSymbol function, @Nullable OCFunctionDeclaration funDefinition, @NlsSafe @NotNull StringBuilder answer, @NotNull PsiElement context) {
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(14);
        }
        if (answer == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(15);
        }
        if (context == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(16);
        }
        boolean hasMacroNoexcept = false;
        if (funDefinition != null) {
            hasMacroNoexcept = OCCppDefinitionsUtil.addTrailingMacroCalls(funDefinition, answer);
        }
        if (!hasMacroNoexcept) {
            OCExceptionSpecificationInfo exceptionSpecificationInfo = function.getType().getExceptionSpecification();
            switch (exceptionSpecificationInfo.getSpecificationKind()) {
                case None: {
                    break;
                }
                case DynamicNone: {
                    answer.append(" throw()");
                    break;
                }
                case Dynamic: {
                    if (OCCppDefinitionsUtil.addThrowText(funDefinition, answer)) break;
                    answer.append(" throw(");
                    for (int i = 0; i < exceptionSpecificationInfo.getThrowTypes().size(); ++i) {
                        OCType throwType = exceptionSpecificationInfo.getThrowTypes().get(i);
                        if (i > 0) {
                            answer.append(", ");
                        }
                        answer.append(throwType.getName(context));
                    }
                    answer.append(")");
                    break;
                }
                case MSAny: {
                    answer.append(" throw(...)");
                    break;
                }
                case BasicNoexcept: {
                    answer.append(" noexcept");
                    break;
                }
                case ComputedNoexcept: {
                    answer.append(" noexcept(");
                    if (!OCCppDefinitionsUtil.addNoexceptExpressionText(funDefinition, answer)) {
                        answer.append(exceptionSpecificationInfo.getNoexceptExpression().getPresentableText());
                    }
                    answer.append(")");
                }
            }
        }
    }

    private static boolean addNoexceptExpressionText(@Nullable OCFunctionDeclaration funDefinition, @NotNull StringBuilder answer) {
        if (answer == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(17);
        }
        if (funDefinition == null) {
            return false;
        }
        OCNoexceptSpecifier noexceptSpecifier = (OCNoexceptSpecifier)PsiTreeUtil.findChildOfType((PsiElement)funDefinition, OCNoexceptSpecifier.class);
        if (noexceptSpecifier == null) {
            return false;
        }
        OCExpression noexceptOperand = noexceptSpecifier.getOperand();
        if (noexceptOperand == null) {
            return false;
        }
        String inParens = noexceptOperand.getTextWithMacros();
        answer.append(inParens);
        return true;
    }

    private static boolean addThrowText(@Nullable OCFunctionDeclaration funDefinition, @NotNull StringBuilder answer) {
        if (answer == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(18);
        }
        if (funDefinition == null || funDefinition.getDeclarator() == null) {
            return false;
        }
        String funDefText = funDefinition.getDeclarator().getText();
        int beginIdx = funDefText.lastIndexOf("throw(");
        int endIdx = funDefText.indexOf(")", beginIdx);
        if (beginIdx == -1 || endIdx == -1) {
            return false;
        }
        String throwsText = funDefText.substring(beginIdx, endIdx + 1);
        answer.append(" ").append(throwsText);
        return true;
    }

    @NotNull
    public static SHOULD_GENERATE_DEFINITION shouldGenerateDefinitionsFor(@NotNull OCFunctionSymbol function, boolean checkNoncopyable, @NotNull Project project) {
        OCType type;
        List<OCType> parameterTypes;
        PsiFile file;
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(19);
        }
        if (project == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(20);
        }
        if (!OCCodeInsightUtil.isValid((PsiElement)(file = function.getContainingPsiFile(project)))) {
            SHOULD_GENERATE_DEFINITION sHOULD_GENERATE_DEFINITION = SHOULD_GENERATE_DEFINITION.NO;
            if (sHOULD_GENERATE_DEFINITION == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(21);
            }
            return sHOULD_GENERATE_DEFINITION;
        }
        if (function.isPureVirtual()) {
            SHOULD_GENERATE_DEFINITION sHOULD_GENERATE_DEFINITION = SHOULD_GENERATE_DEFINITION.NO;
            if (sHOULD_GENERATE_DEFINITION == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(22);
            }
            return sHOULD_GENERATE_DEFINITION;
        }
        if (!function.processSameSymbols((Processor<OCSymbol>)((Processor)s -> s.isPredeclaration() && (!(s instanceof OCFunctionSymbol) || !((OCFunctionSymbol)s).isDefault() && !((OCFunctionSymbol)s).isDelete())), project)) {
            SHOULD_GENERATE_DEFINITION sHOULD_GENERATE_DEFINITION = SHOULD_GENERATE_DEFINITION.NO;
            if (sHOULD_GENERATE_DEFINITION == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(23);
            }
            return sHOULD_GENERATE_DEFINITION;
        }
        if (!(function.getParent() instanceof OCStructSymbol)) {
            SHOULD_GENERATE_DEFINITION sHOULD_GENERATE_DEFINITION = SHOULD_GENERATE_DEFINITION.POSSIBLE;
            if (sHOULD_GENERATE_DEFINITION == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(24);
            }
            return sHOULD_GENERATE_DEFINITION;
        }
        if (checkNoncopyable && function.getVisibility() == OCVisibility.PRIVATE && (function.isCppConstructor() || function.isCppOperator() && function.getName().equals("operator=")) && (parameterTypes = function.getType().getParameterTypes()).size() == 1 && (type = parameterTypes.get(0)) instanceof OCCppReferenceType && function.getParent().getType().cloneWithConstModifier(project).equalsAfterResolving(((OCCppReferenceType)type).getRefType(), OCResolveContext.forSymbol(function, project))) {
            SHOULD_GENERATE_DEFINITION sHOULD_GENERATE_DEFINITION = SHOULD_GENERATE_DEFINITION.POSSIBLE;
            if (sHOULD_GENERATE_DEFINITION == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(25);
            }
            return sHOULD_GENERATE_DEFINITION;
        }
        SHOULD_GENERATE_DEFINITION sHOULD_GENERATE_DEFINITION = SHOULD_GENERATE_DEFINITION.REQUIRED;
        if (sHOULD_GENERATE_DEFINITION == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(26);
        }
        return sHOULD_GENERATE_DEFINITION;
    }

    @NotNull
    public static OCMembersContainer getFunctionParent(@NotNull OCFunctionSymbol function, @NotNull Project project) {
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(27);
        }
        if (project == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(28);
        }
        OCNamespaceLikeSymbol oCNamespaceLikeSymbol = function.getParent() instanceof OCNamespaceLikeSymbol ? (OCNamespaceLikeSymbol)((Object)function.getParent()) : function.getContainingOCFile(project).getMembersContainer(false);
        if (oCNamespaceLikeSymbol == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(29);
        }
        return oCNamespaceLikeSymbol;
    }

    public static boolean shouldInlineNewDefinitions(@NotNull OCMembersContainer parent, @NotNull OCCaretLocation location) {
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(30);
        }
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(31);
        }
        Project project = location.getProject();
        if (location.getElement() != null) {
            if (!(parent instanceof OCSymbol) && location.getFile().equals(parent.getContainingPsiFile(project)) && OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project)) {
                return false;
            }
            if (OCCppDefinitionsUtil.isLocationOutsideParent(location, OCCppDefinitionsUtil.getParentDefinition(parent, project))) {
                return false;
            }
        }
        return OCCppDefinitionsUtil.getBestLocationBasedOnExistingDefinitions((OCMembersContainer)parent, (Project)project).shouldInline;
    }

    @Nullable
    public static OCGenerateUtil.ReplacePosition getOutsidePreferredPosition(@NotNull PsiFile file, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions) {
        OCFile sourceFile;
        if (file == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(32);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(33);
        }
        if (functions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(34);
        }
        if (functions.isEmpty() || !(file instanceof OCFile)) {
            return null;
        }
        Project project = file.getProject();
        BasedOnExistingResult basedOnExisting = OCCppDefinitionsUtil.getBestLocationBasedOnExistingDefinitions(parent, project);
        if (basedOnExisting.outsideLocation != null) {
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby((Integer)basedOnExisting.outsideLocation.second, (PsiFile)basedOnExisting.outsideLocation.first);
        }
        if (OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project) && !ContainerUtil.exists(functions, OCFunctionSymbol::isTemplateSymbol) && (sourceFile = ((OCFile)file).getAssociatedFile()) != null && !sourceFile.isHeader()) {
            PsiElement insertionParent = OCCppDefinitionsUtil.findInsertionParentInFile(sourceFile, (OCNamespaceSymbol)ObjectUtils.tryCast((Object)parent, OCNamespaceSymbol.class));
            ASTNode child = insertionParent.getNode().findChildByType((IElementType)OCLexerTokenTypes.RBRACE);
            PsiElement rBrace = child != null ? child.getPsi() : null;
            int desiredOffset = rBrace != null ? rBrace.getTextRange().getStartOffset() : insertionParent.getTextRange().getEndOffset();
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(desiredOffset, sourceFile);
        }
        PsiElement fallbackLocation = OCCppDefinitionsUtil.defaultFallbackLocation(file, OCCppDefinitionsUtil.getParentDefinition(parent, project), functions);
        return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(fallbackLocation.getTextRange().getEndOffset(), fallbackLocation.getContainingFile());
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getGenerateDefinitionReplacements(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions, @NotNull List<? extends OCCallable> predefinitions, @NotNull InlinePolicy inlinePolicy, boolean addImportReplacements) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(35);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(36);
        }
        if (functions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(37);
        }
        if (predefinitions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(38);
        }
        if (inlinePolicy == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(39);
        }
        if (inlinePolicy.shouldInline(location, parent)) {
            ArrayList<OCGenerateUtil.Replacement> replacements = new ArrayList<OCGenerateUtil.Replacement>(functions.size());
            assert (functions.size() == predefinitions.size());
            for (int i = 0; i < functions.size(); ++i) {
                PsiElement semicolon;
                OCFunctionSymbol symbol = functions.get(i);
                OCCallable predefinition = predefinitions.get(i);
                if (predefinition == null) continue;
                PsiElement lastChild = predefinition.getLastChild();
                PsiElement psiElement = semicolon = !OCElementUtil.isElementSignificant(lastChild) ? OCElementUtil.getPrevSignificantSibling(lastChild) : lastChild;
                if (semicolon == null || OCElementUtil.getElementType(semicolon) != OCLexerTokenTypes.SEMICOLON) continue;
                replacements.add(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(predefinition.getContainingOCFile(), semicolon.getTextRange(), predefinition, false), OCCallableUtil.defaultFunctionBody(symbol, OCCallableUtil.getDefaultBaseToCall(symbol, predefinition.getProject()), predefinition)));
            }
            ArrayList<OCGenerateUtil.Replacement> arrayList = replacements;
            if (arrayList == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(40);
            }
            return arrayList;
        }
        return OCCppDefinitionsUtil.getOutsideReplacements(location, parent, functions, null, addImportReplacements);
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getNewFunctionsReplacements(@NotNull OCCaretLocation location, @NotNull OCStructLike structDefinition, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> symbols, @Nullable List<String> bodies, @NotNull InlinePolicy inlinePolicy) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(41);
        }
        if (structDefinition == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(42);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(43);
        }
        if (symbols == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(44);
        }
        if (inlinePolicy == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(45);
        }
        return OCCppDefinitionsUtil.getNewFunctionsReplacements(location, structDefinition, parent, symbols, Collections.emptyList(), bodies, inlinePolicy);
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getNewFunctionsReplacements(@NotNull OCCaretLocation location, @NotNull OCStructLike structDefinition, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> symbols, @NotNull List<OCFunctionSymbol> baseFunctions, @Nullable List<String> bodies, @NotNull InlinePolicy inlinePolicy) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(46);
        }
        if (structDefinition == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(47);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(48);
        }
        if (symbols == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(49);
        }
        if (baseFunctions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(50);
        }
        if (inlinePolicy == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(51);
        }
        if (symbols.isEmpty()) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(52);
            }
            return list;
        }
        StringBuilder insideClassText = new StringBuilder();
        boolean shouldInline = inlinePolicy.shouldInline(location, parent);
        OCStructLike contextToCalculateNames = structDefinition;
        int insertPositionInsideClass = OCCppDefinitionsUtil.getInsertPositionForFunctionsInsideClass(structDefinition, location, symbols.get(0));
        OCVisibility initialVisibility = OCVisibility.getVisibilityAtOffset(structDefinition, insertPositionInsideClass);
        assert (initialVisibility != null);
        OCVisibility curVisibility = initialVisibility;
        for (int i = 0; i < symbols.size(); ++i) {
            String functionSig;
            OCFunctionSymbol functionSymbol = symbols.get(i);
            OCVisibility visibility = functionSymbol.getVisibility();
            if (visibility != curVisibility) {
                insideClassText.append((Object)visibility).append(": ");
                curVisibility = visibility;
            }
            String afterSignature = shouldInline && !functionSymbol.isDefault() && !functionSymbol.isDelete() ? (bodies == null ? OCCallableUtil.defaultFunctionBody(functionSymbol, OCCallableUtil.getDefaultBaseToCall(functionSymbol, location.getProject()), contextToCalculateNames) : bodies.get(i)) : ";";
            if (!baseFunctions.isEmpty()) {
                OCLog.LOG.assertTrue(baseFunctions.size() == symbols.size());
                OCFunctionSymbol baseFunction = baseFunctions.get(i);
                functionSig = OCCppDefinitionsUtil.functionSignature(functionSymbol, baseFunction, false, (PsiElement)structDefinition);
            } else {
                functionSig = OCCppDefinitionsUtil.functionSignature(functionSymbol, false, structDefinition);
            }
            insideClassText.append(functionSig).append(afterSignature);
        }
        if (OCCppDefinitionsUtil.shouldRestoreVisibility(structDefinition, insertPositionInsideClass, initialVisibility, curVisibility)) {
            insideClassText.append((Object)initialVisibility).append(": ");
        }
        PsiFile structDefinitionFile = structDefinition.getContainingFile();
        Document structDefinitionDocument = PsiDocumentManager.getInstance((Project)location.getProject()).getDocument(structDefinitionFile);
        if (structDefinitionDocument == null) {
            OCLog.LOG.warn("No document for " + structDefinitionFile);
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(53);
            }
            return list;
        }
        List<OCGenerateUtil.Replacement> insideClassReplacements = Collections.singletonList(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(structDefinitionFile, TextRange.from((int)insertPositionInsideClass, (int)0), contextToCalculateNames), insideClassText.toString()));
        List outsideClassReplacements = shouldInline ? Collections.emptyList() : OCCppDefinitionsUtil.getOutsideReplacements(location, parent, symbols, bodies, false);
        List list = ContainerUtil.concat(insideClassReplacements, outsideClassReplacements);
        if (list == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(54);
        }
        return list;
    }

    @Nullable
    public static PsiElement getParentDefinition(@NotNull OCMembersContainer parent, @NotNull Project project) {
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(55);
        }
        if (project == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(56);
        }
        return parent instanceof OCSymbol ? ((OCSymbol)((Object)parent)).locateDefinition(project) : parent.getContainingPsiFile(project);
    }

    @NotNull
    private static List<OCGenerateUtil.Replacement> getOutsideReplacements(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions, @Nullable List<String> bodies, boolean addImportReplacements) {
        OCGenerateUtil.ReplacePosition position;
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(57);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(58);
        }
        if (functions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(59);
        }
        OCGenerateUtil.ReplacePosition replacePosition = position = OCCppDefinitionsUtil.shouldGenerateOutsideDefinitionAtCaret(location, parent) ? OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(location) : OCCppDefinitionsUtil.getOutsidePreferredPosition(location.getFile(), parent, functions);
        if (position == null) {
            OCLog.LOG.warn("Can't find outside position for file '" + location.getFile() + "'");
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(60);
            }
            return list;
        }
        HashSet<VirtualFile> filesToInclude = new HashSet<VirtualFile>();
        StringBuilder text = new StringBuilder();
        OCFile targetFile = (OCFile)position.file;
        for (int i = 0; i < functions.size(); ++i) {
            OCFunctionSymbol function = functions.get(i);
            if (function.isDefault() || function.isDelete()) continue;
            text.append(OCCppDefinitionsUtil.functionSignature(function, true, position.context)).append(bodies != null ? bodies.get(i) : OCCallableUtil.defaultFunctionBody(function, OCCallableUtil.getDefaultBaseToCall(function, location.getProject()), position.context));
            VirtualFile fileToInclude = OCCppDefinitionsUtil.getFileToIncludeIfNeeded(function, targetFile);
            if (fileToInclude == null) continue;
            filesToInclude.add(fileToInclude);
        }
        OCGenerateUtil.Replacement incl = addImportReplacements ? OCCppDefinitionsUtil.calcIncludeReplacement(position, targetFile, filesToInclude) : null;
        OCGenerateUtil.Replacement definitions = new OCGenerateUtil.Replacement(position, text.toString());
        return incl == null ? Collections.singletonList(definitions) : OCCppDefinitionsUtil.mergeReplacements(Arrays.asList(incl, definitions));
    }

    @NotNull
    private static List<OCGenerateUtil.Replacement> mergeReplacements(@NotNull List<OCGenerateUtil.Replacement> replacements) {
        if (replacements == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(61);
        }
        replacements = ContainerUtil.sorted(replacements, REPLACEMENT_COMPARATOR);
        ArrayList<OCGenerateUtil.Replacement> res = new ArrayList<OCGenerateUtil.Replacement>(replacements.size());
        for (OCGenerateUtil.Replacement r : replacements) {
            int lastIdx = res.size() - 1;
            if (res.isEmpty() || !OCCppDefinitionsUtil.intersects(res.get(lastIdx), r)) {
                res.add(r);
                continue;
            }
            res.set(lastIdx, OCCppDefinitionsUtil.union(res.get(lastIdx), r));
        }
        ArrayList<OCGenerateUtil.Replacement> arrayList = res;
        if (arrayList == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    private static boolean intersects(@NotNull OCGenerateUtil.Replacement a, @NotNull OCGenerateUtil.Replacement b) {
        if (a == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(63);
        }
        if (b == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(64);
        }
        if (!a.position.file.equals(b.position.file)) {
            return false;
        }
        return a.position.range.intersects(b.position.range);
    }

    @NotNull
    private static OCGenerateUtil.Replacement union(@NotNull OCGenerateUtil.Replacement a, @NotNull OCGenerateUtil.Replacement b) {
        if (a == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(65);
        }
        if (b == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(66);
        }
        assert (a.position.file.equals(b.position.file));
        return new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(a.position.file, a.position.range.union(b.position.range), a.position.context, a.position.addNewLineBefore, b.position.addNewLineAfter), a.text + b.text);
    }

    @Nullable
    private static OCGenerateUtil.Replacement calcIncludeReplacement(OCGenerateUtil.ReplacePosition position, OCFile targetFile, Set<VirtualFile> filesToInclude) {
        List<OCAutoImportHelper.ImportSpecification> specs = filesToInclude.stream().map(vf -> OCImportSymbolFix.getFileNameToImport(vf, position.file)).filter(Predicates.nonNull()).sorted(Comparator.comparing(OCAutoImportHelper.ImportSpecification::getImportText)).toList();
        if (!specs.isEmpty()) {
            OCAutoImportHelper.ImportSpecification first = (OCAutoImportHelper.ImportSpecification)ContainerUtil.getFirstItem(specs);
            assert (first != null);
            OCNewImportLocation importLoc = OCImportSymbolFix.calcNewImportLocation(targetFile, position.range.getStartOffset(), "#include " + first.getImportText(), OCImportSymbolFix.ImportStyle.INCLUDE, first.getPreferredDelimiters());
            if (importLoc.getInsertAnchor() != null) {
                int offset = importLoc.getInsertBefore() ? importLoc.getInsertAnchor().getTextRange().getStartOffset() : importLoc.getInsertAnchor().getTextRange().getEndOffset();
                String includeText = specs.stream().map(spec -> "#include " + spec.getImportText() + "\n").collect(Collectors.joining());
                return new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(targetFile, TextRange.from((int)offset, (int)0), position.context), includeText);
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile getFileToIncludeIfNeeded(@NotNull OCFunctionSymbol function, @NotNull OCFile file) {
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(67);
        }
        if (file == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(68);
        }
        VirtualFile targetVF = file.getVirtualFile();
        VirtualFile symbolVF = function.getContainingFile();
        if (targetVF == null || symbolVF == null || targetVF.equals(symbolVF)) {
            return null;
        }
        OCImportGraph importGraph = OCImportGraph.getInstance(file.getProject());
        for (VirtualFile included : importGraph.findImmediateIncludingFiles(symbolVF, false)) {
            if (!targetVF.equals(included)) continue;
            return null;
        }
        return symbolVF;
    }

    @NotNull
    private static BasedOnExistingResult getBestLocationBasedOnExistingDefinitions(@NotNull OCMembersContainer parent, final @NotNull Project project) {
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(69);
        }
        if (project == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(70);
        }
        final PsiFile topLevelFile = parent instanceof OCSymbol ? null : parent.getContainingPsiFile(project);
        class OffsetProcessor
        implements Processor {
            public boolean hasInlineDefinition = false;
            public boolean hasOutsideDefinition = false;
            public int maxOffset = 0;
            public PsiFile file = null;

            OffsetProcessor() {
            }

            @Nullable
            Pair<PsiFile, Integer> location() {
                return this.file == null ? null : Pair.create((Object)this.file, (Object)this.maxOffset);
            }

            boolean shouldBeInlined(@NotNull OCMembersContainer parent) {
                if (parent == null) {
                    OffsetProcessor.$$$reportNull$$$0(0);
                }
                return !this.hasOutsideDefinition && (this.hasInlineDefinition || !OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project));
            }

            public boolean process(Object o) {
                ProgressManager.checkCanceled();
                if (!(o instanceof OCSymbol)) {
                    return true;
                }
                OCSymbol symbol = (OCSymbol)o;
                if (symbol.isPredeclaration()) {
                    PsiFile definitionFile;
                    PsiElement definition;
                    OCFunctionSymbol funcSym;
                    if (topLevelFile != null && symbol.getContainingOCFile(project) != topLevelFile) {
                        return true;
                    }
                    OCSymbol definitionSymbol = symbol.getDefinitionSymbol(project);
                    if (definitionSymbol instanceof OCFunctionSymbol && (funcSym = (OCFunctionSymbol)definitionSymbol).isTemplateSymbol()) {
                        return true;
                    }
                    if (definitionSymbol != null && !definitionSymbol.getKind().isType() && (definition = definitionSymbol.locateDefinition(project)) != null && (definitionFile = definition.getContainingFile()) != null) {
                        if (this.file == null && OCCodeInsightUtil.isValid((PsiElement)definitionFile) && !definitionFile.getName().startsWith("moc_")) {
                            this.file = definitionFile;
                            this.hasOutsideDefinition = true;
                        }
                        if (this.file != null && this.file.equals(definitionFile)) {
                            this.maxOffset = Math.max(this.maxOffset, definition.getTextRange().getEndOffset());
                        }
                    }
                } else if (symbol instanceof OCFunctionSymbol) {
                    this.hasInlineDefinition = true;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$1OffsetProcessor", "shouldBeInlined"));
            }
        }
        OffsetProcessor processor2 = new OffsetProcessor();
        parent.processMembers(null, processor2);
        return new BasedOnExistingResult(processor2.shouldBeInlined(parent), processor2.location());
    }

    private static boolean canDefinitionsBePlacedToAssocFile(@NotNull OCMembersContainer parent, @NotNull Project project) {
        OCFile file;
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(71);
        }
        if (project == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(72);
        }
        if ((file = OCLanguageUtils.asOCFile(parent.getContainingPsiFile(project))) == null || !file.isHeader()) {
            return false;
        }
        OCFile assoc = file.getAssociatedFile();
        if (assoc == null || assoc.isHeader()) {
            return false;
        }
        return !(parent instanceof OCTemplateSymbol) || !((OCTemplateSymbol)((Object)parent)).isTemplateSymbol();
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(@NotNull OCCaretLocation location) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(73);
        }
        return location.getOffsetInFile() == null ? null : OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(location.getOffsetInFile(), location.getFile());
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(int originalOffset, @NotNull PsiFile file) {
        PsiElement atCaret;
        Document document;
        if (file == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(74);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) == null) {
            OCLog.LOG.warn("No document for " + file);
            return null;
        }
        PsiElement prev = null;
        for (PsiElement curr = atCaret = (PsiElement)ObjectUtils.notNull((Object)file.findElementAt(originalOffset), (Object)file); curr != null; curr = curr.getParent()) {
            if (curr instanceof OCCppNamespace || curr instanceof PsiFile) {
                int preferredOffset = -1;
                PsiElement context = null;
                if (curr instanceof OCCppNamespace && prev != null) {
                    boolean insideNamespaceHeader = false;
                    for (PsiElement nsChild = curr.getFirstChild(); nsChild != curr.getLastChild(); nsChild = nsChild.getNextSibling()) {
                        if (nsChild.equals(prev)) {
                            insideNamespaceHeader = true;
                        }
                        if (OCElementUtil.getElementType(nsChild) != OCLexerTokenTypes.LBRACE) continue;
                        if (!insideNamespaceHeader) break;
                        preferredOffset = nsChild.getTextRange().getEndOffset();
                        context = curr;
                        break;
                    }
                }
                if (context == null) {
                    boolean isInsideComment = prev instanceof PsiComment && originalOffset > prev.getTextRange().getStartOffset();
                    preferredOffset = (prev == atCaret || prev == null) && !isInsideComment ? originalOffset : prev.getTextRange().getEndOffset();
                    context = curr;
                }
                return new OCGenerateUtil.ReplacePosition(file, TextRange.from((int)preferredOffset, (int)0), context);
            }
            prev = curr;
        }
        return null;
    }

    @NotNull
    private static PsiElement defaultFallbackLocation(@NotNull PsiFile file, @Nullable PsiElement parentDefinition, @NotNull List<OCFunctionSymbol> functions) {
        if (file == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(75);
        }
        if (functions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(76);
        }
        int maxOffset = -1;
        OCFunctionDeclaration result = null;
        for (OCFunctionSymbol symbol : functions) {
            OCFunctionDeclaration definition = symbol.locateFunctionDefinition(file.getProject());
            if (definition == null) continue;
            int offset = definition.getTextRange().getEndOffset();
            if (!file.equals(definition.getContainingFile()) || offset <= maxOffset) continue;
            maxOffset = offset;
            result = definition;
        }
        if (result != null) {
            OCFunctionDeclaration oCFunctionDeclaration = result;
            if (oCFunctionDeclaration == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(77);
            }
            return oCFunctionDeclaration;
        }
        if (parentDefinition != null && file.equals(parentDefinition.getContainingFile())) {
            PsiElement psiElement = parentDefinition;
            if (psiElement == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(78);
            }
            return psiElement;
        }
        PsiFile psiFile = file;
        if (psiFile == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(79);
        }
        return psiFile;
    }

    private static int getInsertPositionForFunctionsInsideClass(@NotNull OCStructLike structDefinition, @NotNull OCCaretLocation location, @NotNull OCFunctionSymbol newFunction) {
        if (structDefinition == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(80);
        }
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(81);
        }
        if (newFunction == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(82);
        }
        int defaultOffset = OCNewCppFunctionsLocator.locateNewFunction(structDefinition, newFunction);
        if (location.getOffsetInFile() == null || !location.getFile().equals(structDefinition.getContainingFile())) {
            return defaultOffset;
        }
        int offset = location.getOffsetInFile();
        if (!OCNewCppFunctionsLocator.getValidLocationRange(structDefinition).contains(offset)) {
            return defaultOffset;
        }
        if (OCCppDefinitionsUtil.isLocationOutsideParent(location, structDefinition)) {
            return defaultOffset;
        }
        PsiElement elementToInsertAfter = null;
        boolean betweenVisibilityAndColon = false;
        for (PsiElement child = structDefinition.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (OCElementUtil.isVisibilityKeyword(child.getNode())) {
                betweenVisibilityAndColon = true;
            } else if (OCElementUtil.getElementType(child) == OCLexerTokenTypes.COLON) {
                betweenVisibilityAndColon = false;
            }
            if (betweenVisibilityAndColon || child.getTextRange().getEndOffset() < offset) continue;
            elementToInsertAfter = child;
            break;
        }
        if (elementToInsertAfter instanceof PsiWhiteSpace && elementToInsertAfter.getTextRange().contains(offset)) {
            return offset;
        }
        if (elementToInsertAfter != null) {
            return elementToInsertAfter.getTextRange().getEndOffset();
        }
        return defaultOffset;
    }

    private static boolean shouldRestoreVisibility(@NotNull OCStructLike definition, int pos, @NotNull OCVisibility initial, @Nullable OCVisibility lastNew) {
        if (definition == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(83);
        }
        if (initial == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(84);
        }
        if (initial == lastNew) {
            return false;
        }
        for (PsiElement child = definition.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getTextRange().getStartOffset() < pos) continue;
            if (child instanceof OCDeclaration) {
                return true;
            }
            if (OCVisibility.getVisibilityFromElement(child) == null) continue;
            return false;
        }
        return false;
    }

    private static boolean isLocationOutsideParent(@NotNull OCCaretLocation location, @Nullable PsiElement parentDefinition) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(85);
        }
        assert (location.getElement() != null);
        return !PsiTreeUtil.isAncestor((PsiElement)parentDefinition, (PsiElement)location.getElement(), (boolean)false);
    }

    private static boolean shouldGenerateOutsideDefinitionAtCaret(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(86);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(87);
        }
        if (location.getElement() == null) {
            return false;
        }
        Project project = location.getProject();
        if (!(parent instanceof OCSymbol)) {
            return !location.getFile().equals(parent.getContainingPsiFile(project)) || !OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project);
        }
        return OCCppDefinitionsUtil.isLocationOutsideParent(location, OCCppDefinitionsUtil.getParentDefinition(parent, project));
    }

    @NotNull
    private static PsiElement findInsertionParentInFile(OCFile file, OCNamespaceSymbol parent) {
        PsiElement namespacePsi;
        ArrayList<OCNamespaceSymbol> parentsPath = new ArrayList<OCNamespaceSymbol>();
        while (parent != null) {
            if (!(parent instanceof OCStructSymbol)) {
                parentsPath.add(0, parent);
            }
            parent = (OCNamespaceSymbol)parent.getParent();
        }
        OCNamespaceLikeSymbol current = file.getMembersContainer(false);
        for (OCNamespaceSymbol symbol : parentsPath) {
            final VirtualFile virtualFile = file.getContainingFile().getVirtualFile();
            CommonProcessors.FindFirstProcessor<OCNamespaceSymbol> finder = new CommonProcessors.FindFirstProcessor<OCNamespaceSymbol>(){

                protected boolean accept(OCNamespaceSymbol symbol) {
                    ProgressManager.checkCanceled();
                    return virtualFile != null && virtualFile.equals(symbol.getContainingFile());
                }
            };
            current.processMembers(symbol.getName(), new OCCommonProcessors.TypeFilteredProcessor((Processor<OCNamespaceSymbol>)finder, OCNamespaceSymbol.class));
            if (!finder.isFound()) break;
            current = (OCNamespaceLikeSymbol)finder.getFoundValue();
        }
        if (current instanceof OCNamespaceSymbol && (namespacePsi = ((OCNamespaceSymbol)current).locateDefinition(file.getProject())) != null) {
            PsiElement psiElement = namespacePsi;
            if (psiElement == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(88);
            }
            return psiElement;
        }
        OCFile oCFile = file;
        if (oCFile == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(89);
        }
        return oCFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 21, 22, 23, 24, 25, 26, 29, 40, 52, 53, 54, 60, 62, 77, 78, 79, 88, 89 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFunction";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 40: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 62: 
            case 77: 
            case 78: 
            case 79: 
            case 88: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funDefinition";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 20: 
            case 28: 
            case 56: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: 
            case 33: 
            case 36: 
            case 43: 
            case 48: 
            case 55: 
            case 58: 
            case 69: 
            case 71: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 31: 
            case 35: 
            case 41: 
            case 46: 
            case 57: 
            case 73: 
            case 81: 
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 32: 
            case 68: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: 
            case 37: 
            case 59: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinitions";
                break;
            }
            case 39: 
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlinePolicy";
                break;
            }
            case 42: 
            case 47: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structDefinition";
                break;
            }
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFunctions";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFunction";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "functionSignature";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldGenerateDefinitionsFor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionParent";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenerateDefinitionReplacements";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFunctionsReplacements";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutsideReplacements";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeReplacements";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultFallbackLocation";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "findInsertionParentInFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "functionSignature";
                break;
            }
            case 7: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 40: 
            case 52: 
            case 53: 
            case 54: 
            case 60: 
            case 62: 
            case 77: 
            case 78: 
            case 79: 
            case 88: 
            case 89: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCudaAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isOverrideSpecifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNoexceptSpecifier";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addTrailingMacroCalls";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionSpecification";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addNoexceptSpecifier";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addNoexceptExpressionText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addThrowText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateDefinitionsFor";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParent";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "shouldInlineNewDefinitions";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getOutsidePreferredPosition";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getGenerateDefinitionReplacements";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getNewFunctionsReplacements";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getParentDefinition";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getOutsideReplacements";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "mergeReplacements";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getFileToIncludeIfNeeded";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getBestLocationBasedOnExistingDefinitions";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "canDefinitionsBePlacedToAssocFile";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getCorrectOutsideInsertPositionNearby";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "defaultFallbackLocation";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getInsertPositionForFunctionsInsideClass";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestoreVisibility";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isLocationOutsideParent";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateOutsideDefinitionAtCaret";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 21, 22, 23, 24, 25, 26, 29, 40, 52, 53, 54, 60, 62, 77, 78, 79, 88, 89 -> new IllegalStateException(string);
        };
    }

    public static enum SHOULD_GENERATE_DEFINITION {
        NO,
        POSSIBLE,
        REQUIRED;

    }

    private static final class BasedOnExistingResult {
        public final boolean shouldInline;
        @Nullable
        public final Pair<PsiFile, Integer> outsideLocation;

        private BasedOnExistingResult(boolean inline, @Nullable Pair<PsiFile, Integer> location) {
            this.shouldInline = inline;
            this.outsideLocation = location;
            assert (this.outsideLocation == null || !this.shouldInline);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum InlinePolicy {
        INLINE{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                if (location == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (parent == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "location";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$InlinePolicy$1";
                objectArray[2] = "shouldInline";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        OUTSIDE{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                if (location == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (parent == null) {
                    2.$$$reportNull$$$0(1);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "location";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$InlinePolicy$2";
                objectArray[2] = "shouldInline";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        PREFERRED{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                if (location == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (parent == null) {
                    3.$$$reportNull$$$0(1);
                }
                return OCCppDefinitionsUtil.shouldInlineNewDefinitions(parent, location);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "location";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$InlinePolicy$3";
                objectArray[2] = "shouldInline";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        public abstract boolean shouldInline(@NotNull OCCaretLocation var1, @NotNull OCMembersContainer var2);

        public static InlinePolicy get(boolean inline) {
            return inline ? INLINE : OUTSIDE;
        }
    }
}

