/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.typing;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardBlockDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardOrDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardRepeatDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardSequenceDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardTokenDetector;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class OCBackwardStructureDetector {
    public boolean tryNext(@NotNull TokenIterator tokenIterator) {
        if (tokenIterator == null) {
            OCBackwardStructureDetector.$$$reportNull$$$0(0);
        }
        if (tokenIterator.atEnd()) {
            return false;
        }
        TokenIterator.Marker mark = tokenIterator.mark();
        if (!this.next(tokenIterator)) {
            mark.rollback();
            return false;
        }
        return true;
    }

    public abstract boolean next(@NotNull TokenIterator var1);

    public static OCBackwardStructureDetector token(IElementType ... types) {
        if (types == null) {
            OCBackwardStructureDetector.$$$reportNull$$$0(1);
        }
        return new OCBackwardTokenDetector(true, TokenSet.create((IElementType[])types));
    }

    public static OCBackwardStructureDetector tokenExcept(IElementType ... types) {
        if (types == null) {
            OCBackwardStructureDetector.$$$reportNull$$$0(2);
        }
        return new OCBackwardTokenDetector(false, TokenSet.create((IElementType[])types));
    }

    public static OCBackwardStructureDetector block(@NotNull IElementType leftBorder, @NotNull IElementType rightBorder) {
        if (leftBorder == null) {
            OCBackwardStructureDetector.$$$reportNull$$$0(3);
        }
        if (rightBorder == null) {
            OCBackwardStructureDetector.$$$reportNull$$$0(4);
        }
        return new OCBackwardBlockDetector(leftBorder, rightBorder);
    }

    public static OCBackwardStructureDetector sequence(OCBackwardStructureDetector ... sequence) {
        return new OCBackwardSequenceDetector(Arrays.asList(sequence));
    }

    public static OCBackwardStructureDetector or(OCBackwardStructureDetector ... variants) {
        if (variants == null) {
            OCBackwardStructureDetector.$$$reportNull$$$0(5);
        }
        return new OCBackwardOrDetector(Arrays.asList(variants));
    }

    public static OCBackwardStructureDetector repeat(@NotNull Cardinality cardinality, @NotNull OCBackwardStructureDetector detector) {
        if (cardinality == null) {
            OCBackwardStructureDetector.$$$reportNull$$$0(6);
        }
        if (detector == null) {
            OCBackwardStructureDetector.$$$reportNull$$$0(7);
        }
        return new OCBackwardRepeatDetector(cardinality, detector);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenIterator";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftBorder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightBorder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cardinality";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/typing/OCBackwardStructureDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryNext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "token";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tokenExcept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "block";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "or";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "repeat";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface TokenIterator {
        public Marker mark();

        public IElementType getTokenType();

        public boolean atEnd();

        public void retreat();

        public void skipWhitespaces();

        public static interface Marker {
            public void rollback();
        }
    }

    public static enum Cardinality {
        ONE_OR_MORE,
        ZERO_OR_MORE,
        MAYBE_ONE;

    }
}

