/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.editor.completion.FunctionInsertHandler;
import com.jetbrains.cidr.lang.editor.completion.MacroInsertHandler;
import com.jetbrains.cidr.lang.editor.completion.MethodInsertHandler;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.PropertyInsertHandler;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SymbolLookupBuilderUtil {
    public static final Key<Boolean> DONT_GO_NEXT_TEMPLATE = Key.create((String)"TEMPLATE_LOOKUP");

    private SymbolLookupBuilderUtil() {
    }

    @NotNull
    public static LookupElementBuilder forSymbol(@NotNull OCSymbol symbol, @NotNull String lookupString, @NotNull Project project) {
        if (symbol == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(0);
        }
        if (lookupString == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(2);
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)new OCSymbolNavigationItem(symbol, project), (String)lookupString);
        if (lookupElementBuilder == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(3);
        }
        return lookupElementBuilder;
    }

    public static LookupElementBuilder lookup(OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(4);
        }
        return SymbolLookupBuilderUtil.lookup(symbol, false, null, null, null, null, project);
    }

    public static LookupElement lookup(@NotNull OCSymbol symbol, @Nullable String qualifier, @Nullable OCObjectType receiverType, @Nullable PsiElement contextExpression, boolean isFromCurrentType, @Nullable OCSymbolGroupContext symbolContext, @NotNull Project project) {
        if (symbol == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(6);
        }
        LookupElementBuilder result = SymbolLookupBuilderUtil.lookup(symbol, false, qualifier, receiverType, contextExpression, symbolContext, project);
        OCCompletionPriority priority = isFromCurrentType ? OCCompletionPriority.HIGH_PRIORITY : null;
        return priority != null ? OCCompletionPriority.elementWithPriority((LookupElement)result, priority) : result;
    }

    public static LookupElementBuilder lookup(@NotNull OCSymbol symbol, @Nullable PsiElement contextExpression, @Nullable OCSymbolGroupContext symbolContext, @NotNull Project project) {
        if (symbol == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(8);
        }
        return SymbolLookupBuilderUtil.lookup(symbol.getName(), symbol, false, null, null, contextExpression, symbolContext, symbol.getIcon(project), project);
    }

    public static LookupElementBuilder lookup(@NotNull OCSymbol symbol, boolean insideSendMessage, @Nullable String qualifier, @Nullable OCObjectType receiverType, @Nullable PsiElement contextExpression, @Nullable OCSymbolGroupContext symbolContext, @NotNull Project project) {
        if (symbol == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(10);
        }
        return SymbolLookupBuilderUtil.lookup(symbol.getName(), symbol, insideSendMessage, qualifier, receiverType, contextExpression, symbolContext, symbol.getIcon(project), project);
    }

    @NotNull
    @NlsSafe
    private static String getMethodQualifier(@Nullable PsiElement contextExpression, @NotNull OCMethodSymbol method) {
        if (method == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(11);
        }
        if (contextExpression instanceof OCReferenceExpression) {
            if (method.isStatic()) {
                String string = "[" + method.getParent().getName();
                if (string == null) {
                    SymbolLookupBuilderUtil.$$$reportNull$$$0(12);
                }
                return string;
            }
            return "[self";
        }
        return "";
    }

    public static LookupElementBuilder lookup(@NotNull String name, @NotNull OCSymbol symbol, boolean insideSendMessage, @Nullable String qualifier, @Nullable OCObjectType receiverType, @Nullable PsiElement contextExpression, @Nullable OCSymbolGroupContext symbolContext, @Nullable Icon icon, @NotNull Project project) {
        int spaceIndex;
        if (name == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(13);
        }
        if (symbol == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(15);
        }
        if ((spaceIndex = name.indexOf(32)) >= 0) {
            name = name.substring(spaceIndex + 1);
        }
        boolean deprecated = symbol.isDeprecated() || !OCResolveUtil.isSymbolAvailable(symbol, contextExpression);
        LookupElementBuilder answer = SymbolLookupBuilderUtil.forSymbol(symbol, name, project).withIcon(icon).withStrikeoutness(deprecated);
        PsiFile ocFile = contextExpression == null ? null : contextExpression.getContainingFile();
        InsertHandler<LookupElement> insertHandler = SymbolLookupBuilderUtil.findInsertHandler(symbol, insideSendMessage, qualifier, contextExpression, symbolContext, project);
        if (insertHandler != null) {
            answer = answer.withInsertHandler(insertHandler);
        }
        OCSymbolKind symbolKind = symbol.getKind();
        if (symbol instanceof OCClassSymbol) {
            VirtualFile file = symbol.getContainingFile();
            if (!(file == null || ocFile instanceof PsiFileImpl && ((PsiFileImpl)ocFile).getContentElementType() == OCElementTypes.TYPE_CODE_FRAGMENT)) {
                answer = answer.withTypeText(file.getName(), true);
            }
        } else if (symbol instanceof OCMacroSymbol) {
            OCMacroSymbol macroSymbol;
            IElementType type;
            OCDirective context = (OCDirective)PsiTreeUtil.getContextOfType((PsiElement)contextExpression, (Class[])new Class[]{OCDirective.class});
            IElementType iElementType = type = context != null ? context.getHeaderToken().getNode().getElementType() : null;
            if (type != OCLexerTokenTypes.IFDEF_DIRECTIVE && type != OCLexerTokenTypes.IFNDEF_DIRECTIVE && type != OCLexerTokenTypes.ELIFDEF_DIRECTIVE && type != OCLexerTokenTypes.ELIFNDEF_DIRECTIVE && type != OCLexerTokenTypes.UNDEF_DIRECTIVE && (macroSymbol = (OCMacroSymbol)symbol).hasParameterList()) {
                answer = answer.withTailText(macroSymbol.getParametersSignature());
            }
        } else if (symbol instanceof OCMemberSymbol || symbol instanceof OCDeclaratorSymbol || symbol instanceof OCFunctionSymbol) {
            OCType resolved;
            OCType type;
            if (symbol instanceof OCMethodSymbol) {
                StringBuilder presentable;
                OCMethodSymbol method = (OCMethodSymbol)symbol;
                if (qualifier == null) {
                    qualifier = SymbolLookupBuilderUtil.getMethodQualifier(contextExpression, method);
                }
                if (!(presentable = new StringBuilder(qualifier)).isEmpty()) {
                    presentable.append(' ');
                }
                presentable.append(method.getName());
                if (!qualifier.isEmpty()) {
                    presentable.append(']');
                }
                answer = answer.withPresentableText(presentable.toString()).withLookupString(presentable.toString());
                type = method.getReturnType(receiverType, project);
            } else if (symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
                type = functionSymbol.getType().getReturnType();
                answer = answer.withTailText(functionSymbol.getParametersSignature(project));
            } else {
                OCSymbol parent;
                if (symbol instanceof OCThisSelfSuperSymbol && ((OCThisSelfSuperSymbol)symbol).isKeywordLike()) {
                    answer = answer.bold();
                }
                type = symbol.getType();
                if (!(symbolKind != OCSymbolKind.ENUM_CONST || (parent = ((OCSymbolWithParent)symbol).getParent()) instanceof OCStructSymbol && ((OCStructSymbol)parent).isEnumClass())) {
                    type = OCUnknownType.INSTANCE;
                }
            }
            if (type != OCUnknownType.INSTANCE && (resolved = type.accept(new OCTypeParameterResolveVisitor(ocFile))) != null && contextExpression != null) {
                answer = answer.withTypeText(resolved.getName(contextExpression));
            }
        }
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static InsertHandler<LookupElement> findInsertHandler(@NotNull OCSymbol symbol, boolean insideSendMessage, @Nullable String qualifier, @Nullable PsiElement contextExpression, @Nullable OCSymbolGroupContext symbolContext, @NotNull Project project) {
        if (symbol == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(16);
        }
        if (project == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(17);
        }
        PsiFile ocFile = contextExpression == null ? null : contextExpression.getContainingFile();
        OCSymbolKind symbolKind = symbol.getKind();
        if (symbol instanceof OCClassSymbol) {
            PsiElement parent;
            VirtualFile file = symbol.getContainingFile();
            if (file == null || ocFile instanceof PsiFileImpl && ((PsiFileImpl)ocFile).getContentElementType() == OCElementTypes.TYPE_CODE_FRAGMENT) return null;
            PsiElement psiElement = parent = contextExpression != null ? contextExpression.getContext() : null;
            if (contextExpression instanceof OCDeclarator) {
                PsiElement possibleType = contextExpression.getPrevSibling();
                if (!(possibleType instanceof OCTypeElement) || !possibleType.getText().isEmpty()) return null;
                return new ClassInsertHandler(symbolContext);
            }
            if (!(parent instanceof OCTypeElement) && (!(parent instanceof OCReferenceExpression) || !(parent.getParent() instanceof OCParenthesizedExpression) && !(parent.getParent() instanceof OCExpressionStatement))) return new WithAutoImportFixHandler(symbolContext, symbolKind != OCSymbolKind.PROTOCOL);
            PsiElement superParent = parent.getContext();
            if (superParent instanceof OCSendMessageExpression || superParent instanceof OCProtocolExpression || superParent instanceof OCTemplateArgumentList) return new WithAutoImportFixHandler(symbolContext, symbolKind != OCSymbolKind.PROTOCOL);
            return new ClassInsertHandler(symbolContext);
        }
        if (symbolKind.isType()) {
            return new TypeInsertHandler(symbol, contextExpression);
        }
        if (symbolKind == OCSymbolKind.NAMESPACE || symbolKind == OCSymbolKind.NAMESPACE_ALIAS) {
            return new NamespaceInsertHandler(contextExpression);
        }
        if (symbol instanceof OCMacroSymbol) {
            IElementType type;
            OCDirective macroContext = (OCDirective)PsiTreeUtil.getContextOfType((PsiElement)contextExpression, (Class[])new Class[]{OCDirective.class});
            IElementType iElementType = type = macroContext != null ? macroContext.getHeaderToken().getNode().getElementType() : null;
            if (type == OCLexerTokenTypes.IFDEF_DIRECTIVE || type == OCLexerTokenTypes.IFNDEF_DIRECTIVE || type == OCLexerTokenTypes.ELIFDEF_DIRECTIVE || type == OCLexerTokenTypes.ELIFNDEF_DIRECTIVE || type == OCLexerTokenTypes.UNDEF_DIRECTIVE) return null;
            OCMacroSymbol macroSymbol = (OCMacroSymbol)symbol;
            return new MacroInsertHandler(macroSymbol);
        }
        if (!(symbol instanceof OCMemberSymbol) && !(symbol instanceof OCDeclaratorSymbol) && !(symbol instanceof OCFunctionSymbol)) return null;
        if (symbol instanceof OCMethodSymbol) {
            OCMethodSymbol method = (OCMethodSymbol)symbol;
            if (qualifier == null) {
                qualifier = SymbolLookupBuilderUtil.getMethodQualifier(contextExpression, method);
            }
            String insertQualifier = insideSendMessage && qualifier.startsWith("[") ? qualifier.substring(1) : qualifier;
            return new MethodInsertHandler(method, contextExpression, insideSendMessage, insertQualifier);
        }
        if (symbol instanceof OCFunctionSymbol) {
            return CallableInsertUtils.createHandler((OCFunctionSymbol)symbol, contextExpression, project);
        }
        if (contextExpression instanceof OCQualifiedExpression && (symbolKind == OCSymbolKind.STRUCT_FIELD || symbolKind == OCSymbolKind.ENUM_CONST || symbolKind.isFunction())) {
            return new StructFieldHandler(symbol, contextExpression);
        }
        if (!(symbol instanceof OCPropertySymbol)) return new WithAutoImportFixHandler(symbolContext, false);
        return new PropertyInsertHandler(contextExpression, (OCPropertySymbol)symbol, symbolContext);
    }

    private static void fixImportsAtCaret(@NotNull InsertionContext context, OCSymbolGroupContext symbolGroupContext) {
        if (context == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(18);
        }
        OCImportSymbolFix.fixAfterCompletionAtCaret(context.getEditor(), context.getFile(), symbolGroupContext);
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/completion/SymbolLookupBuilderUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/SymbolLookupBuilderUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forSymbol";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forSymbol";
                break;
            }
            case 3: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lookup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMethodQualifier";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findInsertHandler";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fixImportsAtCaret";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12 -> new IllegalStateException(string);
        };
    }

    private static final class ClassInsertHandler
    implements InsertHandler<LookupElement> {
        private final OCSymbolGroupContext mySymbolContext;

        private ClassInsertHandler(OCSymbolGroupContext symbolContext) {
            this.mySymbolContext = symbolContext;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            int pos;
            char completionChar;
            if (context == null) {
                ClassInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                ClassInsertHandler.$$$reportNull$$$0(1);
            }
            if ((completionChar = context.getCompletionChar()) == '.' || completionChar == ']') {
                SymbolLookupBuilderUtil.fixImportsAtCaret(context, this.mySymbolContext);
                return;
            }
            String text = context.getDocument().getText();
            for (pos = context.getTailOffset(); pos < text.length() && Character.isSpaceChar(text.charAt(pos)); ++pos) {
            }
            if (pos < text.length() && (text.charAt(pos) == '*' || text.charAt(pos) == '<')) {
                SymbolLookupBuilderUtil.fixImportsAtCaret(context, this.mySymbolContext);
                return;
            }
            StringBuilder insertion = new StringBuilder(completionChar == '*' ? "" : "*");
            OCCodeStyleSettings customSettings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getFile(), OCCodeStyleSettings.class);
            insertion.setLength(0);
            if (customSettings.SPACE_BEFORE_POINTER_IN_DECLARATION) {
                insertion.append(' ');
            }
            if (completionChar != '*') {
                insertion.append('*');
                if (customSettings.SPACE_AFTER_POINTER_IN_DECLARATION) {
                    insertion.append(' ');
                } else {
                    OCTypedHandlerDelegate.overTypeNextStar(1);
                }
            }
            if (completionChar == ' ') {
                context.setAddCompletionChar(false);
            }
            SymbolLookupBuilderUtil.fixImportsAtCaret(context, this.mySymbolContext);
            context.getDocument().insertString(context.getTailOffset(), (CharSequence)insertion.toString());
            context.getEditor().getCaretModel().moveCaretRelatively(insertion.length(), 0, false, false, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/editor/completion/SymbolLookupBuilderUtil$ClassInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class WithAutoImportFixHandler
    implements InsertHandler<LookupElement> {
        private final OCSymbolGroupContext mySymbolContext;
        private final boolean myInsertSpace;

        private WithAutoImportFixHandler(OCSymbolGroupContext symbolContext, boolean insertSpace) {
            this.mySymbolContext = symbolContext;
            this.myInsertSpace = insertSpace;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                WithAutoImportFixHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                WithAutoImportFixHandler.$$$reportNull$$$0(1);
            }
            SymbolLookupBuilderUtil.fixImportsAtCaret(context, this.mySymbolContext);
            if (this.myInsertSpace && context.getCompletionChar() != ' ') {
                char ch;
                CharSequence text;
                int offset = context.getTailOffset();
                if (offset < (text = context.getDocument().getCharsSequence()).length() && (ch = text.charAt(offset)) != ' ' && ch != '>' && ch != '<') {
                    context.getDocument().insertString(offset, (CharSequence)" ");
                }
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/editor/completion/SymbolLookupBuilderUtil$WithAutoImportFixHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TypeInsertHandler
    implements InsertHandler<LookupElement> {
        private final OCSymbol mySymbol;
        private final PsiElement myContext;

        private TypeInsertHandler(OCSymbol symbol, PsiElement context) {
            this.mySymbol = symbol;
            this.myContext = context;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                TypeInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                TypeInsertHandler.$$$reportNull$$$0(1);
            }
            Document document = context.getDocument();
            Editor editor = context.getEditor();
            CharSequence text = document.getCharsSequence();
            int tailOffset = context.getTailOffset();
            if (!(this.myContext.getParent().getParent() instanceof OCCppNewExpression)) {
                OCCodeStyleSettings customSettings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getFile(), OCCodeStyleSettings.class);
                if (customSettings.SPACE_BEFORE_POINTER_IN_DECLARATION) {
                    OCType type;
                    boolean insert = true;
                    if (this.mySymbol.getKind() != OCSymbolKind.ENUM && this.mySymbol instanceof OCNamespaceSymbol || this.mySymbol instanceof OCTypeParameterSymbol) {
                        insert = false;
                    }
                    if (this.mySymbol.getKind() == OCSymbolKind.TYPEDEF && (type = this.mySymbol.getType().resolve(OCResolveContext.forSymbol(this.mySymbol, context.getProject()))) instanceof OCStructType) {
                        insert = false;
                    }
                    if (this.mySymbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL) {
                        insert = false;
                    }
                    if (insert && tailOffset < text.length()) {
                        char ch = text.charAt(tailOffset);
                        if (ch == ')' || ch == ']') {
                            return;
                        }
                        if (ch != ' ' && ch != '\t' && context.getCompletionChar() != ' ') {
                            document.insertString(tailOffset, (CharSequence)" ");
                        }
                        editor.getCaretModel().moveToOffset(tailOffset + 1);
                    }
                }
            }
            PsiElement parent = this.myContext.getParent();
            if (this.mySymbol.getKind().isStructLike() && OCCodeInsightUtil.isInPlainOldC(this.myContext) && parent != null && !(parent instanceof OCStructLike)) {
                document.insertString(context.getStartOffset(), (CharSequence)(this.mySymbol.getKind().getStructKeyword() + " "));
            }
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
            OCImportSymbolFix.fixAfterCompletionAtCaret(context.getEditor(), context.getFile(), this.mySymbol);
            PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/editor/completion/SymbolLookupBuilderUtil$TypeInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class NamespaceInsertHandler
    implements InsertHandler<LookupElement> {
        private final PsiElement myContextExpression;

        private NamespaceInsertHandler(PsiElement contextExpression) {
            this.myContextExpression = contextExpression;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            int pos;
            OCCppUsingStatement usingStatement;
            if (context == null) {
                NamespaceInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                NamespaceInsertHandler.$$$reportNull$$$0(1);
            }
            if ((usingStatement = (OCCppUsingStatement)PsiTreeUtil.getContextOfType((PsiElement)this.myContextExpression, (Class[])new Class[]{OCCppUsingStatement.class})) != null && usingStatement.isNamespaceUsing() || OCElementUtil.getElementType((PsiElement)this.myContextExpression.getContainingFile()) == OCElementTypes.QUALIFIED_ID_CODE_FRAGMENT) {
                return;
            }
            PsiElement parent = this.myContextExpression.getParent();
            if (parent instanceof OCCppNamespace) {
                return;
            }
            if (parent instanceof OCCppNamespaceAlias) {
                return;
            }
            char completionChar = context.getCompletionChar();
            String text = context.getDocument().getText();
            for (pos = context.getTailOffset(); pos < text.length() && Character.isSpaceChar(text.charAt(pos)); ++pos) {
            }
            if (pos >= text.length() || text.charAt(pos) != ':') {
                String INSERTION = completionChar == ':' ? ":" : "::";
                context.getDocument().insertString(context.getTailOffset(), (CharSequence)INSERTION);
                context.getEditor().getCaretModel().moveCaretRelatively(INSERTION.length(), 0, false, false, true);
                OCTypedHandlerDelegate.overTypeNextColon(INSERTION.length());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/editor/completion/SymbolLookupBuilderUtil$NamespaceInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StructFieldHandler
    implements InsertHandler<LookupElement> {
        private final OCSymbol mySymbol;
        private final PsiElement myContextExpression;

        StructFieldHandler(OCSymbol symbol, PsiElement contextExpression) {
            this.mySymbol = symbol;
            this.myContextExpression = contextExpression;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                StructFieldHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                StructFieldHandler.$$$reportNull$$$0(1);
            }
            FunctionInsertHandler.changeQualifyingTokenIfNeeded(context, this.myContextExpression, item);
            OCImportSymbolFix.fixAfterCompletionAtCaret(context.getEditor(), context.getFile(), this.mySymbol);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/editor/completion/SymbolLookupBuilderUtil$StructFieldHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OCEnumConstInsertHandler
    implements InsertHandler<LookupElement> {
        private final OCDeclaratorSymbol mySymbol;
        private final PsiElement myContextExpression;

        public OCEnumConstInsertHandler(OCDeclaratorSymbol symbol, PsiElement contextExpression) {
            this.mySymbol = symbol;
            this.myContextExpression = contextExpression;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                OCEnumConstInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                OCEnumConstInsertHandler.$$$reportNull$$$0(1);
            }
            if (this.myContextExpression instanceof OCReferenceExpression) {
                OCReferenceElement element = ((OCReferenceExpression)this.myContextExpression).getReferenceElement();
                OCResolveContext resolveContext = OCResolveContext.forPsi((PsiElement)context.getFile());
                OCQualifiedName name = OCBindUtil.getShortestPossibleName(this.mySymbol.getResolvedQualifiedName(resolveContext), element, (OCSymbol)this.mySymbol);
                if (name != null) {
                    Document document = context.getDocument();
                    document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)name.getFullName(resolveContext));
                    PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)context.getProject());
                    pdm.commitDocument(document);
                }
            }
            OCImportSymbolFix.fixAfterCompletionAtCaret(context.getEditor(), context.getFile(), this.mySymbol);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/editor/completion/SymbolLookupBuilderUtil$OCEnumConstInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

