/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCLexerWithDirectives;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesNoCommitDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.editor.OCCommenter;
import com.jetbrains.cidr.lang.lexer.OCTokenTypeProvider;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class OCEnterInBlockCommentHandler
extends EnterHandlerDelegateAdapter {
    private static final OCCommenter COMMENTER = new OCCommenter();

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(4);
        }
        Language language = EnterHandler.getLanguage((DataContext)dataContext);
        if (!LanguageUtils.getInstance().isSupportedLanguage(language)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return this.doProcessEnter(file, editor, caretOffsetRef);
    }

    @NotNull
    protected EnterHandlerDelegate.Result doProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef) {
        int caretOffset;
        HighlighterIterator it;
        if (file == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(6);
        }
        if (caretOffsetRef == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(7);
        }
        if (this.shouldBeProcessed(it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((Editor)editor, (int)(caretOffset = ((Integer)caretOffsetRef.get()).intValue())))) {
            Document document = editor.getDocument();
            int commentStart = it.getStart();
            String commentText = document.getCharsSequence().subSequence(commentStart, it.getEnd()).toString();
            if (commentText.endsWith("*/") && (it.getEnd() <= caretOffset || it.getStart() >= caretOffset)) {
                EnterHandlerDelegate.Result result = EnterHandlerDelegate.Result.Continue;
                if (result == null) {
                    OCEnterInBlockCommentHandler.$$$reportNull$$$0(8);
                }
                return result;
            }
            int caretInStringOffset = caretOffset - commentStart;
            String commentBeforeCaret = commentText.substring(0, caretInStringOffset);
            StringBuilder indent = new StringBuilder("\n");
            indent.append(OCEnterInBlockCommentHandler.getIndentLine(editor, caretOffset));
            int newCaretPosition = -1;
            int insertCommentSuffixPosition = -1;
            if (commentBeforeCaret.indexOf(10) == -1) {
                Pair<Integer, Integer> info = this.generateComment(file, editor, caretOffset, commentText, caretInStringOffset, indent);
                insertCommentSuffixPosition = (Integer)info.first;
                newCaretPosition = (Integer)info.second;
            } else {
                caretOffset = OCEnterInBlockCommentHandler.processEnterInsideComment(commentBeforeCaret, caretInStringOffset, commentText, caretOffset, indent);
            }
            this.flushChanges(file, editor, caretOffset, commentText, commentStart, caretInStringOffset, insertCommentSuffixPosition, indent);
            if (newCaretPosition == -1) {
                newCaretPosition = caretOffset + indent.length();
            }
            editor.getCaretModel().moveToOffset(newCaretPosition);
            EnterHandlerDelegate.Result result = EnterHandlerDelegate.Result.Stop;
            if (result == null) {
                OCEnterInBlockCommentHandler.$$$reportNull$$$0(9);
            }
            return result;
        }
        EnterHandlerDelegate.Result result = EnterHandlerDelegate.Result.Continue;
        if (result == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(10);
        }
        return result;
    }

    protected boolean shouldBeProcessed(HighlighterIterator it) {
        return !it.atEnd() && it.getTokenType() == OCCommenter.COMMENT_TOKEN_TYPE;
    }

    protected Pair<Integer, Integer> generateComment(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int caretInStringOffset, @NotNull StringBuilder indent) {
        if (file == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(12);
        }
        if (commentText == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(13);
        }
        if (indent == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(14);
        }
        indent.append("* ");
        int defaultCaretPosition = -1;
        int insertCommentSuffixPosition = -1;
        if (OCEnterInBlockCommentHandler.needCommentSuffixGeneration(file, editor, caretOffset, commentText, ch -> Character.isJavaIdentifierPart(ch.charValue()) || "{}".indexOf(ch.charValue()) >= 0)) {
            int lineEnd = commentText.indexOf(10) != -1 ? commentText.indexOf(10) : commentText.length();
            insertCommentSuffixPosition = caretOffset + indent.length() + (lineEnd - caretInStringOffset);
        }
        return Pair.create((Object)insertCommentSuffixPosition, (Object)defaultCaretPosition);
    }

    protected void flushChanges(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int commentStart, int caretInStringOffset, int insertCommentSuffixPosition, @NotNull StringBuilder indent) {
        if (file == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(16);
        }
        if (commentText == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(17);
        }
        if (indent == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(18);
        }
        Document document = editor.getDocument();
        if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            int deleteTo = caretInStringOffset;
            while (deleteTo < commentText.length() && "\t ".indexOf(commentText.charAt(deleteTo)) >= 0) {
                ++deleteTo;
                --insertCommentSuffixPosition;
            }
            document.deleteString(caretOffset, commentStart + deleteTo);
        }
        document.insertString(caretOffset, (CharSequence)indent);
        if (insertCommentSuffixPosition >= 0) {
            StringBuilder insert = new StringBuilder("\n").append(OCEnterInBlockCommentHandler.getIndentLine(editor, caretOffset)).append("*/");
            document.insertString(insertCommentSuffixPosition, (CharSequence)insert);
        }
    }

    public static boolean needCommentSuffixGeneration(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset, @NotNull String commentText, @NotNull Predicate<Character> isNotAcceptedSymbol) {
        char ch;
        if (file == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(20);
        }
        if (commentText == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(21);
        }
        if (isNotAcceptedSymbol == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(22);
        }
        if (OCEnterInBlockCommentHandler.isCommentComplete(file, editor, caretOffset, commentText, (CodeDocumentationAwareCommenter)COMMENTER)) {
            return false;
        }
        for (int offset = 0; offset < commentText.length() && (ch = commentText.charAt(offset)) != '\n'; ++offset) {
            if (!isNotAcceptedSymbol.test(Character.valueOf(ch))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCommentComplete(@NotNull PsiFile file, @NotNull Editor editor, int caretOffset, @NotNull String commentText, @NotNull CodeDocumentationAwareCommenter commenter) {
        JavaLikeQuoteHandler javaLikeQuoteHandler;
        boolean docComment;
        String expectedCommentEnd;
        if (file == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(24);
        }
        if (commentText == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(25);
        }
        if (commenter == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(26);
        }
        String string = expectedCommentEnd = (docComment = commentText.startsWith(commenter.getDocumentationCommentPrefix())) ? commenter.getDocumentationCommentSuffix() : commenter.getBlockCommentSuffix();
        if (!commentText.endsWith(expectedCommentEnd)) {
            return false;
        }
        OCLexerWithDirectives lexer = OCLexerWithDirectives.createDefault((CidrTokenTypeProvider)OCTokenTypeProvider.INSTANCE);
        String commentPrefix = docComment ? commenter.getDocumentationCommentPrefix() : commenter.getBlockCommentPrefix();
        lexer.start((CharSequence)commentText, commentPrefix == null ? 0 : commentPrefix.length(), commentText.length());
        QuoteHandler fileTypeHandler = TypedHandler.getQuoteHandler((PsiFile)file, (Editor)editor);
        JavaLikeQuoteHandler javaLikeQuoteHandler2 = javaLikeQuoteHandler = fileTypeHandler instanceof JavaLikeQuoteHandler ? (JavaLikeQuoteHandler)fileTypeHandler : null;
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            if (javaLikeQuoteHandler != null && javaLikeQuoteHandler.getStringTokenTypes() != null && javaLikeQuoteHandler.getStringTokenTypes().contains(tokenType)) {
                String text = commentText.substring(lexer.getTokenStart(), lexer.getTokenEnd());
                HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((Editor)editor, (int)caretOffset);
                int endOffset = it.getEnd();
                if (text.endsWith(expectedCommentEnd) && endOffset < file.getTextLength() && file.getText().charAt(endOffset) == '\n') {
                    return true;
                }
            }
            if (tokenType == commenter.getDocumentationCommentTokenType() || tokenType == commenter.getBlockCommentTokenType()) {
                return false;
            }
            if (tokenType == commenter.getLineCommentTokenType() && commentPrefix != null && lexer.getTokenText().contains(commentPrefix)) {
                return false;
            }
            if (lexer.getTokenEnd() == commentText.length()) {
                if (tokenType == commenter.getLineCommentTokenType()) {
                    String prefix = commenter.getLineCommentPrefix();
                    lexer.start((CharSequence)commentText, lexer.getTokenStart() + (prefix == null ? 0 : prefix.length()), commentText.length());
                    lexer.advance();
                    continue;
                }
                return true;
            }
            lexer.advance();
        }
        return false;
    }

    private static int processEnterInsideComment(@NotNull String commentBeforeCaret, int caretInStringOffset, @NotNull String commentText, int caretOffset, @NotNull StringBuilder indent) {
        int offsetInCommentString;
        if (commentBeforeCaret == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(27);
        }
        if (commentText == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(28);
        }
        if (indent == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(29);
        }
        char ch = ' ';
        StringBuilder prevIndent = new StringBuilder("\n");
        for (offsetInCommentString = commentBeforeCaret.lastIndexOf(10) + 1; offsetInCommentString < caretInStringOffset; ++offsetInCommentString) {
            char c = commentText.charAt(offsetInCommentString);
            ch = c;
            if ("\t ".indexOf(c) < 0) break;
            prevIndent.append(ch);
        }
        if (indent.length() < prevIndent.length()) {
            indent.setLength(0);
            indent.append((CharSequence)prevIndent);
        }
        if (ch == '*') {
            int size;
            indent.append('*');
            if (++offsetInCommentString == caretInStringOffset && offsetInCommentString < commentText.length()) {
                ch = commentText.charAt(offsetInCommentString);
                if ("\t ".indexOf(ch) >= 0) {
                    ++caretOffset;
                    indent.append(ch);
                }
            } else {
                while (offsetInCommentString < caretInStringOffset && "\t ".indexOf(ch = commentText.charAt(offsetInCommentString)) >= 0) {
                    ++offsetInCommentString;
                    indent.append(ch);
                }
            }
            if ((size = indent.length()) != 0 && indent.charAt(size - 1) == '*') {
                indent.append(' ');
            }
        }
        return caretOffset;
    }

    @NotNull
    public static String getFirstCommentLineIndentFromContext(@NotNull Editor editor, int caretOffset) {
        if (editor == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(30);
        }
        String indentSpace = "";
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((Editor)editor, (int)caretOffset);
        it.retreat();
        if (!it.atEnd() && OCLexerTokenTypes.WHITESPACES.contains(it.getTokenType())) {
            String whiteSpaces = editor.getDocument().getCharsSequence().subSequence(it.getStart(), it.getEnd()).toString();
            int lineStart = whiteSpaces.lastIndexOf(10);
            if (lineStart >= 0) {
                indentSpace = whiteSpaces.substring(lineStart + 1);
            } else if (it.getStart() == 0) {
                indentSpace = whiteSpaces;
            }
        }
        String string = indentSpace;
        if (string == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String customSettingsIndent(@NotNull Editor editor) {
        if (editor == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(32);
        }
        if (((OCCodeStyleSettings)CodeStyle.getSettings((Editor)editor).getCustomSettings(OCCodeStyleSettings.class)).INDENT_BLOCK_COMMENT) {
            return " ";
        }
        return "";
    }

    @NotNull
    public static String getIndentLine(@NotNull Editor editor, int caretOffset) {
        if (editor == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(33);
        }
        String string = OCEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext(editor, caretOffset) + OCEnterInBlockCommentHandler.customSettingsIndent(editor);
        if (string == null) {
            OCEnterInBlockCommentHandler.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 31, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvanceRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCEnterInBlockCommentHandler";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 14: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isNotAcceptedSymbol";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentBeforeCaret";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCEnterInBlockCommentHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doProcessEnter";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstCommentLineIndentFromContext";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doProcessEnter";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 31: 
            case 34: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateComment";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "flushChanges";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "needCommentSuffixGeneration";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isCommentComplete";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processEnterInsideComment";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFirstCommentLineIndentFromContext";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "customSettingsIndent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getIndentLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 31, 34 -> new IllegalStateException(string);
        };
    }
}

