/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.CTestingBundle;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestInfoForFile;
import com.jetbrains.cidr.execution.testing.CidrTestInfoSerializer;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestFrameworkBase<TEST_OBJECT>
extends OCTestFramework {
    private final Key<CidrTestListUpdater> myFrameworkKeyForVFUpdater;
    private final Key<Boolean> myUpdateMarker;
    protected final Collection<Class<? extends PsiElement>> myTestHolderClass;
    @NlsSafe
    @NotNull
    protected final String myFrameworkId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CidrTestListUpdater getUpdater(@NotNull Project project) {
        CidrTestListUpdater updater;
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(0);
        }
        if ((updater = (CidrTestListUpdater)this.myFrameworkKeyForVFUpdater.get((UserDataHolder)project)) == null) {
            Key<CidrTestListUpdater> key = this.myFrameworkKeyForVFUpdater;
            synchronized (key) {
                updater = (CidrTestListUpdater)this.myFrameworkKeyForVFUpdater.get((UserDataHolder)project);
                if (updater == null) {
                    updater = this.createUpdater(project);
                    this.myFrameworkKeyForVFUpdater.set((UserDataHolder)project, (Object)updater);
                }
            }
        }
        CidrTestListUpdater cidrTestListUpdater = updater;
        if (cidrTestListUpdater == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(1);
        }
        return cidrTestListUpdater;
    }

    @Override
    public boolean hasSuspendedTestIndex(@NotNull PsiFile file) {
        CidrTestListUpdater updater;
        if (file == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(2);
        }
        return (updater = this.getUpdater(file.getProject())).isSuspended() && !updater.isVisible();
    }

    @Override
    public void resumeTestIndex(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(3);
        }
        this.getUpdater(file.getProject()).resume();
    }

    @NotNull
    protected CidrTestListUpdater createUpdater(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(4);
        }
        return new CidrTestListUpdater(this, project);
    }

    public boolean canStartIndexing(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(5);
        }
        return FileSymbolTablesCache.getInstance(project).isUpToDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropUpdater(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(6);
        }
        Key<CidrTestListUpdater> key = this.myFrameworkKeyForVFUpdater;
        synchronized (key) {
            this.myFrameworkKeyForVFUpdater.set((UserDataHolder)project, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CidrTestInfoForFile getTestInfo(@NotNull PsiFile file) {
        CidrTestInfoForFile infoForFile;
        HashMap<VirtualFile, CidrTestInfoForFile> vf2info;
        if (file == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(7);
        }
        Project project = file.getProject();
        if (!this.isPotentialTestHolderFile(file) || !FileSymbolTablesCache.areSymbolsLoaded(project)) {
            CidrTestInfoForFile cidrTestInfoForFile = CidrTestInfoForFile.EMPTY_FILE_INFO;
            if (cidrTestInfoForFile == null) {
                CidrTestFrameworkBase.$$$reportNull$$$0(8);
            }
            return cidrTestInfoForFile;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (!this.isPotentialValidTestHolder(project).value((Object)virtualFile)) {
            CidrTestInfoForFile cidrTestInfoForFile = CidrTestInfoForFile.EMPTY_FILE_INFO;
            if (cidrTestInfoForFile == null) {
                CidrTestFrameworkBase.$$$reportNull$$$0(9);
            }
            return cidrTestInfoForFile;
        }
        HashMap<VirtualFile, CidrTestInfoForFile> hashMap = vf2info = this.getIndexedTests(project);
        synchronized (hashMap) {
            infoForFile = vf2info.get(virtualFile);
        }
        long fileVersion = this.getFileVersion(file);
        if (infoForFile == null || fileVersion != infoForFile.getFileVersion()) {
            CidrTestListUpdater updater = this.getUpdater(project);
            if (!OCTestExecution.canWaitInThisThread()) {
                updater.scheduleUpdate(virtualFile);
                CidrTestInfoForFile cidrTestInfoForFile = infoForFile == null ? CidrTestInfoForFile.EMPTY_FILE_INFO : infoForFile;
                if (cidrTestInfoForFile == null) {
                    CidrTestFrameworkBase.$$$reportNull$$$0(10);
                }
                return cidrTestInfoForFile;
            }
            CidrTestInfoForFile newInfoForFile = new CidrTestInfoForFile(fileVersion, this.createFrameworkVersionDirectly(file));
            HashMap<VirtualFile, CidrTestInfoForFile> hashMap2 = vf2info;
            synchronized (hashMap2) {
                this.copyDirty(newInfoForFile, infoForFile);
                vf2info.put(virtualFile, newInfoForFile);
                updater.incTestInfoVersion();
            }
            CidrTestInfoForFile cidrTestInfoForFile = newInfoForFile;
            if (cidrTestInfoForFile == null) {
                CidrTestFrameworkBase.$$$reportNull$$$0(11);
            }
            return cidrTestInfoForFile;
        }
        CidrTestInfoForFile cidrTestInfoForFile = infoForFile;
        if (cidrTestInfoForFile == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(12);
        }
        return cidrTestInfoForFile;
    }

    protected abstract long getFileVersion(@NotNull PsiFile var1);

    protected void copyDirty(@NotNull CidrTestInfoForFile dst, @Nullable CidrTestInfoForFile src) {
        if (dst == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(13);
        }
    }

    protected void initInfo(@NotNull PsiFile file, @NotNull CidrTestInfoForFile newTestInfo) {
        if (file == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(14);
        }
        if (newTestInfo == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(15);
        }
    }

    protected void indexingScheduled(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(16);
        }
    }

    protected void indexingFinished(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(17);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean consumeTestInfo(@NotNull Project project, @NotNull Iterator<VirtualFile> pfile, @Nullable SearchScope scope, @NotNull Processor<? super Pair<PsiFile, CidrTestInfoForFile>> processor2) throws IndexNotReadyException {
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(18);
        }
        if (pfile == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(19);
        }
        if (processor2 == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(20);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        boolean needBulkUpdate = !OCTestExecution.canWaitInThisThread();
        HashSet<VirtualFile> updateList = needBulkUpdate ? new HashSet<VirtualFile>() : null;
        try {
            while (pfile.hasNext()) {
                PsiFile psiFile;
                ProgressManager.checkCanceled();
                VirtualFile file = pfile.next();
                if (!file.isValid() || scope != null && !scope.contains(file) || (psiFile = psiManager.findFile(file)) == null || !this.isPotentialTestHolderFile(psiFile)) continue;
                try {
                    CidrTestInfoForFile info;
                    if (needBulkUpdate) {
                        this.myUpdateMarker.set((UserDataHolder)file, (Object)Boolean.FALSE);
                    }
                    if ((info = this.getTestInfo(psiFile)).getFrameworkVersion() == CidrTestFrameworkVersion.NOT_AVAILABLE || processor2.process((Object)Pair.create((Object)psiFile, (Object)((Object)info)))) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (ProcessCanceledException ce) {
                    if (needBulkUpdate) throw ce;
                    pfile.hasNext();
                    CidrTestListUpdater.log("re-schedule after pause/write-action cancel: ", file);
                    this.getUpdater(project).scheduleUpdate(file);
                    throw ce;
                }
                finally {
                    if (!needBulkUpdate) continue;
                    Boolean needUpdate = (Boolean)this.myUpdateMarker.get((UserDataHolder)file);
                    if (needUpdate == Boolean.TRUE) {
                        updateList.add(file);
                    }
                    this.myUpdateMarker.set((UserDataHolder)file, null);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (needBulkUpdate) {
                this.getUpdater(project).scheduleBulkUpdate(updateList);
            }
        }
    }

    public boolean markOnlyNotScheduleForUpdate(@NotNull VirtualFile fileWithOutdatedTestInfo) {
        if (fileWithOutdatedTestInfo == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(21);
        }
        if (this.myUpdateMarker.get((UserDataHolder)fileWithOutdatedTestInfo) != null) {
            this.myUpdateMarker.set((UserDataHolder)fileWithOutdatedTestInfo, (Object)Boolean.TRUE);
            return true;
        }
        return false;
    }

    public boolean isPotentialTestHolderFile(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(22);
        }
        return LanguageUtils.getInstance().isSupportedFile(file) && CidrTestFrameworkBase.canContainsTest((PsiFileSystemItem)file);
    }

    protected Condition<VirtualFile> isPotentialValidTestHolder(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(23);
        }
        return sourceOrHeader -> sourceOrHeader != null && sourceOrHeader.isValid() && (!OCTestExecution.canWaitInThisThread() || OCSearchScope.getProjectSourcesScope(project).contains(sourceOrHeader));
    }

    public Condition<VirtualFile> isPotentialTestHolderRoot(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(24);
        }
        return maybeSource -> OCRootKind.getRootKind(maybeSource, project) == OCRootKind.Root;
    }

    public HashMap<VirtualFile, CidrTestInfoForFile> getIndexedTests(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(25);
        }
        return this.getUpdater((Project)project).myIndexedTests;
    }

    @NotNull
    @NlsSafe
    public String getFrameworkId() {
        String string = this.myFrameworkId;
        if (string == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(26);
        }
        return string;
    }

    public String toString() {
        return this.getFrameworkId();
    }

    public void prepareTestIndexLookup(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(27);
        }
    }

    @SafeVarargs
    protected CidrTestFrameworkBase(@NlsSafe @NotNull String testFrameworkId, Class<? extends PsiElement> ... testHolderClass) {
        if (testFrameworkId == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(28);
        }
        if (testHolderClass == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(29);
        }
        this.myFrameworkId = testFrameworkId;
        this.myTestHolderClass = Arrays.asList(testHolderClass);
        this.myFrameworkKeyForVFUpdater = Key.create((String)(this.getFrameworkId() + " updater"));
        this.myUpdateMarker = Key.create((String)(this.getFrameworkId() + " marker"));
    }

    @Contract(value="null -> null")
    public TEST_OBJECT getTestObject(@Nullable PsiElement element) {
        if (element != null && this.isAvailable(element.getContainingFile()) && this.canBeTestHolder(element)) {
            this.prepareTestIndexLookup(element.getContainingFile());
            return this.extractTest(element);
        }
        return null;
    }

    @Nullable
    public TEST_OBJECT findTestObject(@NotNull PsiElement element) {
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(30);
        }
        PsiElement prev = element;
        for (PsiElement current = element; current != null; current = current.getParent()) {
            TEST_OBJECT testObject;
            OCMacroRange call;
            if (current instanceof PsiFile) {
                return (TEST_OBJECT)(prev instanceof PsiWhiteSpace || prev instanceof PsiComment || prev instanceof PsiFile || this.isNeutralNode(prev) ? this.createFileTestObjectIfPossible((PsiFile)current) : null);
            }
            PsiElement id = CidrTestFrameworkBase.getId(current);
            if (id instanceof OCMacroForeignLeafElement && (call = OCElementUtil.getRangeInMacroCall(id)) != null) {
                current = call.getMacroCall();
            }
            if ((testObject = this.getTestObject(current)) != null) {
                return testObject;
            }
            if (this.isScopeDelimiter(current)) continue;
            prev = current;
        }
        return null;
    }

    @Contract(pure=true)
    protected boolean isScopeDelimiter(@NotNull PsiElement element) {
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(31);
        }
        return element instanceof OCCppNamespace;
    }

    @Contract(pure=true)
    protected boolean isNeutralNode(@NotNull PsiElement element) {
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(32);
        }
        return element instanceof OCDirective || element.getParent() instanceof OCCppNamespace && (element == ((OCCppNamespace)element.getParent()).getNameIdentifier() || PsiTreeUtil.findSiblingBackward((PsiElement)element, (IElementType)OCLexerTokenTypes.LBRACE, (boolean)true, null) == null);
    }

    @Nullable
    protected abstract TEST_OBJECT createFileTestObjectIfPossible(@NotNull PsiFile var1);

    public static void checkPrecalculatedSymbols(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(33);
        }
        if (FileSymbolTablesCache.areSymbolsLoaded(project)) {
            return;
        }
        throw IndexNotReadyException.create();
    }

    @Contract(pure=true)
    public boolean canBeTestHolder(@NotNull PsiElement element) {
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(34);
        }
        for (Class<? extends PsiElement> aClass : this.myTestHolderClass) {
            if (!aClass.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract TEST_OBJECT extractTest(@NotNull PsiElement var1);

    @Override
    @Contract(value="null->true")
    public boolean isAvailable(@Nullable PsiFile file) {
        return file == null || this.getFrameworkVersion(file) != CidrTestFrameworkVersion.NOT_AVAILABLE;
    }

    @NotNull
    public CidrTestFrameworkVersion getFrameworkVersion(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(35);
        }
        CidrTestFrameworkVersion cidrTestFrameworkVersion = this.getTestInfo(file).getFrameworkVersion();
        if (cidrTestFrameworkVersion == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(36);
        }
        return cidrTestFrameworkVersion;
    }

    @NotNull
    protected abstract CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile var1);

    @NotNull
    protected static CidrTestFrameworkVersion getFrameworkVersionUsingImportedMacro(@NotNull PsiFile file, @NonNls @NotNull String macroName) {
        if (file == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(37);
        }
        if (macroName == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(38);
        }
        Project project = file.getProject();
        CidrTestFrameworkBase.checkPrecalculatedSymbols(project);
        Ref symbolFromFrameworkWasFound = new Ref((Object)CidrTestFrameworkVersion.NOT_AVAILABLE);
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<? super OCSymbol>)((Processor)symbol -> {
            ProgressManager.checkCanceled();
            if (symbol instanceof OCMacroSymbol && OCFileSymbols.isSymbolImported(OCLanguageUtils.asOCFile(file), symbol)) {
                symbolFromFrameworkWasFound.set((Object)CidrTestFrameworkVersion.DEFAULT);
                return false;
            }
            return true;
        }), macroName, true);
        CidrTestFrameworkVersion cidrTestFrameworkVersion = (CidrTestFrameworkVersion)((Object)symbolFromFrameworkWasFound.get());
        if (cidrTestFrameworkVersion == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(39);
        }
        return cidrTestFrameworkVersion;
    }

    @NonNls
    @NotNull
    public abstract String getPatternSeparatorInCommandLine();

    @NotNull
    public static <T extends OCTestFramework> T findExtension(@NotNull Class<T> extClass) {
        if (extClass == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(40);
        }
        OCTestFramework oCTestFramework = (OCTestFramework)OCTestFramework.EP_NAME.findExtensionOrFail(extClass);
        if (oCTestFramework == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(41);
        }
        return (T)oCTestFramework;
    }

    public static boolean isMacroInjectedIdOwner(@NotNull PsiElement element) {
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(42);
        }
        if (element.getTextLength() == 0) {
            return true;
        }
        PsiElement identifier = CidrTestFrameworkBase.getId(element);
        return identifier == null || identifier.getTextLength() == 0;
    }

    @Nullable
    public static PsiElement getId(@NotNull PsiElement element) {
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(43);
        }
        if (element instanceof OCFunctionDeclaration) {
            return ((OCFunctionDeclaration)element).getNameIdentifier();
        }
        if (element instanceof PsiNameIdentifierOwner) {
            return ((PsiNameIdentifierOwner)element).getNameIdentifier();
        }
        if (element instanceof OCMacroCall) {
            return element.getFirstChild();
        }
        return null;
    }

    @Contract(value="!null,_,_->!null")
    public static <T> T getFromSymbols(@Nullable T defaultIfSymbolsNotReady, Project project, @NotNull Computable<? extends T> computable) {
        if (computable == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(44);
        }
        ProgressIndicator upperIndicator = ProgressManager.getInstance().getProgressIndicator();
        try {
            CidrTestFrameworkBase.checkPrecalculatedSymbols(project);
            if (ApplicationManager.getApplication().isDispatchThread()) {
                return (T)OCLongActionUtil.execWithTimeoutProgressInDispatch((String)CTestingBundle.message("test.ui.progress", new Object[0]), (Project)project, computable);
            }
            Ref result = new Ref();
            if (!ProgressIndicatorUtils.runWithWriteActionPriority(() -> result.set(computable.compute()), (ProgressIndicator)(upperIndicator == null ? new EmptyProgressIndicator() : new SensitiveProgressWrapper(upperIndicator)))) {
                throw new ProcessCanceledException();
            }
            return (T)result.get();
        }
        catch (ProcessCanceledException pce) {
            if (upperIndicator != null) {
                throw pce;
            }
            return defaultIfSymbolsNotReady;
        }
        catch (IndexNotReadyException ignore) {
            if (upperIndicator != null) {
                upperIndicator.cancel();
            }
            return defaultIfSymbolsNotReady;
        }
    }

    public void writeTestInfo(@NotNull Kryo kryo, @NotNull Output output, @NotNull CidrTestInfoForFile testInfo) {
        if (kryo == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(45);
        }
        if (output == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(46);
        }
        if (testInfo == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(47);
        }
    }

    public void readTestInfo(@NotNull Kryo kryo, @NotNull Input input, @NotNull CidrTestInfoForFile initTestInfo, @NotNull PsiFile fileWithTest) {
        if (kryo == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(48);
        }
        if (input == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(49);
        }
        if (initTestInfo == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(50);
        }
        if (fileWithTest == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(51);
        }
    }

    public void registerSerializers(@NotNull CidrTestInfoSerializer serializer) {
        if (serializer == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(52);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 9, 10, 11, 12, 26, 36, 39, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 26: 
            case 36: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestFrameworkBase";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 14: 
            case 22: 
            case 27: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTestInfo";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pfile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithOutdatedTestInfo";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkId";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testHolderClass";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extClass";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kryo";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testInfo";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initTestInfo";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithTest";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestFrameworkBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdater";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestInfo";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkId";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkVersion";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkVersionUsingImportedMacro";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUpdater";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 26: 
            case 36: 
            case 39: 
            case 41: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasSuspendedTestIndex";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resumeTestIndex";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUpdater";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canStartIndexing";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dropUpdater";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyDirty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initInfo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "indexingScheduled";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "indexingFinished";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "consumeTestInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "markOnlyNotScheduleForUpdate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPotentialTestHolderFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isPotentialValidTestHolder";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isPotentialTestHolderRoot";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedTests";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestIndexLookup";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findTestObject";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isScopeDelimiter";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isNeutralNode";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkPrecalculatedSymbols";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "canBeTestHolder";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkVersion";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkVersionUsingImportedMacro";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isMacroInjectedIdOwner";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getFromSymbols";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "writeTestInfo";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "readTestInfo";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "registerSerializers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 9, 10, 11, 12, 26, 36, 39, 41 -> new IllegalStateException(string);
        };
    }
}

