/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen.comment;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.lang.documentation.CidrVirtualDocComment;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DxCommentProcessorUtil {
    @NotNull
    public static List<PsiComment> getCommentScope(@NotNull PsiElement elt) {
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(0);
        }
        return DxCommentProcessorUtil.findOCCommentForElementInternal(elt, false);
    }

    @NotNull
    public static List<PsiComment> findOCCommentFor(@Nullable PsiElement element) {
        if (element instanceof CidrVirtualDocComment) {
            List<PsiComment> list = ((CidrVirtualDocComment)element).getComments();
            if (list == null) {
                DxCommentProcessorUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (element instanceof PsiComment) {
            List<PsiComment> list = Collections.singletonList((PsiComment)element);
            if (list == null) {
                DxCommentProcessorUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<PsiComment> comments = DxCommentProcessorUtil.findOCCommentForElementInternal(element, true);
        if (comments.isEmpty() && element instanceof OCSymbolDeclarator) {
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            Project project = element.getProject();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol(project);
            }
            if (symbol != null) {
                PsiElement associatedElement = symbol.locateDefinition(project);
                comments.addAll(DxCommentProcessorUtil.findOCCommentForElementInternal(associatedElement, true));
            }
        }
        List<PsiComment> list = comments;
        if (list == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<PsiComment> findOCCommentForElementInternal(@Nullable PsiElement elt, boolean doxygenOnly) {
        if (elt instanceof OCDeclarator) {
            elt = elt.getParent();
        }
        if (elt instanceof OCStructLike) {
            elt = PsiTreeUtil.findFirstParent((PsiElement)elt, p -> p instanceof OCDeclaration);
        }
        if (elt == null) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                DxCommentProcessorUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (elt.getParent() instanceof OCProperty) {
            elt = elt.getParent();
        }
        if (elt.getParent() instanceof OCDeclarationStatement) {
            elt = elt.getParent();
        }
        if (elt.getContainingFile() == null) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                DxCommentProcessorUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        LinkedList<PsiComment> comments = new LinkedList<PsiComment>();
        DxCommentProcessorUtil.findPrevComments(elt, comments, doxygenOnly);
        DxCommentProcessorUtil.findInnerComments(elt, comments, doxygenOnly);
        DxCommentProcessorUtil.findNextComments(elt, comments, doxygenOnly);
        LinkedList<PsiComment> linkedList = comments;
        if (linkedList == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(6);
        }
        return linkedList;
    }

    private static void findPrevComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments, boolean doxygenOnly) {
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(7);
        }
        if (comments == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(8);
        }
        PsiElement initElement = elt.getFirstChild();
        boolean hasNewLineGap = false;
        for (PsiElement element = elt.getPrevSibling(); element != null; element = element.getPrevSibling()) {
            if (element instanceof PsiWhiteSpace) {
                hasNewLineGap = !doxygenOnly && StringUtil.countNewLines((CharSequence)element.getText()) > 1;
                continue;
            }
            if (element instanceof OCMacroCall) continue;
            if (!(element instanceof PsiComment) || hasNewLineGap && !DoxygenUtil.isDoxygenComment((PsiComment)element)) break;
            PsiElement prevSibling = element.getPrevSibling();
            if (!DoxygenUtil.isDoxygenComment((PsiComment)element) && prevSibling != null && (!(prevSibling instanceof PsiWhiteSpace) || StringUtil.countNewLines((CharSequence)prevSibling.getText()) <= 0)) break;
            initElement = element;
        }
        if (initElement != null) {
            ArrayList allComments = new ArrayList();
            ArrayList withArrow = new ArrayList();
            DxCommentProcessorUtil.findNextCommentsInternal(initElement, allComments, doxygenOnly, false, true);
            DxCommentProcessorUtil.findNextCommentsInternal(initElement, withArrow, true, true, true);
            allComments.removeAll(withArrow);
            for (PsiComment comment : allComments) {
                if (doxygenOnly && !DoxygenUtil.isDoxygenComment(comment)) continue;
                comments.add(comment);
            }
        }
    }

    private static void findInnerComments(@NotNull PsiElement elt, @NotNull List<? super PsiComment> comments, boolean doxygenOnly) {
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(9);
        }
        if (comments == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(10);
        }
        if (elt instanceof OCClassDeclaration || elt instanceof OCMethod) {
            return;
        }
        ArrayList firstComments = new ArrayList();
        DxCommentProcessorUtil.findNextCommentsInternal(elt.getFirstChild(), firstComments, false, false, true);
        List innerComments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)elt, PsiComment.class);
        for (PsiComment comment : innerComments) {
            if (firstComments.contains(comment) || doxygenOnly && !DoxygenUtil.isDoxygenComment(comment)) continue;
            comments.add((PsiComment)comment);
        }
    }

    private static void findNextComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments, boolean doxygenOnly) {
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(11);
        }
        if (comments == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(12);
        }
        if (elt instanceof OCParameterDeclaration || elt.getParent() instanceof OCEnum) {
            DxCommentProcessorUtil.findNextCommentsForCommaSeparatedSequence(elt, comments);
        } else {
            DxCommentProcessorUtil.findNextCommentsInternal(elt.getNextSibling(), comments, doxygenOnly, true, false);
        }
    }

    private static void findNextCommentsInternal(@Nullable PsiElement elt, @NotNull List<? super PsiComment> comments, boolean doxygenOnly, boolean withArrowOnly, boolean findPrevComments) {
        if (comments == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(13);
        }
        if (elt == null) {
            return;
        }
        boolean hasNewLineGape = false;
        PsiElement next = elt;
        while (next != null) {
            if (next instanceof PsiWhiteSpace) {
                hasNewLineGape = !doxygenOnly && StringUtil.countNewLines((CharSequence)next.getText()) > (findPrevComments ? 1 : 0);
            } else {
                if (!(next instanceof PsiComment)) break;
                PsiComment comment = (PsiComment)next;
                if (!doxygenOnly) {
                    if (hasNewLineGape && !(findPrevComments ? DoxygenUtil.isDoxygenComment(comment) : DoxygenUtil.hasArrow(comment)) || !findPrevComments && DoxygenUtil.isDoxygenComment(comment) && !DoxygenUtil.hasArrow(comment)) break;
                    comments.add((PsiComment)comment);
                } else if (DoxygenUtil.isDoxygenComment(comment)) {
                    if (withArrowOnly && DoxygenUtil.hasArrow(comment)) {
                        if (DoxygenUtil.isDoxygenEOLComment(comment.getText())) {
                            EOLCommentPack pack = new EOLCommentPack(comment);
                            comments.addAll(pack.getComments());
                            next = pack.getLastComment();
                        } else {
                            comments.add((PsiComment)comment);
                        }
                    } else {
                        if (withArrowOnly) break;
                        comments.add((PsiComment)comment);
                    }
                } else if (withArrowOnly) break;
            }
            next = PsiTreeUtil.nextLeaf((PsiElement)next);
        }
    }

    private static void findNextCommentsForCommaSeparatedSequence(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        if (elt == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(14);
        }
        if (comments == null) {
            DxCommentProcessorUtil.$$$reportNull$$$0(15);
        }
        boolean waitForArrow = false;
        PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)elt);
        while (next != null) {
            if (!(next instanceof PsiWhiteSpace)) {
                if (next instanceof LeafElement && ((LeafElement)next).getElementType() == OCLexerTokenTypes.COMMA) {
                    waitForArrow = true;
                } else {
                    PsiComment comment;
                    if (!(next instanceof PsiComment) || !DoxygenUtil.isDoxygenComment(comment = (PsiComment)next) || waitForArrow && !DoxygenUtil.hasArrow(comment)) break;
                    if (DoxygenUtil.isDoxygenEOLComment(comment.getText())) {
                        EOLCommentPack pack = new EOLCommentPack(comment);
                        comments.addAll(pack.getComments());
                        next = pack.getLastComment();
                    } else {
                        comments.add(comment);
                    }
                }
            }
            next = PsiTreeUtil.nextLeaf((PsiElement)next);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessorUtil";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessorUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findOCCommentFor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findOCCommentForElementInternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommentScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findPrevComments";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findInnerComments";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNextComments";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findNextCommentsInternal";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findNextCommentsForCommaSeparatedSequence";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static class EOLCommentPack {
        private final List<PsiComment> comments;

        EOLCommentPack(@NotNull PsiComment EOLComment) {
            if (EOLComment == null) {
                EOLCommentPack.$$$reportNull$$$0(0);
            }
            this.comments = new ArrayList<PsiComment>();
            assert (DoxygenUtil.isDoxygenEOLComment(EOLComment.getText()));
            this.comments.add(EOLComment);
            EOLCommentPack.processEOLCommentPack(EOLComment, this.comments);
        }

        public List<PsiComment> getComments() {
            return this.comments;
        }

        @NotNull
        public PsiComment getLastComment() {
            assert (!this.comments.isEmpty());
            PsiComment psiComment = this.comments.get(this.comments.size() - 1);
            if (psiComment == null) {
                EOLCommentPack.$$$reportNull$$$0(1);
            }
            return psiComment;
        }

        private static void processEOLCommentPack(@NotNull PsiComment EOLComment, @NotNull List<PsiComment> pack) {
            PsiDocumentManager manager;
            Document document;
            if (EOLComment == null) {
                EOLCommentPack.$$$reportNull$$$0(2);
            }
            if (pack == null) {
                EOLCommentPack.$$$reportNull$$$0(3);
            }
            if ((document = (manager = PsiDocumentManager.getInstance((Project)EOLComment.getProject())).getDocument(EOLComment.getContainingFile())) == null) {
                return;
            }
            int startOffset = EOLComment.getTextOffset();
            int lineStartOffset = startOffset - document.getLineStartOffset(document.getLineNumber(startOffset));
            for (PsiElement next = EOLComment.getNextSibling(); next != null && (next instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)next.getText()) == 1 || next instanceof PsiComment && EOLCommentPack.processEOLComment((PsiComment)next, document, lineStartOffset, pack)); next = next.getNextSibling()) {
            }
        }

        private static boolean processEOLComment(@NotNull PsiComment comment, @NotNull Document document, int offset, @NotNull List<PsiComment> pack) {
            int startOffset;
            int lineStartOffset;
            if (comment == null) {
                EOLCommentPack.$$$reportNull$$$0(4);
            }
            if (document == null) {
                EOLCommentPack.$$$reportNull$$$0(5);
            }
            if (pack == null) {
                EOLCommentPack.$$$reportNull$$$0(6);
            }
            if (DoxygenUtil.isDoxygenEOLComment(comment.getText()) && offset == (lineStartOffset = (startOffset = comment.getTextOffset()) - document.getLineStartOffset(document.getLineNumber(startOffset)))) {
                pack.add(comment);
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "EOLComment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessorUtil$EOLCommentPack";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pack";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/doxygen/comment/DxCommentProcessorUtil$EOLCommentPack";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLastComment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processEOLCommentPack";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processEOLComment";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

