/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.DxEnterInBlockCommentHandler;
import com.jetbrains.cidr.doxygen.DxLanguage;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.settings.CidrCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public final class DxEnterInLineCommentHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiElement psiAtOffset;
        Language language;
        if (file == null) {
            DxEnterInLineCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            DxEnterInLineCommentHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            DxEnterInLineCommentHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            DxEnterInLineCommentHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            DxEnterInLineCommentHandler.$$$reportNull$$$0(4);
        }
        if (!((language = EnterHandler.getLanguage((DataContext)dataContext)) instanceof DxLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiFile topFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        Editor topEditor = InjectedLanguageUtil.getTopLevelEditor((Editor)editor);
        int caretOffset = topEditor.getCaretModel().getOffset();
        if (topFile == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = topEditor.getDocument();
        PsiDocumentManager.getInstance((Project)topFile.getProject()).commitDocument(document);
        PsiElement element = topFile.findElementAt(caretOffset);
        PsiElement psiElement = psiAtOffset = element instanceof PsiWhiteSpace ? element.getPrevSibling() : element;
        if (DxEnterInLineCommentHandler.shouldBeProcessed(document, psiAtOffset, caretOffset)) {
            String text = document.getText();
            if (psiAtOffset instanceof PsiComment) {
                PsiComment comment = (PsiComment)psiAtOffset;
                if (DoxygenUtil.isDoxygenEOLComment(psiAtOffset.getText())) {
                    String commentText = comment.getText();
                    String prefix = DxEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext(topEditor, caretOffset) + commentText.substring(0, 3);
                    int caretInComment = caretOffset - comment.getTextRange().getStartOffset();
                    StringBuilder result = new StringBuilder();
                    Project project = topEditor.getProject();
                    if (project == null) {
                        return EnterHandlerDelegate.Result.Continue;
                    }
                    int newCaretPosition = caretOffset;
                    if (commentText.length() == 3 && !DoxygenUtil.hasNextDocCommentSibling(comment) && comment instanceof PsiDocCommentBase) {
                        PsiElement owner = ((PsiDocCommentBase)comment).getOwner();
                        String tagPrefix = DxEnterInLineCommentHandler.getTagPrefix(topFile);
                        result.append(DxEnterInBlockCommentHandler.addBriefIfNeeded(topEditor, tagPrefix));
                        newCaretPosition += result.length();
                        DxEnterInBlockCommentHandler.generateDocComment(owner, prefix, tagPrefix, result);
                        if (!result.isEmpty()) {
                            result.insert(0, ' ');
                            ++newCaretPosition;
                        }
                    } else if (DxEnterInBlockCommentHandler.countWS(commentText, caretInComment) < commentText.length()) {
                        result.append("\n").append(prefix);
                        if (DoxygenUtil.hasArrow(comment)) {
                            result.append("<");
                        }
                        if (text.charAt(caretOffset) != ' ') {
                            result.append(" ");
                        } else {
                            ++newCaretPosition;
                        }
                        newCaretPosition += result.length();
                    } else {
                        return EnterHandlerDelegate.Result.Continue;
                    }
                    if (result.isEmpty()) {
                        return EnterHandlerDelegate.Result.Continue;
                    }
                    document.insertString(caretOffset, (CharSequence)result.toString());
                    topEditor.getCaretModel().moveToOffset(newCaretPosition);
                    return EnterHandlerDelegate.Result.Stop;
                }
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean shouldBeProcessed(Document document, PsiElement psiAtOffset, int caretOffset) {
        return psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset && caretOffset < document.getTextLength() && OCElementUtil.getElementType(psiAtOffset.getParent()) != OCElementTypes.PRAGMA && OCElementUtil.getElementType(PsiTreeUtil.skipWhitespacesBackward((PsiElement)psiAtOffset)) != OCElementTypes.DIRECTIVE;
    }

    private static String getTagPrefix(@NotNull PsiFile refFile) {
        if (refFile == null) {
            DxEnterInLineCommentHandler.$$$reportNull$$$0(5);
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)refFile, OCCodeStyleSettings.class);
        return settings.TAG_PREFIX_OF_LINE_COMMENT == CidrCodeStyleSettings.DocTagPrefix.AT ? "@" : "\\";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/doxygen/DxEnterInLineCommentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getTagPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

