/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerexperience.cloudcode.intellij.auth;

import androidx.annotation.OpenForTesting;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.ApplicationDefaultCredential;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.GoogleLoginCredential;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.IntellijLoginClient;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J\u0006\u0010\u001b\u001a\u00020\u0017J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0006\u0010\u001f\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\u000f\u001a^\u0012(\u0012&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000e0\u000e \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\u0011 \u0012*.\u0012(\u0012&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000e0\u000e \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/OAuthDataStore;", "", "intellijLoginClient", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/IntellijLoginClient;", "<init>", "(Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/IntellijLoginClient;)V", "logger", "Ljava/util/logging/Logger;", "gson", "Lcom/google/gson/Gson;", "commonDir", "Ljava/nio/file/Path;", "ownerReadWrite", "", "Ljava/nio/file/attribute/PosixFilePermission;", "permissions", "Ljava/nio/file/attribute/FileAttribute;", "", "kotlin.jvm.PlatformType", "credentialFile", "Ljava/io/File;", "adcCredentialFile", "saveOAuthData", "", "googleLoginCredential", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/GoogleLoginCredential;", "loadOAuthData", "clearStoredOAuthData", "stageAdc", "applicationDefaultCredential", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/ApplicationDefaultCredential;", "deleteAdc", "java.com.google.cloud.developerexperience.cloudcode.intellij.auth_google_auth_intellij_lib"})
@OpenForTesting
public class OAuthDataStore {
    @NotNull
    private final IntellijLoginClient intellijLoginClient;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Gson gson;
    @NotNull
    private final Path commonDir;
    @NotNull
    private final Set<PosixFilePermission> ownerReadWrite;
    private final FileAttribute<Set<PosixFilePermission>> permissions;
    @NotNull
    private final File credentialFile;
    @NotNull
    private final File adcCredentialFile;

    public OAuthDataStore(@NotNull IntellijLoginClient intellijLoginClient) {
        Intrinsics.checkNotNullParameter((Object)intellijLoginClient, (String)"intellijLoginClient");
        this.intellijLoginClient = intellijLoginClient;
        Logger logger = Logger.getLogger(this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.gson = new Gson();
        this.commonDir = this.intellijLoginClient.getCredentialStoragePath();
        PosixFilePermission[] posixFilePermissionArray = new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE};
        this.ownerReadWrite = SetsKt.setOf((Object[])posixFilePermissionArray);
        this.permissions = PosixFilePermissions.asFileAttribute(this.ownerReadWrite);
        this.credentialFile = new File(this.commonDir.toFile(), "credentials.json");
        this.adcCredentialFile = new File(this.commonDir.toFile(), "application_default_credentials.json");
    }

    public final synchronized void saveOAuthData(@NotNull GoogleLoginCredential googleLoginCredential) {
        Intrinsics.checkNotNullParameter((Object)googleLoginCredential, (String)"googleLoginCredential");
        try {
            String jsonString = this.gson.toJson((Object)googleLoginCredential);
            Files.createDirectories(this.commonDir, new FileAttribute[0]);
            if (!this.credentialFile.exists()) {
                Path path;
                if (!SystemUtils.IS_OS_WINDOWS) {
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{this.permissions};
                    path = Files.createFile(this.credentialFile.toPath(), fileAttributeArray);
                } else {
                    path = Files.createFile(this.credentialFile.toPath(), new FileAttribute[0]);
                }
            }
            Intrinsics.checkNotNull((Object)jsonString);
            FilesKt.writeText$default((File)this.credentialFile, (String)jsonString, null, (int)2, null);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to save credential data to file", e);
        }
    }

    @Nullable
    public final synchronized GoogleLoginCredential loadOAuthData() {
        GoogleLoginCredential googleLoginCredential;
        if (!this.credentialFile.exists()) {
            return null;
        }
        try {
            String jsonString = new String(ByteStreamsKt.readBytes((InputStream)new FileInputStream(this.credentialFile)), Charsets.UTF_8);
            googleLoginCredential = (GoogleLoginCredential)this.gson.fromJson(jsonString, GoogleLoginCredential.class);
        }
        catch (Exception e) {
            FilesKt.writeText$default((File)this.credentialFile, (String)"", null, (int)2, null);
            googleLoginCredential = null;
        }
        return googleLoginCredential;
    }

    public final synchronized void clearStoredOAuthData() {
        if (this.credentialFile.exists()) {
            FilesKt.writeText$default((File)this.credentialFile, (String)"", null, (int)2, null);
        }
    }

    @OpenForTesting
    public synchronized void stageAdc(@NotNull ApplicationDefaultCredential applicationDefaultCredential) {
        Intrinsics.checkNotNullParameter((Object)applicationDefaultCredential, (String)"applicationDefaultCredential");
        try {
            String jsonString = this.gson.toJson((Object)applicationDefaultCredential);
            Files.createDirectories(this.commonDir, new FileAttribute[0]);
            if (!this.adcCredentialFile.exists()) {
                Path path;
                if (!SystemUtils.IS_OS_WINDOWS) {
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{this.permissions};
                    path = Files.createFile(this.adcCredentialFile.toPath(), fileAttributeArray);
                } else {
                    path = Files.createFile(this.adcCredentialFile.toPath(), new FileAttribute[0]);
                }
            }
            Intrinsics.checkNotNull((Object)jsonString);
            FilesKt.writeText$default((File)this.adcCredentialFile, (String)jsonString, null, (int)2, null);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed to save application default credential data to file", e);
        }
    }

    public final synchronized void deleteAdc() {
        if (this.adcCredentialFile.exists()) {
            this.adcCredentialFile.delete();
        }
    }
}

