/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0010J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/impl/projectlevelman/VcsDefaultMappingDetector;", "", "project", "Lcom/intellij/openapi/project/Project;", "rootChecker", "Lcom/intellij/openapi/vcs/VcsRootChecker;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/VcsRootChecker;)V", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "checkedDirs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "detectProjectMappings", "", "projectRoots", "", "mappedDirs", "detectVcsForProjectRoot", "projectRoot", "isUnderVcsRoot", "file", "isVcsRoot", "isUnderProject", "f", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsDefaultMappingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDefaultMappingUtils.kt\ncom/intellij/openapi/vcs/impl/projectlevelman/VcsDefaultMappingDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,109:1\n1251#2,2:110\n*S KotlinDebug\n*F\n+ 1 VcsDefaultMappingUtils.kt\ncom/intellij/openapi/vcs/impl/projectlevelman/VcsDefaultMappingDetector\n*L\n93#1:110,2\n*E\n"})
final class VcsDefaultMappingDetector {
    @NotNull
    private final Project project;
    @NotNull
    private final VcsRootChecker rootChecker;
    @NotNull
    private final ProjectFileIndex fileIndex;
    @NotNull
    private final Map<VirtualFile, Boolean> checkedDirs;

    public VcsDefaultMappingDetector(@NotNull Project project, @NotNull VcsRootChecker rootChecker) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootChecker, (String)"rootChecker");
        this.project = project;
        this.rootChecker = rootChecker;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        this.fileIndex = projectFileIndex;
        this.checkedDirs = new LinkedHashMap();
    }

    @NotNull
    public final Set<VirtualFile> detectProjectMappings(@NotNull Collection<? extends VirtualFile> projectRoots, @NotNull Set<? extends VirtualFile> mappedDirs) {
        Intrinsics.checkNotNullParameter(projectRoots, (String)"projectRoots");
        Intrinsics.checkNotNullParameter(mappedDirs, (String)"mappedDirs");
        for (VirtualFile virtualFile : mappedDirs) {
            this.checkedDirs.put(virtualFile, true);
        }
        Set vcsRoots = new LinkedHashSet();
        for (VirtualFile virtualFile : projectRoots) {
            VirtualFile root = this.detectVcsForProjectRoot(virtualFile);
            if (root == null) continue;
            vcsRoots.add(root);
        }
        vcsRoots.removeAll((Collection)mappedDirs);
        return vcsRoots;
    }

    private final VirtualFile detectVcsForProjectRoot(VirtualFile projectRoot) {
        for (VirtualFile file : SequencesKt.generateSequence((Object)projectRoot, VcsDefaultMappingDetector::detectVcsForProjectRoot$lambda$0)) {
            if (this.isVcsRoot(file)) {
                return file;
            }
            VirtualFile parent = file.getParent();
            if (parent == null || this.isUnderProject(parent)) continue;
            if (this.rootChecker.areChildrenValidMappings() && this.isUnderVcsRoot(parent)) {
                return file;
            }
            return null;
        }
        return null;
    }

    private final boolean isUnderVcsRoot(VirtualFile file) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)file, VcsDefaultMappingDetector::isUnderVcsRoot$lambda$1);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (!this.isVcsRoot(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isVcsRoot(VirtualFile file) {
        ProgressManager.checkCanceled();
        Boolean bl = this.checkedDirs.computeIfAbsent(file, arg_0 -> VcsDefaultMappingDetector.isVcsRoot$lambda$4(arg_0 -> VcsDefaultMappingDetector.isVcsRoot$lambda$3(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    private final boolean isUnderProject(VirtualFile f) {
        return (Boolean)ActionsKt.runReadAction(() -> VcsDefaultMappingDetector.isUnderProject$lambda$5(this, f));
    }

    private static final VirtualFile detectVcsForProjectRoot$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final VirtualFile isUnderVcsRoot$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final Boolean isVcsRoot$lambda$3(VcsDefaultMappingDetector this$0, VirtualFile key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this$0.rootChecker.isRoot(key);
    }

    private static final Boolean isVcsRoot$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isUnderProject$lambda$5(VcsDefaultMappingDetector this$0, VirtualFile $f) {
        if (this$0.project.isDisposed()) {
            throw new ProcessCanceledException();
        }
        return this$0.fileIndex.isInContent($f);
    }
}

