/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.commandLine.InteractiveCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnProcessHandler;

public class TerminalProcessHandler
extends SvnProcessHandler {
    private final List<InteractiveCommandListener> myInteractiveListeners;
    private final CapturingProcessAdapter terminalOutputCapturer;
    private final StringBuilder outputLine;
    private final StringBuilder errorLine;

    public TerminalProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, boolean forceUtf8, boolean forceBinary) {
        if (process == null) {
            TerminalProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            TerminalProcessHandler.$$$reportNull$$$0(1);
        }
        super(process, commandLine, forceUtf8, forceBinary);
        this.myInteractiveListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.terminalOutputCapturer = new CapturingProcessAdapter();
        this.outputLine = new StringBuilder();
        this.errorLine = new StringBuilder();
        this.setHasPty(true);
        this.setShouldDestroyProcessRecursively(false);
    }

    public void addInteractiveListener(@NotNull InteractiveCommandListener listener2) {
        if (listener2 == null) {
            TerminalProcessHandler.$$$reportNull$$$0(2);
        }
        this.myInteractiveListeners.add(listener2);
    }

    protected boolean processHasSeparateErrorStream() {
        return false;
    }

    public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
        if (text == null) {
            TerminalProcessHandler.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            TerminalProcessHandler.$$$reportNull$$$0(4);
        }
        if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
            super.notifyTextAvailable(text, outputType);
        } else {
            this.terminalOutputCapturer.onTextAvailable(new ProcessEvent((ProcessHandler)this, text), outputType);
            text = this.filterText(text);
            if (!StringUtil.isEmpty((String)text)) {
                StringBuilder lastLine = this.getLastLineFor(outputType);
                String currentLine = lastLine.append(text).toString();
                lastLine.setLength(0);
                currentLine = this.filterCombinedText(currentLine);
                boolean handled = this.handlePrompt(currentLine, outputType);
                if (!handled) {
                    this.notify(currentLine, outputType, lastLine);
                }
            }
        }
    }

    protected boolean handlePrompt(String text, Key outputType) {
        boolean shouldHandleWithListeners = !this.processHasSeparateErrorStream() || ProcessOutputTypes.STDERR.equals((Object)outputType);
        return shouldHandleWithListeners && this.handlePromptWithListeners(text, outputType);
    }

    private boolean handlePromptWithListeners(String text, Key outputType) {
        boolean result = false;
        for (InteractiveCommandListener listener2 : this.myInteractiveListeners) {
            result |= listener2.handlePrompt(text, outputType);
        }
        return result;
    }

    @NotNull
    protected String filterCombinedText(@NotNull String currentLine) {
        if (currentLine == null) {
            TerminalProcessHandler.$$$reportNull$$$0(5);
        }
        String string = currentLine;
        if (string == null) {
            TerminalProcessHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected String filterText(@NotNull String text) {
        if (text == null) {
            TerminalProcessHandler.$$$reportNull$$$0(7);
        }
        String string = text;
        if (string == null) {
            TerminalProcessHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void notify(@NotNull String text, @NotNull Key outputType, @NotNull StringBuilder lastLine) {
        if (text == null) {
            TerminalProcessHandler.$$$reportNull$$$0(9);
        }
        if (outputType == null) {
            TerminalProcessHandler.$$$reportNull$$$0(10);
        }
        if (lastLine == null) {
            TerminalProcessHandler.$$$reportNull$$$0(11);
        }
        if (StringUtil.endsWith((CharSequence)text, (CharSequence)"\n")) {
            super.notifyTextAvailable(text, this.resolveOutputType(text, outputType));
        } else {
            lastLine.append(text);
        }
    }

    @NotNull
    protected Key resolveOutputType(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            TerminalProcessHandler.$$$reportNull$$$0(12);
        }
        if (outputType == null) {
            TerminalProcessHandler.$$$reportNull$$$0(13);
        }
        Key result = outputType;
        if (!ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
            Matcher errorMatcher = SvnUtil.ERROR_PATTERN.matcher(line);
            Matcher warningMatcher = SvnUtil.WARNING_PATTERN.matcher(line);
            result = errorMatcher.find() || warningMatcher.find() ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT;
        }
        Key key = result;
        if (key == null) {
            TerminalProcessHandler.$$$reportNull$$$0(14);
        }
        return key;
    }

    @NotNull
    private StringBuilder getLastLineFor(Key outputType) {
        if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
            StringBuilder stringBuilder = this.errorLine;
            if (stringBuilder == null) {
                TerminalProcessHandler.$$$reportNull$$$0(15);
            }
            return stringBuilder;
        }
        if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
            StringBuilder stringBuilder = this.outputLine;
            if (stringBuilder == null) {
                TerminalProcessHandler.$$$reportNull$$$0(16);
            }
            return stringBuilder;
        }
        throw new IllegalArgumentException("Unknown process output type " + outputType);
    }

    public String getTerminalOutput() {
        return this.terminalOutputCapturer.getOutput().getStdout();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLine";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastLine";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/TerminalProcessHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterCombinedText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filterText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveOutputType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastLineFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addInteractiveListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyTextAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterCombinedText";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterText";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveOutputType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

