/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.idea.insights.CustomKey;
import com.android.tools.idea.insights.Log;
import com.google.services.firebase.insights.ui.IssueDetailTable;
import com.google.services.firebase.insights.ui.IssueDetailTablesKt;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\"\u001e\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\n"}, d2={"formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getFormatter", "()Ljava/time/format/DateTimeFormatter;", "createLogsTable", "Lcom/google/services/firebase/insights/ui/IssueDetailTable;", "Lcom/android/tools/idea/insights/Log;", "createCustomKeysTable", "Lcom/android/tools/idea/insights/CustomKey;", "firebase"})
public final class IssueDetailTablesKt {
    @VisibleForTesting
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("hh:mm:ss:SSS a").withZone(ZoneId.systemDefault());

    public static final DateTimeFormatter getFormatter() {
        return formatter;
    }

    @NotNull
    public static final IssueDetailTable<Log> createLogsTable() {
        ListTableModel listTableModel;
        ListTableModel $this$createLogsTable_u24lambda_u240 = listTableModel = new ListTableModel(new ColumnInfo[0]);
        boolean bl = false;
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo<Log, String>(){

            public String valueOf(Log item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return IssueDetailTablesKt.getFormatter().format(item.getEventTime());
            }

            public Comparator<Log> getComparator() {
                return createLogsTable.1.1::getComparator$lambda$0;
            }

            public String getPreferredStringValue() {
                return "99:99:99:999 AM";
            }

            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            public DefaultTableCellRenderer getRenderer(Log item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return new DefaultTableCellRenderer();
            }

            private static final int getComparator$lambda$0(Log o1, Log o2) {
                return o1.getEventTime().compareTo(o2.getEventTime());
            }
        }, new ColumnInfo<Log, String>((ListTableModel<Log>)$this$createLogsTable_u24lambda_u240){
            final /* synthetic */ ListTableModel<Log> $this_apply;
            {
                this.$this_apply = $receiver;
                super("Log");
            }

            public String valueOf(Log item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getTitle();
            }

            public String getPreferredStringValue() {
                Object v1;
                List list = this.$this_apply.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                Iterable $this$maxByOrNull$iv = list;
                boolean $i$f$maxByOrNull = false;
                Iterator<T> iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    T maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = maxElem$iv;
                    } else {
                        Log it = (Log)maxElem$iv;
                        boolean bl = false;
                        int maxValue$iv = it.getTitle().length();
                        do {
                            T e$iv = iterator$iv.next();
                            Log it2 = (Log)e$iv;
                            $i$a$-maxByOrNull-IssueDetailTablesKt$createLogsTable$1$2$getPreferredStringValue$1 = false;
                            int v$iv = it2.getTitle().length();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = maxElem$iv;
                    }
                }
                Log log = v1;
                return log != null ? log.getTitle() : null;
            }

            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            public DefaultTableCellRenderer getRenderer(Log item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return new DefaultTableCellRenderer();
            }
        }, new ColumnInfo<Log, Log>(){

            public Log valueOf(Log item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item;
            }

            public createLogsTable.1.getRenderer.1 getRenderer(Log item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        Component component = super.getTableCellRendererComponent(table, CollectionsKt.joinToString$default((Iterable)((Log)value).getParams().entrySet(), null, null, null, (int)0, null, createLogsTable.1.getRenderer.1::getTableCellRendererComponent$lambda$0, (int)31, null), isSelected, hasFocus, row, column);
                        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getTableCellRendererComponent(...)");
                        return component;
                    }

                    private static final CharSequence getTableCellRendererComponent$lambda$0(Map.Entry it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.getKey() + ": " + it.getValue();
                    }
                };
            }
        }};
        $this$createLogsTable_u24lambda_u240.setColumnInfos(columnInfoArray);
        $this$createLogsTable_u24lambda_u240.setSortable(true);
        Function2 function2 = IssueDetailTablesKt::createLogsTable$lambda$2;
        ListTableModel listTableModel2 = listTableModel;
        return new IssueDetailTable<Log>(listTableModel2, function2);
    }

    @NotNull
    public static final IssueDetailTable<CustomKey> createCustomKeysTable() {
        ListTableModel listTableModel;
        ListTableModel $this$createCustomKeysTable_u24lambda_u243 = listTableModel = new ListTableModel(new ColumnInfo[0]);
        boolean bl = false;
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo<CustomKey, String>((ListTableModel<CustomKey>)$this$createCustomKeysTable_u24lambda_u243){
            final /* synthetic */ ListTableModel<CustomKey> $this_apply;
            {
                this.$this_apply = $receiver;
                super("Key");
            }

            public String valueOf(CustomKey item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getKey();
            }

            public String getPreferredStringValue() {
                Object v1;
                List list = this.$this_apply.getItems();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                Iterable $this$maxByOrNull$iv = list;
                boolean $i$f$maxByOrNull = false;
                Iterator<T> iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    T maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = maxElem$iv;
                    } else {
                        CustomKey it = (CustomKey)maxElem$iv;
                        boolean bl = false;
                        int maxValue$iv = it.getKey().length();
                        do {
                            T e$iv = iterator$iv.next();
                            CustomKey it2 = (CustomKey)e$iv;
                            $i$a$-maxByOrNull-IssueDetailTablesKt$createCustomKeysTable$1$1$getPreferredStringValue$1 = false;
                            int v$iv = it2.getKey().length();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = maxElem$iv;
                    }
                }
                CustomKey customKey = v1;
                return customKey != null ? customKey.getKey() : null;
            }

            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            public DefaultTableCellRenderer getRenderer(CustomKey item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return new DefaultTableCellRenderer();
            }
        }, new ColumnInfo<CustomKey, String>(){

            public String valueOf(CustomKey item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getValue();
            }

            public DefaultTableCellRenderer getRenderer(CustomKey item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return new DefaultTableCellRenderer();
            }
        }};
        $this$createCustomKeysTable_u24lambda_u243.setColumnInfos(columnInfoArray);
        $this$createCustomKeysTable_u24lambda_u243.setSortable(true);
        Function2 function2 = IssueDetailTablesKt::createCustomKeysTable$lambda$4;
        ListTableModel listTableModel2 = listTableModel;
        return new IssueDetailTable<CustomKey>(listTableModel2, function2);
    }

    private static final CharSequence createLogsTable$lambda$2$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + ": " + it.getValue();
    }

    private static final String createLogsTable$lambda$2(Log log, int index) {
        String string;
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        switch (index) {
            case 0: {
                String string2 = formatter.format(log.getEventTime());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                break;
            }
            case 1: {
                string = log.getTitle();
                break;
            }
            case 2: {
                string = CollectionsKt.joinToString$default((Iterable)log.getParams().entrySet(), null, null, null, (int)0, null, IssueDetailTablesKt::createLogsTable$lambda$2$lambda$1, (int)31, null);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private static final String createCustomKeysTable$lambda$4(CustomKey customKey, int index) {
        Intrinsics.checkNotNullParameter((Object)customKey, (String)"customKey");
        return switch (index) {
            case 0 -> customKey.getKey();
            case 1 -> customKey.getValue();
            default -> "";
        };
    }
}

