/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.action.dependency;

import com.android.tools.idea.assistant.RecipeMetadata;
import com.android.tools.idea.assistant.RecipeUtils;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.project.Info;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.FirebaseTutorialBundle;
import com.google.services.firebase.action.dependency.DependencyStateManager;
import com.google.services.firebase.view.ModuleComboBox;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import kotlin.jvm.functions.Function2;
import org.jetbrains.android.AndroidPluginDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyDialog
extends DialogWrapper {
    private static final Dimension DEFAULT_MINIMUM_SIZE = new Dimension(500, 300);
    private final JBLoadingPanel mLoadingPanel;
    private final JPanel myContentPanel;
    private Module mySelectedModule;
    private List<String> myDependenciesToBeApplied = new ArrayList<String>();

    DependencyDialog(@NotNull ActionData actionData, @NotNull Project project) {
        super(project, false);
        FirebaseTutorialBundle.Recipe recipe = this.getRecipe(actionData);
        List modules = Info.getInstance((Project)project).getAndroidModules();
        if (modules.size() == 1) {
            this.mySelectedModule = (Module)modules.iterator().next();
        } else {
            this.setOKActionEnabled(false);
        }
        this.mLoadingPanel = this.createLoadingPanel(project);
        this.myContentPanel = this.createContentPanel();
        this.myContentPanel.add((Component)this.mLoadingPanel, "Center");
        this.init();
        this.setTitle(actionData.getLabel());
        Action okAction = this.getOKAction();
        okAction.putValue("Name", "Accept Changes");
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.getDisposable(), () -> {
            List metadata = RecipeUtils.getRecipeMetadata((Function2)recipe, (Project)project);
            ApplicationManager.getApplication().invokeLater(() -> {
                ProjectChangesPanel projectChangesPanel = this.createProjectChangesPanel(metadata, modules);
                this.replaceLoadingWithContent(projectChangesPanel);
            }, ModalityState.stateForComponent((Component)this.myContentPanel), ignored -> this.isDisposed());
        });
    }

    @NotNull
    public List<String> getDependenciesToBeApplied() {
        return Collections.unmodifiableList(this.myDependenciesToBeApplied);
    }

    @NotNull
    public Module getModule() {
        return this.mySelectedModule;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    private FirebaseTutorialBundle.Recipe getRecipe(@NotNull ActionData actionData) {
        if (!(actionData instanceof FirebaseTutorialBundle.Action)) {
            throw new RuntimeException("This should be impossible, malformed actiondata");
        }
        FirebaseTutorialBundle.Recipe recipe = ((FirebaseTutorialBundle.Action)actionData).getRecipe();
        if (recipe == null) {
            throw new ConfigurationException("Missing dependency configuration data for: " + actionData);
        }
        return recipe;
    }

    private JBLoadingPanel createLoadingPanel(@NotNull Project project) {
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)AndroidPluginDisposable.getProjectInstance((Project)project));
        loadingPanel.startLoading();
        return loadingPanel;
    }

    private JPanel createContentPanel() {
        JBPanel contentPanel2 = new JBPanel((LayoutManager)new BorderLayout());
        contentPanel2.setPreferredSize(DEFAULT_MINIMUM_SIZE);
        return contentPanel2;
    }

    private ProjectChangesPanel createProjectChangesPanel(@NotNull List<RecipeMetadata> metadata, @NotNull List<Module> modules) {
        ProjectChangesPanel projectChangesPanel = new ProjectChangesPanel(metadata, modules);
        projectChangesPanel.setLayout(new BoxLayout((Container)((Object)projectChangesPanel), 1));
        return projectChangesPanel;
    }

    private void replaceLoadingWithContent(@NotNull ProjectChangesPanel projectChangesPanel) {
        this.mLoadingPanel.stopLoading();
        this.myContentPanel.remove((Component)this.mLoadingPanel);
        this.myContentPanel.add((Component)((Object)projectChangesPanel), "Center");
        projectChangesPanel.updateMutableView();
    }

    public static class ConfigurationException
    extends RuntimeException {
        public ConfigurationException(String message) {
            super(message);
        }
    }

    public class ProjectChangesPanel
    extends JBPanel {
        private final Project myProject;
        private ComboBox myModuleBox;
        private JBPanel myProposedChangesPanel;
        private final RecipeMetadata mySampleMetadata;
        private final List<RecipeMetadata> myMetadataList;
        private RecipeMetadata mySelectedMetadata;

        public ProjectChangesPanel(@NotNull List<RecipeMetadata> metadataList, List<Module> modules) {
            Module sampleModule = modules.iterator().next();
            this.myProject = sampleModule.getProject();
            this.myMetadataList = metadataList;
            this.mySampleMetadata = this.myMetadataList.get(0);
            if (DependencyDialog.this.mySelectedModule == null) {
                JPanel moduleWrapper = new JPanel(new FlowLayout(0, 0, 5));
                moduleWrapper.setOpaque(false);
                JBLabel moduleLabel = new JBLabel(FirebaseBundle.message("dependencies.add.selectModule.label", new Object[0]));
                moduleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
                moduleWrapper.add((Component)moduleLabel);
                ArrayList<Module> incompleteModules = new ArrayList<Module>();
                if (DependencyStateManager.getPendingClasspaths(this.myProject, this.mySampleMetadata).isEmpty()) {
                    for (RecipeMetadata metadata : this.myMetadataList) {
                        Module module = metadata.getModule();
                        if (!DependencyStateManager.getPendingPlugins(metadata).isEmpty()) {
                            incompleteModules.add(module);
                            continue;
                        }
                        if (DependencyStateManager.getPendingDependencies(metadata, GradleBuildModel.get((Module)module)).isEmpty()) continue;
                        incompleteModules.add(module);
                    }
                } else {
                    incompleteModules.addAll(modules);
                }
                this.myModuleBox = new ModuleComboBox(incompleteModules);
                moduleWrapper.add((Component)this.myModuleBox);
                moduleWrapper.setAlignmentX(0.0f);
                this.add(moduleWrapper);
                this.myModuleBox.addActionListener(this::selectModule);
            }
            this.updateMutableView();
        }

        private void updateMutableView() {
            List<String> pluginsToApply;
            if (this.myProposedChangesPanel != null) {
                this.remove((Component)this.myProposedChangesPanel);
                this.revalidate();
                this.repaint();
            }
            this.myProposedChangesPanel = new JBPanel();
            this.myProposedChangesPanel.setLayout((LayoutManager)new BoxLayout((Container)this.myProposedChangesPanel, 1));
            List<String> classpathEntriesToAdd = DependencyStateManager.getPendingClasspaths(this.myProject, this.mySampleMetadata);
            if (DependencyDialog.this.mySelectedModule != null) {
                for (RecipeMetadata metadata : this.myMetadataList) {
                    if (!metadata.getModule().equals(DependencyDialog.this.mySelectedModule)) continue;
                    this.mySelectedMetadata = metadata;
                }
            }
            GradleBuildModel gradleBuildModel = null;
            if (this.mySelectedMetadata == null) {
                pluginsToApply = this.mySampleMetadata.getPlugins();
                DependencyDialog.this.myDependenciesToBeApplied = this.mySampleMetadata.getDependencies();
            } else {
                pluginsToApply = DependencyStateManager.getPendingPlugins(this.mySelectedMetadata);
                gradleBuildModel = GradleBuildModel.get((Module)this.mySelectedMetadata.getModule());
                DependencyDialog.this.myDependenciesToBeApplied = DependencyStateManager.getPendingDependencies(this.mySelectedMetadata, gradleBuildModel);
            }
            JLabel summary = new JLabel();
            summary.setOpaque(false);
            summary.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            summary.setText(FirebaseBundle.message("dependencies.add.preface", new Object[0]));
            summary.setAlignmentX(0.0f);
            this.myProposedChangesPanel.add((Component)summary);
            StringBuilder detailsBuilder = new StringBuilder();
            String detailsCss = ".dependency { color: green; font-weight: bold; font-family: monospace; }\nbody {padding: 10px; }";
            String indent_1 = "    ";
            String indent_2 = "        ";
            if (!classpathEntriesToAdd.isEmpty()) {
                detailsBuilder.append("<pre><b>build.gradle (project-level)</b>\n\n").append(indent_1).append("Add rules to include the Google Services Gradle plugin:\n");
                for (String classpathEntry : classpathEntriesToAdd) {
                    detailsBuilder.append(indent_2).append("classpath <font class=\"dependency\">'").append(classpathEntry).append("'</font>\n");
                }
                detailsBuilder.append("</pre>");
                detailsBuilder.append("<div style=\"height: 1px; font-size: 0; background: #cccccc;\"></div><br>");
            }
            detailsBuilder.append("<pre><b>app/build.gradle</b>\n\n");
            if (!pluginsToApply.isEmpty()) {
                detailsBuilder.append(indent_1).append("Apply the Google Services Gradle plugin:\n");
                for (String plugin : pluginsToApply) {
                    detailsBuilder.append(indent_2).append("apply plugin: <font class=\"dependency\">'").append(plugin).append("'</font>\n");
                }
                detailsBuilder.append("\n");
            }
            if (!DependencyDialog.this.myDependenciesToBeApplied.isEmpty()) {
                detailsBuilder.append(indent_1).append("Add the library " + (DependencyDialog.this.myDependenciesToBeApplied.size() > 1 ? "dependencies" : "dependency") + ":\n");
                for (String dependency : DependencyDialog.this.myDependenciesToBeApplied) {
                    detailsBuilder.append(indent_2).append("implementation <font class=\"dependency\">'").append(dependency).append("'</font>\n");
                }
            }
            detailsBuilder.append("</pre>");
            JTextPane details = new JTextPane();
            UIUtils.setHtml((JEditorPane)details, (String)detailsBuilder.toString(), (String)detailsCss);
            details.setBackground(UIUtils.getBackgroundColor());
            details.setMargin((Insets)new JBInsets(10, 10, 10, 10));
            details.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIUtils.getSeparatorColor()));
            details.setAlignmentX(0.0f);
            this.myProposedChangesPanel.add((Component)details);
            this.add((Component)this.myProposedChangesPanel);
            DependencyDialog.this.pack();
        }

        void selectModule(ActionEvent e) {
            DependencyDialog.this.mySelectedModule = (Module)this.myModuleBox.getSelectedItem();
            this.updateMutableView();
            DependencyDialog.this.setOKActionEnabled(true);
        }
    }
}

