/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.font.FontWeight;
import com.android.tools.idea.flags.StudioFlags;
import com.google.api.client.auth.oauth2.Credential;
import com.google.gct.login2.LoginCompletedCallback;
import com.google.gct.login2.LoginFeature;
import com.google.gct.login2.OAuthScope;
import com.google.gct.login2.PreferredUser;
import com.google.gct.wizard.WizardPage;
import com.google.services.firebase.FirebaseLoginCallbackHandler;
import com.google.services.firebase.FirebaseLoginFeature;
import com.intellij.openapi.actionSystem.AnAction;
import icons.FirebaseIcons;
import icons.StudioIllustrationsCompose;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.ui.icon.IconKey;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u0016\u0010\u001f\u001a\u0004\u0018\u00010 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/google/services/firebase/FirebaseLoginFeature;", "Lcom/google/gct/login2/LoginFeature;", "<init>", "()V", "key", "", "getKey", "()Ljava/lang/String;", "title", "getTitle", "description", "getDescription", "infoUrl", "getInfoUrl", "infoUrlDisplayText", "getInfoUrlDisplayText", "settingsAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getSettingsAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "oAuthScopes", "", "Lcom/google/gct/login2/OAuthScope;", "getOAuthScopes", "()Ljava/util/Collection;", "onboardingWizardEntry", "Lcom/google/gct/login2/LoginFeature$OnboardingWizardEntry;", "getOnboardingWizardEntry", "()Lcom/google/gct/login2/LoginFeature$OnboardingWizardEntry;", "projectCreationDescription", "getProjectCreationDescription", "handler", "Lcom/google/services/firebase/FirebaseLoginCallbackHandler;", "getHandler", "()Lcom/google/services/firebase/FirebaseLoginCallbackHandler;", "firebase"})
@SourceDebugExtension(value={"SMAP\nFirebaseLoginFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseLoginFeature.kt\ncom/google/services/firebase/FirebaseLoginFeature\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class FirebaseLoginFeature
implements LoginFeature {
    @NotNull
    private final String key;
    @Nullable
    private final FirebaseLoginCallbackHandler handler = (Boolean)StudioFlags.DIRECT_ACCESS_CREATE_PROJECT.get() != false ? new FirebaseLoginCallbackHandler() : null;

    public FirebaseLoginFeature() {
        this.key = "Firebase";
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public String getTitle() {
        return "Firebase";
    }

    @NotNull
    public String getDescription() {
        return "View and administer all your Firebase data and settings. " + ((Boolean)StudioFlags.DIRECT_ACCESS.get() != false ? "Used in Firebase Assistant, Crashlytics integration in App Quality Insights, and Device Streaming" : "Used in Firebase Assistant and Crashlytics integration in App Quality Insights");
    }

    @NotNull
    public String getInfoUrl() {
        return "http://console.firebase.google.com";
    }

    @NotNull
    public String getInfoUrlDisplayText() {
        return "Go to Firebase Console";
    }

    @Nullable
    public AnAction getSettingsAction() {
        return null;
    }

    @NotNull
    public Collection<OAuthScope> getOAuthScopes() {
        Object[] objectArray = new OAuthScope[]{OAuthScope.Firebase, OAuthScope.CloudPlatform};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public LoginFeature.OnboardingWizardEntry getOnboardingWizardEntry() {
        return new LoginFeature.OnboardingWizardEntry(this){
            private final Icon icon;
            private final IconKey composeIconKey;
            private final String title;
            private final AnnotatedString annotatedTitle;
            private final String description;
            {
                void $this$withStyle$iv;
                void $this$annotatedTitle_u24lambda_u241;
                AnnotatedString.Builder builder;
                Icon icon = FirebaseIcons.ACTION_ICON;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ACTION_ICON");
                this.icon = icon;
                this.composeIconKey = (IconKey)StudioIllustrationsCompose.Common.INSTANCE.getFirebaseIcon();
                this.title = "<b>Firebase:</b> Enable Android Device Streaming";
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                onboardingWizardEntry.1 var12_5 = this;
                boolean bl = false;
                void var6_7 = $this$annotatedTitle_u24lambda_u241;
                SpanStyle style$iv = new SpanStyle(0L, 0L, FontWeight.Companion.getBold(), null, null, null, null, 0L, null, null, null, 0L, null, null, null, null, 65531, null);
                boolean $i$f$withStyle = false;
                int index$iv = $this$withStyle$iv.pushStyle(style$iv);
                try {
                    void $this$annotatedTitle_u24lambda_u241_u24lambda_u240 = $this$withStyle$iv;
                    boolean bl2 = false;
                    $this$annotatedTitle_u24lambda_u241_u24lambda_u240.append("Firebase:");
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$withStyle$iv.pop(index$iv);
                }
                $this$annotatedTitle_u24lambda_u241.append(" Enable Android Device Streaming");
                var12_5.annotatedTitle = builder.toAnnotatedString();
                this.description = "Enable Android Device Streaming, powered by Firebase, to start accessing real Android devices to test your app\u2014at no cost. Firebase also provides additional services you can access directly from the IDE, such as Crashlytics crash reporting." + FirebaseLoginFeature.access$getProjectCreationDescription($receiver);
            }

            public Icon getIcon() {
                return this.icon;
            }

            public IconKey getComposeIconKey() {
                return this.composeIconKey;
            }

            public String getTitle() {
                return this.title;
            }

            public AnnotatedString getAnnotatedTitle() {
                return this.annotatedTitle;
            }

            public String getDescription() {
                return this.description;
            }

            public List<WizardPage> getPages() {
                return super.getPages();
            }
        };
    }

    private final String getProjectCreationDescription() {
        String string;
        String it = string = " \n\nIf you don\u2019t have a Firebase project, Android Studio will create one for you.";
        boolean bl = false;
        Object object = StudioFlags.DIRECT_ACCESS_CREATE_PROJECT.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string2 = (Boolean)object != false ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @Nullable
    public FirebaseLoginCallbackHandler getHandler() {
        return this.handler;
    }

    @Nullable
    public Credential credential() {
        return super.credential();
    }

    @Nullable
    public Credential credential(@NotNull String userEmail) {
        return super.credential(userEmail);
    }

    public boolean isLoggedIn() {
        return super.isLoggedIn();
    }

    public boolean isLoggedIn(@NotNull String email) {
        return super.isLoggedIn(email);
    }

    @Nullable
    public Object logIn(@NotNull PreferredUser preferredUser, boolean switchUserIfApplicable, @Nullable JComponent parentComponent, @Nullable LoginCompletedCallback loginCompletedCallback, @NotNull Continuation<? super PreferredUser> $completion) {
        return super.logIn(preferredUser, switchUserIfApplicable, parentComponent, loginCompletedCallback, $completion);
    }

    @NotNull
    public PreferredUser logInBlocking(@NotNull PreferredUser preferredUser, boolean switchUserIfApplicable, @Nullable JComponent parentComponent, @Nullable LoginCompletedCallback loginCompletedCallback) {
        return super.logInBlocking(preferredUser, switchUserIfApplicable, parentComponent, loginCompletedCallback);
    }

    @Nullable
    public String oAuthToken() {
        return super.oAuthToken();
    }

    public boolean getActiveUserSwitchRequired() {
        return super.getActiveUserSwitchRequired();
    }

    public boolean isAvailable() {
        return super.isAvailable();
    }

    public boolean isInternal() {
        return super.isInternal();
    }

    @Nullable
    public LoginCompletedCallback getOnLoginCompleted() {
        return super.getOnLoginCompleted();
    }

    public boolean getShowInIntegrations() {
        return super.getShowInIntegrations();
    }

    public static final /* synthetic */ String access$getProjectCreationDescription(FirebaseLoginFeature $this) {
        return $this.getProjectCreationDescription();
    }
}

