/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;

class CommonButtonUI
extends BasicButtonUI {
    private final MouseAdapter myAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            CommonButtonUI.this.myHover = true;
            e.getComponent().repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            CommonButtonUI.this.myHover = false;
            e.getComponent().repaint();
        }
    };
    private boolean myHover;

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(BorderFactory.createEmptyBorder(JBUI.scale((int)4), JBUI.scale((int)4), JBUI.scale((int)4), JBUI.scale((int)4)));
        }
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addMouseListener(this.myAdapter);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removeMouseListener(this.myAdapter);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (this.myHover && b.isEnabled() || b.isSelected() || b.isFocusOwner()) {
            GraphicsUtilKt.paintBackground(g, c);
        }
        super.paint(g, c);
    }
}

