/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.instructions.RenderInstruction;
import com.intellij.ui.HyperlinkLabel;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class HyperlinkInstruction
extends RenderInstruction {
    @NotNull
    private final HyperlinkLabel myHyperlinkLabel;
    @NotNull
    private final Dimension mySize;

    private HyperlinkInstruction(@NotNull Font font, @NotNull String text, @Nullable String url, final @Nullable Runnable action) {
        this.myHyperlinkLabel = new HyperlinkLabel(text);
        this.myHyperlinkLabel.setFont(font);
        if (url != null) {
            this.myHyperlinkLabel.setHyperlinkTarget(url);
        }
        if (action != null) {
            this.myHyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    action.run();
                }
            });
        }
        this.setMouseHandler(evt -> this.myHyperlinkLabel.dispatchEvent((AWTEvent)evt));
        this.mySize = this.myHyperlinkLabel.getPreferredSize();
    }

    public HyperlinkInstruction(@NotNull Font font, @NotNull String text, @NotNull String url) {
        this(font, text, url, null);
    }

    public HyperlinkInstruction(@NotNull Font font, @NotNull String text, @NotNull Runnable action) {
        this(font, text, null, action);
    }

    @Override
    @NotNull
    public Dimension getSize() {
        return this.mySize;
    }

    @Override
    @Nullable
    public Cursor getCursorIcon() {
        return this.myHyperlinkLabel.isCursorSet() ? this.myHyperlinkLabel.getCursor() : null;
    }

    @Override
    public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2d.translate(bounds.x, bounds.y);
        this.myHyperlinkLabel.setBounds(bounds);
        this.myHyperlinkLabel.paint((Graphics)g2d);
        g2d.translate(-bounds.x, -bounds.y);
    }

    @TestOnly
    @NotNull
    public String getDisplayText() {
        return this.myHyperlinkLabel.getText();
    }
}

