/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.actions.ZoomType;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public abstract class SetZoomAction
extends DumbAwareAction {
    @VisibleForTesting
    @NotNull
    public final ZoomType myType;

    public SetZoomAction(@NotNull ZoomType type) {
        super(type.getLabel());
        this.myType = type;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Zoomable zoomable = (Zoomable)event.getData(ZoomableKt.ZOOMABLE_KEY);
        if (zoomable != null) {
            zoomable.zoom(this.myType);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setIcon(this.myType.getIcon());
        e.getPresentation().setText(this.myType.getLabel());
        String optionalDescription = this.myType.getDescription();
        if (optionalDescription != null) {
            e.getPresentation().setDescription(optionalDescription);
        }
    }
}

