/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.execution.ParametersListUtil;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleCommandLineUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionWorkspace;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;

public class GradleExecutionSettings
extends ExternalSystemExecutionSettings {
    @NotNull
    private static final String USE_VERBOSE_GRADLE_API_KEY = "gradle.api.verbose";
    private static final boolean USE_VERBOSE_GRADLE_API_DEFAULT = false;
    @NotNull
    private final GradleExecutionWorkspace myExecutionWorkspace;
    @Nullable
    private String myGradleHome;
    @Nullable
    private String myServiceDirectory;
    private boolean myIsOfflineWork;
    @NotNull
    private DistributionType myDistributionType;
    @Nullable
    private String wrapperPropertyFile;
    @Nullable
    private String myJavaHome;
    @Nullable
    private String myIdeProjectPath;
    private boolean resolveModulePerSourceSet;
    private boolean useQualifiedModuleNames;
    private boolean delegatedBuild;
    private boolean downloadSources;
    private boolean isParallelModelFetch;
    private boolean myBuiltInTestEventsUsed;

    @Deprecated
    public GradleExecutionSettings(@Nullable String gradleHome, @Nullable String serviceDirectory, @NotNull DistributionType distributionType, boolean isOfflineWork) {
        if (distributionType == null) {
            GradleExecutionSettings.$$$reportNull$$$0(0);
        }
        this();
        this.setGradleHome(gradleHome);
        this.setServiceDirectory(serviceDirectory);
        this.setDistributionType(distributionType);
        this.setOfflineWork(isOfflineWork);
    }

    @Deprecated
    public GradleExecutionSettings(@Nullable String gradleHome, @Nullable String serviceDirectory, @NotNull DistributionType distributionType, @Nullable String daemonVmOptions, boolean isOfflineWork) {
        if (distributionType == null) {
            GradleExecutionSettings.$$$reportNull$$$0(1);
        }
        this(gradleHome, serviceDirectory, distributionType, isOfflineWork);
        if (daemonVmOptions != null) {
            this.withVmOptions(ParametersListUtil.parse((String)daemonVmOptions));
        }
    }

    public GradleExecutionSettings() {
        this.myGradleHome = null;
        this.myServiceDirectory = null;
        this.myIsOfflineWork = false;
        this.myDistributionType = DistributionType.BUNDLED;
        this.wrapperPropertyFile = null;
        this.myJavaHome = null;
        this.myIdeProjectPath = null;
        this.resolveModulePerSourceSet = true;
        this.useQualifiedModuleNames = false;
        this.delegatedBuild = true;
        this.downloadSources = false;
        this.isParallelModelFetch = false;
        this.myBuiltInTestEventsUsed = false;
        this.myExecutionWorkspace = new GradleExecutionWorkspace();
        this.setVerboseProcessing(SystemProperties.getBooleanProperty((String)USE_VERBOSE_GRADLE_API_KEY, (boolean)false));
    }

    public GradleExecutionSettings(@NotNull GradleExecutionSettings settings) {
        if (settings == null) {
            GradleExecutionSettings.$$$reportNull$$$0(2);
        }
        super((ExternalSystemExecutionSettings)settings);
        this.myGradleHome = null;
        this.myServiceDirectory = null;
        this.myIsOfflineWork = false;
        this.myDistributionType = DistributionType.BUNDLED;
        this.wrapperPropertyFile = null;
        this.myJavaHome = null;
        this.myIdeProjectPath = null;
        this.resolveModulePerSourceSet = true;
        this.useQualifiedModuleNames = false;
        this.delegatedBuild = true;
        this.downloadSources = false;
        this.isParallelModelFetch = false;
        this.myBuiltInTestEventsUsed = false;
        this.myExecutionWorkspace = settings.myExecutionWorkspace;
        this.myGradleHome = settings.myGradleHome;
        this.myServiceDirectory = settings.myServiceDirectory;
        this.myIsOfflineWork = settings.myIsOfflineWork;
        this.myDistributionType = settings.myDistributionType;
        this.wrapperPropertyFile = settings.wrapperPropertyFile;
        this.myJavaHome = settings.myJavaHome;
        this.myIdeProjectPath = settings.myIdeProjectPath;
        this.resolveModulePerSourceSet = settings.resolveModulePerSourceSet;
        this.useQualifiedModuleNames = settings.useQualifiedModuleNames;
        this.delegatedBuild = settings.delegatedBuild;
        this.downloadSources = settings.downloadSources;
        this.isParallelModelFetch = settings.isParallelModelFetch;
        this.myBuiltInTestEventsUsed = settings.myBuiltInTestEventsUsed;
    }

    public void setIdeProjectPath(@Nullable String ideProjectPath) {
        this.myIdeProjectPath = ideProjectPath;
    }

    @Nullable
    public String getIdeProjectPath() {
        return this.myIdeProjectPath;
    }

    @Nullable
    public String getGradleHome() {
        return this.myGradleHome;
    }

    public void setGradleHome(@Nullable String gradleHome) {
        this.myGradleHome = gradleHome;
    }

    @Nullable
    public String getServiceDirectory() {
        return this.myServiceDirectory;
    }

    public void setServiceDirectory(@Nullable String serviceDirectory) {
        this.myServiceDirectory = serviceDirectory;
    }

    @Nullable
    public String getJavaHome() {
        return this.myJavaHome;
    }

    public void setJavaHome(@Nullable String javaHome) {
        this.myJavaHome = javaHome;
    }

    public boolean isOfflineWork() {
        return this.myIsOfflineWork;
    }

    public void setOfflineWork(boolean offlineWork) {
        this.myIsOfflineWork = offlineWork;
    }

    public boolean isResolveModulePerSourceSet() {
        return this.resolveModulePerSourceSet;
    }

    public void setResolveModulePerSourceSet(boolean resolveModulePerSourceSet) {
        this.resolveModulePerSourceSet = resolveModulePerSourceSet;
    }

    public boolean isUseQualifiedModuleNames() {
        return this.useQualifiedModuleNames;
    }

    public void setUseQualifiedModuleNames(boolean useQualifiedModuleNames) {
        this.useQualifiedModuleNames = useQualifiedModuleNames;
    }

    public boolean isDelegatedBuild() {
        return this.delegatedBuild;
    }

    public void setDelegatedBuild(boolean delegatedBuild) {
        this.delegatedBuild = delegatedBuild;
    }

    @Nullable
    public String getWrapperPropertyFile() {
        return this.wrapperPropertyFile;
    }

    public void setWrapperPropertyFile(@Nullable String wrapperPropertyFile) {
        this.wrapperPropertyFile = wrapperPropertyFile;
    }

    @NotNull
    public DistributionType getDistributionType() {
        DistributionType distributionType = this.myDistributionType;
        if (distributionType == null) {
            GradleExecutionSettings.$$$reportNull$$$0(3);
        }
        return distributionType;
    }

    public void setDistributionType(@NotNull DistributionType distributionType) {
        if (distributionType == null) {
            GradleExecutionSettings.$$$reportNull$$$0(4);
        }
        this.myDistributionType = distributionType;
    }

    @NotNull
    public GradleExecutionWorkspace getExecutionWorkspace() {
        GradleExecutionWorkspace gradleExecutionWorkspace = this.myExecutionWorkspace;
        if (gradleExecutionWorkspace == null) {
            GradleExecutionSettings.$$$reportNull$$$0(5);
        }
        return gradleExecutionWorkspace;
    }

    public boolean isDebugAllEnabled() {
        Boolean value = (Boolean)this.getUserData(GradleRunConfiguration.DEBUG_ALL_KEY);
        return (Boolean)ObjectUtils.chooseNotNull((Object)value, (Object)false);
    }

    public boolean isRunAsTest() {
        Boolean value = (Boolean)this.getUserData(GradleRunConfiguration.RUN_AS_TEST_KEY);
        return (Boolean)ObjectUtils.chooseNotNull((Object)value, (Object)false);
    }

    public void setRunAsTest(boolean isRunAsTest) {
        this.putUserData(GradleRunConfiguration.RUN_AS_TEST_KEY, isRunAsTest);
    }

    public boolean isTestTaskRerun() {
        Boolean value = (Boolean)this.getUserData(GradleRunConfiguration.IS_TEST_TASK_RERUN_KEY);
        return (Boolean)ObjectUtils.chooseNotNull((Object)value, (Object)false);
    }

    public boolean isBuiltInTestEventsUsed() {
        return this.myBuiltInTestEventsUsed;
    }

    public void setBuiltInTestEventsUsed(boolean isBuiltInTestEventsUsed) {
        this.myBuiltInTestEventsUsed = isBuiltInTestEventsUsed;
    }

    public boolean isDownloadSources() {
        return this.downloadSources;
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
    }

    public boolean isParallelModelFetch() {
        return this.isParallelModelFetch;
    }

    public void setParallelModelFetch(boolean parallelModelFetch) {
        this.isParallelModelFetch = parallelModelFetch;
    }

    @NotNull
    public List<String> getTasks() {
        List<String> list = super.getTasks().stream().flatMap(s -> ParametersListUtil.parse((String)s, (boolean)false, (boolean)true).stream()).collect(Collectors.toList());
        if (list == null) {
            GradleExecutionSettings.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public GradleCommandLine getCommandLine() {
        GradleCommandLine gradleCommandLine = GradleCommandLineUtil.parseCommandLine(this.getTasks(), this.getArguments());
        if (gradleCommandLine == null) {
            GradleExecutionSettings.$$$reportNull$$$0(7);
        }
        return gradleCommandLine;
    }

    public void addInitScript(@NotNull String namePrefix, @NotNull String content) {
        if (namePrefix == null) {
            GradleExecutionSettings.$$$reportNull$$$0(8);
        }
        if (content == null) {
            GradleExecutionSettings.$$$reportNull$$$0(9);
        }
        Path initScriptPath = GradleInitScriptUtil.createInitScript(namePrefix, content);
        this.withArguments(new String[]{"--init-script", initScriptPath.toString()});
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myGradleHome != null ? this.myGradleHome.hashCode() : 0);
        result = 31 * result + (this.myServiceDirectory != null ? this.myServiceDirectory.hashCode() : 0);
        result = 31 * result + this.myDistributionType.hashCode();
        result = 31 * result + (this.myJavaHome != null ? this.myJavaHome.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GradleExecutionSettings that = (GradleExecutionSettings)((Object)o);
        if (this.myDistributionType != that.myDistributionType) {
            return false;
        }
        if (!Objects.equals(this.myGradleHome, that.myGradleHome)) {
            return false;
        }
        if (!Objects.equals(this.myJavaHome, that.myJavaHome)) {
            return false;
        }
        return Objects.equals(this.myServiceDirectory, that.myServiceDirectory);
    }

    public String toString() {
        return "home: " + this.myGradleHome + ", distributionType: " + this.myDistributionType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExecutionSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExecutionSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistributionType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionWorkspace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDistributionType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addInitScript";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

