/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtensionResolverBridge;", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtension;", "<init>", "()V", "configureTasks", "", "projectPath", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "createEnhancementParameters", "", "Companion", "intellij.gradle"})
@ApiStatus.Internal
public final class GradleTaskManagerExtensionResolverBridge
implements GradleTaskManagerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String RESOLVER_SCRIPT_NAME = "ijresolvers";

    @Override
    public void configureTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        Project project2 = id.findProject();
        List<String> list = settings.getTasks();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTasks(...)");
        List<String> taskNames = list;
        Map<String, String> enhancementParameters = this.createEnhancementParameters(settings, gradleVersion);
        GradleProjectResolverUtil.createProjectResolvers(null).forEachOrdered(arg_0 -> GradleTaskManagerExtensionResolverBridge.configureTasks$lambda$2(arg_0 -> GradleTaskManagerExtensionResolverBridge.configureTasks$lambda$1(project2, taskNames, enhancementParameters, settings, arg_0), arg_0));
    }

    private final Map<String, String> createEnhancementParameters(GradleExecutionSettings settings, GradleVersion gradleVersion) {
        String debugDispatchAddr;
        String debugOptions;
        Map map;
        Map $this$createEnhancementParameters_u24lambda_u243 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        String jvmParameters = settings.getJvmParameters();
        if (jvmParameters != null) {
            $this$createEnhancementParameters_u24lambda_u243.put("JVM_PARAMETERS_SETUP", jvmParameters);
        }
        boolean isRunAsTest = settings.isRunAsTest();
        $this$createEnhancementParameters_u24lambda_u243.put("IS_RUN_AS_TEST", String.valueOf(isRunAsTest));
        boolean isBuiltInTestEventsUsed = settings.isBuiltInTestEventsUsed();
        $this$createEnhancementParameters_u24lambda_u243.put("IS_BUILT_IN_TEST_EVENTS_USED", String.valueOf(isBuiltInTestEventsUsed));
        Integer debugDispatchPort = (Integer)settings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY);
        if (debugDispatchPort != null) {
            $this$createEnhancementParameters_u24lambda_u243.put("DEBUG_DISPATCH_PORT", debugDispatchPort.toString());
        }
        if ((debugOptions = (String)settings.getUserData(ExternalSystemRunnableState.DEBUGGER_PARAMETERS_KEY)) != null) {
            $this$createEnhancementParameters_u24lambda_u243.put("DEBUG_OPTIONS", debugOptions);
        }
        if ((debugDispatchAddr = (String)settings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY)) != null) {
            $this$createEnhancementParameters_u24lambda_u243.put("DEBUG_DISPATCH_ADDR", debugDispatchAddr);
        }
        if (gradleVersion != null) {
            String string = gradleVersion.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
            $this$createEnhancementParameters_u24lambda_u243.put("GRADLE_VERSION", string);
        }
        return MapsKt.build((Map)map);
    }

    private static final void configureTasks$lambda$1$lambda$0(ArrayList $initScripts, String $resolverClassName, String script) {
        CharSequence charSequence = script;
        if (!(charSequence == null || charSequence.length() == 0)) {
            $initScripts.add("//-- Generated by " + $resolverClassName);
            $initScripts.add(script);
            $initScripts.add("//");
        }
    }

    private static final Unit configureTasks$lambda$1(Project $project, List $taskNames, Map $enhancementParameters, GradleExecutionSettings $settings, GradleProjectResolverExtension resolverExtension) {
        String resolverClassName = resolverExtension.getClass().getName();
        ArrayList initScripts = new ArrayList();
        Map<String, String> map = resolverExtension.enhanceTaskProcessing($project, $taskNames, (Consumer<String>)((Consumer)arg_0 -> GradleTaskManagerExtensionResolverBridge.configureTasks$lambda$1$lambda$0(initScripts, resolverClassName, arg_0)), $enhancementParameters);
        Intrinsics.checkNotNullExpressionValue(map, (String)"enhanceTaskProcessing(...)");
        Map<String, String> executionEnvironmentVariables = map;
        if (!initScripts.isEmpty()) {
            String initScript = GradleInitScriptUtil.joinInitScripts(initScripts);
            $settings.addInitScript(RESOLVER_SCRIPT_NAME, initScript);
        }
        $settings.withEnvironmentVariables(executionEnvironmentVariables);
        return Unit.INSTANCE;
    }

    private static final void configureTasks$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/service/task/GradleTaskManagerExtensionResolverBridge$Companion;", "", "<init>", "()V", "RESOLVER_SCRIPT_NAME", "", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

