/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.google.gson.GsonBuilder;
import com.intellij.build.SyncViewManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Task;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.model.data.CompositeBuildData;
import org.jetbrains.plugins.gradle.service.GradleFileModificationTracker;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.GradleCommandLineUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleInitScriptUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleWrapperHelper;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleTasksIndices;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.service.task.VersionSpecificInitScript;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleTaskData;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLine;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineTask;

public class GradleTaskManager
implements ExternalSystemTaskManager<GradleExecutionSettings> {
    public static final Key<String> INIT_SCRIPT_KEY = Key.create((String)"INIT_SCRIPT_KEY");
    public static final Key<String> INIT_SCRIPT_PREFIX_KEY = Key.create((String)"INIT_SCRIPT_PREFIX_KEY");
    public static final Key<Collection<VersionSpecificInitScript>> VERSION_SPECIFIC_SCRIPTS_KEY = Key.create((String)"VERSION_SPECIFIC_SCRIPTS_KEY");
    private static final Logger LOG = Logger.getInstance(GradleTaskManager.class);
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = new ConcurrentHashMap<ExternalSystemTaskId, CancellationTokenSource>();

    @Deprecated
    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable String jvmParametersSetup, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(0);
        }
        if (taskNames == null) {
            GradleTaskManager.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(3);
        }
        super.executeTasks(id, taskNames, projectPath, (ExternalSystemExecutionSettings)settings, jvmParametersSetup, listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(4);
        }
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(6);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(7);
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : GradleTaskManagerExtension.EP_NAME.getExtensionList()) {
                if (!gradleTaskManagerExtension.executeTasks(projectPath, id, settings, listener2)) continue;
                return;
            }
        }
        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
        CancellationToken cancellationToken = cancellationTokenSource.token();
        this.myCancellationMap.put(id, cancellationTokenSource);
        try {
            if (settings.getDistributionType() == DistributionType.WRAPPED) {
                String rootProjectPath = GradleUtil.determineRootProject(projectPath);
                GradleWrapperHelper.ensureInstalledWrapper(id, rootProjectPath, settings, listener2, cancellationToken);
            }
            GradleExecutionHelper.execute(projectPath, settings, id, listener2, cancellationToken, connection -> {
                GradleTaskManager.executeTasks(projectPath, id, settings, listener2, connection, cancellationToken);
                return null;
            });
        }
        finally {
            this.myCancellationMap.remove(id);
        }
    }

    private static void executeTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection, @NotNull CancellationToken cancellationToken) {
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(8);
        }
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(10);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(11);
        }
        if (connection == null) {
            GradleTaskManager.$$$reportNull$$$0(12);
        }
        if (cancellationToken == null) {
            GradleTaskManager.$$$reportNull$$$0(13);
        }
        BuildEnvironment buildEnvironment = null;
        try {
            buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener2, cancellationToken, settings);
            GradleVersion gradleVersion = GradleTaskManager.getGradleVersion(buildEnvironment);
            GradleTaskManager.setupGradleScriptDebugging(settings);
            GradleTaskManager.setupDebuggerDispatchPort(settings);
            GradleTaskManager.setupBuiltInTestEvents(settings, gradleVersion);
            GradleTaskManager.configureTasks(projectPath, id, settings, gradleVersion);
            for (GradleBuildParticipant buildParticipant : settings.getExecutionWorkspace().getBuildParticipants()) {
                settings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
            }
            GradleTaskManager.prepareTaskState(id, settings, listener2);
            if (Registry.is((String)"gradle.report.recently.saved.paths")) {
                ((GradleFileModificationTracker)ApplicationManager.getApplication().getService(GradleFileModificationTracker.class)).notifyConnectionAboutChangedPaths(connection);
            }
            TestLauncher operation = GradleTaskManager.isApplicableTestLauncher(id, projectPath, settings, gradleVersion) ? connection.newTestLauncher() : connection.newBuild();
            GradleExecutionHelper.prepareForExecution((LongRunningOperation)operation, cancellationToken, id, settings, listener2, buildEnvironment);
            if (operation instanceof BuildLauncher) {
                ((BuildLauncher)operation).run();
            } else {
                operation.run();
            }
        }
        catch (RuntimeException e) {
            LOG.debug("Gradle build launcher error", (Throwable)e);
            GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain();
            throw projectResolverChain.getUserFriendlyError(buildEnvironment, e, projectPath, null);
        }
    }

    @Nullable
    private static GradleVersion getGradleVersion(@Nullable BuildEnvironment buildEnvironment) {
        return Optional.ofNullable(buildEnvironment).map(it -> it.getGradle()).map(it -> it.getGradleVersion()).map(it -> GradleInstallationManager.getGradleVersionSafe(it)).orElse(null);
    }

    private static boolean isApplicableTestLauncher(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion) {
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(14);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(16);
        }
        if (!Registry.is((String)"gradle.testLauncherAPI.enabled")) {
            LOG.debug("TestLauncher isn't applicable: disabled by registry");
            return false;
        }
        if (ExternalSystemExecutionAware.hasTargetEnvironmentConfiguration((ExternalSystemExecutionSettings)settings)) {
            LOG.debug("TestLauncher isn't applicable: unsupported execution with remote target");
            return false;
        }
        if (!settings.isTestTaskRerun()) {
            LOG.debug("TestLauncher isn't applicable: RC doesn't expect task rerun");
            return false;
        }
        if (gradleVersion == null) {
            LOG.debug("TestLauncher isn't applicable: Gradle version cannot be determined");
            return false;
        }
        if (GradleVersionUtil.isGradleOlderThan((GradleVersion)gradleVersion, (String)"8.3")) {
            LOG.debug("TestLauncher isn't applicable: unsupported Gradle version: " + gradleVersion);
            return false;
        }
        Project project2 = id.findProject();
        if (project2 == null) {
            LOG.debug("TestLauncher isn't applicable: Project is already closed");
            return false;
        }
        if (GradleVersionUtil.isGradleOlderThan((GradleVersion)gradleVersion, (String)"8.4") && GradleTaskManager.hasProjectIncludedBuild(project2, projectPath)) {
            LOG.debug("TestLauncher isn't applicable: Project has included build. " + gradleVersion);
            return false;
        }
        GradleCommandLine commandLine = settings.getCommandLine();
        if (!GradleTaskManager.hasJvmTestTasks(commandLine, project2, projectPath)) {
            LOG.debug("TestLauncher isn't applicable: RC hasn't JVM test tasks");
            return false;
        }
        if (GradleTaskManager.hasNonJvmTestTasks(commandLine, project2, projectPath)) {
            LOG.debug("TestLauncher isn't applicable: RC has non-JVM test tasks");
            return false;
        }
        if (GradleTaskManager.hasNonTestOptions(commandLine)) {
            LOG.debug("TestLauncher isn't applicable: RC tasks have non-test options");
            return false;
        }
        if (GradleTaskManager.hasUnrecognizedOptions(commandLine)) {
            LOG.debug("TestLauncher isn't applicable: RC has unrecognized options");
            return false;
        }
        LOG.debug("TestLauncher is applicable");
        return true;
    }

    private static boolean hasJvmTestTasks(@NotNull GradleCommandLine commandLine, @NotNull Project project2, @NotNull String projectPath) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(17);
        }
        if (project2 == null) {
            GradleTaskManager.$$$reportNull$$$0(18);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(19);
        }
        GradleTasksIndices indices = GradleTasksIndices.getInstance(project2);
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            List<GradleTaskData> taskData = indices.findTasks(projectPath, task2.getName());
            if (!ContainerUtil.exists(taskData, it -> it.isJvmTest())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonJvmTestTasks(@NotNull GradleCommandLine commandLine, @NotNull Project project2, @NotNull String projectPath) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(20);
        }
        if (project2 == null) {
            GradleTaskManager.$$$reportNull$$$0(21);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(22);
        }
        GradleTasksIndices indices = GradleTasksIndices.getInstance(project2);
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            List<GradleTaskData> taskData = indices.findTasks(projectPath, task2.getName());
            if (!ContainerUtil.exists(taskData, it -> it.isTest() && !it.isJvmTest())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasProjectIncludedBuild(@NotNull Project project2, @NotNull String projectPath) {
        DataNode projectNode;
        if (project2 == null) {
            GradleTaskManager.$$$reportNull$$$0(23);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(24);
        }
        if ((projectNode = ExternalSystemApiUtil.findProjectNode((Project)project2, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath)) == null) {
            return false;
        }
        DataNode compositeBuildNode = ExternalSystemApiUtil.find((DataNode)projectNode, CompositeBuildData.KEY);
        if (compositeBuildNode == null) {
            return false;
        }
        List<BuildParticipant> compositeBuildParticipants = ((CompositeBuildData)compositeBuildNode.getData()).getCompositeParticipants();
        return !compositeBuildParticipants.isEmpty();
    }

    private static boolean hasNonTestOptions(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(25);
        }
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            if (!ContainerUtil.exists((Iterable)task2.getOptions(), it -> !GradleCommandLineUtil.isTestPattern(it))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUnrecognizedOptions(@NotNull GradleCommandLine commandLine) {
        if (commandLine == null) {
            GradleTaskManager.$$$reportNull$$$0(26);
        }
        for (GradleCommandLineTask task2 : commandLine.getTasks()) {
            if (!task2.getName().startsWith("-")) continue;
            return true;
        }
        return false;
    }

    private static void prepareTaskState(@NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) {
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(27);
        }
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(28);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(29);
        }
        if (ExternalSystemExecutionAware.hasTargetEnvironmentConfiguration((ExternalSystemExecutionSettings)settings)) {
            return;
        }
        RunConfigurationTaskState taskState = (RunConfigurationTaskState)settings.getUserData(RunConfigurationTaskState.getKEY());
        if (taskState == null) {
            return;
        }
        LocalTargetEnvironmentRequest request = new LocalTargetEnvironmentRequest();
        TargetProgressIndicator progressIndicator = TargetProgressIndicator.EMPTY;
        try {
            taskState.prepareTargetEnvironmentRequest((TargetEnvironmentRequest)request, progressIndicator);
            LocalTargetEnvironment environment = request.prepareEnvironment(progressIndicator);
            String taskStateInitScript = taskState.handleCreatedTargetEnvironment((TargetEnvironment)environment, progressIndicator);
            if (taskStateInitScript != null) {
                Path initScriptPath = GradleInitScriptUtil.createInitScript("ijtgttaskstate", taskStateInitScript);
                settings.prependArguments(new String[]{"--init-script", initScriptPath.toString()});
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        listener2.onEnvironmentPrepared(id);
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        CancellationTokenSource cancellationTokenSource;
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(30);
        }
        if (listener2 == null) {
            GradleTaskManager.$$$reportNull$$$0(31);
        }
        if ((cancellationTokenSource = this.myCancellationMap.get(id)) != null) {
            cancellationTokenSource.cancel();
            return true;
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener2)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static void appendInitScriptArgument(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull GradleExecutionSettings settings) {
        if (taskNames == null) {
            GradleTaskManager.$$$reportNull$$$0(32);
        }
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(33);
        }
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (String)"");
        settings.setTasks(taskNames);
        settings.setJvmParameters(jvmParametersSetup);
        GradleTaskManager.configureTasks("", id, settings, null);
    }

    @ApiStatus.Internal
    public static void configureTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion) {
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(34);
        }
        if (id == null) {
            GradleTaskManager.$$$reportNull$$$0(35);
        }
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(36);
        }
        GradleTaskManagerExtension.EP_NAME.forEachExtensionSafe(it -> it.configureTasks(projectPath, id, settings, gradleVersion));
        String initScript = (String)settings.getUserData(INIT_SCRIPT_KEY);
        if (StringUtil.isNotEmpty((String)initScript)) {
            String initScriptPrefix = StringUtil.notNullize((String)((String)settings.getUserData(INIT_SCRIPT_PREFIX_KEY)), (String)"ijmiscinit");
            Path initScriptPath = GradleInitScriptUtil.createInitScript(initScriptPrefix, initScript);
            settings.withArguments(new String[]{"--init-script", initScriptPath.toString()});
        }
        Collection scripts = (Collection)settings.getUserData(VERSION_SPECIFIC_SCRIPTS_KEY);
        if (gradleVersion != null && scripts != null) {
            for (VersionSpecificInitScript script : scripts) {
                if (!script.isApplicableTo(gradleVersion) || !StringUtil.isNotEmpty((String)script.getScript())) continue;
                String initScriptPrefix = StringUtil.notNullize((String)script.getFilePrefix(), (String)"ijverspecinit");
                Path initScriptPath = GradleInitScriptUtil.createInitScript(initScriptPrefix, script.getScript());
                settings.withArguments(new String[]{"--init-script", initScriptPath.toString()});
            }
        }
        if (settings.getArguments().contains("--init-script")) {
            Path targetPathMapperInitScript = GradleInitScriptUtil.createTargetPathMapperInitScript();
            settings.prependArguments(new String[]{"--init-script", targetPathMapperInitScript.toString()});
        }
    }

    public static void setupGradleScriptDebugging(@NotNull GradleExecutionSettings effectiveSettings) {
        if (effectiveSettings == null) {
            GradleTaskManager.$$$reportNull$$$0(37);
        }
        Integer gradleScriptDebugPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.BUILD_PROCESS_DEBUGGER_PORT_KEY);
        if (effectiveSettings.isDebugServerProcess() && gradleScriptDebugPort != null && gradleScriptDebugPort > 0) {
            boolean isJdk9orLater;
            String dispatchAddr = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY);
            String debugAddress = dispatchAddr != null ? dispatchAddr + ":" + gradleScriptDebugPort : ((isJdk9orLater = ExternalSystemJdkUtil.isJdk9orLater((String)effectiveSettings.getJavaHome())) ? "127.0.0.1:" : "") + gradleScriptDebugPort;
            String jvmOpt = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + debugAddress;
            effectiveSettings.withVmOption(jvmOpt);
        }
        if (effectiveSettings.isDebugAllEnabled()) {
            effectiveSettings.withArgument("-Didea.gradle.debug.all=true");
        }
    }

    public static void setupDebuggerDispatchPort(@NotNull GradleExecutionSettings effectiveSettings) {
        String dispatchAddr;
        Integer dispatchPort;
        if (effectiveSettings == null) {
            GradleTaskManager.$$$reportNull$$$0(38);
        }
        if ((dispatchPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY)) != null) {
            effectiveSettings.withArgument(String.format("-D%s=%d", "idea.debugger.dispatch.port", dispatchPort));
        }
        if ((dispatchAddr = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY)) != null) {
            effectiveSettings.withArgument(String.format("-D%s=%s", "idea.debugger.dispatch.addr", dispatchAddr));
        }
    }

    private static void setupBuiltInTestEvents(@NotNull GradleExecutionSettings settings, @Nullable GradleVersion gradleVersion) {
        if (settings == null) {
            GradleTaskManager.$$$reportNull$$$0(39);
        }
        if (gradleVersion != null && GradleVersionUtil.isGradleAtLeast((GradleVersion)gradleVersion, (String)"7.6")) {
            settings.setBuiltInTestEventsUsed(true);
        }
    }

    public static void runCustomTaskScript(@NotNull Project project2, @NotNull @Nls String executionName, @NotNull String projectPath, @NotNull String gradlePath2, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback, @NotNull String initScript, @NotNull String taskName) {
        if (project2 == null) {
            GradleTaskManager.$$$reportNull$$$0(40);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(41);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(42);
        }
        if (gradlePath2 == null) {
            GradleTaskManager.$$$reportNull$$$0(43);
        }
        if (progressExecutionMode == null) {
            GradleTaskManager.$$$reportNull$$$0(44);
        }
        if (initScript == null) {
            GradleTaskManager.$$$reportNull$$$0(45);
        }
        if (taskName == null) {
            GradleTaskManager.$$$reportNull$$$0(46);
        }
        UserDataHolderBase userData = new UserDataHolderBase();
        userData.putUserData(INIT_SCRIPT_KEY, (Object)initScript);
        userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, SyncViewManager.class);
        String gradleVmOptions = GradleSettings.getInstance(project2).getGradleVmOptions();
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExecutionName(executionName);
        settings.setExternalProjectPath(projectPath);
        Object taskPrefix = gradlePath2.endsWith(":") ? gradlePath2 : gradlePath2 + ":";
        settings.setTaskNames(Collections.singletonList((String)taskPrefix + taskName));
        settings.setVmOptions(gradleVmOptions);
        settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)"Run", (Project)project2, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)callback, (ProgressExecutionMode)progressExecutionMode, (boolean)false, (UserDataHolderBase)userData);
    }

    public static void runCustomTask(@NotNull Project project2, @NotNull @Nls String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath2, @Nullable String taskConfiguration, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback, @NotNull Set<Class<?>> toolingExtensionClasses) {
        if (project2 == null) {
            GradleTaskManager.$$$reportNull$$$0(47);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(48);
        }
        if (taskClass == null) {
            GradleTaskManager.$$$reportNull$$$0(49);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(50);
        }
        if (gradlePath2 == null) {
            GradleTaskManager.$$$reportNull$$$0(51);
        }
        if (progressExecutionMode == null) {
            GradleTaskManager.$$$reportNull$$$0(52);
        }
        if (toolingExtensionClasses == null) {
            GradleTaskManager.$$$reportNull$$$0(53);
        }
        String taskName = taskClass.getSimpleName();
        String taskType = taskClass.getName();
        HashSet tools = new HashSet(toolingExtensionClasses);
        tools.add(taskClass);
        tools.add(GsonBuilder.class);
        String initScript = GradleInitScriptUtil.loadTaskInitScript(gradlePath2, taskName, taskType, tools, taskConfiguration);
        GradleTaskManager.runCustomTaskScript(project2, executionName, projectPath, gradlePath2, progressExecutionMode, callback, initScript, taskName);
    }

    public static void runCustomTask(@NotNull Project project2, @NotNull @Nls String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath2, @Nullable String taskConfiguration, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback) {
        if (project2 == null) {
            GradleTaskManager.$$$reportNull$$$0(54);
        }
        if (executionName == null) {
            GradleTaskManager.$$$reportNull$$$0(55);
        }
        if (taskClass == null) {
            GradleTaskManager.$$$reportNull$$$0(56);
        }
        if (projectPath == null) {
            GradleTaskManager.$$$reportNull$$$0(57);
        }
        if (gradlePath2 == null) {
            GradleTaskManager.$$$reportNull$$$0(58);
        }
        if (progressExecutionMode == null) {
            GradleTaskManager.$$$reportNull$$$0(59);
        }
        GradleTaskManager.runCustomTask(project2, executionName, taskClass, projectPath, gradlePath2, taskConfiguration, progressExecutionMode, callback, new HashSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 34: 
            case 42: 
            case 50: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 10: 
            case 16: 
            case 28: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationToken";
                break;
            }
            case 17: 
            case 20: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 18: 
            case 21: 
            case 23: 
            case 40: 
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveSettings";
                break;
            }
            case 41: 
            case 48: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionName";
                break;
            }
            case 43: 
            case 51: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 44: 
            case 52: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressExecutionMode";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScript";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskClass";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolingExtensionClasses";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/task/GradleTaskManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTasks";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableTestLauncher";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "hasJvmTestTasks";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonJvmTestTasks";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProjectIncludedBuild";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonTestOptions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "hasUnrecognizedOptions";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareTaskState";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelTask";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "appendInitScriptArgument";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTasks";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "setupGradleScriptDebugging";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "setupDebuggerDispatchPort";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "setupBuiltInTestEvents";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "runCustomTaskScript";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[2] = "runCustomTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

