/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\t\nB\u0016\b\u0004\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/settingsSync/core/FileState;", "", "file", "", "Lorg/jetbrains/annotations/SystemIndependent;", "<init>", "(Ljava/lang/String;)V", "getFile", "()Ljava/lang/String;", "Modified", "Deleted", "Lcom/intellij/settingsSync/core/FileState$Deleted;", "Lcom/intellij/settingsSync/core/FileState$Modified;", "intellij.settingsSync.core"})
@ApiStatus.Internal
public abstract class FileState {
    @NotNull
    private final String file;

    private FileState(String file) {
        this.file = file;
    }

    @NotNull
    public String getFile() {
        return this.file;
    }

    public /* synthetic */ FileState(String file, DefaultConstructorMarker $constructor_marker) {
        this(file);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0018\u0010\n\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0019\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/settingsSync/core/FileState$Deleted;", "Lcom/intellij/settingsSync/core/FileState;", "file", "", "Lorg/jetbrains/annotations/SystemIndependent;", "<init>", "(Ljava/lang/String;)V", "getFile", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.settingsSync.core"})
    public static final class Deleted
    extends FileState {
        @NotNull
        private final String file;

        public Deleted(@NotNull String file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(file, null);
            this.file = file;
        }

        @Override
        @NotNull
        public String getFile() {
            return this.file;
        }

        @NotNull
        public final String component1() {
            return this.file;
        }

        @NotNull
        public final Deleted copy(@NotNull String file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new Deleted(file);
        }

        public static /* synthetic */ Deleted copy$default(Deleted deleted, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = deleted.file;
            }
            return deleted.copy(string);
        }

        @NotNull
        public String toString() {
            return "Deleted(file=" + this.file + ")";
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Deleted)) {
                return false;
            }
            Deleted deleted = (Deleted)other;
            return Intrinsics.areEqual((Object)this.file, (Object)deleted.file);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0003H\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0019\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/settingsSync/core/FileState$Modified;", "Lcom/intellij/settingsSync/core/FileState;", "file", "", "Lorg/jetbrains/annotations/SystemIndependent;", "content", "", "<init>", "(Ljava/lang/String;[B)V", "getFile", "()Ljava/lang/String;", "getContent", "()[B", "toString", "equals", "", "other", "", "hashCode", "", "intellij.settingsSync.core"})
    public static final class Modified
    extends FileState {
        @NotNull
        private final String file;
        @NotNull
        private final byte[] content;

        public Modified(@NotNull String file, @NotNull byte[] content) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            super(file, null);
            this.file = file;
            this.content = content;
        }

        @Override
        @NotNull
        public String getFile() {
            return this.file;
        }

        @NotNull
        public final byte[] getContent() {
            return this.content;
        }

        @NotNull
        public String toString() {
            String string = this.getFile();
            byte[] byArray = this.content;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            return "file='" + string + "', content:\n" + new String(byArray, charset2);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.settingsSync.core.FileState.Modified");
            Modified cfr_ignored_0 = (Modified)other;
            if (!Intrinsics.areEqual((Object)this.getFile(), (Object)((Modified)other).getFile())) {
                return false;
            }
            return Arrays.equals(this.content, ((Modified)other).content);
        }

        public int hashCode() {
            int result = this.getFile().hashCode();
            result = 31 * result + Arrays.hashCode(this.content);
            return result;
        }
    }
}

