/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.sync.AgpVersionIncompatible;
import com.android.tools.idea.gradle.project.sync.AgpVersionTooNew;
import com.android.tools.idea.gradle.project.sync.AgpVersionTooOld;
import com.android.tools.idea.gradle.project.sync.GradleSyncStudioFlags;
import com.android.tools.idea.gradle.project.sync.ModelConsumerVersion;
import com.android.tools.idea.gradle.project.upgrade.AndroidGradlePluginCompatibility;
import com.android.tools.idea.gradle.project.upgrade.AndroidGradlePluginCompatibilityKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000b"}, d2={"MINIMUM_SUPPORTED_AGP_VERSION", "Lcom/android/ide/common/repository/AgpVersion;", "getMINIMUM_SUPPORTED_AGP_VERSION", "()Lcom/android/ide/common/repository/AgpVersion;", "checkAgpVersionCompatibility", "", "minimumModelConsumer", "Lcom/android/tools/idea/gradle/project/sync/ModelConsumerVersion;", "agpVersion", "flags", "Lcom/android/tools/idea/gradle/project/sync/GradleSyncStudioFlags;", "intellij.android.projectSystem.gradle.sync"})
public final class AgpCompatibilityKt {
    @NotNull
    private static final AgpVersion MINIMUM_SUPPORTED_AGP_VERSION = AgpVersion.Companion.parse("4.0.0");

    @NotNull
    public static final AgpVersion getMINIMUM_SUPPORTED_AGP_VERSION() {
        return MINIMUM_SUPPORTED_AGP_VERSION;
    }

    public static final void checkAgpVersionCompatibility(@Nullable ModelConsumerVersion minimumModelConsumer, @NotNull AgpVersion agpVersion, @NotNull GradleSyncStudioFlags flags) {
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        AgpVersion latestKnown = AgpVersion.Companion.parse(flags.getStudioLatestKnownAgpVersion());
        if (minimumModelConsumer != null && flags.getStudioFlagSupportFutureAgpVersions()) {
            if (agpVersion.compareTo(MINIMUM_SUPPORTED_AGP_VERSION) < 0) {
                throw new AgpVersionTooOld(agpVersion);
            }
            if (minimumModelConsumer.compareTo(flags.getModelConsumerVersion()) > 0) {
                throw new AgpVersionTooNew(agpVersion, latestKnown);
            }
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[AndroidGradlePluginCompatibilityKt.computeAndroidGradlePluginCompatibility(agpVersion, latestKnown).ordinal()]) {
            case 1: {
                throw new AgpVersionTooOld(agpVersion);
            }
            case 2: {
                if (flags.getStudioFlagDisableForcedUpgrades()) break;
                throw new AgpVersionIncompatible(agpVersion, latestKnown);
            }
            case 3: {
                if (flags.getStudioFlagDisableForcedUpgrades()) break;
                throw new AgpVersionTooNew(agpVersion, latestKnown);
            }
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidGradlePluginCompatibility.values().length];
            try {
                nArray[AndroidGradlePluginCompatibility.BEFORE_MINIMUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.DIFFERENT_PREVIEW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.AFTER_MAXIMUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.COMPATIBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.DEPRECATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

